/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.util;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources;
import edu.cmu.cs.stage3.alice.authoringtool.util.ContextAssignableUndoableRedoable;
import edu.cmu.cs.stage3.alice.authoringtool.util.DefaultUndoRedoStack;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.Property;
import edu.cmu.cs.stage3.alice.core.Response;
import edu.cmu.cs.stage3.alice.core.response.CallToUserDefinedResponse;
import edu.cmu.cs.stage3.alice.core.response.UserDefinedResponse;

public class PropertyUndoableRedoable
implements ContextAssignableUndoableRedoable {
    protected Property property;
    protected Object oldValue;
    protected Object newValue;
    protected Object context;

    public PropertyUndoableRedoable(Property property, Object oldValue, Object newValue, Object context) {
        this.property = property;
        this.oldValue = oldValue;
        this.newValue = newValue;
    }

    public PropertyUndoableRedoable(Property property, Object oldValue, Object newValue) {
        this.property = property;
        this.oldValue = oldValue;
        this.newValue = newValue;
    }

    @Override
    public void setContext(Object context) {
        this.context = context;
    }

    @Override
    public void undo() {
        this.property.set(this.oldValue);
    }

    @Override
    public void redo() {
        this.property.set(this.newValue);
    }

    @Override
    public Object getAffectedObject() {
        return this.property.getOwner();
    }

    @Override
    public Object getContext() {
        return this.context;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("edu.cmu.cs.stage3.alice.authoringtool.util.PropertyUndoableRedoable[ ");
        s.append("property=" + this.property + "; ");
        s.append("oldValue=" + this.oldValue + "; ");
        s.append("newValue=" + this.newValue + "; ");
        if (this.context != this && !(this.context instanceof DefaultUndoRedoStack)) {
            s.append("context=" + this.context + "; ");
        } else {
            s.append("context=" + this.context.getClass() + "; ");
        }
        s.append(" ]");
        return s.toString();
    }

    public String getLogString() {
        String logString = "TIME=<" + System.currentTimeMillis() + "> ";
        String oldValueString = "null";
        String newValueString = "null";
        String ownerKey = "";
        if (this.oldValue instanceof Element) {
            oldValueString = ((Element)this.oldValue).getKey();
        } else if (this.oldValue != null) {
            oldValueString = this.oldValue.toString();
        }
        if (this.newValue instanceof Element) {
            newValueString = ((Element)this.newValue).getKey();
        } else if (this.newValue != null) {
            newValueString = this.newValue.toString();
        }
        if (this.property.getOwner() instanceof CallToUserDefinedResponse) {
            CallToUserDefinedResponse cudResponse = (CallToUserDefinedResponse)this.property.getOwner();
            String methodName = "";
            if (cudResponse.userDefinedResponse.get() instanceof UserDefinedResponse) {
                UserDefinedResponse udResponse = (UserDefinedResponse)cudResponse.userDefinedResponse.get();
                methodName = udResponse.getKey();
            }
            ownerKey = String.valueOf(methodName) + "(" + this.property.getOwner().getKey() + ")";
        } else if (this.property.getOwner() instanceof Response) {
            String responseType = AuthoringToolResources.getReprForValue(this.property.getOwner().getClass());
            if (responseType.indexOf("set") != -1) {
                responseType = "set";
            } else {
                if (responseType.indexOf("<<<") != -1 && responseType.indexOf(">>>") != -1) {
                    responseType = responseType.substring(responseType.indexOf(">>>") + 3, responseType.length());
                }
                if (responseType.indexOf("<") != -1 && responseType.indexOf(">") != -1) {
                    responseType = responseType.substring(0, responseType.indexOf("<"));
                }
            }
            ownerKey = String.valueOf(responseType.trim()) + "(" + this.property.getOwner().getKey() + ")";
        } else {
            ownerKey = this.property.getOwner().getKey();
        }
        if (!this.property.getName().equals("data")) {
            logString = String.valueOf(logString) + "EVENT=<propertyChange> PROPERTYNAME=<" + this.property.getName() + "> " + "PROPERTYOWNER=<" + ownerKey + "> " + "OLDVALUE=<" + oldValueString + "> " + "NEWVALUE=<" + newValueString + ">";
            return logString;
        }
        return null;
    }
}

