/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.util;

import edu.cmu.cs.stage3.alice.authoringtool.util.PointOfViewUndoableRedoable;
import edu.cmu.cs.stage3.alice.authoringtool.util.RenderTargetManipulatorMode;
import edu.cmu.cs.stage3.alice.authoringtool.util.UndoRedoStack;
import edu.cmu.cs.stage3.alice.core.Camera;
import edu.cmu.cs.stage3.alice.core.Scheduler;
import edu.cmu.cs.stage3.alice.core.Transformable;
import edu.cmu.cs.stage3.alice.core.World;
import edu.cmu.cs.stage3.alice.core.camera.OrthographicCamera;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.PickInfo;
import edu.cmu.cs.stage3.math.Matrix44;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector4d;

public class OrthographicScrollMode
extends RenderTargetManipulatorMode {
    protected double minScrollFactor = 0.3;
    protected double maxScrollFactor = 4.0;
    protected double scrollRampUpDistance = 10.0;
    protected World world;
    protected Camera camera = null;
    protected Transformable identity = new Transformable();
    protected Vector3d tempVec = new Vector3d();
    protected Vector3d zeroVec = new Vector3d(0.0, 0.0, 0.0);
    protected Vector4d tempVec4 = new Vector4d();
    protected Vector3d cameraForward = new Vector3d();
    protected Vector3d cameraUp = new Vector3d();
    protected Matrix44 oldTransformation;
    protected UndoRedoStack undoRedoStack;
    protected Scheduler scheduler;
    protected Point pressPoint = new Point();

    public OrthographicScrollMode() {
        this(null, null);
    }

    public OrthographicScrollMode(UndoRedoStack undoRedoStack, Scheduler scheduler) {
        this.undoRedoStack = undoRedoStack;
        this.scheduler = scheduler;
    }

    @Override
    public boolean requiresPickedObject() {
        return false;
    }

    @Override
    public boolean hideCursorOnDrag() {
        return false;
    }

    @Override
    public void mousePressed(MouseEvent ev, Transformable pickedTransformable, PickInfo pickInfo) {
        this.camera = (Camera)pickInfo.getSource().getBonus();
        if (this.camera instanceof OrthographicCamera) {
            this.world = this.camera.getWorld();
            this.oldTransformation = this.camera.getLocalTransformation();
            this.identity.vehicle.set(this.world);
            this.pressPoint.setLocation(ev.getPoint());
        }
    }

    @Override
    public void mouseReleased(MouseEvent ev) {
        if (this.camera instanceof OrthographicCamera && this.undoRedoStack != null && this.scheduler != null && !ev.isPopupTrigger()) {
            this.undoRedoStack.push(new PointOfViewUndoableRedoable(this.camera, this.oldTransformation, this.camera.getLocalTransformation(), this.scheduler));
        }
    }

    @Override
    public void mouseDragged(MouseEvent ev, int dx, int dy) {
        if (this.camera instanceof OrthographicCamera) {
            boolean controlDown = ev.isControlDown();
            boolean shiftDown = ev.isShiftDown();
            OrthographicCamera orthoCamera = (OrthographicCamera)this.camera;
            double nearClipHeightInScreen = this.renderTarget.getAWTComponent().getHeight();
            double nearClipHeightInWorld = orthoCamera.getSceneGraphOrthographicCamera().getPlane()[3] - orthoCamera.getSceneGraphOrthographicCamera().getPlane()[1];
            double deltaFactor = nearClipHeightInWorld / nearClipHeightInScreen;
            double offsetDist = Math.min(Math.sqrt(dx * dx + dy * dy), this.scrollRampUpDistance);
            if (controlDown) {
                deltaFactor = shiftDown ? (deltaFactor *= 2.0 * this.maxScrollFactor) : (deltaFactor *= this.maxScrollFactor);
            } else if (shiftDown) {
                deltaFactor *= this.minScrollFactor;
            }
            this.tempVec.x = (double)(-dx) * deltaFactor;
            this.tempVec.y = (double)dy * deltaFactor;
            this.tempVec.z = 0.0;
            this.camera.moveRightNow(this.tempVec);
        }
    }
}

