/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.util;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources;
import edu.cmu.cs.stage3.alice.authoringtool.datatransfer.ObjectArrayPropertyItemTransferable;
import edu.cmu.cs.stage3.alice.authoringtool.util.GUIFactory;
import edu.cmu.cs.stage3.alice.authoringtool.util.ObjectArrayPropertyItem;
import edu.cmu.cs.stage3.alice.authoringtool.util.SetPropertyImmediatelyFactory;
import edu.cmu.cs.stage3.alice.authoringtool.viewcontroller.PropertyGUI;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.World;
import edu.cmu.cs.stage3.alice.core.event.PropertyEvent;
import edu.cmu.cs.stage3.alice.core.event.PropertyListener;
import edu.cmu.cs.stage3.alice.core.property.ObjectArrayProperty;
import edu.cmu.cs.stage3.lang.Messages;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class ObjectArrayPropertyEditor
extends JPanel
implements PropertyListener,
DropTargetListener {
    protected ObjectArrayProperty objectArrayProperty;
    protected JButton newItemButton = new JButton(Messages.getString("new_item"));
    protected JButton removeItemButton = new JButton(Messages.getString("remove_item"));
    protected Class type = Object.class;
    protected int lineLocation = -1;
    protected int position = 0;

    public ObjectArrayPropertyEditor() {
        this.guiInit();
    }

    private void guiInit() {
        this.setLayout(new GridBagLayout());
        this.setBackground(Color.white);
        this.newItemButton.setBackground(new Color(240, 240, 255));
        this.newItemButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                ObjectArrayPropertyEditor.this.objectArrayProperty.add(AuthoringToolResources.getDefaultValueForClass(ObjectArrayPropertyEditor.this.type));
                ObjectArrayPropertyEditor.this.newItemButton.scrollRectToVisible(ObjectArrayPropertyEditor.this.newItemButton.getBounds());
            }
        });
        this.removeItemButton.setBackground(new Color(240, 240, 255));
        this.removeItemButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (ObjectArrayPropertyEditor.this.objectArrayProperty.size() > 0) {
                    ObjectArrayPropertyEditor.this.objectArrayProperty.remove(ObjectArrayPropertyEditor.this.objectArrayProperty.size() - 1);
                }
                ObjectArrayPropertyEditor.this.removeItemButton.scrollRectToVisible(ObjectArrayPropertyEditor.this.removeItemButton.getBounds());
            }
        });
        this.setDropTarget(new DropTarget(this, this));
        this.refreshGUI();
    }

    public void setObjectArrayProperty(ObjectArrayProperty objectArrayProperty) {
        if (this.objectArrayProperty != null) {
            this.objectArrayProperty.removePropertyListener(this);
        }
        this.objectArrayProperty = objectArrayProperty;
        if (this.objectArrayProperty != null) {
            this.objectArrayProperty.addPropertyListener(this);
        }
        this.refreshGUI();
    }

    public void setType(Class type) {
        this.type = type;
    }

    public void refreshGUI() {
        this.removeAll();
        if (this.objectArrayProperty != null) {
            Object[] items = this.objectArrayProperty.getArrayValue();
            int count = 0;
            if (items != null) {
                int i = 0;
                while (i < items.length) {
                    SetPropertyImmediatelyFactory factory;
                    ObjectArrayPropertyItem item;
                    PropertyGUI gui;
                    Element owner = this.objectArrayProperty.getOwner();
                    if (owner == null || !(owner.getRoot() instanceof World)) {
                        owner = AuthoringTool.getHack().getWorld();
                    }
                    if ((gui = GUIFactory.getPropertyGUI(item = new ObjectArrayPropertyItem(owner, this.objectArrayProperty, i, this.type), true, false, factory = new SetPropertyImmediatelyFactory(item))) != null) {
                        this.add((Component)gui, new GridBagConstraints(0, count++, 1, 1, 1.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
                    } else {
                        AuthoringTool.showErrorDialog(String.valueOf(Messages.getString("Unable_to_create_gui_for_item__")) + item, null);
                    }
                    ++i;
                }
            }
            this.add((Component)this.newItemButton, new GridBagConstraints(0, count, 1, 1, 1.0, 0.0, 17, 0, new Insets(8, 2, 8, 2), 0, 0));
            this.newItemButton.setDropTarget(new DropTarget(this.newItemButton, this));
            this.add((Component)this.removeItemButton, new GridBagConstraints(1, count++, 1, 1, 1.0, 0.0, 17, 0, new Insets(8, 2, 8, 2), 0, 0));
            this.removeItemButton.setDropTarget(new DropTarget(this.removeItemButton, this));
            Component glue = Box.createGlue();
            this.add(glue, new GridBagConstraints(0, count++, 1, 1, 1.0, 1.0, 17, 1, new Insets(2, 2, 2, 2), 0, 0));
            glue.setDropTarget(new DropTarget(glue, this));
        }
        this.revalidate();
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.lineLocation > -1) {
            Rectangle bounds = this.getBounds();
            g.setColor(Color.black);
            g.fillRect(0, this.lineLocation, bounds.width, 2);
        }
    }

    protected void calculateLineLocation(int mouseY) {
        int numSpots = this.objectArrayProperty.size() + 1;
        int[] spots = new int[numSpots];
        spots[0] = 0;
        int i = 1;
        while (i < numSpots) {
            Component c = this.getComponent(i - 1);
            spots[i] = c.getBounds().y + c.getBounds().height + 1;
            ++i;
        }
        int closestSpot = -1;
        int minDist = Integer.MAX_VALUE;
        int i2 = 0;
        while (i2 < numSpots) {
            int d = Math.abs(mouseY - spots[i2]);
            if (d < minDist) {
                minDist = d;
                closestSpot = i2;
            }
            ++i2;
        }
        this.position = closestSpot;
        this.lineLocation = spots[closestSpot];
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        if (AuthoringToolResources.safeIsDataFlavorSupported(dtde, ObjectArrayPropertyItemTransferable.objectArrayPropertyItemFlavor)) {
            dtde.acceptDrag(2);
            int mouseY = SwingUtilities.convertPoint((Component)dtde.getDropTargetContext().getComponent(), (Point)dtde.getLocation(), (Component)this).y;
            this.calculateLineLocation(mouseY);
        } else {
            this.lineLocation = -1;
            dtde.rejectDrag();
        }
        this.repaint();
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        if (AuthoringToolResources.safeIsDataFlavorSupported(dtde, ObjectArrayPropertyItemTransferable.objectArrayPropertyItemFlavor)) {
            dtde.acceptDrag(2);
            int mouseY = SwingUtilities.convertPoint((Component)dtde.getDropTargetContext().getComponent(), (Point)dtde.getLocation(), (Component)this).y;
            this.calculateLineLocation(mouseY);
        } else {
            this.lineLocation = -1;
            dtde.rejectDrag();
        }
        this.repaint();
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        Transferable transferable = dtde.getTransferable();
        if (AuthoringToolResources.safeIsDataFlavorSupported(transferable, ObjectArrayPropertyItemTransferable.objectArrayPropertyItemFlavor)) {
            dtde.acceptDrop(2);
            try {
                ObjectArrayPropertyItem item = (ObjectArrayPropertyItem)transferable.getTransferData(ObjectArrayPropertyItemTransferable.objectArrayPropertyItemFlavor);
                Object value = item.get();
                if (this.position > item.getIndex()) {
                    --this.position;
                }
                item.getObjectArrayProperty().remove(item.getIndex());
                item.getObjectArrayProperty().add(this.position, value);
                dtde.dropComplete(true);
            }
            catch (UnsupportedFlavorException e) {
                AuthoringTool.showErrorDialog(Messages.getString("Drop_didn_t_work__bad_flavor"), e);
                dtde.dropComplete(false);
            }
            catch (IOException e) {
                AuthoringTool.showErrorDialog(Messages.getString("Drop_didn_t_work__IOException"), e);
                dtde.dropComplete(false);
            }
            catch (Throwable t) {
                AuthoringTool.showErrorDialog(Messages.getString("Error_moving_item_"), t);
                dtde.dropComplete(false);
            }
        } else {
            dtde.rejectDrop();
            dtde.dropComplete(false);
        }
        this.lineLocation = -1;
        this.repaint();
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
        if (AuthoringToolResources.safeIsDataFlavorSupported(dtde, ObjectArrayPropertyItemTransferable.objectArrayPropertyItemFlavor)) {
            dtde.acceptDrag(2);
        } else {
            dtde.rejectDrag();
        }
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
        this.lineLocation = -1;
        this.repaint();
    }

    @Override
    public void propertyChanging(PropertyEvent propertyEvent) {
    }

    @Override
    public void propertyChanged(PropertyEvent propertyEvent) {
        this.refreshGUI();
    }
}

