/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.util;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.caitlin.stencilhelp.application.IDDoesNotExistException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.event.MouseInputAdapter;

public class HighlightingGlassPane
extends JPanel {
    protected AuthoringTool authoringTool;
    protected Component savedGlassPane;
    protected String highlightID;
    protected Timer blinkTimer;
    protected Color highlightColor = Color.red;
    protected MousePassThroughListener mousePassThroughListener = new MousePassThroughListener();

    public HighlightingGlassPane(AuthoringTool authoringTool) {
        this.authoringTool = authoringTool;
        this.setOpaque(false);
        this.addMouseListener(this.mousePassThroughListener);
        this.addMouseMotionListener(this.mousePassThroughListener);
        this.blinkTimer = new Timer(10, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                Rectangle r = HighlightingGlassPane.this.getHighlightRect();
                if (r != null) {
                    HighlightingGlassPane.this.highlightColor = new Color(1.0f, 0.0f, 0.0f, (float)(0.5 * Math.sin((double)System.currentTimeMillis() / 400.0) + 0.5));
                    r.x -= 4;
                    r.y -= 4;
                    r.width += 8;
                    r.height += 8;
                    HighlightingGlassPane.this.repaint(r);
                }
            }
        });
    }

    public void setHighlightID(String highlightID) {
        boolean oldEnabled = this.blinkTimer.isRunning();
        this.setHighlightingEnabled(false);
        this.highlightID = highlightID;
        if (oldEnabled) {
            this.setHighlightingEnabled(true);
        }
    }

    public void setHighlightingEnabled(boolean enabled) {
        if (enabled) {
            if (this.authoringTool.getJAliceFrame().getGlassPane() != this) {
                this.savedGlassPane = this.authoringTool.getJAliceFrame().getGlassPane();
                this.authoringTool.setGlassPane(this);
                this.setVisible(true);
                this.blinkTimer.start();
                this.revalidate();
                this.repaint();
            }
        } else if (this.authoringTool.getJAliceFrame().getGlassPane() != this.savedGlassPane) {
            if (this.savedGlassPane == null) {
                this.savedGlassPane = this.authoringTool.getJAliceFrame().getGlassPane();
            } else {
                this.authoringTool.setGlassPane(this.savedGlassPane);
            }
            this.blinkTimer.stop();
        }
    }

    public Rectangle getHighlightRect() {
        Rectangle r = null;
        if (this.highlightID != null) {
            try {
                if (!this.authoringTool.isIDVisible(this.highlightID)) {
                    this.authoringTool.makeIDVisible(this.highlightID);
                }
                if ((r = this.authoringTool.getBoxForID(this.highlightID)) != null && !r.isEmpty()) {
                    r.x -= 2;
                    r.y -= 2;
                    r.width += 4;
                    r.height += 4;
                }
            }
            catch (IDDoesNotExistException iDDoesNotExistException) {
                // empty catch block
            }
        }
        return r;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Rectangle r = this.getHighlightRect();
        if (r != null && !r.isEmpty()) {
            g.setColor(this.highlightColor);
            int i = 0;
            while (i < 4) {
                g.drawRect(r.x - i, r.y - i, r.width + 2 * i, r.height + 2 * i);
                ++i;
            }
        }
    }

    class MousePassThroughListener
    extends MouseInputAdapter {
        MousePassThroughListener() {
        }

        @Override
        public void mouseMoved(MouseEvent ev) {
            this.redispatchMouseEvent(ev);
        }

        @Override
        public void mouseDragged(MouseEvent ev) {
            this.redispatchMouseEvent(ev);
        }

        @Override
        public void mouseClicked(MouseEvent ev) {
            this.redispatchMouseEvent(ev);
        }

        @Override
        public void mouseEntered(MouseEvent ev) {
            this.redispatchMouseEvent(ev);
        }

        @Override
        public void mouseExited(MouseEvent ev) {
            this.redispatchMouseEvent(ev);
        }

        @Override
        public void mousePressed(MouseEvent ev) {
            this.redispatchMouseEvent(ev);
        }

        @Override
        public void mouseReleased(MouseEvent ev) {
            this.redispatchMouseEvent(ev);
        }

        private void redispatchMouseEvent(MouseEvent ev) {
            HighlightingGlassPane.this.authoringTool.handleMouseEvent(ev);
        }
    }
}

