/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.util;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources;
import edu.cmu.cs.stage3.alice.authoringtool.util.ImagePanel;
import edu.cmu.cs.stage3.alice.authoringtool.util.PointOfViewUndoableRedoable;
import edu.cmu.cs.stage3.alice.authoringtool.util.ScreenWrappingMouseListener;
import edu.cmu.cs.stage3.alice.core.ReferenceFrame;
import edu.cmu.cs.stage3.alice.core.Scheduler;
import edu.cmu.cs.stage3.alice.core.Transformable;
import edu.cmu.cs.stage3.alice.core.World;
import edu.cmu.cs.stage3.alice.scenegraph.Scene;
import edu.cmu.cs.stage3.lang.Messages;
import edu.cmu.cs.stage3.math.MathUtilities;
import edu.cmu.cs.stage3.math.Matrix33;
import edu.cmu.cs.stage3.math.Matrix44;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.vecmath.Vector3d;

public class GuiNavigator
extends JPanel
implements Runnable {
    public static final int SLIDE_MODE = 1;
    public static final int DRIVE_MODE = 2;
    public static final int TILT_MODE = 3;
    public static final int SMALL_IMAGES = 1;
    public static final int LARGE_IMAGES = 2;
    protected int mode = 0;
    protected int imageSize = 2;
    protected long lastTime;
    protected Transformable objectToNavigate;
    protected Transformable coreHelper = new Transformable();
    protected World world;
    protected Vector3d tempVec = new Vector3d();
    protected Matrix44 oldTransformation;
    protected ImagePanel slidePanel = new ImagePanel();
    protected ImagePanel drivePanel = new ImagePanel();
    protected ImagePanel tiltPanel = new ImagePanel();
    protected NavMouseListener navMouseListener = new NavMouseListener();
    protected int buffer = 4;
    protected AuthoringTool authoringTool;
    protected Image slide = AuthoringToolResources.getImageForString("guiNavigator/slide");
    protected Image slideDown = AuthoringToolResources.getImageForString("guiNavigator/slideDown");
    protected Image slideDownLeft = AuthoringToolResources.getImageForString("guiNavigator/slideDownLeft");
    protected Image slideDownRight = AuthoringToolResources.getImageForString("guiNavigator/slideDownRight");
    protected Image slideHighlight = AuthoringToolResources.getImageForString("guiNavigator/slideHighlight");
    protected Image slideLeft = AuthoringToolResources.getImageForString("guiNavigator/slideLeft");
    protected Image slideRight = AuthoringToolResources.getImageForString("guiNavigator/slideRight");
    protected Image slideUp = AuthoringToolResources.getImageForString("guiNavigator/slideUp");
    protected Image slideUpLeft = AuthoringToolResources.getImageForString("guiNavigator/slideUpLeft");
    protected Image slideUpRight = AuthoringToolResources.getImageForString("guiNavigator/slideUpRight");
    protected Image drive = AuthoringToolResources.getImageForString("guiNavigator/drive");
    protected Image driveBack = AuthoringToolResources.getImageForString("guiNavigator/driveBack");
    protected Image driveBackLeft = AuthoringToolResources.getImageForString("guiNavigator/driveBackLeft");
    protected Image driveBackRight = AuthoringToolResources.getImageForString("guiNavigator/driveBackRight");
    protected Image driveForward = AuthoringToolResources.getImageForString("guiNavigator/driveForward");
    protected Image driveForwardLeft = AuthoringToolResources.getImageForString("guiNavigator/driveForwardLeft");
    protected Image driveForwardRight = AuthoringToolResources.getImageForString("guiNavigator/driveForwardRight");
    protected Image driveHighlight = AuthoringToolResources.getImageForString("guiNavigator/driveHighlight");
    protected Image driveLeft = AuthoringToolResources.getImageForString("guiNavigator/driveLeft");
    protected Image driveRight = AuthoringToolResources.getImageForString("guiNavigator/driveRight");
    protected Image tilt = AuthoringToolResources.getImageForString("guiNavigator/tilt");
    protected Image tiltDown = AuthoringToolResources.getImageForString("guiNavigator/tiltDown");
    protected Image tiltHighlight = AuthoringToolResources.getImageForString("guiNavigator/tiltHighlight");
    protected Image tiltUp = AuthoringToolResources.getImageForString("guiNavigator/tiltUp");

    public GuiNavigator() {
        this.setOpaque(false);
        this.slidePanel.setImage(this.slide);
        this.drivePanel.setImage(this.drive);
        this.tiltPanel.setImage(this.tilt);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.slidePanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.drivePanel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.tiltPanel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.slidePanel.addMouseListener(this.navMouseListener);
        this.drivePanel.addMouseListener(this.navMouseListener);
        this.tiltPanel.addMouseListener(this.navMouseListener);
        this.slidePanel.setToolTipText(Messages.getString("Move_the_Camera_Up__Down__Left__and_Right_"));
        this.drivePanel.setToolTipText(Messages.getString("Move_the_Camera_Forward__Backward__Turn_the_Camera_Left__Right_"));
        this.tiltPanel.setToolTipText(Messages.getString("Tilt_the_Camera_Forward_and_Backward_"));
    }

    public void setAuthoringTool(AuthoringTool authoringTool) {
        this.authoringTool = authoringTool;
    }

    public ImagePanel getSlidePanel() {
        return this.slidePanel;
    }

    public ImagePanel getDrivePanel() {
        return this.drivePanel;
    }

    public ImagePanel getTiltPanel() {
        return this.tiltPanel;
    }

    public void setObjectToNavigate(Transformable objectToNavigate) {
        this.objectToNavigate = objectToNavigate;
        this.world = objectToNavigate != null ? objectToNavigate.getWorld() : null;
    }

    public void setImageSize(int size) {
        if (size == 1) {
            this.imageSize = size;
            this.slide = AuthoringToolResources.getImageForString("smallGuiNavigator/slide");
            this.slideDown = AuthoringToolResources.getImageForString("smallGuiNavigator/slideDown");
            this.slideDownLeft = AuthoringToolResources.getImageForString("smallGuiNavigator/slideDownLeft");
            this.slideDownRight = AuthoringToolResources.getImageForString("smallGuiNavigator/slideDownRight");
            this.slideHighlight = AuthoringToolResources.getImageForString("smallGuiNavigator/slideHighlight");
            this.slideLeft = AuthoringToolResources.getImageForString("smallGuiNavigator/slideLeft");
            this.slideRight = AuthoringToolResources.getImageForString("smallGuiNavigator/slideRight");
            this.slideUp = AuthoringToolResources.getImageForString("smallGuiNavigator/slideUp");
            this.slideUpLeft = AuthoringToolResources.getImageForString("smallGuiNavigator/slideUpLeft");
            this.slideUpRight = AuthoringToolResources.getImageForString("smallGuiNavigator/slideUpRight");
            this.drive = AuthoringToolResources.getImageForString("smallGuiNavigator/drive");
            this.driveBack = AuthoringToolResources.getImageForString("smallGuiNavigator/driveBack");
            this.driveBackLeft = AuthoringToolResources.getImageForString("smallGuiNavigator/driveBackLeft");
            this.driveBackRight = AuthoringToolResources.getImageForString("smallGuiNavigator/driveBackRight");
            this.driveForward = AuthoringToolResources.getImageForString("smallGuiNavigator/driveForward");
            this.driveForwardLeft = AuthoringToolResources.getImageForString("smallGuiNavigator/driveForwardLeft");
            this.driveForwardRight = AuthoringToolResources.getImageForString("smallGuiNavigator/driveForwardRight");
            this.driveHighlight = AuthoringToolResources.getImageForString("smallGuiNavigator/driveHighlight");
            this.driveLeft = AuthoringToolResources.getImageForString("smallGuiNavigator/driveLeft");
            this.driveRight = AuthoringToolResources.getImageForString("smallGuiNavigator/driveRight");
            this.tilt = AuthoringToolResources.getImageForString("smallGuiNavigator/tilt");
            this.tiltDown = AuthoringToolResources.getImageForString("smallGuiNavigator/tiltDown");
            this.tiltHighlight = AuthoringToolResources.getImageForString("smallGuiNavigator/tiltHighlight");
            this.tiltUp = AuthoringToolResources.getImageForString("smallGuiNavigator/tiltUp");
        } else if (size == 2) {
            this.imageSize = size;
            this.slide = AuthoringToolResources.getImageForString("guiNavigator/slide");
            this.slideDown = AuthoringToolResources.getImageForString("guiNavigator/slideDown");
            this.slideDownLeft = AuthoringToolResources.getImageForString("guiNavigator/slideDownLeft");
            this.slideDownRight = AuthoringToolResources.getImageForString("guiNavigator/slideDownRight");
            this.slideHighlight = AuthoringToolResources.getImageForString("guiNavigator/slideHighlight");
            this.slideLeft = AuthoringToolResources.getImageForString("guiNavigator/slideLeft");
            this.slideRight = AuthoringToolResources.getImageForString("guiNavigator/slideRight");
            this.slideUp = AuthoringToolResources.getImageForString("guiNavigator/slideUp");
            this.slideUpLeft = AuthoringToolResources.getImageForString("guiNavigator/slideUpLeft");
            this.slideUpRight = AuthoringToolResources.getImageForString("guiNavigator/slideUpRight");
            this.drive = AuthoringToolResources.getImageForString("guiNavigator/drive");
            this.driveBack = AuthoringToolResources.getImageForString("guiNavigator/driveBack");
            this.driveBackLeft = AuthoringToolResources.getImageForString("guiNavigator/driveBackLeft");
            this.driveBackRight = AuthoringToolResources.getImageForString("guiNavigator/driveBackRight");
            this.driveForward = AuthoringToolResources.getImageForString("guiNavigator/driveForward");
            this.driveForwardLeft = AuthoringToolResources.getImageForString("guiNavigator/driveForwardLeft");
            this.driveForwardRight = AuthoringToolResources.getImageForString("guiNavigator/driveForwardRight");
            this.driveHighlight = AuthoringToolResources.getImageForString("guiNavigator/driveHighlight");
            this.driveLeft = AuthoringToolResources.getImageForString("guiNavigator/driveLeft");
            this.driveRight = AuthoringToolResources.getImageForString("guiNavigator/driveRight");
            this.tilt = AuthoringToolResources.getImageForString("guiNavigator/tilt");
            this.tiltDown = AuthoringToolResources.getImageForString("guiNavigator/tiltDown");
            this.tiltHighlight = AuthoringToolResources.getImageForString("guiNavigator/tiltHighlight");
            this.tiltUp = AuthoringToolResources.getImageForString("guiNavigator/tiltUp");
        } else {
            AuthoringTool.showErrorDialog(String.valueOf(Messages.getString("Invalid_image_size_constant_in_setImageSize__")) + this.imageSize, null);
        }
        this.updateImages();
    }

    public void updateImages() {
        if (this.navMouseListener.isMouseDown()) {
            int offsetx = this.navMouseListener.getOffsetX();
            int offsety = this.navMouseListener.getOffsetY();
            if (this.mode == 1) {
                if (offsety > this.buffer) {
                    if (offsetx > this.buffer) {
                        this.slidePanel.setImage(this.slideDownRight);
                    } else if (Math.abs(offsetx) > this.buffer) {
                        this.slidePanel.setImage(this.slideDownLeft);
                    } else {
                        this.slidePanel.setImage(this.slideDown);
                    }
                } else if (Math.abs(offsety) > this.buffer) {
                    if (offsetx > this.buffer) {
                        this.slidePanel.setImage(this.slideUpRight);
                    } else if (Math.abs(offsetx) > this.buffer) {
                        this.slidePanel.setImage(this.slideUpLeft);
                    } else {
                        this.slidePanel.setImage(this.slideUp);
                    }
                } else if (offsetx > this.buffer) {
                    this.slidePanel.setImage(this.slideRight);
                } else if (Math.abs(offsetx) > this.buffer) {
                    this.slidePanel.setImage(this.slideLeft);
                } else {
                    this.slidePanel.setImage(this.slideHighlight);
                }
                this.drivePanel.setImage(this.drive);
                this.tiltPanel.setImage(this.tilt);
            } else if (this.mode == 2) {
                if (offsety > this.buffer) {
                    if (offsetx > this.buffer) {
                        this.drivePanel.setImage(this.driveBackRight);
                    } else if (Math.abs(offsetx) > this.buffer) {
                        this.drivePanel.setImage(this.driveBackLeft);
                    } else {
                        this.drivePanel.setImage(this.driveBack);
                    }
                } else if (Math.abs(offsety) > this.buffer) {
                    if (offsetx > this.buffer) {
                        this.drivePanel.setImage(this.driveForwardRight);
                    } else if (Math.abs(offsetx) > this.buffer) {
                        this.drivePanel.setImage(this.driveForwardLeft);
                    } else {
                        this.drivePanel.setImage(this.driveForward);
                    }
                } else if (offsetx > this.buffer) {
                    this.drivePanel.setImage(this.driveRight);
                } else if (Math.abs(offsetx) > this.buffer) {
                    this.drivePanel.setImage(this.driveLeft);
                } else {
                    this.drivePanel.setImage(this.driveHighlight);
                }
                this.slidePanel.setImage(this.slide);
                this.tiltPanel.setImage(this.tilt);
            } else if (this.mode == 3) {
                if (offsety > this.buffer) {
                    this.tiltPanel.setImage(this.tiltUp);
                } else if (Math.abs(offsety) > this.buffer) {
                    this.tiltPanel.setImage(this.tiltDown);
                } else {
                    this.tiltPanel.setImage(this.tiltHighlight);
                }
                this.slidePanel.setImage(this.slide);
                this.drivePanel.setImage(this.drive);
            } else {
                this.slidePanel.setImage(this.slide);
                this.drivePanel.setImage(this.drive);
                this.tiltPanel.setImage(this.tilt);
            }
        } else if (this.mode == 1) {
            this.slidePanel.setImage(this.slideHighlight);
            this.drivePanel.setImage(this.drive);
            this.tiltPanel.setImage(this.tilt);
        } else if (this.mode == 2) {
            this.slidePanel.setImage(this.slide);
            this.drivePanel.setImage(this.driveHighlight);
            this.tiltPanel.setImage(this.tilt);
        } else if (this.mode == 3) {
            this.slidePanel.setImage(this.slide);
            this.drivePanel.setImage(this.drive);
            this.tiltPanel.setImage(this.tiltHighlight);
        } else {
            this.slidePanel.setImage(this.slide);
            this.drivePanel.setImage(this.drive);
            this.tiltPanel.setImage(this.tilt);
        }
    }

    @Override
    public void run() {
        int offsetx = this.navMouseListener.getOffsetX();
        int offsety = this.navMouseListener.getOffsetY();
        long time = System.currentTimeMillis();
        long deltaTime = time - this.lastTime;
        if (deltaTime > 0L) {
            double dt = (double)deltaTime * 0.001;
            this.tempVec.x = 0.0;
            this.tempVec.y = 0.0;
            this.tempVec.z = 0.0;
            this.coreHelper.setPositionRightNow(this.tempVec, this.objectToNavigate);
            Matrix33 m = this.objectToNavigate.getOrientationAsAxes(this.world);
            this.tempVec.x = m.m20;
            this.tempVec.y = 0.0;
            this.tempVec.z = m.m22;
            this.coreHelper.setOrientationRightNow(this.tempVec, MathUtilities.getYAxis(), (ReferenceFrame)this.world);
            switch (this.mode) {
                case 1: {
                    this.tempVec.x = 0.0;
                    this.tempVec.y = -0.1 * (double)offsety * dt;
                    this.tempVec.z = 0.0;
                    this.objectToNavigate.moveRightNow(this.tempVec, (ReferenceFrame)this.world);
                    this.tempVec.x = 0.05 * (double)offsetx * dt;
                    this.tempVec.y = 0.0;
                    this.tempVec.z = 0.0;
                    this.objectToNavigate.moveRightNow(this.tempVec, (ReferenceFrame)this.objectToNavigate);
                    break;
                }
                case 2: {
                    if (this.objectToNavigate.getOrientationAsAxes((ReferenceFrame)this.world).m11 < 0.0) {
                        this.tempVec.x = -1.0;
                        this.tempVec.y = -1.0;
                        this.tempVec.z = 1.0;
                        this.coreHelper.scaleSpaceRightNow(this.tempVec, null);
                    }
                    if (this.navMouseListener.shiftIsDown) {
                        this.tempVec.x = 0.0;
                        this.tempVec.y = -0.05 * (double)offsety * dt;
                        this.tempVec.z = 0.0;
                        this.objectToNavigate.moveRightNow(this.tempVec, (ReferenceFrame)this.world);
                        break;
                    }
                    if (this.navMouseListener.controlIsDown) {
                        this.objectToNavigate.rotateRightNow(MathUtilities.getYAxis(), 0.001 * (double)offsetx * dt, this.coreHelper);
                        break;
                    }
                    this.tempVec.x = 0.0;
                    this.tempVec.y = 0.0;
                    this.tempVec.z = -0.05 * (double)offsety * dt;
                    this.objectToNavigate.moveRightNow(this.tempVec, (ReferenceFrame)this.coreHelper);
                    this.objectToNavigate.rotateRightNow(MathUtilities.getYAxis(), 6.0E-4 * (double)offsetx * dt, this.coreHelper);
                    break;
                }
                case 3: {
                    this.objectToNavigate.rotateRightNow(MathUtilities.getXAxis(), -0.001 * (double)offsety * dt, this.objectToNavigate);
                }
            }
        }
        this.lastTime = time;
    }

    class NavMouseListener
    extends ScreenWrappingMouseListener {
        protected Component source = null;
        public boolean shiftIsDown = false;
        public boolean controlIsDown = false;

        NavMouseListener() {
        }

        protected void setMode(MouseEvent ev) {
            if (ev == null) {
                GuiNavigator.this.mode = 0;
            } else if (ev.getComponent() == GuiNavigator.this.slidePanel) {
                GuiNavigator.this.mode = 1;
            } else if (ev.getComponent() == GuiNavigator.this.drivePanel) {
                GuiNavigator.this.mode = 2;
            } else if (ev.getComponent() == GuiNavigator.this.tiltPanel) {
                GuiNavigator.this.mode = 3;
            }
        }

        @Override
        public void mousePressed(MouseEvent ev) {
            super.mousePressed(ev);
            GuiNavigator.this.lastTime = System.currentTimeMillis();
            GuiNavigator.this.authoringTool.getUndoRedoStack().setIsListening(false);
            GuiNavigator.this.oldTransformation = GuiNavigator.this.objectToNavigate.getLocalTransformation();
            this.setMode(ev);
            if (GuiNavigator.this.imageSize == 2) {
                if (GuiNavigator.this.mode == 1) {
                    this.pressedx = 39;
                    this.pressedy = 38;
                } else if (GuiNavigator.this.mode == 2) {
                    this.pressedx = 58;
                    this.pressedy = 28;
                } else if (GuiNavigator.this.mode == 3) {
                    this.pressedx = 31;
                    this.pressedy = 42;
                }
            } else if (GuiNavigator.this.imageSize == 1) {
                if (GuiNavigator.this.mode == 1) {
                    this.pressedx = 19;
                    this.pressedy = 18;
                } else if (GuiNavigator.this.mode == 2) {
                    this.pressedx = 29;
                    this.pressedy = 13;
                } else if (GuiNavigator.this.mode == 3) {
                    this.pressedx = 14;
                    this.pressedy = 20;
                }
            } else {
                AuthoringTool.showErrorDialog(String.valueOf(Messages.getString("Invalid_image_size_constant_in_NavMouseListener__")) + GuiNavigator.this.imageSize, null);
            }
            super.mouseDragged(ev);
            Scene root = GuiNavigator.this.world.getSceneGraphScene();
            GuiNavigator.this.coreHelper.vehicle.set(GuiNavigator.this.world);
            GuiNavigator.this.coreHelper.setTransformationRightNow(GuiNavigator.this.objectToNavigate.getTransformation(GuiNavigator.this.world), GuiNavigator.this.world);
            this.shiftIsDown = ev.isShiftDown();
            this.controlIsDown = ev.isControlDown();
            GuiNavigator.this.authoringTool.getScheduler().addEachFrameRunnable(GuiNavigator.this);
            GuiNavigator.this.updateImages();
        }

        @Override
        public void mouseReleased(MouseEvent ev) {
            super.mouseReleased(ev);
            GuiNavigator.this.authoringTool.getScheduler().removeEachFrameRunnable(GuiNavigator.this);
            GuiNavigator.this.authoringTool.getUndoRedoStack().push(new PointOfViewUndoableRedoable(GuiNavigator.this.objectToNavigate, GuiNavigator.this.oldTransformation, GuiNavigator.this.objectToNavigate.getLocalTransformation(), (Scheduler)GuiNavigator.this.authoringTool.getOneShotScheduler()));
            GuiNavigator.this.authoringTool.getUndoRedoStack().setIsListening(true);
            if (ev.getComponent().contains(ev.getPoint())) {
                this.setMode(ev);
            } else {
                this.setMode(null);
            }
            GuiNavigator.this.updateImages();
        }

        @Override
        public void mouseDragged(MouseEvent ev) {
            super.mouseDragged(ev);
            this.shiftIsDown = ev.isShiftDown();
            this.controlIsDown = ev.isControlDown();
            this.setMode(ev);
            GuiNavigator.this.updateImages();
        }

        @Override
        public void mouseEntered(MouseEvent ev) {
            this.setMode(ev);
            GuiNavigator.this.updateImages();
        }

        @Override
        public void mouseExited(MouseEvent ev) {
            this.setMode(null);
            GuiNavigator.this.updateImages();
        }

        @Override
        public void mouseMoved(MouseEvent ev) {
            this.setMode(ev);
            GuiNavigator.this.updateImages();
        }

        @Override
        public void mouseClicked(MouseEvent ev) {
        }
    }
}

