/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.util;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.util.Configuration;
import edu.cmu.cs.stage3.alice.authoringtool.util.GUIElementContainerListener;
import edu.cmu.cs.stage3.alice.authoringtool.util.Releasable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;

public class GroupingPanel
extends JPanel
implements DropTargetListener,
Releasable {
    protected Border outerBorder;
    protected Border innerBorder;
    protected Border border;
    protected Configuration authoringToolConfig = Configuration.getLocalConfiguration(AuthoringTool.class.getPackage());

    public GroupingPanel() {
        this.outerBorder = new PartialLineBorder(Color.lightGray, 1, false, false, true, true);
        this.innerBorder = BorderFactory.createEmptyBorder(1, 1, 1, 1);
        this.border = BorderFactory.createCompoundBorder(this.outerBorder, this.innerBorder);
        this.setBorder(this.border);
        this.setDoubleBuffered(true);
        this.setDropTarget(new DropTarget(this, this));
        this.addContainerListener(new ContainerAdapter(){

            @Override
            public void componentAdded(ContainerEvent ev) {
                if (ev.getChild().getDropTarget() == null) {
                    ev.getChild().setDropTarget(new DropTarget(ev.getChild(), GroupingPanel.this));
                }
            }

            @Override
            public void componentRemoved(ContainerEvent ev) {
                if (ev.getChild().getDropTarget() != null) {
                    ev.getChild().getDropTarget().setActive(false);
                    ev.getChild().setDropTarget(null);
                }
            }
        });
        this.addContainerListener(GUIElementContainerListener.getStaticListener());
    }

    @Override
    public void release() {
        this.removeAll();
    }

    public void paintBackground(Graphics g) {
    }

    public void paintForeground(Graphics g) {
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.paintBackground(g);
    }

    @Override
    public void paintChildren(Graphics g) {
        super.paintChildren(g);
        this.paintForeground(g);
    }

    @Override
    public void printComponent(Graphics g) {
        if (this.authoringToolConfig.getValue("printing.fillBackground").equalsIgnoreCase("true")) {
            super.printComponent(g);
        }
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        if (this.getParent() instanceof DropTargetListener) {
            ((DropTargetListener)((Object)this.getParent())).dragEnter(dtde);
        } else {
            dtde.rejectDrag();
        }
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
        if (this.getParent() instanceof DropTargetListener) {
            ((DropTargetListener)((Object)this.getParent())).dragExit(dte);
        }
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        if (this.getParent() instanceof DropTargetListener) {
            ((DropTargetListener)((Object)this.getParent())).dragOver(dtde);
        } else {
            dtde.rejectDrag();
        }
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        if (this.getParent() instanceof DropTargetListener) {
            ((DropTargetListener)((Object)this.getParent())).drop(dtde);
        } else {
            dtde.rejectDrop();
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
        if (this.getParent() instanceof DropTargetListener) {
            ((DropTargetListener)((Object)this.getParent())).dropActionChanged(dtde);
        } else {
            dtde.rejectDrag();
        }
    }

    private class PartialLineBorder
    extends AbstractBorder {
        protected Color color;
        protected int thickness;
        protected boolean includeTop;
        protected boolean includeLeft;
        protected boolean includeBottom;
        protected boolean includeRight;

        public PartialLineBorder(Color color, int thickness, boolean includeTop, boolean includeLeft, boolean includeBottom, boolean includeRight) {
            this.color = color;
            this.thickness = thickness;
            this.includeTop = includeTop;
            this.includeLeft = includeLeft;
            this.includeBottom = includeBottom;
            this.includeRight = includeRight;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Color oldColor = g.getColor();
            g.setColor(this.color);
            int i = 0;
            while (i < this.thickness) {
                if (this.includeTop) {
                    g.drawLine(x, y + i, x + width - 1, y + i);
                }
                if (this.includeLeft) {
                    g.drawLine(x + i, y, x + i, y + height - 1);
                }
                if (this.includeBottom) {
                    g.drawLine(x, y - i + height - 1, x + width - 1, y - i + height - 1);
                }
                if (this.includeRight) {
                    g.drawLine(x - i + width - 1, y, x - i + width - 1, y + height - 1);
                }
                ++i;
            }
            g.setColor(oldColor);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(this.includeTop ? this.thickness : 0, this.includeLeft ? this.thickness : 0, this.includeBottom ? this.thickness : 0, this.includeRight ? this.thickness : 0);
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            insets.top = this.includeTop ? this.thickness : 0;
            insets.left = this.includeLeft ? this.thickness : 0;
            insets.bottom = this.includeBottom ? this.thickness : 0;
            insets.right = this.includeRight ? this.thickness : 0;
            return insets;
        }

        public Color getLineColor() {
            return this.color;
        }

        public int getThickness() {
            return this.thickness;
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }
    }
}

