/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.util;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;

public class GUIEffects {
    public static ImageObserver allBitsObserver = new ImageObserver(){

        @Override
        public boolean imageUpdate(Image image, int infoflags, int x, int y, int width, int height) {
            return (infoflags & 0x20) <= 0;
        }
    };
    public static ImageObserver sizeObserver = new ImageObserver(){

        @Override
        public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
            return (infoflags & 1 & 2) > 0;
        }
    };
    private static Color disabledBackgroundColor = AuthoringToolResources.getColor("guiEffectsDisabledBackground");
    private static Color disabledLineColor = AuthoringToolResources.getColor("guiEffectsDisabledLine");
    private static BufferedImage disabledImage;
    private static Dimension disabledImageSize;
    private static Color shadowColor;
    private static Color edgeColor;
    private static int shadowSteps;
    private static double dr;
    private static double dg;
    private static double db;
    private static double da;
    private static Color troughHighlightColor;
    private static Color troughShadowColor;

    static {
        disabledImageSize = new Dimension(-1, -1);
        shadowColor = AuthoringToolResources.getColor("guiEffectsShadow");
        edgeColor = AuthoringToolResources.getColor("guiEffectsEdge");
        shadowSteps = 4;
        dr = edgeColor.getRed() - shadowColor.getRed();
        dg = edgeColor.getGreen() - shadowColor.getGreen();
        db = edgeColor.getBlue() - shadowColor.getBlue();
        da = edgeColor.getAlpha() - shadowColor.getAlpha();
        troughHighlightColor = AuthoringToolResources.getColor("guiEffectsTroughHighlight");
        troughShadowColor = AuthoringToolResources.getColor("guiEffectsTroughShadow");
    }

    private static void createDisabledImage(int width, int height) {
        disabledImageSize.setSize(width, height);
        disabledImage = new BufferedImage(width, height, 2);
        Graphics2D g = (Graphics2D)disabledImage.getGraphics();
        g.addRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        g.setColor(disabledBackgroundColor);
        g.fillRect(0, 0, width, height);
        g.setColor(disabledLineColor);
        double slope = 2.0;
        int xOffset = (int)((double)height / slope);
        int spacing = 10;
        int x = 0;
        while (x <= width + xOffset) {
            g.drawLine(x, 0, x - xOffset, height);
            x += spacing;
        }
    }

    public static void paintDisabledEffect(Graphics g, Rectangle bounds) {
        if (bounds.width > GUIEffects.disabledImageSize.width || bounds.height > GUIEffects.disabledImageSize.height) {
            GUIEffects.createDisabledImage(bounds.width, bounds.height);
        }
        g.setClip(bounds.x, bounds.y, bounds.width, bounds.height);
        g.drawImage(disabledImage, bounds.x, bounds.y, allBitsObserver);
    }

    public static BufferedImage getImageScaledAndCropped(Image inputImage, double scaleFactor, Rectangle cropRect) {
        BufferedImage inputBufferedImage = new BufferedImage(inputImage.getWidth(sizeObserver), inputImage.getHeight(sizeObserver), 2);
        Graphics2D g = inputBufferedImage.createGraphics();
        g.drawImage(inputImage, 0, 0, allBitsObserver);
        AffineTransformOp scaleOp = new AffineTransformOp(AffineTransform.getScaleInstance(scaleFactor, scaleFactor), 2);
        BufferedImage scaledImage = scaleOp.filter(inputBufferedImage, null);
        scaledImage = scaledImage.getSubimage(cropRect.x, cropRect.y, Math.min(cropRect.width, scaledImage.getWidth() - cropRect.x), Math.min(cropRect.height, scaledImage.getHeight() - cropRect.y));
        BufferedImage outputImage = AuthoringTool.getHack() != null ? AuthoringTool.getHack().getJAliceFrame().getGraphicsConfiguration().createCompatibleImage(scaledImage.getWidth(sizeObserver), scaledImage.getHeight(sizeObserver), 3) : new BufferedImage(scaledImage.getWidth(sizeObserver), scaledImage.getHeight(sizeObserver), 2);
        g = outputImage.createGraphics();
        g.drawImage((Image)scaledImage, 0, 0, allBitsObserver);
        return outputImage;
    }

    public static BufferedImage getImageScaledToLongestDimension(Image inputImage, int longestDimension) {
        int height;
        int width = inputImage.getWidth(sizeObserver);
        double scaleFactor = width > (height = inputImage.getHeight(sizeObserver)) ? (double)longestDimension / (double)width : (double)longestDimension / (double)height;
        BufferedImage inputBufferedImage = new BufferedImage(width, height, 2);
        Graphics2D g = inputBufferedImage.createGraphics();
        g.drawImage(inputImage, 0, 0, allBitsObserver);
        AffineTransformOp scaleOp = new AffineTransformOp(AffineTransform.getScaleInstance(scaleFactor, scaleFactor), 2);
        BufferedImage scaledImage = scaleOp.filter(inputBufferedImage, null);
        return scaledImage;
    }

    public static BufferedImage getImageWithDropShadow(Image inputImage, int xOffset, int yOffset, int arcWidth, int arcHeight) {
        int width = inputImage.getWidth(sizeObserver);
        int height = inputImage.getHeight(sizeObserver);
        Rectangle imageBounds = new Rectangle(xOffset > 0 ? 0 : -xOffset + shadowSteps, yOffset > 0 ? 0 : -yOffset + shadowSteps, width, height);
        Rectangle shadowBounds = new Rectangle(xOffset > 0 ? xOffset - shadowSteps : 0, yOffset > 0 ? yOffset - shadowSteps : 0, width + shadowSteps * 2, height + shadowSteps * 2);
        BufferedImage outputImage = AuthoringTool.getHack() != null ? AuthoringTool.getHack().getJAliceFrame().getGraphicsConfiguration().createCompatibleImage(width + Math.abs(xOffset) + shadowSteps, height + Math.abs(yOffset) + shadowSteps, 3) : new BufferedImage(width + Math.abs(xOffset) + shadowSteps, height + Math.abs(yOffset) + shadowSteps, 2);
        Graphics2D g = outputImage.createGraphics();
        GUIEffects.paintDropShadow(g, shadowBounds, arcWidth, arcHeight);
        g.drawImage(inputImage, imageBounds.x, imageBounds.y, allBitsObserver);
        return outputImage;
    }

    public static void paintDropShadow(Graphics g, Rectangle bounds, int arcWidth, int arcHeight) {
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        Color c = new Color(edgeColor.getRed(), edgeColor.getGreen(), edgeColor.getBlue(), edgeColor.getAlpha());
        int i = 0;
        while (i < shadowSteps) {
            double portion = (double)i / (double)shadowSteps;
            c = new Color(edgeColor.getRed() - (int)(portion * dr), edgeColor.getGreen() - (int)(portion * dg), edgeColor.getBlue() - (int)(portion * db), edgeColor.getAlpha() - (int)(portion * da));
            g.setColor(c);
            g.drawRoundRect(bounds.x, bounds.y, bounds.width - 1, bounds.height - 1, arcWidth, arcHeight);
            ++bounds.x;
            ++bounds.y;
            bounds.width -= 2;
            bounds.height -= 2;
            ++i;
        }
        g.setColor(shadowColor);
        g.fillRoundRect(bounds.x, bounds.y, bounds.width, bounds.height, arcWidth, arcHeight);
    }

    public static BufferedImage getImageWithColoredBorder(Image inputImage, Color color) {
        int width = inputImage.getWidth(sizeObserver);
        int height = inputImage.getHeight(sizeObserver);
        BufferedImage outputImage = AuthoringTool.getHack() != null ? AuthoringTool.getHack().getJAliceFrame().getGraphicsConfiguration().createCompatibleImage(width, height, 3) : new BufferedImage(width, height, 2);
        Graphics2D g = outputImage.createGraphics();
        g.drawImage(inputImage, 0, 0, allBitsObserver);
        GUIEffects.paintColoredBorder(g, color, width, height);
        return outputImage;
    }

    public static void paintColoredBorder(Graphics g, Color color, int width, int height) {
        g.setColor(color);
        g.drawRect(0, 0, width - 1, height - 1);
        g.drawRect(1, 1, width - 3, height - 3);
    }

    public static void paintTrough(Graphics g, Rectangle bounds, int arcWidth, int arcHeight) {
        Object oldAntialiasing = null;
        Shape oldClip = g.getClip();
        if (g instanceof Graphics2D) {
            oldAntialiasing = ((Graphics2D)g).getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            ((Graphics2D)g).addRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
            int halfHeight = bounds.height / 2;
            Polygon highlightClip = new Polygon();
            highlightClip.addPoint(bounds.x, bounds.y + bounds.height);
            highlightClip.addPoint(bounds.x + halfHeight, bounds.y + halfHeight);
            highlightClip.addPoint(bounds.x + bounds.width - halfHeight, bounds.y + halfHeight);
            highlightClip.addPoint(bounds.x + bounds.width, bounds.y);
            highlightClip.addPoint(bounds.x + bounds.width, bounds.y + bounds.height);
            Polygon shadowClip = new Polygon();
            shadowClip.addPoint(bounds.x, bounds.y + bounds.height);
            shadowClip.addPoint(bounds.x, bounds.y);
            shadowClip.addPoint(bounds.x + bounds.width, bounds.y);
            shadowClip.addPoint(bounds.x + bounds.width - halfHeight, bounds.y + halfHeight);
            shadowClip.addPoint(bounds.x + halfHeight, bounds.y + halfHeight);
            Object edgeTreatment = AuthoringToolResources.getMiscItem("tileEdgeTreatment");
            if (edgeTreatment.equals("square")) {
                ((Graphics2D)g).clip(highlightClip);
                g.setColor(troughHighlightColor);
                g.drawRect(bounds.x, bounds.y, bounds.width - 1, bounds.height - 1);
                g.setClip(oldClip);
                ((Graphics2D)g).clip(shadowClip);
                g.setColor(troughShadowColor);
                g.drawRect(bounds.x, bounds.y, bounds.width - 1, bounds.height - 1);
            } else {
                ((Graphics2D)g).clip(highlightClip);
                g.setColor(troughHighlightColor);
                g.drawRoundRect(bounds.x, bounds.y, bounds.width - 1, bounds.height - 1, arcWidth, arcHeight);
                g.setClip(oldClip);
                ((Graphics2D)g).clip(shadowClip);
                g.setColor(troughShadowColor);
                g.drawRoundRect(bounds.x, bounds.y, bounds.width - 1, bounds.height - 1, arcWidth, arcHeight);
            }
            g.setClip(oldClip);
            ((Graphics2D)g).addRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, oldAntialiasing));
        }
    }
}

