/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.util;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.InputVerifier;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FontChooser
extends JPanel {
    protected HashSet changeListeners = new HashSet();
    JComboBox fontFaceCombo = new JComboBox();
    JComboBox fontSizeCombo = new JComboBox();
    JToggleButton boldToggle = new JToggleButton();
    JToggleButton italicToggle = new JToggleButton();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    Border border1;
    Component component1;
    JScrollPane previewScrollPane = new JScrollPane();
    JTextArea previewTextArea = new JTextArea();

    public FontChooser(boolean sizeVisible, boolean previewVisible) {
        this.init(sizeVisible, previewVisible);
    }

    private void init(boolean sizeVisible, boolean previewVisible) {
        this.jbInit();
        this.fontSizeCombo.setVisible(sizeVisible);
        this.previewScrollPane.setVisible(previewVisible);
        String[] families = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        int i = 0;
        while (i < families.length) {
            this.fontFaceCombo.addItem(families[i]);
            ++i;
        }
        this.fontFaceCombo.setSelectedIndex(0);
        this.fontSizeCombo.addItem(" 8");
        this.fontSizeCombo.addItem(" 9");
        this.fontSizeCombo.addItem("10");
        this.fontSizeCombo.addItem("11");
        this.fontSizeCombo.addItem("12");
        this.fontSizeCombo.addItem("14");
        this.fontSizeCombo.addItem("16");
        this.fontSizeCombo.addItem("18");
        this.fontSizeCombo.addItem("20");
        this.fontSizeCombo.addItem("22");
        this.fontSizeCombo.addItem("24");
        this.fontSizeCombo.addItem("26");
        this.fontSizeCombo.addItem("28");
        this.fontSizeCombo.addItem("36");
        this.fontSizeCombo.addItem("48");
        this.fontSizeCombo.addItem("72");
        this.fontSizeCombo.setSelectedIndex(0);
        this.fontSizeCombo.setInputVerifier(new InputVerifier(){

            @Override
            public boolean verify(JComponent c) {
                try {
                    String text = (String)((JComboBox)c).getSelectedItem();
                    Integer.parseInt(text.trim());
                    return true;
                }
                catch (NumberFormatException e) {
                    return false;
                }
                catch (Exception e) {
                    AuthoringTool.showErrorDialog(e.getMessage(), e);
                    return true;
                }
            }
        });
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                FontChooser.this.fireChange(ev.getSource());
            }
        };
        this.fontFaceCombo.addActionListener(actionListener);
        this.fontSizeCombo.addActionListener(actionListener);
        this.boldToggle.addActionListener(actionListener);
        this.italicToggle.addActionListener(actionListener);
    }

    public Font getChosenFont() {
        String familyName = (String)this.fontFaceCombo.getSelectedItem();
        int size = Integer.parseInt(((String)this.fontSizeCombo.getSelectedItem()).trim());
        int style = (this.boldToggle.isSelected() ? 1 : 0) | (this.italicToggle.isSelected() ? 2 : 0);
        return new Font(familyName, style, size);
    }

    public void setSizeVisible(boolean sizeVisible) {
        this.fontSizeCombo.setVisible(sizeVisible);
    }

    public void setPreviewVisible(boolean previewVisible) {
        this.previewScrollPane.setVisible(previewVisible);
    }

    public void setFontFace(String fontName) {
        this.fontFaceCombo.setSelectedItem(fontName);
        this.fireChange(this.fontFaceCombo);
    }

    public void setFontSize(int size) {
        this.fontSizeCombo.setSelectedItem(Integer.toString(size));
        this.fireChange(this.fontSizeCombo);
    }

    public void setFontStyle(int bitmask) {
        boolean italic;
        boolean bold = (bitmask & 1) > 0;
        boolean bl = italic = (bitmask & 2) > 0;
        if (bold != this.boldToggle.isSelected()) {
            this.boldToggle.setSelected(bold);
            this.fireChange(this.boldToggle);
        }
        if (italic != this.italicToggle.isSelected()) {
            this.italicToggle.setSelected(italic);
            this.fireChange(this.italicToggle);
        }
    }

    public void setSampleText(String text) {
        if (text != null) {
            this.previewTextArea.setText(text);
        } else {
            this.previewTextArea.setText("The quick brown fox jumped over the lazy dog's back.");
        }
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeListeners.add(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeListeners.remove(listener);
    }

    protected void fireChange(Object source) {
        Font font = this.getChosenFont();
        this.previewTextArea.setFont(font);
        ChangeEvent ev = new ChangeEvent(source);
        Iterator iter = this.changeListeners.iterator();
        while (iter.hasNext()) {
            ((ChangeListener)iter.next()).stateChanged(ev);
        }
    }

    private void jbInit() {
        this.border1 = BorderFactory.createEmptyBorder(4, 4, 4, 4);
        this.component1 = Box.createGlue();
        this.boldToggle.setFont(new Font("SansSerif", 1, 14));
        this.boldToggle.setAlignmentX(0.5f);
        this.boldToggle.setMaximumSize(new Dimension(27, 27));
        this.boldToggle.setMinimumSize(new Dimension(27, 27));
        this.boldToggle.setPreferredSize(new Dimension(27, 27));
        this.boldToggle.setMargin(new Insets(2, 3, 2, 2));
        this.boldToggle.setText("B");
        this.italicToggle.setFont(new Font("Serif", 3, 14));
        this.italicToggle.setMaximumSize(new Dimension(27, 27));
        this.italicToggle.setMinimumSize(new Dimension(27, 27));
        this.italicToggle.setPreferredSize(new Dimension(27, 27));
        this.italicToggle.setMargin(new Insets(2, 1, 2, 3));
        this.italicToggle.setText("I");
        this.setLayout(this.gridBagLayout1);
        this.setBorder(this.border1);
        this.fontSizeCombo.setMinimumSize(new Dimension(60, 26));
        this.fontSizeCombo.setPreferredSize(new Dimension(60, 26));
        this.fontSizeCombo.setEditable(true);
        this.previewTextArea.setText("The quick brown fox jumped over the lazy dog's back.");
        this.add((Component)this.fontFaceCombo, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 16, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.fontSizeCombo, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 16, 0, new Insets(0, 4, 0, 0), 0, 0));
        this.add((Component)this.boldToggle, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 16, 0, new Insets(0, 4, 0, 0), 0, 0));
        this.add((Component)this.italicToggle, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 16, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.component1, new GridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 16, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.previewScrollPane, new GridBagConstraints(0, 1, 5, 1, 1.0, 1.0, 11, 1, new Insets(8, 0, 0, 0), 0, 0));
        this.previewScrollPane.getViewport().add((Component)this.previewTextArea, null);
    }
}

