/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.util;

import edu.cmu.cs.stage3.alice.authoringtool.event.AuthoringToolStateChangedEvent;
import edu.cmu.cs.stage3.alice.authoringtool.event.AuthoringToolStateListener;
import edu.cmu.cs.stage3.alice.authoringtool.util.TreeModelSupport;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.World;
import edu.cmu.cs.stage3.alice.core.event.ChildrenEvent;
import edu.cmu.cs.stage3.alice.core.event.ChildrenListener;
import edu.cmu.cs.stage3.alice.core.event.PropertyEvent;
import edu.cmu.cs.stage3.alice.core.event.PropertyListener;
import edu.cmu.cs.stage3.lang.Messages;
import edu.cmu.cs.stage3.util.Criterion;
import java.util.LinkedList;
import javax.swing.event.TreeModelEvent;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class FilteringElementTreeModel
extends TreeModelSupport
implements PropertyListener,
ChildrenListener,
AuthoringToolStateListener,
TreeModel {
    protected Element root;
    protected Object[] emptyPath = new Object[]{new World()};
    protected LinkedList inclusionList;
    protected LinkedList exclusionList;

    public LinkedList getInclusionList() {
        return this.inclusionList;
    }

    public void setInclusionList(LinkedList list) {
        this.inclusionList = list;
        this.update();
    }

    public LinkedList getExclusionList() {
        return this.exclusionList;
    }

    public void setExclusionList(LinkedList list) {
        this.exclusionList = list;
        this.update();
    }

    public boolean isAcceptedByFilter(Element element) {
        if (this.inclusionList == null) {
            return false;
        }
        if (this.exclusionList != null) {
            for (Object item : this.exclusionList) {
                if (!(item instanceof Criterion) || !((Criterion)item).accept(element)) continue;
                return false;
            }
        }
        if (this.inclusionList != null) {
            for (Object item : this.inclusionList) {
                if (!(item instanceof Criterion) || !((Criterion)item).accept(element)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isElementInTree(Element element) {
        if (element == this.root) {
            return true;
        }
        if (element == null) {
            return false;
        }
        return this.isElementInTree(element.getParent()) && this.isAcceptedByFilter(element);
    }

    public void update() {
        this.clearAllListening(this.root);
        this.startListeningToTree(this.root);
        if (this.root == null) {
            TreeModelEvent ev = new TreeModelEvent((Object)this, this.emptyPath);
            this.fireTreeStructureChanged(ev);
        } else {
            TreeModelEvent ev = new TreeModelEvent((Object)this, this.getPath(this.root));
            this.fireTreeStructureChanged(ev);
        }
    }

    public void setRoot(Element root) {
        this.clearAllListening(this.root);
        this.root = root;
        this.startListeningToTree(root);
        if (root == null) {
            TreeModelEvent ev = new TreeModelEvent((Object)this, this.emptyPath);
            this.fireTreeStructureChanged(ev);
        } else {
            TreeModelEvent ev = new TreeModelEvent((Object)this, this.getPath(root));
            this.fireTreeStructureChanged(ev);
        }
    }

    public Object[] getPath(Element element) {
        LinkedList<Element> list = new LinkedList<Element>();
        Element e = element;
        while (true) {
            if (e == null) {
                return new Object[0];
            }
            list.addFirst(e);
            if (e == this.root) break;
            e = e.getParent();
        }
        return list.toArray();
    }

    public void setListeningEnabled(boolean enabled) {
        if (enabled) {
            this.startListeningToTree(this.root);
        } else {
            this.stopListeningToTree(this.root);
        }
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public boolean isLeaf(Object node) {
        if (node == null) {
            return true;
        }
        if (node == this.root) {
            return false;
        }
        if (!(node instanceof Element)) {
            throw new IllegalArgumentException(Messages.getString("nodes_must_be_edu_cmu_cs_stage3_alice_core_Elements"));
        }
        Element element = (Element)node;
        Element[] children = element.getChildren();
        int i = 0;
        while (i < children.length) {
            if (this.isAcceptedByFilter(children[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public int getChildCount(Object parent) {
        if (!(parent instanceof Element)) {
            throw new IllegalArgumentException(Messages.getString("nodes_must_be_edu_cmu_cs_stage3_alice_core_Elements"));
        }
        int childCount = 0;
        Element element = (Element)parent;
        Element[] children = element.getChildren();
        int i = 0;
        while (i < children.length) {
            if (this.isAcceptedByFilter(children[i])) {
                ++childCount;
            }
            ++i;
        }
        return childCount;
    }

    @Override
    public Object getChild(Object parent, int index) {
        if (!(parent instanceof Element)) {
            throw new IllegalArgumentException(Messages.getString("nodes_must_be_edu_cmu_cs_stage3_alice_core_Elements"));
        }
        int childCount = 0;
        Element element = (Element)parent;
        Element[] children = element.getChildren();
        int i = 0;
        while (i < children.length) {
            if (this.isAcceptedByFilter(children[i])) {
                if (childCount == index) {
                    return children[i];
                }
                ++childCount;
            }
            ++i;
        }
        return null;
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        if (!(parent instanceof Element)) {
            throw new IllegalArgumentException(Messages.getString("nodes_must_be_edu_cmu_cs_stage3_alice_core_Elements"));
        }
        if (!(child instanceof Element)) {
            throw new IllegalArgumentException(Messages.getString("nodes_must_be_edu_cmu_cs_stage3_alice_core_Elements"));
        }
        int childCount = 0;
        Element element = (Element)parent;
        Element[] children = element.getChildren();
        int i = 0;
        while (i < children.length) {
            if (this.isAcceptedByFilter(children[i])) {
                if (children[i] == child) {
                    return childCount;
                }
                ++childCount;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        if (path.getLastPathComponent() instanceof Element && newValue instanceof String) {
            Element element = (Element)path.getLastPathComponent();
            Object previousName = element.name.get();
            try {
                element.name.set(newValue);
            }
            catch (IllegalArgumentException e) {
                element.name.set(previousName);
            }
        } else {
            throw new RuntimeException(Messages.getString("FilteringElementTreeModel_only_allows_name_changes_through_the_model"));
        }
    }

    @Override
    public void stateChanging(AuthoringToolStateChangedEvent ev) {
        if (ev.getCurrentState() == 3) {
            this.setListeningEnabled(false);
        } else {
            this.setListeningEnabled(true);
        }
    }

    @Override
    public void worldLoading(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void worldUnLoading(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void worldStarting(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void worldStopping(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void worldPausing(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void worldSaving(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void stateChanged(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void worldLoaded(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void worldUnLoaded(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void worldStarted(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void worldStopped(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void worldPaused(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void worldSaved(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void childrenChanging(ChildrenEvent childrenEvent) {
    }

    @Override
    public void childrenChanged(ChildrenEvent childrenEvent) {
        Element element = childrenEvent.getChild();
        Element parent = (Element)childrenEvent.getSource();
        Object[] path = this.getPath(parent);
        if (childrenEvent.getChangeType() == 1) {
            if (this.isAcceptedByFilter(element)) {
                this.startListeningToTree(element);
                int[] childIndices = new int[]{this.getIndexOfChild(parent, element)};
                Object[] children = new Object[]{element};
                TreeModelEvent ev = new TreeModelEvent((Object)this, path, childIndices, children);
                this.fireTreeNodesInserted(ev);
            }
        } else if (childrenEvent.getChangeType() == 3) {
            this.stopListeningToTree(element);
            TreeModelEvent ev = new TreeModelEvent((Object)this, path);
            this.fireTreeStructureChanged(ev);
        } else if (childrenEvent.getChangeType() == 2 && this.isElementInTree(element)) {
            TreeModelEvent ev = new TreeModelEvent((Object)this, path);
            this.fireTreeStructureChanged(ev);
        }
    }

    @Override
    public void propertyChanging(PropertyEvent propertyEvent) {
    }

    @Override
    public void propertyChanged(PropertyEvent propertyEvent) {
        if (propertyEvent.getProperty() == propertyEvent.getProperty().getOwner().name) {
            Element element = propertyEvent.getProperty().getOwner();
            Element parent = element.getParent();
            Object[] path = this.getPath(parent);
            int[] childIndices = new int[]{this.getIndexOfChild(parent, element)};
            Object[] children = new Object[]{element};
            if (path == null || path.length == 0) {
                path = this.getPath(element);
                childIndices = null;
                children = null;
            }
            TreeModelEvent ev = new TreeModelEvent((Object)this, path, childIndices, children);
            this.fireTreeNodesChanged(ev);
        }
    }

    protected void startListeningToTree(Element element) {
        if (element != null) {
            element.addChildrenListener(this);
            element.name.addPropertyListener(this);
            Element[] children = element.getChildren();
            int i = 0;
            while (i < children.length) {
                if (this.isAcceptedByFilter(children[i])) {
                    this.startListeningToTree(children[i]);
                }
                ++i;
            }
        }
    }

    protected void stopListeningToTree(Element element) {
        if (element != null) {
            element.removeChildrenListener(this);
            element.name.removePropertyListener(this);
            Element[] children = element.getChildren();
            int i = 0;
            while (i < children.length) {
                if (this.isAcceptedByFilter(children[i])) {
                    this.stopListeningToTree(children[i]);
                }
                ++i;
            }
        }
    }

    protected void clearAllListening(Element element) {
        if (element != null) {
            element.removeChildrenListener(this);
            element.name.removePropertyListener(this);
            Element[] children = element.getChildren();
            int i = 0;
            while (i < children.length) {
                this.clearAllListening(children[i]);
                ++i;
            }
        }
    }

    protected static int getClassDepth(Class superclass, Class subclass) {
        if (!superclass.isAssignableFrom(subclass)) {
            return -1;
        }
        Class temp = subclass;
        int i = 0;
        while (temp != superclass && superclass.isAssignableFrom(temp)) {
            ++i;
            temp = temp.getSuperclass();
        }
        return i;
    }
}

