/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.util;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.Expression;
import edu.cmu.cs.stage3.alice.core.Property;
import edu.cmu.cs.stage3.alice.core.Question;
import edu.cmu.cs.stage3.alice.core.Variable;
import edu.cmu.cs.stage3.alice.core.World;
import edu.cmu.cs.stage3.alice.core.question.PropertyValue;
import edu.cmu.cs.stage3.alice.core.question.userdefined.CallToUserDefinedQuestion;
import edu.cmu.cs.stage3.alice.core.question.userdefined.ForEach;
import edu.cmu.cs.stage3.alice.core.question.userdefined.LoopN;
import edu.cmu.cs.stage3.alice.core.response.CallToUserDefinedResponse;
import edu.cmu.cs.stage3.alice.core.response.ForEachInOrder;
import edu.cmu.cs.stage3.alice.core.response.ForEachTogether;
import edu.cmu.cs.stage3.alice.core.response.LoopNInOrder;
import edu.cmu.cs.stage3.lang.Messages;
import edu.cmu.cs.stage3.util.StringObjectPair;
import java.util.Arrays;
import java.util.ListIterator;
import java.util.Vector;

public class ElementPrototype {
    protected Class elementClass;
    protected StringObjectPair[] knownPropertyValues;
    protected String[] desiredProperties;

    public ElementPrototype(Class elementClass, StringObjectPair[] knownPropertyValues, String[] desiredProperties) {
        if (!Element.class.isAssignableFrom(elementClass)) {
            throw new IllegalArgumentException(Messages.getString("The_elementClass_given_is_not_actually_a_subclass_of_Element_"));
        }
        Element testElement = null;
        try {
            testElement = (Element)elementClass.newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.valueOf(Messages.getString("Unable_to_create_a_new_element_of_type__")) + elementClass.getName());
        }
        if (!CallToUserDefinedResponse.class.isAssignableFrom(elementClass) && !CallToUserDefinedQuestion.class.isAssignableFrom(elementClass)) {
            int i;
            if (knownPropertyValues != null) {
                i = 0;
                while (i < knownPropertyValues.length) {
                    String propertyName = knownPropertyValues[i].getString();
                    Object propertyValue = knownPropertyValues[i].getObject();
                    Property property = testElement.getPropertyNamed(propertyName);
                    if (property == null) {
                        throw new IllegalArgumentException(String.valueOf(Messages.getString("property_named_")) + propertyName + " " + Messages.getString("does_not_exist_in_") + elementClass.getName());
                    }
                    if (propertyValue != null) {
                        if (propertyValue instanceof Expression) {
                            Class valueClass = property.getValueClass();
                            if (!property.getValueClass().isAssignableFrom(propertyValue.getClass()) && !property.getValueClass().isAssignableFrom(((Expression)propertyValue).getValueClass())) {
                                throw new IllegalArgumentException(String.valueOf(Messages.getString("property_named_")) + propertyName + " " + Messages.getString("in_class_") + elementClass.getName() + " " + Messages.getString("does_not_accept_expressions_of_type_") + ((Expression)propertyValue).getValueClass().getName());
                            }
                        } else if (!property.getValueClass().isAssignableFrom(propertyValue.getClass())) {
                            throw new IllegalArgumentException(String.valueOf(Messages.getString("property_named_")) + propertyName + " " + Messages.getString("in_class_") + elementClass.getName() + " " + Messages.getString("does_not_accept_values_of_type_") + propertyValue.getClass().getName() + Messages.getString("__bad_value__") + propertyValue);
                        }
                    }
                    ++i;
                }
            } else {
                knownPropertyValues = new StringObjectPair[]{};
            }
            if (desiredProperties != null) {
                i = 0;
                while (i < desiredProperties.length) {
                    Property property = testElement.getPropertyNamed(desiredProperties[i]);
                    if (property == null) {
                        throw new IllegalArgumentException(String.valueOf(Messages.getString("property_named_")) + desiredProperties[i] + " " + Messages.getString("does_not_exist_in_") + elementClass.getName());
                    }
                    ++i;
                }
            } else {
                desiredProperties = new String[]{};
            }
        }
        this.elementClass = elementClass;
        this.knownPropertyValues = knownPropertyValues;
        this.desiredProperties = desiredProperties;
    }

    public Element createNewElement() {
        try {
            Variable indexVar;
            Variable eachVar;
            Element element = (Element)this.elementClass.newInstance();
            if (this.knownPropertyValues != null) {
                int i = 0;
                while (i < this.knownPropertyValues.length) {
                    Element e;
                    String propertyName = this.knownPropertyValues[i].getString();
                    Object propertyValue = this.knownPropertyValues[i].getObject();
                    Property property = element.getPropertyNamed(propertyName);
                    property.set(propertyValue);
                    if (propertyValue instanceof PropertyValue) {
                        PropertyValue propertyValueQuestion = (PropertyValue)propertyValue;
                        propertyValueQuestion.removeFromParent();
                        property.getOwner().addChild(propertyValueQuestion);
                    } else if (propertyValue instanceof Question) {
                        Question q = (Question)propertyValue;
                        q.removeFromParent();
                        property.getOwner().addChild(q);
                        q.data.put("associatedProperty", property.getName());
                    }
                    if (propertyValue instanceof Element && (e = (Element)propertyValue).getParent() == null && !(e instanceof World)) {
                        property.getOwner().addChild(e);
                        e.data.put("associatedProperty", property.getName());
                    }
                    ++i;
                }
            }
            if (edu.cmu.cs.stage3.alice.core.response.ForEach.class.isAssignableFrom(this.elementClass)) {
                edu.cmu.cs.stage3.alice.core.response.ForEach forResponse = null;
                if (ForEachInOrder.class.isAssignableFrom(this.elementClass)) {
                    forResponse = (ForEachInOrder)element;
                } else if (ForEachTogether.class.isAssignableFrom(this.elementClass)) {
                    forResponse = (ForEachTogether)element;
                }
                eachVar = new Variable();
                eachVar.name.set(Messages.getString("item"));
                eachVar.valueClass.set(Object.class);
                forResponse.addChild(eachVar);
                forResponse.each.set(eachVar);
            } else if (ForEach.class.isAssignableFrom(this.elementClass)) {
                ForEach forQuestion = (ForEach)element;
                eachVar = new Variable();
                eachVar.name.set(Messages.getString("item"));
                eachVar.valueClass.set(Object.class);
                forQuestion.addChild(eachVar);
                forQuestion.each.set(eachVar);
            } else if (LoopNInOrder.class.isAssignableFrom(this.elementClass)) {
                LoopNInOrder loopN = (LoopNInOrder)element;
                indexVar = new Variable();
                indexVar.name.set(Messages.getString("index"));
                indexVar.valueClass.set(Number.class);
                loopN.addChild(indexVar);
                loopN.index.set(indexVar);
            } else if (LoopN.class.isAssignableFrom(this.elementClass)) {
                LoopN loopN = (LoopN)element;
                indexVar = new Variable();
                indexVar.name.set(Messages.getString("index"));
                indexVar.valueClass.set(Number.class);
                loopN.addChild(indexVar);
                loopN.index.set(indexVar);
            }
            return element;
        }
        catch (Exception e) {
            AuthoringTool.showErrorDialog(Messages.getString("Error_creating_new_element_"), e);
            return null;
        }
    }

    public ElementPrototype createCopy(StringObjectPair newKnownPropertyValue) {
        return this.createCopy(new StringObjectPair[]{newKnownPropertyValue});
    }

    public ElementPrototype createCopy(StringObjectPair[] newKnownPropertyValues) {
        Vector<StringObjectPair> vKnownPropertyValues = new Vector<StringObjectPair>(Arrays.asList(this.knownPropertyValues));
        Vector<String> vDesiredProperties = new Vector<String>(Arrays.asList(this.desiredProperties));
        if (newKnownPropertyValues != null) {
            int i = 0;
            while (i < newKnownPropertyValues.length) {
                if (vDesiredProperties.contains(newKnownPropertyValues[i].getString())) {
                    vDesiredProperties.remove(newKnownPropertyValues[i].getString());
                }
                boolean subbed = false;
                ListIterator<StringObjectPair> iter = vKnownPropertyValues.listIterator();
                while (iter.hasNext()) {
                    StringObjectPair pair = iter.next();
                    if (!pair.getString().equals(newKnownPropertyValues[i].getString())) continue;
                    iter.set(newKnownPropertyValues[i]);
                    subbed = true;
                }
                if (!subbed) {
                    vKnownPropertyValues.add(newKnownPropertyValues[i]);
                }
                ++i;
            }
        }
        return this.createInstance(this.elementClass, vKnownPropertyValues.toArray(new StringObjectPair[0]), vDesiredProperties.toArray(new String[0]));
    }

    public Class getElementClass() {
        return this.elementClass;
    }

    public StringObjectPair[] getKnownPropertyValues() {
        return this.knownPropertyValues;
    }

    public String[] getDesiredProperties() {
        return this.desiredProperties;
    }

    protected ElementPrototype createInstance(Class elementClass, StringObjectPair[] knownPropertyValues, String[] desiredProperties) {
        return new ElementPrototype(elementClass, knownPropertyValues, desiredProperties);
    }

    public String toString() {
        int i;
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf(this.getClass().getName()) + "[ ");
        sb.append("elementClass = " + this.elementClass.getName() + ", ");
        sb.append("knownPropertyValues = [ ");
        if (this.knownPropertyValues != null) {
            i = 0;
            while (i < this.knownPropertyValues.length) {
                sb.append("StringObjectPair( ");
                sb.append(String.valueOf(this.knownPropertyValues[i].getString()) + ", ");
                sb.append(String.valueOf(this.knownPropertyValues[i].getObject().toString()) + ", ");
                sb.append("), ");
                ++i;
            }
        } else {
            sb.append("<null>");
        }
        sb.append(" ], ");
        sb.append("desiredProperties = [ ");
        if (this.desiredProperties != null) {
            i = 0;
            while (i < this.desiredProperties.length) {
                sb.append(String.valueOf(this.desiredProperties[i]) + ", ");
                ++i;
            }
        } else {
            sb.append("<null>");
        }
        sb.append(" ], ]");
        return sb.toString();
    }
}

