/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.util;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources;
import edu.cmu.cs.stage3.alice.authoringtool.Editor;
import edu.cmu.cs.stage3.lang.Messages;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Vector;

public final class EditorUtilities {
    private static Class[] allEditors = null;

    static {
        allEditors = AuthoringToolResources.getEditorClasses();
        if (allEditors == null) {
            AuthoringTool.showErrorDialog(Messages.getString("no_editors_found__"), null);
            allEditors = new Class[0];
        }
    }

    public static Class[] getAllEditors() {
        return allEditors;
    }

    public static Class[] getEditorsForClass(Class objectClass) {
        Vector<Class> editors = new Vector<Class>();
        if (!Object.class.isAssignableFrom(objectClass)) {
            return null;
        }
        if (allEditors == null) {
            return null;
        }
        int i = 0;
        while (i < allEditors.length) {
            Class acceptedClass = EditorUtilities.getObjectParameter(allEditors[i]);
            if (acceptedClass.isAssignableFrom(objectClass)) {
                editors.addElement(allEditors[i]);
            }
            ++i;
        }
        EditorUtilities.sort(editors, objectClass);
        Class[] cvs = new Class[editors.size()];
        int i2 = 0;
        while (i2 < cvs.length) {
            cvs[i2] = (Class)editors.elementAt(i2);
            ++i2;
        }
        return cvs;
    }

    public static boolean isInAllEditors(Class potentialEditor) {
        if (allEditors == null) {
            return false;
        }
        int i = 0;
        while (i < allEditors.length) {
            if (potentialEditor == allEditors[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static Editor getEditorFromClass(Class editorClass) {
        try {
            return (Editor)editorClass.newInstance();
        }
        catch (Throwable t) {
            AuthoringTool.showErrorDialog(String.valueOf(Messages.getString("Error_creating_new_editor_of_type_")) + editorClass, t);
            return null;
        }
    }

    public static Method getSetMethodFromClass(Class editorClass) {
        Method[] methods = editorClass.getMethods();
        int i = 0;
        while (i < methods.length) {
            Class<?>[] parameterTypes;
            Method potentialMethod = methods[i];
            if (potentialMethod.getName().equals("setObject") && (parameterTypes = potentialMethod.getParameterTypes()).length == 1 && Object.class.isAssignableFrom(parameterTypes[0])) {
                return potentialMethod;
            }
            ++i;
        }
        return null;
    }

    public static Class getObjectParameter(Class editorClass) {
        Method setObject = EditorUtilities.getSetMethodFromClass(editorClass);
        if (setObject != null) {
            return setObject.getParameterTypes()[0];
        }
        return null;
    }

    public static Class getBestEditor(Class objectClass) {
        Class bestEditor = null;
        int bestDepth = Integer.MAX_VALUE;
        int i = 0;
        while (i < allEditors.length) {
            int depth;
            Class<?>[] parameterTypes;
            Class editorClass = allEditors[i];
            Method setObject = EditorUtilities.getSetMethodFromClass(editorClass);
            if (setObject != null && (parameterTypes = setObject.getParameterTypes()).length == 1 && (depth = EditorUtilities.getObjectClassDepth(parameterTypes[0], objectClass)) < bestDepth && depth >= 0) {
                bestDepth = depth;
                bestEditor = editorClass;
            }
            ++i;
        }
        return bestEditor;
    }

    public static void editObject(Editor editor, Object object) {
        Method setObject = EditorUtilities.getSetMethodFromClass(editor.getClass());
        try {
            setObject.invoke((Object)editor, object);
        }
        catch (Exception e) {
            AuthoringTool.showErrorDialog(String.valueOf(Messages.getString("Error_editing_object__")) + object, e);
        }
    }

    private static boolean isValidEditor(Class editorClass) {
        if (!Editor.class.isAssignableFrom(editorClass)) {
            return false;
        }
        boolean constructorFound = false;
        Constructor<?>[] editorConstructors = editorClass.getConstructors();
        int i = 0;
        while (i < editorConstructors.length) {
            Class<?>[] parameterTypes = editorConstructors[i].getParameterTypes();
            if (parameterTypes.length == 0) {
                constructorFound = true;
                break;
            }
            ++i;
        }
        return EditorUtilities.getSetMethodFromClass(editorClass) != null && constructorFound;
    }

    private static int getObjectClassDepth(Class superclass, Class subclass) {
        if (!superclass.isAssignableFrom(subclass)) {
            return -1;
        }
        Class temp = subclass;
        int i = 0;
        while (temp != superclass && superclass.isAssignableFrom(temp)) {
            ++i;
            temp = temp.getSuperclass();
        }
        return i;
    }

    private static void swap(Vector v, int a, int b) {
        Object t = v.elementAt(a);
        v.setElementAt(v.elementAt(b), a);
        v.setElementAt(t, b);
    }

    private static int compare(Class a, Class b, Class objectClass) {
        int bDist;
        int aDist = EditorUtilities.getObjectClassDepth(EditorUtilities.getObjectParameter(a), objectClass);
        if (aDist < (bDist = EditorUtilities.getObjectClassDepth(EditorUtilities.getObjectParameter(b), objectClass))) {
            return -1;
        }
        if (bDist < aDist) {
            return 1;
        }
        return 0;
    }

    private static void sort(Vector v, Class objectClass) {
        int i = 0;
        while (i < v.size()) {
            int j = i;
            while (j > 0 && EditorUtilities.compare((Class)v.elementAt(j - 1), (Class)v.elementAt(j), objectClass) > 0) {
                EditorUtilities.swap(v, j, j - 1);
                --j;
            }
            ++i;
        }
    }
}

