/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.util;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.util.Configuration;
import edu.cmu.cs.stage3.alice.authoringtool.util.GUIElement;
import edu.cmu.cs.stage3.alice.authoringtool.util.GUIFactory;
import edu.cmu.cs.stage3.alice.authoringtool.util.Releasable;
import edu.cmu.cs.stage3.lang.Messages;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.border.AbstractBorder;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicBorders;

public class EditObjectButton
extends JButton
implements GUIElement,
Releasable {
    protected AuthoringTool authoringTool;
    protected Object object;
    protected JComponent animationSource;
    private Configuration authoringToolConfig = Configuration.getLocalConfiguration(AuthoringTool.class.getPackage());

    public EditObjectButton() {
        this.setBackground(new Color(240, 240, 255));
        this.setMargin(new Insets(0, 2, 0, 2));
        this.setText(Messages.getString("edit"));
        int fontSize = Integer.parseInt(this.authoringToolConfig.getValue("fontSize"));
        this.setFont(new Font("SansSerif", 1, (int)((double)(11 * fontSize) / 12.0)));
        this.setFocusPainted(false);
        this.setBorder(new BorderUIResource.CompoundBorderUIResource(new CustomButtonBorder(), new BasicBorders.MarginBorder()));
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (EditObjectButton.this.authoringTool != null) {
                    if (EditObjectButton.this.object != null) {
                        if (EditObjectButton.this.animationSource != null) {
                            EditObjectButton.this.authoringTool.editObject(EditObjectButton.this.object, EditObjectButton.this.animationSource);
                        } else {
                            EditObjectButton.this.authoringTool.editObject(EditObjectButton.this.object);
                        }
                    } else {
                        AuthoringTool.showErrorDialog(Messages.getString("object_unexpectedly_null_in_EditObjectButton"), null);
                    }
                } else {
                    AuthoringTool.showErrorDialog(Messages.getString("authoringTool_unexpectedly_null_in_EditObjectButton"), null);
                }
            }
        });
    }

    public void setAuthoringTool(AuthoringTool authoringTool) {
        this.authoringTool = authoringTool;
    }

    public void setObject(Object object) {
        this.object = object;
    }

    public Object getObject() {
        return this.object;
    }

    public void setAnimationSource(JComponent animationSource) {
        this.animationSource = animationSource;
    }

    @Override
    public void goToSleep() {
    }

    @Override
    public void wakeUp() {
    }

    @Override
    public void clean() {
        this.object = null;
        this.animationSource = null;
    }

    @Override
    public void die() {
        this.clean();
        this.authoringTool = null;
    }

    @Override
    public void release() {
        GUIFactory.releaseGUI(this);
    }

    class CustomBevelBorder
    extends BevelBorder {
        public CustomBevelBorder(int type) {
            super(type);
        }

        @Override
        public Color getHighlightInnerColor(Component c) {
            return c.getBackground();
        }

        @Override
        public Color getShadowInnerColor(Component c) {
            return c.getBackground();
        }
    }

    class CustomButtonBorder
    extends AbstractBorder
    implements UIResource {
        protected Insets insets = new Insets(1, 3, 1, 3);
        protected Border line = BorderFactory.createLineBorder(Color.darkGray, 1);
        protected Border spacer = BorderFactory.createEmptyBorder(0, 3, 0, 3);
        protected Border raisedBevel;
        protected Border loweredBevel;
        protected Border raisedBorder;
        protected Border loweredBorder;

        CustomButtonBorder() {
            this.raisedBevel = new CustomBevelBorder(0);
            this.loweredBevel = new CustomBevelBorder(1);
            this.raisedBorder = BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(this.line, this.raisedBevel), this.spacer);
            this.loweredBorder = BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(this.line, this.loweredBevel), this.spacer);
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            JButton button = (JButton)c;
            ButtonModel model = button.getModel();
            if (model.isEnabled()) {
                if (model.isPressed() && model.isArmed()) {
                    this.loweredBorder.paintBorder(button, g, x, y, w, h);
                } else {
                    this.raisedBorder.paintBorder(button, g, x, y, w, h);
                }
            } else {
                this.raisedBorder.paintBorder(button, g, x, y, w, h);
            }
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.insets;
        }
    }
}

