/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.util;

import edu.cmu.cs.stage3.alice.authoringtool.util.event.DnDManagerListener;
import java.awt.Component;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.util.HashSet;
import java.util.Iterator;

public class DnDManager {
    private static Transferable currentTransferable;
    private static Component currentDragComponent;
    private static HashSet listeners;
    private static DnDListener dndListener;
    private static DragSourceContext currentContext;

    static {
        listeners = new HashSet();
        dndListener = new DnDListener();
    }

    public static Transferable getCurrentTransferable() {
        return currentTransferable;
    }

    public static void setCurrentTransferable(Transferable transferable) {
        currentTransferable = transferable;
    }

    public static Component getCurrentDragComponent() {
        return currentDragComponent;
    }

    public static DragSourceContext getCurrentDragContext() {
        return currentContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addListener(DnDManagerListener listener) {
        DnDListener dnDListener = dndListener;
        synchronized (dnDListener) {
            listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeListener(DnDManagerListener listener) {
        DnDListener dnDListener = dndListener;
        synchronized (dnDListener) {
            listeners.remove(listener);
        }
    }

    public static DnDListener getInternalListener() {
        return dndListener;
    }

    public static void fireDragGestureRecognized(DragGestureEvent ev) {
        Iterator iter = listeners.iterator();
        while (iter.hasNext()) {
            ((DragGestureListener)iter.next()).dragGestureRecognized(ev);
        }
    }

    public static void fireDragStarted(Transferable transferable, Component dragComponent) {
        currentTransferable = transferable;
        currentDragComponent = dragComponent;
        Iterator iter = listeners.iterator();
        while (iter.hasNext()) {
            ((DnDManagerListener)iter.next()).dragStarted();
        }
    }

    public static class DnDListener
    implements DragSourceListener {
        @Override
        public synchronized void dragEnter(DragSourceDragEvent dsde) {
            currentTransferable = dsde.getDragSourceContext().getTransferable();
            currentDragComponent = dsde.getDragSourceContext().getComponent();
            currentContext = dsde.getDragSourceContext();
            Iterator iter = listeners.iterator();
            while (iter.hasNext()) {
                ((DragSourceListener)iter.next()).dragEnter(dsde);
            }
        }

        @Override
        public synchronized void dragExit(DragSourceEvent dse) {
            currentTransferable = dse.getDragSourceContext().getTransferable();
            currentDragComponent = dse.getDragSourceContext().getComponent();
            Iterator iter = listeners.iterator();
            while (iter.hasNext()) {
                ((DragSourceListener)iter.next()).dragExit(dse);
            }
        }

        @Override
        public synchronized void dragOver(DragSourceDragEvent dsde) {
            currentTransferable = dsde.getDragSourceContext().getTransferable();
            currentDragComponent = dsde.getDragSourceContext().getComponent();
            Iterator iter = listeners.iterator();
            while (iter.hasNext()) {
                ((DragSourceListener)iter.next()).dragOver(dsde);
            }
        }

        @Override
        public synchronized void dropActionChanged(DragSourceDragEvent dsde) {
            currentTransferable = dsde.getDragSourceContext().getTransferable();
            currentDragComponent = dsde.getDragSourceContext().getComponent();
            Iterator iter = listeners.iterator();
            while (iter.hasNext()) {
                ((DragSourceListener)iter.next()).dropActionChanged(dsde);
            }
        }

        @Override
        public synchronized void dragDropEnd(DragSourceDropEvent dsde) {
            currentTransferable = null;
            currentDragComponent = null;
            Iterator iter = listeners.iterator();
            while (iter.hasNext()) {
                ((DragSourceListener)iter.next()).dragDropEnd(dsde);
            }
        }
    }
}

