/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.util;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources;
import edu.cmu.cs.stage3.alice.authoringtool.datatransfer.CallToUserDefinedQuestionPrototypeReferenceTransferable;
import edu.cmu.cs.stage3.alice.authoringtool.datatransfer.CallToUserDefinedResponsePrototypeReferenceTransferable;
import edu.cmu.cs.stage3.alice.authoringtool.datatransfer.CommonMathQuestionsTransferable;
import edu.cmu.cs.stage3.alice.authoringtool.datatransfer.ElementReferenceTransferable;
import edu.cmu.cs.stage3.alice.authoringtool.datatransfer.PropertyReferenceTransferable;
import edu.cmu.cs.stage3.alice.authoringtool.datatransfer.QuestionPrototypeReferenceTransferable;
import edu.cmu.cs.stage3.alice.authoringtool.datatransfer.ResponsePrototypeReferenceTransferable;
import edu.cmu.cs.stage3.alice.authoringtool.util.Configuration;
import edu.cmu.cs.stage3.alice.authoringtool.util.DnDManager;
import edu.cmu.cs.stage3.alice.authoringtool.util.DragWindow;
import edu.cmu.cs.stage3.alice.authoringtool.util.GUIEffects;
import edu.cmu.cs.stage3.alice.authoringtool.util.GroupingPanel;
import edu.cmu.cs.stage3.alice.authoringtool.util.event.DnDManagerListener;
import edu.cmu.cs.stage3.awt.AWTUtilities;
import edu.cmu.cs.stage3.awt.SemitransparentWindow;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class DnDGroupingPanel
extends GroupingPanel {
    protected Transferable transferable;
    protected DnDGrip grip = new DnDGrip();
    protected DragSource dragSource = new DragSource();
    protected Point hotSpot = new Point(0, 0);
    protected DragSourceListener dndManagerListener = DnDManager.getInternalListener();
    protected DragWindow dragWindow;
    protected SemitransparentWindow dragWindow2;
    protected Point dragOffset;
    protected int arcWidth = 12;
    protected int arcHeight = 10;
    protected GroupingPanelDragGestureListener dragGestureListener = new GroupingPanelDragGestureListener();
    protected LinkedList dragGestureRecognizers = new LinkedList();
    protected boolean dragEnabled = true;
    protected boolean drawFaded = false;
    protected Composite defaultComposite = AlphaComposite.SrcOver;
    protected AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.5f);
    protected boolean isSystemDefined = false;
    protected static Configuration authoringToolConfig = Configuration.getLocalConfiguration(AuthoringTool.class.getPackage());

    public DnDGroupingPanel() {
        this.setLayout(new BorderLayout(2, 2));
        this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.setOpaque(false);
        this.add((Component)this.grip, "West");
        this.addDragSourceComponent(this.grip);
        this.addDragSourceComponent(this);
    }

    public Transferable getTransferable() {
        return this.transferable;
    }

    public void setTransferable(Transferable transferable) {
        this.transferable = transferable;
        if (transferable != null) {
            this.isSystemDefined = AuthoringToolResources.safeIsDataFlavorSupported(transferable, PropertyReferenceTransferable.propertyReferenceFlavor) ? true : (AuthoringToolResources.safeIsDataFlavorSupported(transferable, ResponsePrototypeReferenceTransferable.responsePrototypeReferenceFlavor) && !AuthoringToolResources.safeIsDataFlavorSupported(transferable, CallToUserDefinedResponsePrototypeReferenceTransferable.callToUserDefinedResponsePrototypeReferenceFlavor) ? true : (AuthoringToolResources.safeIsDataFlavorSupported(transferable, QuestionPrototypeReferenceTransferable.questionPrototypeReferenceFlavor) && !AuthoringToolResources.safeIsDataFlavorSupported(transferable, CallToUserDefinedQuestionPrototypeReferenceTransferable.callToUserDefinedQuestionPrototypeReferenceFlavor) ? true : AuthoringToolResources.safeIsDataFlavorSupported(transferable, CommonMathQuestionsTransferable.commonMathQuestionsFlavor)));
        }
    }

    public boolean isDragEnabled() {
        return this.dragEnabled;
    }

    public void setDragEnabled(boolean b) {
        this.dragEnabled = b;
    }

    public void addDragSourceComponent(Component component) {
        for (DragGestureRecognizer dgr : this.dragGestureRecognizers) {
            if (dgr.getComponent() != component) continue;
            return;
        }
        if (this.dragSource != null) {
            this.dragGestureRecognizers.add(this.dragSource.createDefaultDragGestureRecognizer(component, 0x40000003, this.dragGestureListener));
        } else {
            AuthoringTool.showErrorDialog("dragSource is null", null);
        }
    }

    public void removeDragSourceComponent(Component component) {
        ListIterator iter = this.dragGestureRecognizers.listIterator();
        while (iter.hasNext()) {
            DragGestureRecognizer dgr = (DragGestureRecognizer)iter.next();
            if (dgr.getComponent() != component) continue;
            dgr.removeDragGestureListener(this.dragGestureListener);
            dgr.setComponent(null);
            iter.remove();
            break;
        }
    }

    public DragSource getDragSource() {
        return this.dragSource;
    }

    public void reset() {
        this.add((Component)this.grip, "West");
        this.addDragSourceComponent(this.grip);
        this.addDragSourceComponent(this);
    }

    @Override
    public void release() {
        super.release();
        ListIterator iter = this.dragGestureRecognizers.listIterator();
        while (iter.hasNext()) {
            DragGestureRecognizer dgr = (DragGestureRecognizer)iter.next();
            if (this.dragGestureListener != null) {
                dgr.removeDragGestureListener(this.dragGestureListener);
                iter.remove();
            }
            dgr.setComponent(null);
        }
    }

    public Image getImage() {
        Rectangle bounds = this.getBounds();
        BufferedImage image = new BufferedImage(bounds.width, bounds.height, 2);
        Graphics2D g = image.createGraphics();
        this.paintAll(g);
        return image;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Object oldAntialiasing = null;
        if (g instanceof Graphics2D) {
            oldAntialiasing = ((Graphics2D)g).getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            ((Graphics2D)g).addRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        }
        Rectangle bounds = this.getBounds();
        g.setColor(this.getBackground());
        g.fillRoundRect(0, 0, bounds.width, bounds.height, this.arcWidth, this.arcHeight);
        g.setColor(Color.lightGray);
        g.drawRoundRect(0, 0, bounds.width - 1, bounds.height - 1, this.arcWidth, this.arcHeight);
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).addRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, oldAntialiasing));
        }
    }

    @Override
    public void paintForeground(Graphics g) {
        super.paintForeground(g);
    }

    @Override
    public void printComponent(Graphics g) {
        if (!authoringToolConfig.getValue("printing.fillBackground").equalsIgnoreCase("true")) {
            Object oldAntialiasing = null;
            if (g instanceof Graphics2D) {
                oldAntialiasing = ((Graphics2D)g).getRenderingHint(RenderingHints.KEY_ANTIALIASING);
                ((Graphics2D)g).addRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
            }
            Rectangle bounds = this.getBounds();
            g.setColor(Color.lightGray);
            g.drawRoundRect(0, 0, bounds.width - 1, bounds.height - 1, this.arcWidth, this.arcHeight);
            if (g instanceof Graphics2D) {
                ((Graphics2D)g).addRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, oldAntialiasing));
            }
        } else {
            super.printComponent(g);
        }
    }

    public class DnDGrip
    extends JComponent {
        protected Color highlightColor = MetalLookAndFeel.getControlHighlight();
        protected Color shadowColor = MetalLookAndFeel.getControlDarkShadow();

        public DnDGrip() {
            this.setMinimumSize(new Dimension(6, 0));
            this.setMaximumSize(new Dimension(6, Integer.MAX_VALUE));
            this.setPreferredSize(new Dimension(6, 0));
        }

        @Override
        protected void printComponent(Graphics g) {
        }

        @Override
        protected void paintComponent(Graphics g) {
            int y;
            Dimension size = this.getSize();
            g.setColor(this.highlightColor);
            int x = 0;
            while (x < size.width) {
                y = 0;
                while (y < size.height) {
                    g.drawLine(x, y, x, y);
                    g.drawLine(x + 2, y + 2, x + 2, y + 2);
                    y += 4;
                }
                x += 4;
            }
            g.setColor(this.shadowColor);
            x = 0;
            while (x < size.width) {
                y = 0;
                while (y < size.height) {
                    g.drawLine(x + 1, y + 1, x + 1, y + 1);
                    g.drawLine(x + 3, y + 3, x + 3, y + 3);
                    y += 4;
                }
                x += 4;
            }
        }
    }

    public class GroupingPanelDragGestureListener
    implements DragGestureListener {
        protected DragListener dragListener = new DragListener();
        protected DragSourceListener dragSourceListener = new DragSourceListener();

        @Override
        public void dragGestureRecognized(DragGestureEvent dge) {
            if (DnDGroupingPanel.this.transferable != null) {
                DnDManager.fireDragGestureRecognized(dge);
                try {
                    if (DnDGroupingPanel.this.dragEnabled) {
                        BufferedImage empty = new BufferedImage(1, 1, 1);
                        dge.startDrag(DragSource.DefaultCopyDrop, empty, new Point(), DnDGroupingPanel.this.transferable, DnDManager.getInternalListener());
                        DnDManager.fireDragStarted(DnDGroupingPanel.this.transferable, DnDGroupingPanel.this);
                        if (authoringToolConfig.getValue("gui.pickUpTiles").equalsIgnoreCase("true") && AWTUtilities.mouseListenersAreSupported() && AWTUtilities.mouseMotionListenersAreSupported()) {
                            if (authoringToolConfig.getValue("gui.useAlphaTiles").equalsIgnoreCase("true") && SemitransparentWindow.isSupported()) {
                                if (DnDGroupingPanel.this.dragWindow2 == null) {
                                    DnDGroupingPanel.this.dragWindow2 = new SemitransparentWindow();
                                }
                                DnDGroupingPanel.this.dragWindow2.show();
                            } else {
                                if (DnDGroupingPanel.this.dragWindow == null) {
                                    DnDGroupingPanel.this.dragWindow = new DragWindow(AuthoringTool.getHack().getJAliceFrame());
                                }
                                DnDGroupingPanel.this.dragWindow.setLocation(-10000, -10000);
                                DnDGroupingPanel.this.dragWindow.setVisible(true);
                            }
                            boolean scaledAndCropped = this.updateImages(false);
                            if (scaledAndCropped) {
                                DnDGroupingPanel.this.dragOffset = new Point(3, 3);
                            } else {
                                DnDGroupingPanel.this.dragOffset = dge.getDragOrigin();
                                DnDGroupingPanel.this.dragOffset = SwingUtilities.convertPoint(dge.getComponent(), DnDGroupingPanel.this.dragOffset, DnDGroupingPanel.this);
                            }
                            AWTUtilities.addMouseListener(this.dragListener);
                            AWTUtilities.addMouseMotionListener(this.dragListener);
                            DnDManager.addListener(this.dragSourceListener);
                        }
                        DnDGroupingPanel.this.drawFaded = true;
                        DnDGroupingPanel.this.repaint();
                    }
                }
                catch (Throwable t) {
                    AuthoringTool.showErrorDialog("Error initiating drag of tile.", t);
                }
            }
        }

        private boolean updateImages(boolean valid) {
            Image tileImage = DnDGroupingPanel.this.getImage();
            boolean scaledAndCropped = false;
            if (AuthoringToolResources.safeIsDataFlavorSupported(DnDGroupingPanel.this.transferable, ElementReferenceTransferable.responseReferenceFlavor) || AuthoringToolResources.safeIsDataFlavorSupported(DnDGroupingPanel.this.transferable, AuthoringToolResources.getReferenceFlavorForClass(edu.cmu.cs.stage3.alice.core.question.userdefined.Component.class))) {
                int width = tileImage.getWidth(GUIEffects.sizeObserver);
                int height = tileImage.getHeight(GUIEffects.sizeObserver);
                if (width > 64 || height > 64) {
                    double scaleFactor = 1.0;
                    Rectangle cropRect = new Rectangle(0, 0, 64, 64);
                    if (width > 128 && height > 128) {
                        scaleFactor = 0.5;
                    } else if (height < 32) {
                        cropRect = new Rectangle(0, 0, 128, height);
                    } else if (width > 128 || height > 128) {
                        scaleFactor = Math.min(1.0, 64.0 / (double)Math.min(width, height));
                    } else {
                        cropRect = new Rectangle(0, 0, width, height);
                    }
                    tileImage = GUIEffects.getImageScaledAndCropped(tileImage, scaleFactor, cropRect);
                    scaledAndCropped = true;
                }
            }
            tileImage = valid ? GUIEffects.getImageWithColoredBorder(tileImage, AuthoringToolResources.getColor("dndHighlight2")) : GUIEffects.getImageWithColoredBorder(tileImage, AuthoringToolResources.getColor("dndHighlight3"));
            if (authoringToolConfig.getValue("gui.useAlphaTiles").equalsIgnoreCase("true") && DnDGroupingPanel.this.dragWindow2 != null) {
                BufferedImage image = GUIEffects.getImageWithDropShadow(tileImage, 8, 8, DnDGroupingPanel.this.arcWidth, DnDGroupingPanel.this.arcHeight);
                try {
                    DnDGroupingPanel.this.dragWindow2.setImage(image);
                }
                catch (InterruptedException ie) {
                    throw new RuntimeException();
                }
            } else if (DnDGroupingPanel.this.dragWindow != null) {
                DnDGroupingPanel.this.dragWindow.setImage(tileImage);
            }
            return scaledAndCropped;
        }

        protected class DragListener
        extends MouseAdapter
        implements MouseMotionListener {
            protected DragListener() {
            }

            @Override
            public void mouseReleased(MouseEvent ev) {
                ((GroupingPanelDragGestureListener)GroupingPanelDragGestureListener.this).DnDGroupingPanel.this.drawFaded = false;
                DnDGroupingPanel.this.repaint();
                if (authoringToolConfig.getValue("gui.useAlphaTiles").equalsIgnoreCase("true") && ((GroupingPanelDragGestureListener)GroupingPanelDragGestureListener.this).DnDGroupingPanel.this.dragWindow2 != null) {
                    ((GroupingPanelDragGestureListener)GroupingPanelDragGestureListener.this).DnDGroupingPanel.this.dragWindow2.hide();
                    AWTUtilities.pumpMessageQueue();
                } else if (((GroupingPanelDragGestureListener)GroupingPanelDragGestureListener.this).DnDGroupingPanel.this.dragWindow != null) {
                    ((GroupingPanelDragGestureListener)GroupingPanelDragGestureListener.this).DnDGroupingPanel.this.dragWindow.setVisible(false);
                }
                AWTUtilities.removeMouseListener(this);
                AWTUtilities.removeMouseMotionListener(this);
                DnDManager.removeListener(GroupingPanelDragGestureListener.this.dragSourceListener);
            }

            @Override
            public void mouseDragged(MouseEvent ev) {
                Point p = ev.getPoint();
                p.x += 5;
                p.y += 5;
                if (authoringToolConfig.getValue("gui.useAlphaTiles").equalsIgnoreCase("true") && ((GroupingPanelDragGestureListener)GroupingPanelDragGestureListener.this).DnDGroupingPanel.this.dragWindow2 != null) {
                    if (authoringToolConfig.getValue("gui.pickUpTiles").equalsIgnoreCase("false")) {
                        ((GroupingPanelDragGestureListener)GroupingPanelDragGestureListener.this).DnDGroupingPanel.this.dragWindow2.hide();
                    } else {
                        ((GroupingPanelDragGestureListener)GroupingPanelDragGestureListener.this).DnDGroupingPanel.this.dragWindow2.show();
                    }
                    ((GroupingPanelDragGestureListener)GroupingPanelDragGestureListener.this).DnDGroupingPanel.this.dragWindow2.setLocationOnScreen(p.x, p.y);
                    AWTUtilities.pumpMessageQueue();
                } else if (((GroupingPanelDragGestureListener)GroupingPanelDragGestureListener.this).DnDGroupingPanel.this.dragWindow != null) {
                    if (authoringToolConfig.getValue("gui.pickUpTiles").equalsIgnoreCase("false")) {
                        ((GroupingPanelDragGestureListener)GroupingPanelDragGestureListener.this).DnDGroupingPanel.this.dragWindow.setVisible(false);
                    } else {
                        ((GroupingPanelDragGestureListener)GroupingPanelDragGestureListener.this).DnDGroupingPanel.this.dragWindow.setVisible(true);
                    }
                    ((GroupingPanelDragGestureListener)GroupingPanelDragGestureListener.this).DnDGroupingPanel.this.dragWindow.setLocation(p);
                }
            }

            @Override
            public void mouseMoved(MouseEvent ev) {
            }
        }

        protected class DragSourceListener
        implements DnDManagerListener {
            protected DragSourceListener() {
            }

            @Override
            public void dragEnter(DragSourceDragEvent ev) {
                GroupingPanelDragGestureListener.this.updateImages(true);
            }

            @Override
            public void dragExit(DragSourceEvent ev) {
                GroupingPanelDragGestureListener.this.updateImages(false);
            }

            @Override
            public void dragDropEnd(DragSourceDropEvent ev) {
            }

            @Override
            public void dragOver(DragSourceDragEvent ev) {
            }

            @Override
            public void dropActionChanged(DragSourceDragEvent ev) {
            }

            @Override
            public void dragGestureRecognized(DragGestureEvent ev) {
            }

            @Override
            public void dragStarted() {
            }
        }
    }
}

