/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.util;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources;
import edu.cmu.cs.stage3.alice.authoringtool.JAlice;
import edu.cmu.cs.stage3.alice.authoringtool.datatransfer.ElementReferenceTransferable;
import edu.cmu.cs.stage3.alice.authoringtool.datatransfer.TransferableFactory;
import edu.cmu.cs.stage3.alice.authoringtool.util.CustomMouseAdapter;
import edu.cmu.cs.stage3.alice.authoringtool.util.DnDManager;
import edu.cmu.cs.stage3.alice.authoringtool.util.event.DnDManagerListener;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.Model;
import edu.cmu.cs.stage3.alice.core.Sound;
import edu.cmu.cs.stage3.alice.core.World;
import edu.cmu.cs.stage3.alice.core.response.CallToUserDefinedResponse;
import edu.cmu.cs.stage3.lang.Messages;
import edu.cmu.cs.stage3.swing.DialogManager;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class DnDClipboard
extends JPanel {
    protected ImageIcon clipboardIcon = new ImageIcon(JAlice.class.getResource("images/clipboard.gif"));
    protected ImageIcon clipboardWithPaperIcon = new ImageIcon(JAlice.class.getResource("images/clipboardWithPaper.gif"));
    protected Dimension size;
    protected Transferable transferable;
    protected DragSource dragSource = new DragSource();
    protected boolean underDrag = false;
    protected boolean paintDropPotential = false;
    protected DropPotentialFeedbackListener dropPotentialFeedbackListener = new DropPotentialFeedbackListener();

    public DnDClipboard() {
        this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.size = new Dimension(this.clipboardIcon.getIconWidth(), this.clipboardIcon.getIconHeight());
        this.setOpaque(false);
        this.dragSource.createDefaultDragGestureRecognizer(this, 0x40000003, new ClipboardDragGestureListener());
        this.setDropTarget(new DropTarget(this, new ClipboardDropTargetListener()));
        DnDManager.addListener(this.dropPotentialFeedbackListener);
        this.setToolTipText("<html><font face=arial size=-1>" + Messages.getString("Copy_Paste_Clipboard_p__p_Drag_and_drop_tiles__b_to__b__the_clipboard_to_copy_them__p_Drag_and_drop_tiles__b_from__b__the_clipboard_to_paste_them_") + "</font></html>");
        this.addMouseListener(new CustomMouseAdapter(){

            @Override
            public void singleClickResponse(MouseEvent ev) {
                DialogManager.showMessageDialog(DnDClipboard.this.getToolTipText());
            }
        });
    }

    public void setTransferable(Transferable transferable) {
        this.transferable = transferable;
        this.repaint();
    }

    public void clear() {
        this.setTransferable(null);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Insets insets = this.getInsets();
        if (this.paintDropPotential) {
            Dimension size = this.getSize();
            if (this.underDrag) {
                g.setColor(AuthoringToolResources.getColor("dndHighlight2"));
            } else {
                g.setColor(AuthoringToolResources.getColor("dndHighlight"));
            }
            g.drawRect(0, 0, size.width - 1, size.height - 1);
            g.drawRect(1, 1, size.width - 3, size.height - 3);
        }
        if (this.transferable != null || this.underDrag) {
            this.clipboardWithPaperIcon.paintIcon(this, g, insets.left, insets.top);
        } else {
            this.clipboardIcon.paintIcon(this, g, insets.left, insets.top);
        }
    }

    @Override
    public Dimension getMinimumSize() {
        Insets insets = this.getInsets();
        return new Dimension(this.size.width + insets.left + insets.right, this.size.height + insets.top + insets.bottom);
    }

    @Override
    public Dimension getPreferredSize() {
        Insets insets = this.getInsets();
        return new Dimension(this.size.width + insets.left + insets.right, this.size.height + insets.top + insets.bottom);
    }

    @Override
    public Dimension getMaximumSize() {
        Insets insets = this.getInsets();
        return new Dimension(this.size.width + insets.left + insets.right, this.size.height + insets.top + insets.bottom);
    }

    protected boolean checkTransferable(Transferable transferable) {
        Element element;
        block4: {
            element = (Element)transferable.getTransferData(ElementReferenceTransferable.elementReferenceFlavor);
            if (!(element instanceof Sound) && !(element instanceof Model) && !(element instanceof World)) break block4;
            return false;
        }
        try {
            if (element instanceof CallToUserDefinedResponse) {
                element.getChildCount();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return AuthoringToolResources.safeIsDataFlavorSupported(transferable, ElementReferenceTransferable.elementReferenceFlavor);
    }

    public class ClipboardDragGestureListener
    implements DragGestureListener {
        @Override
        public void dragGestureRecognized(DragGestureEvent dge) {
            DnDManager.fireDragGestureRecognized(dge);
            if (DnDClipboard.this.transferable != null) {
                dge.startDrag(DragSource.DefaultCopyDrop, DnDClipboard.this.transferable, DnDManager.getInternalListener());
                DnDManager.fireDragStarted(DnDClipboard.this.transferable, DnDClipboard.this);
            }
        }
    }

    public class ClipboardDropTargetListener
    implements DropTargetListener {
        private boolean checkDrag(DropTargetDragEvent dtde) {
            Element element;
            block5: {
                Transferable transferable = dtde.getTransferable();
                element = (Element)transferable.getTransferData(ElementReferenceTransferable.elementReferenceFlavor);
                if (!(element instanceof Sound) && !(element instanceof Model) && !(element instanceof World)) break block5;
                dtde.rejectDrag();
                return false;
            }
            try {
                if (element instanceof CallToUserDefinedResponse) {
                    element.getChildCount();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (AuthoringToolResources.safeIsDataFlavorSupported(dtde, ElementReferenceTransferable.elementReferenceFlavor)) {
                dtde.acceptDrag(dtde.getDropAction());
                DnDClipboard.this.paintDropPotential = true;
                DnDClipboard.this.repaint();
                return true;
            }
            dtde.rejectDrag();
            return false;
        }

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
            this.checkDrag(dtde);
            DnDClipboard.this.underDrag = true;
            DnDClipboard.this.repaint();
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
            DnDClipboard.this.underDrag = false;
            DnDClipboard.this.repaint();
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
            DnDClipboard.this.underDrag = this.checkDrag(dtde);
            DnDClipboard.this.repaint();
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
            this.checkDrag(dtde);
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            Transferable transferable = dtde.getTransferable();
            if (DnDManager.getCurrentDragComponent() instanceof DnDClipboard && DnDManager.getCurrentDragComponent() != DnDClipboard.this) {
                DnDClipboard clipboard = (DnDClipboard)DnDManager.getCurrentDragComponent();
                clipboard.setTransferable(null);
            } else {
                DataFlavor elementReferenceFlavor = AuthoringToolResources.getReferenceFlavorForClass(Element.class);
                try {
                    if (AuthoringToolResources.safeIsDataFlavorSupported(transferable, elementReferenceFlavor)) {
                        Element element = (Element)transferable.getTransferData(elementReferenceFlavor);
                        transferable = TransferableFactory.createTransferable(element.createCopyFactory());
                    }
                }
                catch (IOException e) {
                    AuthoringTool.showErrorDialog(Messages.getString("Error_dropping_on_clipboard_"), e);
                }
                catch (UnsupportedFlavorException e) {
                    AuthoringTool.showErrorDialog(Messages.getString("Error_dropping_on_clipboard_"), e);
                }
            }
            DnDClipboard.this.transferable = transferable;
            DnDClipboard.this.underDrag = false;
            DnDClipboard.this.repaint();
            dtde.acceptDrop(dtde.getDropAction());
            dtde.getDropTargetContext().dropComplete(true);
        }
    }

    protected class DropPotentialFeedbackListener
    implements DnDManagerListener {
        protected DropPotentialFeedbackListener() {
        }

        private void doCheck() {
            Transferable transferable = DnDManager.getCurrentTransferable();
            DnDClipboard.this.paintDropPotential = DnDClipboard.this.checkTransferable(transferable);
            DnDClipboard.this.repaint();
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dge) {
        }

        @Override
        public void dragStarted() {
            this.doCheck();
        }

        @Override
        public void dragEnter(DragSourceDragEvent dsde) {
        }

        @Override
        public void dragExit(DragSourceEvent dse) {
            this.doCheck();
        }

        @Override
        public void dragOver(DragSourceDragEvent dsde) {
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent dsde) {
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent dsde) {
            DnDClipboard.this.paintDropPotential = false;
            DnDClipboard.this.repaint();
        }
    }
}

