/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.util;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.lang.Messages;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyObject;

public class DefaultScheduler
implements Runnable {
    private static final long minDelay = 20L;
    private double simFPS = 0.0;
    private double renderFPS = 0.0;
    private int simFrameCount = 0;
    private int renderFrameCount = 0;
    private long simDT = 0L;
    private long renderDT = 0L;
    private long simLastTime = 0L;
    private long renderLastTime = -1L;
    private long lastRenderLastTime = 0L;
    private long idleLastTime = 0L;
    private boolean defaultThreadEnabled = false;
    private Set doOnceRunnables = new HashSet();
    private Set eachFrameRunnables = new HashSet();
    private Set eachFrameRunnablesMarkedForRemoval = new HashSet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addDoOnceRunnable(Runnable doOnceRunnable) {
        Set set = this.doOnceRunnables;
        synchronized (set) {
            return this.doOnceRunnables.add(doOnceRunnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addEachFrameRunnable(Runnable eachFrameRunnable) {
        Set set = this.eachFrameRunnables;
        synchronized (set) {
            return this.eachFrameRunnables.add(eachFrameRunnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeEachFrameRunnable(Runnable eachFrameRunnable) {
        Set set = this.eachFrameRunnablesMarkedForRemoval;
        synchronized (set) {
            return this.eachFrameRunnablesMarkedForRemoval.add(eachFrameRunnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Runnable[] getEachFrameRunnables() {
        Set set = this.eachFrameRunnables;
        synchronized (set) {
            Runnable[] runnables = new Runnable[this.eachFrameRunnables.size()];
            int i = 0;
            Iterator iter = this.eachFrameRunnables.iterator();
            while (iter.hasNext()) {
                runnables[i++] = (Runnable)iter.next();
            }
            return runnables;
        }
    }

    @Override
    public void run() {
        this.simulateOnce();
    }

    private synchronized void simulateOnce() {
        Iterator iter = this.doOnceRunnables.iterator();
        while (iter.hasNext()) {
            Runnable runnable = (Runnable)iter.next();
            try {
                runnable.run();
            }
            catch (PyException e) {
                if (!Py.matchException((PyException)e, (PyObject)Py.SystemExit)) {
                    Py.printException((Throwable)e, null, (PyObject)AuthoringTool.getPyStdErr());
                }
            }
            catch (Throwable t) {
                System.err.println(Messages.getString("Error_during_simulation_"));
                t.printStackTrace();
            }
            iter.remove();
        }
        iter = this.eachFrameRunnablesMarkedForRemoval.iterator();
        while (iter.hasNext()) {
            this.eachFrameRunnables.remove(iter.next());
        }
        this.eachFrameRunnablesMarkedForRemoval.clear();
        for (Runnable runnable : this.eachFrameRunnables) {
            try {
                runnable.run();
            }
            catch (PyException e) {
                if (Py.matchException((PyException)e, (PyObject)Py.SystemExit)) continue;
                Py.printException((Throwable)e, null, (PyObject)AuthoringTool.getPyStdErr());
            }
            catch (Throwable t) {
                System.err.println(Messages.getString("Error_during_simulation_"));
                t.printStackTrace();
            }
        }
        long time = System.currentTimeMillis();
        this.simDT += time - this.simLastTime;
        this.simLastTime = time;
        ++this.simFrameCount;
        if (this.simFrameCount == 5 || this.simDT > 500L) {
            this.simFPS = (double)this.simFrameCount / ((double)this.simDT * 0.001);
            this.simFrameCount = 0;
            this.simDT = 0L;
        }
    }

    public double getSimulationFPS() {
        return this.simFPS;
    }
}

