/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.util;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.JAlice;
import edu.cmu.cs.stage3.alice.authoringtool.util.event.ConfigurationEvent;
import edu.cmu.cs.stage3.alice.authoringtool.util.event.ConfigurationListener;
import edu.cmu.cs.stage3.lang.Messages;
import edu.cmu.cs.stage3.swing.DialogManager;
import edu.cmu.cs.stage3.xml.Encoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public final class Configuration {
    public static final int VIS_OPEN = 1;
    public static final int VIS_ADVANCED = 2;
    public static final int VIS_HIDDEN = 4;
    public static final int VIS_ALL = 7;
    private String keyPrefix;
    private static final File configLocation = new File(JAlice.getAliceUserDirectory(), "AlicePreferences.xml").getAbsoluteFile();
    private static Key root = new Key();
    protected static HashSet listeners;

    static {
        Configuration.root.name = "<root>";
        Configuration.root.subKeys = new HashMap();
        File aliceHasNotExitedFile = new File(JAlice.getAliceUserDirectory(), "aliceHasNotExited.txt");
        try {
            Configuration.loadConfig(configLocation);
        }
        catch (Exception e) {
            try {
                Configuration.storeConfig();
            }
            catch (IOException e1) {
                AuthoringTool.showErrorDialog(Messages.getString("Unable_to_create_new_preferences_file_"), e1);
            }
        }
        listeners = new HashSet();
    }

    public static String getValue(Package p, String relativeKey) {
        return Configuration._getValue(String.valueOf(p.getName()) + "." + relativeKey);
    }

    public static String[] getValueList(Package p, String relativeKey) {
        return Configuration._getValueList(String.valueOf(p.getName()) + "." + relativeKey);
    }

    public static void setValue(Package p, String relativeKey, String value) {
        Configuration._setValue(String.valueOf(p.getName()) + "." + relativeKey, value);
    }

    public static void setValueList(Package p, String relativeKey, String[] values) {
        Configuration._setValueList(String.valueOf(p.getName()) + "." + relativeKey, values);
    }

    public static void addToValueList(Package p, String relativeKey, String item) {
        Configuration._addToValueList(String.valueOf(p.getName()) + "." + relativeKey, item);
    }

    public static void removeFromValueList(Package p, String relativeKey, String item) {
        Configuration._removeFromValueList(String.valueOf(p.getName()) + "." + relativeKey, item);
    }

    public static boolean isList(Package p, String relativeKey) {
        return Configuration._isList(String.valueOf(p.getName()) + "." + relativeKey);
    }

    public static boolean keyExists(Package p, String relativeKey) {
        return Configuration._keyExists(String.valueOf(p.getName()) + "." + relativeKey);
    }

    public static void deleteKey(Package p, String relativeKey) {
        Configuration._deleteKey(String.valueOf(p.getName()) + "." + relativeKey);
    }

    public static String[] getSubKeys(Package p, String relativeKey, int visibility) {
        return Configuration._getSubKeys(String.valueOf(p.getName()) + "." + relativeKey, visibility);
    }

    public static void setVisibility(Package p, String relativeKey, int visibility) {
        Configuration._setVisibility(String.valueOf(p.getName()) + "." + relativeKey, visibility);
    }

    private Configuration(Package p) {
        this.keyPrefix = String.valueOf(p.getName()) + ".";
    }

    public static Configuration getLocalConfiguration(Package p) {
        return new Configuration(p);
    }

    public String getValue(String relativeKey) {
        return Configuration._getValue(String.valueOf(this.keyPrefix) + relativeKey);
    }

    public String[] getValueList(String relativeKey) {
        return Configuration._getValueList(String.valueOf(this.keyPrefix) + relativeKey);
    }

    public void setValue(String relativeKey, String value) {
        Configuration._setValue(String.valueOf(this.keyPrefix) + relativeKey, value);
    }

    public void setValueList(String relativeKey, String[] values) {
        Configuration._setValueList(String.valueOf(this.keyPrefix) + relativeKey, values);
    }

    public void addToValueList(String relativeKey, String item) {
        Configuration._addToValueList(String.valueOf(this.keyPrefix) + relativeKey, item);
    }

    public void removeFromValueList(String relativeKey, String item) {
        Configuration._removeFromValueList(String.valueOf(this.keyPrefix) + relativeKey, item);
    }

    public boolean isList(String relativeKey) {
        return Configuration._isList(String.valueOf(this.keyPrefix) + relativeKey);
    }

    public boolean keyExists(String relativeKey) {
        return Configuration._keyExists(String.valueOf(this.keyPrefix) + relativeKey);
    }

    public void deleteKey(String relativeKey) {
        Configuration._deleteKey(String.valueOf(this.keyPrefix) + relativeKey);
    }

    public String[] getSubKeys(String relativeKey, int visibility) {
        return Configuration._getSubKeys(String.valueOf(this.keyPrefix) + relativeKey, visibility);
    }

    public void setVisibility(String relativeKey, int visibility) {
        Configuration._setVisibility(String.valueOf(this.keyPrefix) + relativeKey, visibility);
    }

    private static String _getValue(String keyName) {
        Key key = root.getSubKey(keyName);
        if (key != null) {
            return key.value;
        }
        return null;
    }

    private static String[] _getValueList(String keyName) {
        Key key = root.getSubKey(keyName);
        if (key != null && key.valueList != null) {
            return key.valueList.toArray(new String[0]);
        }
        return null;
    }

    private static void _setValue(String keyName, String value) {
        Key key = root.getSubKey(keyName);
        if (key == null) {
            key = root.createSubKey(keyName);
        }
        String oldValue = key.value;
        String[] oldValueList = Configuration._getValueList(keyName);
        Configuration.fireChanging(keyName, Configuration._isList(keyName), oldValue, value, oldValueList, null);
        if (key.valueList != null) {
            key.valueList = null;
        }
        key.value = value;
        Configuration.fireChanged(keyName, Configuration._isList(keyName), oldValue, value, oldValueList, null);
    }

    private static void _setValueList(String keyName, String[] values) {
        Key key = root.getSubKey(keyName);
        if (key == null) {
            key = root.createSubKey(keyName);
        }
        String oldValue = key.value;
        String[] oldValueList = Configuration._getValueList(keyName);
        Configuration.fireChanging(keyName, Configuration._isList(keyName), oldValue, null, oldValueList, values);
        if (key.value != null) {
            key.value = null;
        }
        if (key.valueList == null) {
            key.valueList = new ArrayList(values == null ? 0 : values.length);
        } else {
            key.valueList.clear();
        }
        if (values != null) {
            int i = 0;
            while (i < values.length) {
                key.valueList.add(values[i]);
                ++i;
            }
        }
        Configuration.fireChanged(keyName, Configuration._isList(keyName), oldValue, null, oldValueList, values);
    }

    private static void _addToValueList(String keyName, String item) {
        Key key = root.getSubKey(keyName);
        if (key == null) {
            key = root.createSubKey(keyName);
        }
        String oldValue = key.value;
        String[] oldValueList = Configuration._getValueList(keyName);
        Configuration.fireChanging(keyName, Configuration._isList(keyName), oldValue, null, oldValueList, null);
        if (key.value != null) {
            key.value = null;
        }
        if (key.valueList == null) {
            key.valueList = new ArrayList();
        }
        if (item != null) {
            key.valueList.add(item);
        }
        Configuration.fireChanged(keyName, Configuration._isList(keyName), oldValue, null, oldValueList, Configuration._getValueList(keyName));
    }

    private static void _removeFromValueList(String keyName, String item) {
        Key key = root.getSubKey(keyName);
        if (key == null) {
            key = root.createSubKey(keyName);
        }
        String oldValue = key.value;
        String[] oldValueList = Configuration._getValueList(keyName);
        Configuration.fireChanging(keyName, Configuration._isList(keyName), oldValue, null, oldValueList, null);
        if (key.value != null) {
            key.value = null;
        }
        if (key.valueList == null) {
            key.valueList = new ArrayList();
        } else if (item != null) {
            key.valueList.remove(item);
        }
        Configuration.fireChanged(keyName, Configuration._isList(keyName), oldValue, null, oldValueList, Configuration._getValueList(keyName));
    }

    private static boolean _isList(String keyName) {
        Key key = root.getSubKey(keyName);
        if (key != null) {
            return key.valueList != null;
        }
        return false;
    }

    private static boolean _keyExists(String keyName) {
        return root.getSubKey(keyName) != null;
    }

    private static void _deleteKey(String keyName) {
        root.deleteSubKey(keyName);
    }

    private static String[] _getSubKeys(String keyName, int visibility) {
        Key key = root.getSubKey(keyName);
        if (key != null) {
            ArrayList<String> list = new ArrayList<String>(key.subKeys.size());
            for (Key subKey : key.subKeys.keySet()) {
                if ((subKey.visibility & visibility) <= 0) continue;
                list.add(subKey.name);
            }
            return list.toArray(new String[0]);
        }
        return null;
    }

    private static void _setVisibility(String keyName, int visibility) {
        Key key = root.getSubKey(keyName);
        if (key != null) {
            key.visibility = visibility;
        }
    }

    private static void loadConfig(File file) throws IOException {
        Configuration.loadConfig(file.toURL());
    }

    private static void loadConfig(URL url) throws IOException {
        BufferedInputStream bis = new BufferedInputStream(url.openStream());
        Configuration.loadConfig(bis);
        bis.close();
    }

    private static void loadConfig(InputStream is) throws IOException {
        Configuration.root.subKeys = new HashMap();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(is);
            Element rootElement = document.getDocumentElement();
            rootElement.normalize();
            NodeList childNodes = rootElement.getChildNodes();
            int i = 0;
            while (i < childNodes.getLength()) {
                Key subKey;
                Element childElement;
                String tagName;
                Node childNode = childNodes.item(i);
                if (childNode instanceof Element && (tagName = (childElement = (Element)childNode).getTagName()).equals("key") && (subKey = Configuration.loadKey(childElement)) != null && subKey.name != null) {
                    Configuration.root.subKeys.put(subKey.name, subKey);
                }
                ++i;
            }
        }
        catch (Exception e) {
            DialogManager.showMessageDialog(Messages.getString("Alice_had_trouble_reading_your_preferences_but_will_continue_to_run_normally"), Messages.getString("Unable_to_load_preferences"), 2);
        }
    }

    private static Key loadKey(Element keyElement) {
        ArrayList keys;
        Element valueElement;
        Text textNode;
        Key key = new Key();
        String visibility = keyElement.getAttribute("visibility").trim();
        if (visibility.equals("open")) {
            key.visibility = 1;
        } else if (visibility.equals("advanced")) {
            key.visibility = 2;
        } else if (visibility.equals("hidden")) {
            key.visibility = 4;
        }
        HashMap map = Configuration.parseSingleNode(keyElement);
        Element nameElement = (Element)map.get("name");
        if (nameElement != null && (textNode = (Text)Configuration.parseSingleNode(nameElement).get("text")) != null) {
            key.name = textNode.getData().trim();
        }
        if ((valueElement = (Element)map.get("value")) != null) {
            Element listElement = (Element)Configuration.parseSingleNode(valueElement).get("list");
            if (listElement != null) {
                key.valueList = new ArrayList();
                ArrayList items = (ArrayList)Configuration.parseSingleNode(listElement).get("items");
                if (items != null) {
                    for (Element itemElement : items) {
                        Text textNode2;
                        if (itemElement == null || (textNode2 = (Text)Configuration.parseSingleNode(itemElement).get("text")) == null) continue;
                        key.valueList.add(textNode2.getData().trim());
                    }
                }
            } else {
                Text textNode3 = (Text)Configuration.parseSingleNode(valueElement).get("text");
                if (textNode3 != null) {
                    key.value = textNode3.getData().trim();
                }
            }
        }
        if ((keys = (ArrayList)map.get("keys")) != null) {
            for (Element subKeyElement : keys) {
                Key subKey;
                if (subKeyElement == null) continue;
                if (key.subKeys == null) {
                    key.subKeys = new HashMap();
                }
                if ((subKey = Configuration.loadKey(subKeyElement)) == null || subKey.name == null) continue;
                key.subKeys.put(subKey.name, subKey);
            }
        }
        return key;
    }

    private static HashMap parseSingleNode(Node node) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        NodeList childNodes = node.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node childNode = childNodes.item(i);
            if (childNode instanceof Element) {
                ArrayList list;
                Element childElement = (Element)childNode;
                String tagName = childElement.getTagName();
                if (tagName.equals("name")) {
                    map.put("name", childElement);
                } else if (tagName.equals("value")) {
                    map.put("value", childElement);
                } else if (tagName.equals("list")) {
                    map.put("list", childElement);
                } else if (tagName.equals("item")) {
                    list = (ArrayList)map.get("items");
                    if (list == null) {
                        list = new ArrayList();
                        map.put("items", list);
                    }
                    list.add(childElement);
                } else if (tagName.equals("key")) {
                    list = (ArrayList)map.get("keys");
                    if (list == null) {
                        list = new ArrayList();
                        map.put("keys", list);
                    }
                    list.add(childElement);
                }
            } else if (childNode instanceof Text) {
                map.put("text", childNode);
            }
            ++i;
        }
        return map;
    }

    private static Element getChildElementNamed(String name, Node node) {
        NodeList childNodes = node.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Element childElement;
            String tagName;
            Node childNode = childNodes.item(i);
            if (childNode instanceof Element && (tagName = (childElement = (Element)childNode).getTagName()).equals(name)) {
                return childElement;
            }
            ++i;
        }
        return null;
    }

    public static void storeConfig() throws IOException {
        if (configLocation.getParentFile().exists() && configLocation.getParentFile().canWrite()) {
            Configuration.storeConfig(configLocation);
        }
    }

    private static void storeConfig(File file) throws IOException {
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file));
        Configuration.storeConfig(bos);
        bos.flush();
        bos.close();
    }

    private static void storeConfig(OutputStream os) throws IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element rootElement = document.createElement("configuration");
            document.appendChild(rootElement);
            if (Configuration.root.subKeys != null) {
                for (Key key : Configuration.root.subKeys.values()) {
                    rootElement.appendChild(Configuration.makeKeyElement(document, key));
                }
            }
            document.getDocumentElement().normalize();
            Encoder.write(document, os);
        }
        catch (ParserConfigurationException pce) {
            AuthoringTool.showErrorDialog(Messages.getString("Error_parsing_preferences_file_"), pce);
        }
    }

    private static Element makeKeyElement(Document document, Key key) {
        Element valueElement;
        Element keyElement = document.createElement("key");
        if ((key.visibility & 1) > 0) {
            keyElement.setAttribute("visibility", "open");
        } else if ((key.visibility & 2) > 0) {
            keyElement.setAttribute("visibility", "advanced");
        } else if ((key.visibility & 4) > 0) {
            keyElement.setAttribute("visibility", "hidden");
        } else {
            keyElement.setAttribute("visibility", "open");
        }
        Element nameElement = document.createElement("name");
        nameElement.appendChild(document.createTextNode(key.name));
        keyElement.appendChild(nameElement);
        if (key.value != null) {
            valueElement = document.createElement("value");
            valueElement.appendChild(document.createTextNode(key.value));
            keyElement.appendChild(valueElement);
        } else if (key.valueList != null) {
            valueElement = document.createElement("value");
            Element listElement = document.createElement("list");
            Iterator iter = key.valueList.iterator();
            while (iter.hasNext()) {
                Element itemElement = document.createElement("item");
                itemElement.appendChild(document.createTextNode((String)iter.next()));
                listElement.appendChild(itemElement);
            }
            valueElement.appendChild(listElement);
            keyElement.appendChild(valueElement);
        }
        if (key.subKeys != null) {
            for (Key subKey : key.subKeys.values()) {
                keyElement.appendChild(Configuration.makeKeyElement(document, subKey));
            }
        }
        return keyElement;
    }

    public static void addConfigurationListener(ConfigurationListener listener) {
        listeners.add(listener);
    }

    public static void removeConfigurationListener(ConfigurationListener listener) {
        listeners.remove(listener);
    }

    protected static void fireChanging(String keyName, boolean isList, String oldValue, String newValue, String[] oldValueList, String[] newValueList) {
        ConfigurationEvent ev = new ConfigurationEvent(keyName, isList, oldValue, newValue, oldValueList, newValueList);
        Object[] listenerArray = listeners.toArray();
        int i = 0;
        while (i < listenerArray.length) {
            ((ConfigurationListener)listenerArray[i]).changing(ev);
            ++i;
        }
    }

    protected static void fireChanged(String keyName, boolean isList, String oldValue, String newValue, String[] oldValueList, String[] newValueList) {
        ConfigurationEvent ev = new ConfigurationEvent(keyName, isList, oldValue, newValue, oldValueList, newValueList);
        Object[] listenerArray = listeners.toArray();
        int i = 0;
        while (i < listenerArray.length) {
            ((ConfigurationListener)listenerArray[i]).changed(ev);
            ++i;
        }
    }

    private static class Key {
        public String name;
        public int visibility;
        public String value;
        public ArrayList valueList;
        public HashMap subKeys;

        private Key() {
        }

        public Key getSubKey(String name) {
            if (this.subKeys != null) {
                int i = name.indexOf(46);
                if (i == -1) {
                    return (Key)this.subKeys.get(name);
                }
                Key subKey = (Key)this.subKeys.get(name.substring(0, i));
                if (subKey != null) {
                    return subKey.getSubKey(name.substring(i + 1));
                }
            }
            return null;
        }

        public Key createSubKey(String name) {
            int i;
            if (this.subKeys == null) {
                this.subKeys = new HashMap();
            }
            if ((i = name.indexOf(46)) == -1) {
                Key subKey = (Key)this.subKeys.get(name);
                if (subKey == null) {
                    subKey = new Key();
                    subKey.name = name;
                    this.subKeys.put(name, subKey);
                }
                return subKey;
            }
            Key subKey = (Key)this.subKeys.get(name.substring(0, i));
            if (subKey == null) {
                subKey = new Key();
                subKey.name = name.substring(0, i);
                this.subKeys.put(subKey.name, subKey);
            }
            return subKey.createSubKey(name.substring(i + 1));
        }

        public void deleteSubKey(String name) {
            if (this.subKeys != null) {
                int i = name.indexOf(46);
                if (i == -1) {
                    this.subKeys.remove(name);
                } else {
                    Key subKey = (Key)this.subKeys.get(name.substring(0, i));
                    if (subKey != null) {
                        subKey.deleteSubKey(name.substring(i + 1));
                    }
                }
            }
        }

        public String toString() {
            StringBuffer s = new StringBuffer();
            s.append(String.valueOf(Messages.getString("_nname__")) + this.name + "\n");
            s.append(String.valueOf(Messages.getString("visibility__")) + this.visibility + "\n");
            s.append(String.valueOf(Messages.getString("value__")) + this.value + "\n");
            s.append(String.valueOf(Messages.getString("valueList__")) + this.valueList + "\n");
            s.append(String.valueOf(Messages.getString("subKeys__")) + this.subKeys + "\n");
            return s.toString();
        }
    }
}

