/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.util;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.JAliceFrame;
import edu.cmu.cs.stage3.alice.authoringtool.event.AuthoringToolStateChangedEvent;
import edu.cmu.cs.stage3.alice.authoringtool.event.AuthoringToolStateListener;
import edu.cmu.cs.stage3.alice.authoringtool.util.ChildChangeUndoableRedoable;
import edu.cmu.cs.stage3.alice.authoringtool.util.Configuration;
import edu.cmu.cs.stage3.alice.authoringtool.util.ObjectArrayPropertyUndoableRedoable;
import edu.cmu.cs.stage3.alice.authoringtool.util.OneShotUndoableRedoable;
import edu.cmu.cs.stage3.alice.authoringtool.util.PropertyUndoableRedoable;
import edu.cmu.cs.stage3.alice.authoringtool.util.UndoableRedoable;
import edu.cmu.cs.stage3.alice.core.World;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;

public class ChangeLogger
implements AuthoringToolStateListener {
    protected AuthoringTool authoringTool;
    protected World world;
    private Package authoringToolPackage = Package.getPackage("edu.cmu.cs.stage3.alice.authoringtool");
    String dataDirectory;
    protected PrintWriter printWriter = null;
    private File file = null;

    public ChangeLogger(AuthoringTool authoringTool) {
        this.authoringTool = authoringTool;
        authoringTool.addAuthoringToolStateListener(this);
        this.dataDirectory = String.valueOf(Configuration.getValue(this.authoringToolPackage, "directories.worldsDirectory")) + System.getProperty("file.separator") + "loggingData";
    }

    public void pushUndoableRedoable(UndoableRedoable ur) {
        if (ur instanceof ChildChangeUndoableRedoable) {
            this.record(((ChildChangeUndoableRedoable)ur).getLogString());
        } else if (ur instanceof ObjectArrayPropertyUndoableRedoable) {
            this.record(((ObjectArrayPropertyUndoableRedoable)ur).getLogString());
        } else if (ur instanceof PropertyUndoableRedoable) {
            this.record(((PropertyUndoableRedoable)ur).getLogString());
        } else if (ur instanceof OneShotUndoableRedoable) {
            this.record(((OneShotUndoableRedoable)ur).getLogString());
        }
    }

    public void recordInstructorIntervention(String type, String comment) {
        String logString = "TIME=<" + System.currentTimeMillis() + "> " + "TYPE=<" + type + "> " + "COMMENT=<" + comment + ">";
        this.record(logString);
    }

    protected void record(String toRecord) {
        if (toRecord != null && this.authoringTool.instructorInControl && this.printWriter != null) {
            this.printWriter.println(toRecord);
            this.printWriter.flush();
        }
    }

    protected void recordWorldEvent(long time, String type) {
        String logString = "TIME=<" + time + "> " + "EVENT=<World> " + "TYPE=<" + type + ">";
        this.record(logString);
    }

    @Override
    public void stateChanged(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void worldUnLoading(AuthoringToolStateChangedEvent ev) {
        if (this.printWriter != null && JAliceFrame.isLogging) {
            this.printWriter.close();
            this.printWriter = null;
            if (this.file.length() == 0L) {
                this.file.delete();
                this.file = null;
            }
        }
    }

    @Override
    public void worldLoaded(AuthoringToolStateChangedEvent ev) {
        if (JAliceFrame.isLogging && this.file == null) {
            this.file = new File(this.dataDirectory);
            if (!this.file.exists()) {
                this.file.mkdir();
            }
            this.file = new File(String.valueOf(this.dataDirectory) + System.getProperty("file.separator") + System.currentTimeMillis() + ".txt");
            try {
                this.printWriter = new PrintWriter(new FileOutputStream(this.file));
            }
            catch (FileNotFoundException fnfe) {
                fnfe.printStackTrace();
            }
        }
    }

    @Override
    public void stateChanging(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void worldLoading(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void worldStarting(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void worldStopping(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void worldPausing(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void worldSaving(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void worldUnLoaded(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void worldStarted(AuthoringToolStateChangedEvent ev) {
        this.recordWorldEvent(System.currentTimeMillis(), "start");
    }

    @Override
    public void worldStopped(AuthoringToolStateChangedEvent ev) {
        this.recordWorldEvent(System.currentTimeMillis(), "stop");
    }

    @Override
    public void worldPaused(AuthoringToolStateChangedEvent ev) {
        this.recordWorldEvent(System.currentTimeMillis(), "pause");
    }

    @Override
    public void worldSaved(AuthoringToolStateChangedEvent ev) {
        this.recordWorldEvent(System.currentTimeMillis(), "save");
    }
}

