/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.util;

import edu.cmu.cs.stage3.alice.authoringtool.AikMin;
import edu.cmu.cs.stage3.alice.authoringtool.util.AliceMenu;
import edu.cmu.cs.stage3.alice.authoringtool.util.MultiColumnPopupLayout;
import edu.cmu.cs.stage3.alice.authoringtool.util.PopupMenuUtilities;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.Timer;

public class AlicePopupMenu
extends JPopupMenu {
    protected int millisecondDelay = 300;
    protected Timer setPopupVisibleTrueTimer;
    protected Timer setPopupVisibleFalseTimer;
    AliceMenu invokerMenu;
    public static AlicePopupMenu item = new AlicePopupMenu();

    public AlicePopupMenu() {
        this.setLayout(new MultiColumnPopupLayout());
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        Container popup = null;
        if (b) {
            popup = this.getParent();
            if (popup != null) {
                popup = popup.getParent();
            }
            if (popup != null) {
                popup = popup.getParent();
            }
            if (popup != null) {
                popup = popup.getParent();
            }
            if (popup instanceof Window) {
                Window[] windows = ((Window)popup).getOwnedWindows();
                int i = 0;
                while (i < windows.length) {
                    windows[i].setVisible(false);
                    ++i;
                }
            }
        }
    }

    @Override
    public void menuSelectionChanged(boolean isIncluded) {
        if (this.setPopupVisibleTrueTimer == null) {
            this.setPopupVisibleTrueTimer = new Timer(this.millisecondDelay, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    AlicePopupMenu.this.invokerMenu.setPopupMenuVisible(true);
                }
            });
            this.setPopupVisibleTrueTimer.setRepeats(false);
        }
        if (this.setPopupVisibleFalseTimer == null) {
            this.setPopupVisibleFalseTimer = new Timer(this.millisecondDelay, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    AlicePopupMenu.this.invokerMenu.setPopupMenuVisible(false);
                }
            });
            this.setPopupVisibleFalseTimer.setRepeats(false);
        }
        if (this.setPopupVisibleTrueTimer.isRunning()) {
            this.setPopupVisibleTrueTimer.stop();
        }
        if (this.setPopupVisibleFalseTimer.isRunning()) {
            this.setPopupVisibleFalseTimer.stop();
        }
        if (this.getInvoker() instanceof AliceMenu) {
            boolean allGone = MenuSelectionManager.defaultManager().getSelectedPath().length == 0;
            this.invokerMenu = (AliceMenu)this.getInvoker();
            if (isIncluded) {
                this.setPopupVisibleTrueTimer.start();
            } else if (allGone) {
                this.setVisible(false);
            } else {
                this.setPopupVisibleFalseTimer.start();
            }
        }
        if (this.isPopupMenu() && !isIncluded) {
            this.setVisible(false);
        }
    }

    private boolean isPopupMenu() {
        return this.getInvoker() != null && !(this.getInvoker() instanceof AliceMenu);
    }

    public static void hidePopup() {
        if (item != null) {
            item.setFocusable(false);
        }
    }

    public static void showPopup() {
        if (item != null) {
            item.setFocusable(true);
        }
    }

    @Override
    public void show(Component invoker, int x, int y) {
        final AlicePopupMenu menu = this;
        if (item.isFocusable()) {
            super.show(invoker, x, y);
            PopupMenuUtilities.ensurePopupIsOnScreen(menu);
            if (AikMin.isMAC()) {
                item.addPropertyChangeListener("focusable", new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent arg0) {
                        item.removePropertyChangeListener(this);
                        if (!item.hasFocus() && menu.isVisible()) {
                            menu.setVisible(false);
                        }
                    }
                });
            }
        }
    }

    public void printPath(MenuElement[] path) {
        System.out.print("path [");
        int i = 0;
        while (i < path.length) {
            MenuElement me = path[i];
            if (me instanceof JMenu) {
                System.out.print(String.valueOf(((JMenu)me).getText()) + ", ");
            } else if (me instanceof JPopupMenu) {
                Component invoker = ((JPopupMenu)me).getInvoker();
                if (invoker instanceof JMenu) {
                    System.out.print(String.valueOf(((JMenu)invoker).getText()) + ".popupMenu, ");
                } else {
                    System.out.print("anonymous popupMenu, ");
                }
            } else {
                System.out.print(me.getClass().getName());
            }
            ++i;
        }
        System.out.println("]");
    }
}

