/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.Timer;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.basic.BasicMenuUI;

public class AliceMenuUI
extends BasicMenuUI {
    @Override
    protected MouseInputListener createMouseInputListener(JComponent c) {
        return new AliceMouseInputHandler();
    }

    @Override
    protected void setupPostTimer(JMenu menu) {
        Timer timer = new Timer(menu.getDelay(), new AlicePostAction(menu));
        timer.setRepeats(false);
        timer.start();
    }

    @Override
    public MenuElement[] getPath() {
        Vector<JMenuItem> path = new Vector<JMenuItem>();
        MenuElement me = this.menuItem;
        while (me instanceof MenuElement) {
            Component o;
            path.add(0, (JMenuItem)me);
            if (me instanceof JPopupMenu) {
                o = ((JPopupMenu)me).getInvoker();
                if (o instanceof MenuElement && o != me) {
                    me = (MenuElement)((Object)o);
                    continue;
                }
                me = null;
                continue;
            }
            if (me instanceof JMenuItem) {
                o = me.getParent();
                if (o instanceof MenuElement && o != me) {
                    me = (MenuElement)((Object)o);
                    continue;
                }
                me = null;
                continue;
            }
            me = null;
        }
        return path.toArray(new MenuElement[0]);
    }

    public void printPath(MenuElement[] path) {
        System.out.print("path [");
        int i = 0;
        while (i < path.length) {
            MenuElement me = path[i];
            if (me instanceof JMenu) {
                System.out.print(String.valueOf(((JMenu)me).getText()) + ", ");
            } else if (me instanceof JPopupMenu) {
                Component invoker = ((JPopupMenu)me).getInvoker();
                if (invoker instanceof JMenu) {
                    System.out.print(String.valueOf(((JMenu)invoker).getText()) + ".popupMenu, ");
                } else {
                    System.out.print("anonymous popupMenu, ");
                }
            } else {
                System.out.print(me.getClass().getName());
            }
            ++i;
        }
        System.out.println("]");
    }

    protected class AliceMouseInputHandler
    implements MouseInputListener {
        protected AliceMouseInputHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            MenuElement[] selectedPath;
            JMenu menu = (JMenu)AliceMenuUI.this.menuItem;
            if (!menu.isEnabled()) {
                return;
            }
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            if (menu.isTopLevelMenu()) {
                if (menu.isSelected()) {
                    manager.clearSelectedPath();
                } else {
                    Container cnt = menu.getParent();
                    if (cnt != null && cnt instanceof JMenuBar) {
                        MenuElement[] me = new MenuElement[]{(MenuElement)((Object)cnt), menu};
                        manager.setSelectedPath(me);
                    }
                }
            }
            if ((selectedPath = manager.getSelectedPath()).length <= 0 || selectedPath[selectedPath.length - 1] != menu.getPopupMenu()) {
                if (menu.isTopLevelMenu() || menu.getDelay() == 0) {
                    MenuElement[] newPath = new MenuElement[selectedPath.length + 1];
                    System.arraycopy(selectedPath, 0, newPath, 0, selectedPath.length);
                    newPath[selectedPath.length] = menu.getPopupMenu();
                    manager.setSelectedPath(newPath);
                } else {
                    AliceMenuUI.this.setupPostTimer(menu);
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            JMenu menu = (JMenu)AliceMenuUI.this.menuItem;
            if (!menu.isEnabled()) {
                return;
            }
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            manager.processMouseEvent(e);
            if (!e.isConsumed()) {
                manager.clearSelectedPath();
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            JMenu menu = (JMenu)AliceMenuUI.this.menuItem;
            if (!menu.isEnabled()) {
                return;
            }
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            MenuElement[] selectedPath = manager.getSelectedPath();
            if (!menu.isTopLevelMenu()) {
                if (menu.getDelay() == 0) {
                    MenuElement[] path = AliceMenuUI.this.getPath();
                    MenuElement[] newPath = new MenuElement[AliceMenuUI.this.getPath().length + 1];
                    System.arraycopy(path, 0, newPath, 0, path.length);
                    newPath[path.length] = menu.getPopupMenu();
                    manager.setSelectedPath(newPath);
                } else {
                    manager.setSelectedPath(AliceMenuUI.this.getPath());
                    AliceMenuUI.this.setupPostTimer(menu);
                }
            } else if (selectedPath.length > 0 && selectedPath[0] == menu.getParent()) {
                MenuElement[] newPath = new MenuElement[]{(MenuElement)((Object)menu.getParent()), menu, menu.getPopupMenu()};
                manager.setSelectedPath(newPath);
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            JMenu menu = (JMenu)AliceMenuUI.this.menuItem;
            if (!menu.isEnabled()) {
                return;
            }
            MenuSelectionManager.defaultManager().processMouseEvent(e);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }
    }

    private static class AlicePostAction
    extends AbstractAction {
        JMenu menu;

        AlicePostAction(JMenu menu) {
            this.menu = menu;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MenuSelectionManager defaultManager = MenuSelectionManager.defaultManager();
            MenuElement[] path = ((BasicMenuUI)this.menu.getUI()).getPath();
            MenuElement[] newPath = new MenuElement[path.length + 1];
            int i = 0;
            while (i < path.length) {
                newPath[i] = path[i];
                ++i;
            }
            newPath[path.length] = this.menu.getPopupMenu();
            defaultManager.setSelectedPath(newPath);
        }

        @Override
        public boolean isEnabled() {
            return this.menu.getModel().isEnabled();
        }
    }
}

