/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.util;

import edu.cmu.cs.stage3.alice.authoringtool.util.AlicePopupMenu;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.basic.BasicMenuItemUI;

public class AliceMenuItemUI
extends BasicMenuItemUI {
    @Override
    protected MouseInputListener createMouseInputListener(JComponent c) {
        return new MouseInputHandler();
    }

    @Override
    public MenuElement[] getPath() {
        MenuElement[] newPath;
        MenuSelectionManager m = MenuSelectionManager.defaultManager();
        MenuElement[] oldPath = m.getSelectedPath();
        int i = oldPath.length;
        if (i == 0) {
            return new MenuElement[0];
        }
        Container parent = this.menuItem.getParent();
        if (oldPath[i - 1].getComponent() == parent) {
            newPath = new MenuElement[i + 1];
            System.arraycopy(oldPath, 0, newPath, 0, i);
            newPath[i] = this.menuItem;
        } else {
            Vector<JMenuItem> path = new Vector<JMenuItem>();
            MenuElement me = this.menuItem;
            while (me instanceof MenuElement) {
                Component o;
                path.add(0, (JMenuItem)me);
                if (me instanceof JPopupMenu) {
                    o = ((JPopupMenu)me).getInvoker();
                    if (o instanceof MenuElement && o != me) {
                        me = (MenuElement)((Object)o);
                        continue;
                    }
                    me = null;
                    continue;
                }
                if (me instanceof JMenuItem) {
                    o = me.getParent();
                    if (o instanceof MenuElement && o != me) {
                        me = (MenuElement)((Object)o);
                        continue;
                    }
                    me = null;
                    continue;
                }
                me = null;
            }
            newPath = path.toArray(new MenuElement[0]);
        }
        return newPath;
    }

    public void printPath(MenuElement[] path) {
        System.out.print("path [");
        int i = 0;
        while (i < path.length) {
            MenuElement me = path[i];
            if (me instanceof JMenu) {
                System.out.print(String.valueOf(((JMenu)me).getText()) + ", ");
            } else if (me instanceof JPopupMenu) {
                Component invoker = ((JPopupMenu)me).getInvoker();
                if (invoker instanceof JMenu) {
                    System.out.print(String.valueOf(((JMenu)invoker).getText()) + ".popupMenu, ");
                } else {
                    System.out.print("anonymous popupMenu, ");
                }
            } else {
                System.out.print(me.getClass().getName());
            }
            ++i;
        }
        System.out.println("]");
    }

    protected class MouseInputHandler
    implements MouseInputListener {
        protected MouseInputHandler() {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            Point p = e.getPoint();
            if (p.x >= 0 && p.x < AliceMenuItemUI.this.menuItem.getWidth() && p.y >= 0 && p.y < AliceMenuItemUI.this.menuItem.getHeight()) {
                MenuElement[] path = AliceMenuItemUI.this.getPath();
                manager.clearSelectedPath();
                AliceMenuItemUI.this.menuItem.doClick(0);
                int i = 0;
                while (i < path.length) {
                    if (path[i] instanceof AlicePopupMenu) {
                        ((AlicePopupMenu)path[i]).setVisible(false);
                    }
                    ++i;
                }
            } else {
                manager.processMouseEvent(e);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            int modifiers = e.getModifiers();
            if ((modifiers & 0x1C) != 0) {
                MenuSelectionManager.defaultManager().processMouseEvent(e);
            } else {
                manager.setSelectedPath(AliceMenuItemUI.this.getPath());
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            int modifiers = e.getModifiers();
            if ((modifiers & 0x1C) != 0) {
                MenuSelectionManager.defaultManager().processMouseEvent(e);
            } else {
                MenuElement[] path = manager.getSelectedPath();
                if (path.length > 1) {
                    MenuElement[] newPath = new MenuElement[path.length - 1];
                    int i = 0;
                    while (i < path.length - 1) {
                        newPath[i] = path[i];
                        ++i;
                    }
                    manager.setSelectedPath(newPath);
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            MenuSelectionManager.defaultManager().processMouseEvent(e);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }
    }
}

