/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.galleryviewer;

import edu.cmu.cs.stage3.alice.authoringtool.AikMin;
import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources;
import edu.cmu.cs.stage3.alice.authoringtool.JAlice;
import edu.cmu.cs.stage3.alice.authoringtool.datatransfer.FileListTransferable;
import edu.cmu.cs.stage3.alice.authoringtool.datatransfer.URLTransferable;
import edu.cmu.cs.stage3.alice.authoringtool.galleryviewer.DirectoryBarButton;
import edu.cmu.cs.stage3.alice.authoringtool.galleryviewer.GalleryObject;
import edu.cmu.cs.stage3.alice.authoringtool.galleryviewer.GenericBuilderButton;
import edu.cmu.cs.stage3.alice.authoringtool.galleryviewer.ModelInfoContentPane;
import edu.cmu.cs.stage3.alice.authoringtool.galleryviewer.PersonBuilderButton;
import edu.cmu.cs.stage3.alice.authoringtool.galleryviewer.TextBuilderButton;
import edu.cmu.cs.stage3.alice.authoringtool.galleryviewer.WebGalleryDirectory;
import edu.cmu.cs.stage3.alice.authoringtool.galleryviewer.WebGalleryObject;
import edu.cmu.cs.stage3.alice.authoringtool.util.Configuration;
import edu.cmu.cs.stage3.alice.authoringtool.util.GUIFactory;
import edu.cmu.cs.stage3.alice.authoringtool.util.GroupingPanel;
import edu.cmu.cs.stage3.alice.core.Model;
import edu.cmu.cs.stage3.caitlin.personbuilder.PersonBuilder;
import edu.cmu.cs.stage3.lang.Messages;
import edu.cmu.cs.stage3.swing.DialogManager;
import edu.cmu.cs.stage3.util.StringObjectPair;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.vecmath.Vector3d;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class GalleryViewer
extends GroupingPanel {
    private Package authoringToolPackage = Package.getPackage("edu.cmu.cs.stage3.alice.authoringtool");
    protected static final String FILENAME = "directoryIndex.xml";
    protected static final String FILENAME2 = "galleryIndex.xml";
    public static final int LOCAL = 1;
    public static final int WEB = 2;
    public static final int CD = 3;
    protected final Insets panelInset = new Insets(1, 2, 0, 0);
    public static final String webGalleryName = Messages.getString("Web_Gallery");
    public static final String localGalleryName = Messages.getString("Local_Gallery");
    public static final String cdGalleryName = Messages.getString("CD_Gallery");
    public static final String customGalleryName = Messages.getString("Custom_Gallery");
    public static boolean showBuilder = false;
    public static String webGalleryRoot;
    public static String localGalleryRoot;
    public static String cdGalleryRoot;
    public static String customGalleryRoot;
    protected static boolean alreadyEnteredWebGallery;
    public static final String homeName;
    protected static final Color backgroundColor;
    protected static final Color textColor;
    protected static final Color linkColor;
    protected static final String noModelsYet;
    public static String cacheDir;
    protected RootDirectoryStructure webGallery = null;
    protected RootDirectoryStructure localGallery = null;
    protected RootDirectoryStructure cdGallery = null;
    protected RootDirectoryStructure customGallery = null;
    protected Vector currentGalleryObjects;
    protected GroupingPanel objectPanel;
    protected FlowLayout objectPanelLayout;
    protected JPanel directoryPanel;
    protected JPanel searchPanel;
    protected Vector rootDirectories;
    protected DirectoryStructure directoryOnDisplay;
    protected DirectoryStructure searchResults;
    protected DirectoryStructure oldDirectoryOnDisplay;
    protected ImageIcon customGalleryIcon;
    protected ImageIcon webGalleryIcon;
    protected ImageIcon localGalleryIcon;
    protected ImageIcon cdGalleryIcon;
    protected ImageIcon add3DTextIcon;
    protected ObjectXmlData add3DTextData;
    protected TextBuilderButton add3DTextButton;
    protected JButton upLevelButton;
    public static ImageIcon noFolderImageIcon;
    public static ImageIcon loadingImageIcon;
    public static ImageIcon noImageIcon;
    protected boolean inBrowseMode;
    protected boolean stopSearch = true;
    protected SearchingLabel searchingProgressLabel = new SearchingLabel();
    protected String lastSearchString = "";
    protected String stopSearchString = Messages.getString("Stop_Search");
    protected String startSearchString = Messages.getString("Search");
    protected String startSearchWebString = Messages.getString("Search_www_alice_org");
    protected String webGalleryHostName = Messages.getString("www_alice_org");
    protected String searchString = Messages.getString("Browse_Gallery");
    protected String browseString = Messages.getString("Search_Gallery");
    protected JLabel attributeLabel;
    protected JPanel attributePanel;
    protected JTextField searchField;
    protected JButton searchButton;
    protected JButton searchWebButton;
    protected JButton searchBrowseButton;
    protected JPanel headerPanel;
    protected JLabel noObjectsLabel;
    protected JLabel noSearchResults;
    protected JLabel searching;
    protected GridBagConstraints glueConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0);
    protected Thread changingThread;
    protected Vector builderButtonsVector;
    protected static double bitsPerSecond;
    protected AuthoringTool authoringTool;
    protected static JFrame aliceFrame;
    protected ModelInfoContentPane modelContentPane;
    protected int searchCount = 0;
    protected boolean updatePanelsWhileLoading = false;
    protected boolean stopBuildingGallery = false;
    protected boolean isInWebGallery = false;
    protected boolean oldIsInWebGalleryValue = false;
    protected AliceCharacterFilter characterFilter = new AliceCharacterFilter();
    protected DirectoryFilter directoryFilter = new DirectoryFilter();
    protected ThumbnailFilter thumbnailFilter = new ThumbnailFilter();

    static {
        alreadyEnteredWebGallery = false;
        homeName = Messages.getString("Home");
        backgroundColor = new Color(118, 128, 128);
        textColor = new Color(255, 255, 255);
        linkColor = new Color(153, 204, 255);
        noModelsYet = Messages.getString("No_models_found_yet_");
        bitsPerSecond = 0.0;
    }

    public void setAuthoringTool(AuthoringTool authoringTool) {
        this.authoringTool = authoringTool;
        this.characterFilter.setFilter(this.authoringTool.getCharacterFileFilter());
        this.add3DTextButton.set(this.add3DTextData, this.add3DTextIcon, authoringTool);
    }

    public boolean shouldShowWebWarning() {
        return Configuration.getValue(this.authoringToolPackage, "showWebWarningDialog").equalsIgnoreCase("true");
    }

    public GalleryViewer() {
        showBuilder = Configuration.getValue(this.authoringToolPackage, "showBuilderMode").equalsIgnoreCase("true");
        URL mainWebGalleryURL = AuthoringToolResources.getMainWebGalleryURL();
        if (mainWebGalleryURL != null) {
            this.webGalleryHostName = mainWebGalleryURL.getHost();
            this.startSearchWebString = String.valueOf(Messages.getString("Search_")) + this.webGalleryHostName;
        }
        File mainLocalGalleryFile = AuthoringToolResources.getMainDiskGalleryDirectory();
        File mainCDGalleryFile = AuthoringToolResources.getMainCDGalleryDirectory();
        File mainCustomGalleryFile = new File(Configuration.getValue(this.authoringToolPackage, "directories.charactersDirectory"));
        cacheDir = String.valueOf(File.separator) + "webGalleryCache" + File.separator;
        File testDir = new File(JAlice.getAliceUserDirectory(), cacheDir);
        if (!testDir.exists()) {
            testDir.mkdirs();
        }
        this.rootDirectories = new Vector();
        this.inBrowseMode = true;
        this.guiInit();
        String[] file = Configuration.getValueList(this.authoringToolPackage, "directories.galleryDirectory");
        RootDirectoryStructure templocal = this.createDirectory(new File(String.valueOf(mainLocalGalleryFile.getAbsolutePath()) + System.getProperty("file.separator") + "Core"), String.valueOf(localGalleryName) + " (Core)", 1);
        int i = 0;
        while (i < file.length) {
            File temp = new File(String.valueOf(mainLocalGalleryFile.getAbsolutePath()) + System.getProperty("file.separator") + file[i]);
            this.localGallery = this.createDirectory(temp, String.valueOf(localGalleryName) + " (" + file[i] + ")", 1);
            if (this.localGallery != null) {
                this.rootDirectories.add(this.localGallery);
                localGalleryRoot = this.localGallery.rootPath;
                if (AikMin.locale.equalsIgnoreCase(file[i])) {
                    templocal = this.localGallery;
                }
            }
            ++i;
        }
        if (templocal != null) {
            this.localGallery = templocal;
        }
        this.cdGallery = this.createDirectory(mainCDGalleryFile, cdGalleryName, 3);
        if (this.cdGallery != null) {
            this.rootDirectories.add(this.cdGallery);
            cdGalleryRoot = this.cdGallery.rootPath;
        }
        this.webGallery = this.createDirectory(mainWebGalleryURL, webGalleryName, FILENAME2, false);
        if (this.webGallery != null) {
            this.rootDirectories.add(this.webGallery);
            webGalleryRoot = this.webGallery.rootPath;
        } else {
            this.webGallery = this.createDirectory(mainWebGalleryURL, webGalleryName, FILENAME, false);
            if (this.webGallery != null) {
                this.rootDirectories.add(this.webGallery);
                webGalleryRoot = this.webGallery.rootPath;
            }
        }
        this.customGallery = this.createDirectory(mainCustomGalleryFile, customGalleryName, 1);
        if (this.customGallery != null) {
            this.rootDirectories.add(this.customGallery);
            customGalleryRoot = this.customGallery.rootPath;
        }
        if (this.localGallery != null) {
            this.webGallery.directory.firstLocalDirectory = this.localGallery.directory;
        }
        if (this.cdGallery != null) {
            this.webGallery.directory.secondLocalDirectory = this.cdGallery.directory;
        }
        this.directoryOnDisplay = this.inBrowseMode ? (this.localGallery != null ? this.localGallery.directory : null) : this.searchResults;
        this.searchResults = new DirectoryStructure(null, Messages.getString("Search"), null);
        this.searchResults.xmlData = new DirectoryXmlData(Messages.getString("Search"));
        this.refreshGUI();
    }

    private GalleryObject getGalleryObject(Component c) {
        if (c instanceof GalleryObject) {
            return (GalleryObject)c;
        }
        if (c == null) {
            return null;
        }
        return this.getGalleryObject(c.getParent());
    }

    private String getRelativeDirectory(String root, String filename, String separator) {
        int split = filename.indexOf(root);
        String toReturn = null;
        if (split >= 0) {
            toReturn = filename.substring(split + root.length());
            toReturn = (split = toReturn.lastIndexOf(separator)) >= 0 && split < toReturn.length() - 1 ? String.valueOf(toReturn.substring(0, split)) + separator : "";
        }
        return toReturn;
    }

    private String removeRootFromDirectory(String root, String filename) {
        int split = filename.indexOf(root);
        String toReturn = null;
        if (split >= 0) {
            toReturn = filename.substring(split + root.length());
        }
        return toReturn;
    }

    private String getFilename(String filename, String separator) {
        int split = filename.lastIndexOf(separator);
        String toReturn = null;
        if (split >= 0) {
            toReturn = filename.substring(split, filename.length());
        }
        return toReturn;
    }

    public void saveModel(edu.cmu.cs.stage3.alice.core.Element toSave, Transferable transferable) {
        ObjectXmlData objectToAdd = null;
        Image image = null;
        int i = 0;
        while (i < this.objectPanel.getComponentCount()) {
            if (this.objectPanel.getComponent(i) instanceof GalleryObject) {
                GalleryObject currentObject = (GalleryObject)this.objectPanel.getComponent(i);
                if (currentObject.data.transferable == transferable) {
                    objectToAdd = currentObject.data;
                    image = currentObject.image.getImage();
                    if (objectToAdd.type == 2) break;
                    return;
                }
            }
            ++i;
        }
        String path = null;
        if (objectToAdd != null) {
            path = objectToAdd.objectFilename;
            int split = path.lastIndexOf(47);
            path = path.substring(0, split);
        } else {
            DirectoryStructure dirOwner;
            try {
                URL url;
                if (AuthoringToolResources.safeIsDataFlavorSupported(transferable, URLTransferable.urlFlavor) && (url = (URL)transferable.getTransferData(URLTransferable.urlFlavor)) != null) {
                    path = this.getRelativeDirectory(webGalleryRoot, url.toString(), "/");
                    path = String.valueOf(webGalleryName) + File.separator + GalleryViewer.reverseWebReady(path);
                }
            }
            catch (Exception e) {
                return;
            }
            if (path != null && (dirOwner = this.getDirectoryStructure(path)) != null && (objectToAdd = dirOwner.getModel(transferable)) != null) {
                if (objectToAdd.type == 2) {
                    image = WebGalleryObject.retrieveImage(webGalleryRoot, objectToAdd.imageFilename, objectToAdd.timeStamp);
                } else {
                    return;
                }
            }
        }
        if (objectToAdd != null) {
            String localFilename = GalleryViewer.reverseWebReady(objectToAdd.objectFilename);
            String baseFilename = localFilename.substring(0, localFilename.length() - 3);
            String xmlFilename = String.valueOf(objectToAdd.objectFilename.substring(0, objectToAdd.objectFilename.length() - 3)) + "xml";
            String pngFilename = String.valueOf(baseFilename) + "png";
            String a2cFilename = String.valueOf(baseFilename) + "a2c";
            GalleryObject.storeThumbnail(String.valueOf(localGalleryRoot) + pngFilename, image, objectToAdd.timeStamp);
            this.getXML(objectToAdd.parentDirectory.rootNode.rootPath, xmlFilename, objectToAdd.type, -1L, localGalleryRoot, true);
            File objectFile = GalleryViewer.createFile(String.valueOf(localGalleryRoot) + a2cFilename);
            if (objectFile != null) {
                try {
                    toSave.store(objectFile);
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }
    }

    protected void addObject(Model toAdd) {
        if (this.authoringTool != null) {
            this.authoringTool.getUndoRedoStack().startCompound();
            this.authoringTool.addCharacter(toAdd, null);
            this.authoringTool.getUndoRedoStack().stopCompound();
        }
    }

    protected void addObject(File toAdd) {
        if (this.authoringTool != null) {
            this.authoringTool.loadAndAddCharacter(toAdd);
        }
    }

    protected void addObject(URL toAdd) {
        if (this.authoringTool != null) {
            this.authoringTool.loadAndAddCharacter(toAdd);
        }
    }

    private DirectoryStructure getRootDirectoryNamed(String dirName) {
        int i = 0;
        while (i < this.rootDirectories.size()) {
            RootDirectoryStructure current = (RootDirectoryStructure)this.rootDirectories.get(i);
            if (current.directory.name.equalsIgnoreCase(dirName)) {
                return current.directory;
            }
            ++i;
        }
        return null;
    }

    public String getDirectory() {
        if (this.directoryOnDisplay == null) {
            return homeName;
        }
        return this.directoryOnDisplay.getGUIPath();
    }

    protected void displayModelDialog(ObjectXmlData data, ImageIcon image) {
        if (this.modelContentPane == null) {
            this.modelContentPane = new ModelInfoContentPane();
        }
        this.modelContentPane.set(data, image);
        int result = DialogManager.showDialog(this.modelContentPane);
        if (result == 0) {
            if (data.type != 2) {
                File file = new File(this.modelContentPane.getFilename());
                this.addObject(file);
            } else {
                while (true) {
                    try {
                        URL url = new URL(this.modelContentPane.getFilename());
                        this.addObject(url);
                    }
                    catch (Exception exception) {
                        Object[] options = new Object[]{Messages.getString("Retry"), Messages.getString("Cancel")};
                        int returnVal = DialogManager.showOptionDialog(Messages.getString("Alice_can_t_reach_the_web_gallery__Your_computer_may_not_be_connected_to_the_internet_properly_"), Messages.getString("Internet_Connection_Error"), 0, 2, null, options, options[1]);
                        if (returnVal != 0) continue;
                    }
                    break;
                }
            }
        }
    }

    protected DirectoryStructure getDirectoryStructure(String pathToSet) {
        if (pathToSet == null) {
            return null;
        }
        StringTokenizer token = new StringTokenizer(pathToSet, File.separator);
        boolean isFirst = true;
        DirectoryStructure currentDirToSet = null;
        while (token.hasMoreTokens()) {
            String current = token.nextToken();
            if (current == null || current.equalsIgnoreCase("") || current.equalsIgnoreCase(" ")) continue;
            if (isFirst) {
                isFirst = false;
                if (current.equalsIgnoreCase(homeName)) {
                    currentDirToSet = null;
                    isFirst = true;
                    continue;
                }
                if (current.equalsIgnoreCase(webGalleryName)) {
                    currentDirToSet = this.getRootDirectoryNamed(webGalleryName);
                    continue;
                }
                if (current.startsWith(localGalleryName)) {
                    currentDirToSet = this.getRootDirectoryNamed(String.valueOf(localGalleryName) + " (" + Configuration.getValue(this.authoringToolPackage, "language") + ")");
                    if (currentDirToSet != null) continue;
                    currentDirToSet = this.getRootDirectoryNamed(String.valueOf(localGalleryName) + " (Core)");
                    continue;
                }
                if (current.equalsIgnoreCase(cdGalleryName)) {
                    currentDirToSet = this.getRootDirectoryNamed(cdGalleryName);
                    continue;
                }
                return null;
            }
            if (currentDirToSet != null) {
                currentDirToSet = currentDirToSet.getDirectoryNamed(current);
                continue;
            }
            return null;
        }
        return currentDirToSet;
    }

    public void setDirectory(String pathToSet) {
        DirectoryStructure d = null;
        if (AikMin.isWindows()) {
            d = this.getDirectoryStructure(pathToSet);
        } else {
            pathToSet = pathToSet.replace("\\", "/");
            d = this.getDirectoryStructure(pathToSet);
        }
        if (d == null) {
            AuthoringTool.showErrorDialog(String.valueOf(Messages.getString("Error_changing_gallery_viewer_to_")) + pathToSet, null);
            return;
        }
        this.changeDirectory(d);
    }

    private RootDirectoryStructure createDirectory(URL root, String name, String rootFilename, boolean initXML) {
        String path = this.getRootString(root);
        if (path == null) {
            return null;
        }
        rootFilename = this.makeWebRelativePathReady(rootFilename);
        ObjectXmlData data = new ObjectXmlData();
        data.name = name;
        data.type = 2;
        data.objectFilename = rootFilename;
        data.size = -1;
        data.mainViewer = this;
        data.transferable = new StringSelection(data.name);
        RootDirectoryStructure toReturn = new RootDirectoryStructure(path, 2, null, data);
        DirectoryStructure dirStruct = new DirectoryStructure(toReturn, name, rootFilename);
        if (initXML) {
            String xml;
            block5: {
                try {
                    xml = this.getXML(path, rootFilename, 2, this.getURLTimeStamp(String.valueOf(path) + rootFilename), cacheDir, false);
                    if (xml != null) break block5;
                    return null;
                }
                catch (Exception e) {
                    return null;
                }
            }
            dirStruct.initSelf(xml);
        }
        data.directoryData = dirStruct;
        toReturn.directory = dirStruct;
        return toReturn;
    }

    private RootDirectoryStructure createDirectory(File root, String name, int type) {
        if (!(root != null && root.exists() && root.isDirectory() && root.canRead())) {
            return null;
        }
        String path = this.getRootString(root);
        ObjectXmlData data = new ObjectXmlData();
        data.name = name;
        data.objectFilename = "";
        data.size = -1;
        data.type = type;
        data.mainViewer = this;
        data.transferable = new StringSelection(data.name);
        RootDirectoryStructure toReturn = new RootDirectoryStructure(path, type, null, data);
        DirectoryStructure dirStruct = null;
        try {
            dirStruct = new DirectoryStructure(toReturn, name, "");
            dirStruct.initSelf(root);
        }
        catch (Exception e) {
            return null;
        }
        data.directoryData = dirStruct;
        toReturn.directory = dirStruct;
        return toReturn;
    }

    private String getRootString(File file) {
        if (file == null) {
            return null;
        }
        String toReturn = file.getAbsolutePath();
        if (!toReturn.endsWith(File.separator)) {
            toReturn = String.valueOf(toReturn) + File.separator;
        }
        return toReturn;
    }

    private String getRootString(URL url) {
        if (url == null) {
            return null;
        }
        String toReturn = url.toString();
        if (!toReturn.endsWith("/")) {
            toReturn = String.valueOf(toReturn) + "/";
        }
        return toReturn;
    }

    protected static synchronized void setDownloadRate(long time, int bytes) {
        double newRate = (double)bytes / ((double)time * 0.001);
        bitsPerSecond = bitsPerSecond != 0.0 ? bitsPerSecond * 0.8 + newRate * 0.2 : newRate;
    }

    public static File createFile(String filename) {
        int split2;
        int nameSplit = filename.lastIndexOf(File.separator);
        if (File.separator.equals("\\")) {
            split2 = filename.lastIndexOf("/");
            if (split2 > nameSplit) {
                nameSplit = split2;
            }
        } else {
            split2 = filename.lastIndexOf("\\");
            if (split2 > nameSplit) {
                nameSplit = split2;
            }
        }
        String parentDir = filename.substring(0, nameSplit + 1);
        File cacheFile = new File(filename);
        if (!cacheFile.exists()) {
            try {
                File parentDirFile = new File(parentDir);
                if (!parentDirFile.exists()) {
                    parentDirFile.mkdirs();
                }
                cacheFile.createNewFile();
            }
            catch (Exception e) {
                return null;
            }
        }
        return cacheFile;
    }

    protected long getURLTimeStamp(String urlString) {
        long toReturn = 0L;
        try {
            URL url = new URL(urlString);
            toReturn = url.openConnection().getLastModified();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return toReturn;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getXML(String root, String relativeFile, int type, final long sourceTimeStamp, String cacheDirectory, boolean forceCache) {
        boolean needToCache;
        String cacheFilenameTemp;
        String xmlTemp;
        block8: {
            Object[] options;
            int returnVal;
            xmlTemp = null;
            cacheFilenameTemp = null;
            needToCache = true;
            if (type == 1 || type == 3) {
                File file = new File(String.valueOf(root) + relativeFile);
                if (file.exists() && file.canRead()) {
                    xmlTemp = this.getXML(file);
                    cacheFilenameTemp = String.valueOf(cacheDirectory) + relativeFile;
                    needToCache = false;
                    break block8;
                } else {
                    AuthoringTool.showErrorDialog(String.valueOf(Messages.getString("Error_accessing_the_local_gallery__")) + file.getAbsolutePath() + " " + Messages.getString("is_either_not_there_or_can_not_be_read"), null);
                    return null;
                }
            }
            cacheFilenameTemp = String.valueOf(cacheDirectory) + GalleryViewer.reverseWebReady(relativeFile);
            File cachedCopy = new File(cacheFilenameTemp);
            long cacheTimeStamp = -2L;
            if (cachedCopy.exists() && cachedCopy.canRead() && (cacheTimeStamp = cachedCopy.lastModified()) == sourceTimeStamp) {
                xmlTemp = this.getXML(cachedCopy);
                needToCache = false;
            }
            URL url = null;
            do {
                try {
                    url = new URL(String.valueOf(root) + relativeFile);
                    xmlTemp = this.getXML(url);
                }
                catch (Exception e) {
                    xmlTemp = null;
                }
                if (xmlTemp != null) break block8;
                options = new Object[]{Messages.getString("Retry"), Messages.getString("Cancel")};
            } while ((returnVal = DialogManager.showOptionDialog(Messages.getString("Alice_can_t_reach_the_web_gallery__Your_computer_may_not_be_connected_to_the_internet_properly_"), Messages.getString("Internet_Connection_Error"), 0, 2, null, options, options[1])) == 0);
            return null;
        }
        final String xml = xmlTemp;
        final String cacheFilename = cacheFilenameTemp;
        if (needToCache || forceCache) {
            Runnable doStore = new Runnable(){

                @Override
                public void run() {
                    File cacheFile = GalleryViewer.createFile(cacheFilename);
                    if (cacheFile != null) {
                        try {
                            FileOutputStream fos = new FileOutputStream(cacheFile);
                            OutputStreamWriter osw = new OutputStreamWriter(fos);
                            BufferedWriter bw = new BufferedWriter(osw);
                            bw.write(xml);
                            bw.flush();
                            osw.close();
                            cacheFile.setLastModified(sourceTimeStamp);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            };
            Thread t = new Thread(doStore);
            t.start();
        }
        return xml;
    }

    private String getXML(ZipFile zipFile) {
        String content = "";
        try {
            ZipEntry entry = zipFile.getEntry("galleryData.xml");
            if (entry != null) {
                InputStream stream = zipFile.getInputStream(entry);
                BufferedReader fileReader = new BufferedReader(new InputStreamReader(stream));
                char[] b = new char[1000];
                int numRead = fileReader.read(b);
                content = new String(b, 0, numRead);
                while (numRead != -1) {
                    numRead = fileReader.read(b);
                    if (numRead == -1) continue;
                    String newContent = new String(b, 0, numRead);
                    content = String.valueOf(content) + newContent;
                }
            }
            zipFile.close();
        }
        catch (Exception e) {
            return null;
        }
        return content;
    }

    private String getXML(File file) {
        String content = "";
        try {
            FileReader fileReader = new FileReader(file);
            char[] b = new char[1000];
            int numRead = fileReader.read(b);
            content = new String(b, 0, numRead);
            while (numRead != -1) {
                numRead = fileReader.read(b);
                if (numRead == -1) continue;
                String newContent = new String(b, 0, numRead);
                content = String.valueOf(content) + newContent;
            }
            fileReader.close();
        }
        catch (IOException e) {
            return null;
        }
        return content;
    }

    private String getXML(URL url) {
        String content = "";
        try {
            InputStream urlStream = url.openStream();
            BufferedInputStream bufis = new BufferedInputStream(urlStream);
            byte[] b = new byte[1000];
            int numRead = bufis.read(b);
            content = new String(b, 0, numRead);
            while (numRead != -1) {
                numRead = bufis.read(b);
                if (numRead == -1) continue;
                String newContent = new String(b, 0, numRead);
                content = String.valueOf(content) + newContent;
            }
            urlStream.close();
        }
        catch (MalformedURLException e) {
            return null;
        }
        catch (Exception e) {
            return null;
        }
        return content;
    }

    private Transferable createURLTransferable(String filename) {
        HttpURLConnection connection;
        URL url;
        block6: {
            block5: {
                Object toReturn = null;
                url = new URL(filename);
                if (url.getProtocol().equalsIgnoreCase("http")) break block5;
                return null;
            }
            connection = (HttpURLConnection)url.openConnection();
            int response = connection.getResponseCode();
            if (response == 200) break block6;
            return null;
        }
        try {
            connection.disconnect();
            return new URLTransferable(url);
        }
        catch (MalformedURLException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    private Transferable createFileTransferable(String filename) {
        File fileToTransfer = new File(filename);
        if (fileToTransfer.exists() && fileToTransfer.canRead()) {
            ArrayList<File> list = new ArrayList<File>(1);
            list.add(fileToTransfer);
            return new FileListTransferable(list);
        }
        return null;
    }

    protected static void enteredWebGallery() {
        alreadyEnteredWebGallery = true;
    }

    public void switchMode() {
        if (this.inBrowseMode) {
            this.searchBrowseButton.setText(this.searchString);
            this.headerPanel.remove(this.directoryPanel);
            this.headerPanel.add((Component)this.searchPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.oldDirectoryOnDisplay = this.directoryOnDisplay;
            this.directoryOnDisplay = this.searchResults;
        } else {
            this.searchBrowseButton.setText(this.browseString);
            this.headerPanel.remove(this.searchPanel);
            this.stopSearch = true;
            this.isInWebGallery = this.oldIsInWebGalleryValue;
            this.headerPanel.add((Component)this.directoryPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.directoryOnDisplay = this.oldDirectoryOnDisplay;
        }
        this.inBrowseMode = !this.inBrowseMode;
        this.refreshGUI();
    }

    private void guiInit() {
        this.setBackground(backgroundColor);
        this.objectPanel = new GroupingPanel();
        this.objectPanel.setBorder(null);
        this.objectPanel.setBackground(backgroundColor);
        this.objectPanelLayout = new FlowLayout();
        this.objectPanelLayout.setAlignment(0);
        this.objectPanelLayout.setVgap(0);
        this.objectPanelLayout.setHgap(1);
        this.objectPanel.setLayout(this.objectPanelLayout);
        this.directoryPanel = new JPanel();
        this.directoryPanel.setLayout(new GridBagLayout());
        this.directoryPanel.setOpaque(false);
        this.attributeLabel = new JLabel(" ");
        this.attributeLabel.setForeground(textColor);
        this.attributePanel = new JPanel();
        this.attributePanel.setOpaque(false);
        this.attributePanel.setLayout(new GridBagLayout());
        this.attributePanel.add((Component)this.attributeLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.searchBrowseButton = new JButton(this.browseString);
        this.searchBrowseButton.setBackground(new Color(240, 240, 255));
        this.searchBrowseButton.setMargin(new Insets(2, 2, 2, 2));
        this.searchBrowseButton.setMinimumSize(new Dimension(100, 26));
        if (!this.inBrowseMode) {
            this.searchBrowseButton.setText(this.searchString);
        }
        this.searchBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GalleryViewer.this.switchMode();
            }
        });
        this.searchField = new JTextField(15);
        this.searchField.setMinimumSize(new Dimension(200, 26));
        this.searchField.setPreferredSize(new Dimension(200, 26));
        this.searchField.setMaximumSize(new Dimension(200, 26));
        this.searchField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GalleryViewer.this.searchGallery(null, GalleryViewer.this.searchField.getText(), false);
            }
        });
        this.searchField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent ev) {
                GalleryViewer.this.searchWebButton.setEnabled(false);
            }

            @Override
            public void removeUpdate(DocumentEvent ev) {
                GalleryViewer.this.searchWebButton.setEnabled(false);
            }

            private void updateHeightTextField() {
                GalleryViewer.this.searchWebButton.setEnabled(false);
            }

            @Override
            public void changedUpdate(DocumentEvent ev) {
                GalleryViewer.this.searchWebButton.setEnabled(false);
            }
        });
        this.searchButton = new JButton(this.startSearchString);
        this.searchButton.setBackground(new Color(240, 240, 255));
        this.searchButton.setMargin(new Insets(2, 2, 2, 2));
        this.searchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!GalleryViewer.this.stopSearch) {
                    GalleryViewer.this.stopSearch = true;
                    GalleryViewer.this.isInWebGallery = GalleryViewer.this.oldIsInWebGalleryValue;
                    GalleryViewer.this.searchButton.setText(GalleryViewer.this.startSearchString);
                } else {
                    GalleryViewer.this.searchGallery(null, GalleryViewer.this.searchField.getText(), false);
                }
            }
        });
        this.searchWebButton = new JButton(this.startSearchWebString);
        this.searchWebButton.setBackground(new Color(240, 240, 255));
        this.searchWebButton.setMargin(new Insets(2, 2, 2, 2));
        this.searchWebButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!GalleryViewer.this.stopSearch) {
                    GalleryViewer.this.stopSearch = true;
                    GalleryViewer.this.isInWebGallery = GalleryViewer.this.oldIsInWebGalleryValue;
                    GalleryViewer.this.searchWebButton.setText(GalleryViewer.this.startSearchWebString);
                } else if (!alreadyEnteredWebGallery && GalleryViewer.this.shouldShowWebWarning()) {
                    int dialogVal = DialogManager.showConfirmDialog(String.valueOf(Messages.getString("You_are_about_to_search_the_online_gallery__This_is_accessed_through_the_internet_n")) + Messages.getString("and_is_potentially_slow_depending_on_your_connection_"), Messages.getString("Web_gallery_may_be_slow"), 2);
                    if (dialogVal == 0) {
                        GalleryViewer.enteredWebGallery();
                        GalleryViewer.this.searchGallery(GalleryViewer.this.webGallery.directory, GalleryViewer.this.searchField.getText(), true);
                    }
                } else {
                    GalleryViewer.this.searchGallery(GalleryViewer.this.webGallery.directory, GalleryViewer.this.searchField.getText(), true);
                }
            }
        });
        this.searchWebButton.setEnabled(false);
        this.searchPanel = new JPanel();
        this.searchPanel.setOpaque(false);
        this.searchPanel.setBorder(null);
        this.searchPanel.setLayout(new GridBagLayout());
        this.searchPanel.add((Component)this.searchField, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(2, 4, 0, 8), 0, 0));
        this.searchPanel.add((Component)this.searchButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(2, 0, 0, 0), 0, 0));
        this.searchPanel.add((Component)this.searchWebButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(2, 4, 0, 0), 0, 0));
        this.searchPanel.add((Component)this.searchingProgressLabel, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(2, 4, 0, 0), 0, 0));
        this.searchPanel.add(Box.createHorizontalGlue(), new GridBagConstraints(4, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.headerPanel = new JPanel();
        this.headerPanel.setMinimumSize(new Dimension(1, 34));
        this.headerPanel.setOpaque(false);
        this.headerPanel.setLayout(new GridBagLayout());
        if (this.inBrowseMode) {
            this.headerPanel.add((Component)this.directoryPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        } else {
            this.headerPanel.add((Component)this.searchPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
        this.headerPanel.add((Component)this.attributeLabel, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 18, 0, new Insets(0, 30, 0, 0), 0, 0));
        this.headerPanel.add((Component)this.searchBrowseButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 12, 0, new Insets(2, 0, 0, 4), 0, 0));
        this.headerPanel.add(Box.createHorizontalGlue(), new GridBagConstraints(1, 1, 2, 1, 1.0, 1.0, 13, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.headerPanel.add(Box.createHorizontalGlue(), new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 13, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.customGalleryIcon = new ImageIcon(GalleryViewer.class.getResource("images/defaultFolderIcon.png"));
        this.webGalleryIcon = new ImageIcon(GalleryViewer.class.getResource("images/webGalleryIcon.png"));
        loadingImageIcon = new ImageIcon(GalleryViewer.class.getResource("images/loadingImageIcon.png"));
        noImageIcon = new ImageIcon(GalleryViewer.class.getResource("images/noImageIcon.png"));
        noFolderImageIcon = new ImageIcon(GalleryViewer.class.getResource("images/defaultFolderIcon.png"));
        this.localGalleryIcon = new ImageIcon(GalleryViewer.class.getResource("images/localGalleryIcon.png"));
        this.cdGalleryIcon = new ImageIcon(GalleryViewer.class.getResource("images/cdGalleryIcon.png"));
        this.add3DTextIcon = new ImageIcon(GalleryViewer.class.getResource("images/3DText.png"));
        ImageIcon upLevelIcon = new ImageIcon(GalleryViewer.class.getResource("images/upLevelIcon.png"));
        ImageIcon upLevelIconPressed = new ImageIcon(GalleryViewer.class.getResource("images/upLevelIconPressed.png"));
        ImageIcon upLevelIconDisabled = AuthoringToolResources.getDisabledIcon(upLevelIcon, 45);
        this.upLevelButton = new JButton(upLevelIcon);
        this.upLevelButton.setToolTipText(Messages.getString("Move_Up_a_Level"));
        this.upLevelButton.setOpaque(false);
        this.upLevelButton.setDisabledIcon(upLevelIconDisabled);
        this.upLevelButton.setPressedIcon(upLevelIconPressed);
        this.upLevelButton.setSize(upLevelIcon.getIconWidth() + 2, upLevelIcon.getIconHeight() + 2);
        this.upLevelButton.setMargin(new Insets(0, 0, 0, 0));
        this.upLevelButton.setBorder(null);
        this.upLevelButton.setCursor(new Cursor(12));
        this.upLevelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GalleryViewer.this.goUpOneLevel();
            }
        });
        this.add3DTextData = new ObjectXmlData();
        this.add3DTextData.name = Messages.getString("Create_3D_Text");
        this.add3DTextData.mainViewer = this;
        this.add3DTextData.transferable = new StringSelection(this.add3DTextData.name);
        this.add3DTextButton = new TextBuilderButton();
        this.add3DTextButton.set(this.add3DTextData, this.add3DTextIcon, null);
        Vector builderVector = PersonBuilder.getAllBuilders();
        this.builderButtonsVector = new Vector();
        int i = 0;
        while (i < builderVector.size()) {
            if (builderVector.get(i) instanceof StringObjectPair) {
                StringObjectPair sop = (StringObjectPair)builderVector.get(i);
                ImageIcon builderIcon = null;
                if (sop.getObject() instanceof ImageIcon) {
                    builderIcon = (ImageIcon)sop.getObject();
                    ObjectXmlData personBuilderData = new ObjectXmlData();
                    personBuilderData.name = sop.getString();
                    personBuilderData.mainViewer = this;
                    personBuilderData.transferable = new StringSelection(personBuilderData.name);
                    PersonBuilderButton currentButton = new PersonBuilderButton();
                    currentButton.set(personBuilderData, builderIcon);
                    this.builderButtonsVector.add(currentButton);
                }
            }
            ++i;
        }
        this.noObjectsLabel = new JLabel();
        this.noObjectsLabel.setFont(new Font("Dialog", 0, 24));
        this.noObjectsLabel.setForeground(Color.white);
        this.noObjectsLabel.setText(Messages.getString("No_folders_or_Alice_characters_found_in_this_directory_"));
        this.noSearchResults = new JLabel();
        this.noSearchResults.setFont(new Font("Dialog", 0, 24));
        this.noSearchResults.setForeground(Color.white);
        this.noSearchResults.setText(Messages.getString("No_models_were_found_"));
        this.searching = new JLabel();
        this.searching.setFont(new Font("Dialog", 0, 24));
        this.searching.setForeground(Color.white);
        this.searching.setText(noModelsYet);
        this.setLayout(new BorderLayout());
        this.add((Component)this.headerPanel, "North");
        JScrollPane scrollPane = new JScrollPane(this.objectPanel, 20, 30);
        this.add((Component)scrollPane, "Center");
        scrollPane.getHorizontalScrollBar().setUnitIncrement(44);
        int fontSize = Integer.parseInt(Configuration.getValue(this.authoringToolPackage, "fontSize"));
        this.setPreferredSize(new Dimension(Integer.MAX_VALUE, 250 + (fontSize - 12) * 6));
        this.setMinimumSize(new Dimension(100, 250));
    }

    private String getNodeText(Node node) {
        String toReturn = "";
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            if (children.item(i).getNodeType() == 3) {
                toReturn = String.valueOf(toReturn) + children.item(i).getNodeValue();
            }
            ++i;
        }
        return toReturn;
    }

    private Object getDetailedNodeText(Node node) {
        Object toReturn = null;
        NodeList children = node.getChildNodes();
        if (children.getLength() == 1 && children.item(0).getNodeType() == 3) {
            toReturn = children.item(0).getNodeValue();
        } else if (children.getLength() > 0) {
            Vector<String> detailVector = new Vector<String>();
            int i = 0;
            while (i < children.getLength()) {
                Node currentNode = children.item(i);
                if (currentNode.getNodeType() == 1 && currentNode.getFirstChild().getNodeType() == 3) {
                    detailVector.add(currentNode.getFirstChild().getNodeValue());
                }
                ++i;
            }
            toReturn = detailVector;
        }
        return toReturn;
    }

    public static String reverseWebReady(String url) {
        String toReturn = "";
        int beginning = 0;
        int index = url.indexOf("%20");
        while (index != -1) {
            toReturn = String.valueOf(toReturn) + url.substring(beginning, index);
            toReturn = String.valueOf(toReturn) + " ";
            beginning = index + 3;
            index = url.indexOf("%20", beginning);
        }
        toReturn = String.valueOf(toReturn) + url.substring(beginning, url.length());
        toReturn = toReturn.replace('/', File.separatorChar);
        return toReturn;
    }

    private String makeWebReady(String url) {
        String toReturn = "";
        int beginning = 0;
        int i = 0;
        while (i < url.length()) {
            if (url.charAt(i) == ' ') {
                toReturn = String.valueOf(toReturn) + url.substring(beginning, i) + "%20";
                beginning = i + 1;
            }
            ++i;
        }
        toReturn = String.valueOf(toReturn) + url.substring(beginning, url.length());
        toReturn = toReturn.replace('\\', '/');
        return toReturn;
    }

    private String makeWebRelativePathReady(String url) {
        String toReturn = this.makeWebReady(url);
        if (toReturn.charAt(0) == '/') {
            toReturn = toReturn.substring(1);
        }
        return toReturn;
    }

    private String makeRelativePathReady(String relativeFilename) {
        String pathname = new String(relativeFilename);
        if (File.separatorChar == '\\') {
            pathname = pathname.replace('/', File.separatorChar);
        } else if (File.separatorChar == '/') {
            pathname = pathname.replace('\\', File.separatorChar);
        }
        if (pathname.charAt(0) == File.separatorChar) {
            pathname = pathname.substring(1);
        }
        return pathname;
    }

    private GalleryObject createGalleryObject(ObjectXmlData currentObject) {
        ObjectXmlData localMatch = null;
        if (currentObject.parentDirectory.firstLocalDirectory != null && currentObject.parentDirectory.firstLocalDirectory.xmlData != null) {
            localMatch = currentObject.parentDirectory.firstLocalDirectory.xmlData.getModel(currentObject);
        }
        if (localMatch == null && currentObject.parentDirectory.secondLocalDirectory != null && currentObject.parentDirectory.secondLocalDirectory.xmlData != null) {
            localMatch = currentObject.parentDirectory.secondLocalDirectory.xmlData.getModel(currentObject);
        }
        if (localMatch != null) {
            currentObject = localMatch;
        }
        GalleryObject toReturn = (GalleryObject)GUIFactory.getGUI(currentObject);
        try {
            toReturn.set(currentObject);
        }
        catch (Exception e) {
            return null;
        }
        toReturn.loadImage();
        return toReturn;
    }

    private GalleryObject createGalleryDirectory(ObjectXmlData currentObject) {
        GalleryObject toReturn = (GalleryObject)GUIFactory.getGUI(currentObject);
        try {
            toReturn.set(currentObject);
        }
        catch (Exception e) {
            return null;
        }
        toReturn.loadImage();
        return toReturn;
    }

    private ObjectXmlData createObjectXmlData(File dirFile, String root, int type) {
        if (dirFile == null || dirFile.isDirectory() || !dirFile.canRead()) {
            return null;
        }
        ObjectXmlData currentObject = new ObjectXmlData();
        currentObject.type = type;
        currentObject.mainViewer = this;
        currentObject.name = dirFile.getName();
        currentObject.timeStamp = dirFile.lastModified();
        currentObject.objectFilename = this.removeRootFromDirectory(root, dirFile.getAbsolutePath());
        currentObject.transferable = this.createFileTransferable(String.valueOf(root) + currentObject.objectFilename);
        currentObject.imageFilename = currentObject.objectFilename;
        currentObject.size = (int)(dirFile.length() / 1000L);
        return currentObject;
    }

    private ObjectXmlData createDirectoryObjectXmlData(File dirFile, String root, int type) {
        if (dirFile == null || !dirFile.isDirectory() || !dirFile.canRead()) {
            return null;
        }
        ObjectXmlData currentObject = new ObjectXmlData();
        currentObject.type = type;
        currentObject.mainViewer = this;
        currentObject.name = dirFile.getName();
        currentObject.timeStamp = dirFile.lastModified();
        currentObject.objectFilename = this.removeRootFromDirectory(root, dirFile.getAbsolutePath());
        currentObject.transferable = this.createFileTransferable(String.valueOf(root) + currentObject.objectFilename);
        File[] thumbFiles = dirFile.listFiles(this.thumbnailFilter);
        currentObject.imageFilename = thumbFiles != null && thumbFiles.length > 0 ? this.makeRelativePathReady(String.valueOf(currentObject.objectFilename) + File.separator + thumbFiles[0].getName()) : null;
        currentObject.size = -1;
        return currentObject;
    }

    private ObjectXmlData createObjectXmlData(Node currentModel, String root, int type) {
        ObjectXmlData currentObject = new ObjectXmlData();
        currentObject.type = type;
        currentObject.mainViewer = this;
        NodeList nodeDetails = currentModel.getChildNodes();
        int j = 0;
        while (j < nodeDetails.getLength()) {
            block16: {
                Node currentDetail = nodeDetails.item(j);
                if (currentDetail != null && currentDetail.getNodeType() == 1 && !currentDetail.getNodeName().equals("#text")) {
                    String rawFilename;
                    block17: {
                        block18: {
                            try {
                                if (currentDetail.getNodeName().equalsIgnoreCase("name")) {
                                    currentObject.name = this.getNodeText(currentDetail);
                                    break block16;
                                }
                                if (currentDetail.getNodeName().equalsIgnoreCase("timestamp")) {
                                    currentObject.timeStamp = Long.parseLong(this.getNodeText(currentDetail));
                                    break block16;
                                }
                                if (!currentDetail.getNodeName().equalsIgnoreCase("objectfilename")) break block17;
                                rawFilename = this.getNodeText(currentDetail);
                                currentObject.objectFilename = type == 2 ? this.makeWebRelativePathReady(rawFilename) : this.makeRelativePathReady(rawFilename);
                                if (type != 2) break block18;
                                currentObject.transferable = this.createURLTransferable(String.valueOf(root) + currentObject.objectFilename);
                                if (currentObject.transferable == null) {
                                    return null;
                                }
                            }
                            catch (Exception e) {
                                currentObject = null;
                                break;
                            }
                        }
                        if (type != 1 && type != 3) break block16;
                        currentObject.transferable = this.createFileTransferable(String.valueOf(root) + currentObject.objectFilename);
                        if (currentObject.transferable == null) {
                            return null;
                        }
                    }
                    if (currentDetail.getNodeName().equalsIgnoreCase("imagefilename")) {
                        rawFilename = this.getNodeText(currentDetail);
                        currentObject.imageFilename = type == 2 ? this.makeWebRelativePathReady(rawFilename) : this.makeRelativePathReady(rawFilename);
                    } else if (currentDetail.getNodeName().equalsIgnoreCase("size")) {
                        currentObject.setSize(this.getNodeText(currentDetail));
                    } else if (currentDetail.getNodeName().equalsIgnoreCase("physicalsize")) {
                        currentObject.setDimensions(this.getNodeText(currentDetail));
                    } else {
                        currentObject.addDetail(currentDetail.getNodeName(), this.getDetailedNodeText(currentDetail));
                    }
                }
            }
            ++j;
        }
        return currentObject;
    }

    private void buildNewDirectory(DirectoryStructure newDir, boolean setAsCurrent) {
        String xml;
        DirectoryStructure oldDir = this.directoryOnDisplay;
        boolean oldIsInWebGallery = this.isInWebGallery;
        if (setAsCurrent) {
            this.directoryOnDisplay = newDir;
            if (!this.stopBuildingGallery) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        GalleryViewer.this.createDirectoryButtons();
                        GalleryViewer.this.directoryPanel.revalidate();
                        GalleryViewer.this.repaint();
                    }
                });
            } else {
                this.directoryOnDisplay = oldDir;
                this.refreshGUI();
                return;
            }
        }
        if (newDir.rootNode.type == 2) {
            this.isInWebGallery = true;
            boolean oldUpdateValue = this.updatePanelsWhileLoading;
            this.updatePanelsWhileLoading = false;
            if (newDir.firstLocalDirectory != null) {
                if (newDir.firstLocalDirectory.xmlData == null) {
                    this.buildNewDirectory(newDir.firstLocalDirectory, false);
                }
            } else if (newDir.secondLocalDirectory != null && newDir.secondLocalDirectory.xmlData == null) {
                this.buildNewDirectory(newDir.secondLocalDirectory, false);
            }
            this.updatePanelsWhileLoading = oldUpdateValue;
            long tempTimeStamp = -1L;
            if (newDir.data != null) {
                if (newDir.data.timeStamp == -1L) {
                    tempTimeStamp = newDir.data.timeStamp = this.getURLTimeStamp(String.valueOf(newDir.rootNode.rootPath) + newDir.path);
                }
            } else {
                tempTimeStamp = this.getURLTimeStamp(String.valueOf(newDir.rootNode.rootPath) + newDir.path);
            }
            if ((xml = this.getXML(newDir.rootNode.rootPath, newDir.path, 2, tempTimeStamp, cacheDir, false)) == null) {
                if (setAsCurrent) {
                    this.isInWebGallery = oldIsInWebGallery;
                    this.directoryOnDisplay = oldDir;
                    this.refreshGUI();
                }
                return;
            }
        } else {
            if (this.directoryOnDisplay.name.startsWith(localGalleryName) || this.directoryOnDisplay.name.equals(cdGalleryName)) {
                this.isInWebGallery = false;
            }
            xml = null;
        }
        int totalInside = -1;
        try {
            if (xml != null) {
                totalInside = newDir.initSelf(xml);
            } else if (newDir.rootNode.type != 2) {
                totalInside = newDir.initSelf(new File(String.valueOf(newDir.rootNode.rootPath) + newDir.path));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            if (setAsCurrent) {
                this.isInWebGallery = oldIsInWebGallery;
                this.directoryOnDisplay = oldDir;
                this.refreshGUI();
            }
            return;
        }
        if (setAsCurrent && totalInside < 0) {
            this.isInWebGallery = oldIsInWebGallery;
            this.directoryOnDisplay = oldDir;
            this.refreshGUI();
        }
        if (this.updatePanelsWhileLoading) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GalleryViewer.this.removeAttribution();
                }
            });
        }
    }

    public int searchDirectory(DirectoryStructure toSearch, String toSearchFor) {
        if (toSearch != null && !this.stopSearch) {
            Vector matches;
            if (toSearch.xmlData == null) {
                this.updatePanelsWhileLoading = false;
                this.buildNewDirectory(toSearch, false);
            }
            if ((matches = toSearch.getObjectMatches(toSearchFor)) != null) {
                int i = 0;
                while (i < matches.size()) {
                    if (!this.searchResults.contains((ObjectXmlData)matches.get(i))) {
                        this.searchResults.xmlData.addModel((ObjectXmlData)matches.get(i));
                        if (this.searchCount == 0) {
                            this.objectPanel.removeAll();
                        }
                        this.modelAdded((ObjectXmlData)matches.get(i), this.searchCount);
                        ++this.searchCount;
                    }
                    ++i;
                }
            }
            int count = matches.size();
            int i = 0;
            while (i < toSearch.xmlData.directories.size()) {
                count += this.searchDirectory(toSearch.xmlData.getDirectory(i), toSearchFor);
                ++i;
            }
            return count;
        }
        return 0;
    }

    public void searchGallery(final DirectoryStructure toSearch, final String toSearchFor, final boolean isWeb) {
        this.oldIsInWebGalleryValue = this.isInWebGallery;
        if (toSearchFor == null) {
            return;
        }
        this.lastSearchString = toSearchFor;
        if (!isWeb) {
            this.searchResults.xmlData.models.removeAllElements();
            this.searching.setText(noModelsYet);
            this.searchCount = 0;
            this.objectPanel.removeAll();
            this.objectPanel.add(this.searching);
            this.objectPanel.revalidate();
            this.objectPanel.repaint();
        }
        this.stopSearch = false;
        this.searchingProgressLabel.reset();
        if (isWeb) {
            this.searchWebButton.setText(this.stopSearchString);
        } else {
            this.searchButton.setText(this.stopSearchString);
        }
        Thread searchThread = new Thread(){

            @Override
            public void run() {
                int total = 0;
                Thread t = new Thread(){

                    @Override
                    public void run() {
                        while (!(this).GalleryViewer.this.stopSearch) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    ((this).this).GalleryViewer.this.searchingProgressLabel.advance();
                                }
                            });
                            try {
                                Thread.sleep(250L);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                };
                t.start();
                if (toSearch == null) {
                    int i = 0;
                    while (i < GalleryViewer.this.rootDirectories.size()) {
                        RootDirectoryStructure currentRoot = (RootDirectoryStructure)GalleryViewer.this.rootDirectories.get(i);
                        if (!isWeb && currentRoot != GalleryViewer.this.webGallery) {
                            total += GalleryViewer.this.searchDirectory(currentRoot.directory, toSearchFor);
                        }
                        ++i;
                    }
                } else {
                    total = GalleryViewer.this.searchDirectory(toSearch, toSearchFor);
                }
                final int finalTotal = total;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (finalTotal <= 0 && (this).GalleryViewer.this.searchCount <= 0) {
                            (this).GalleryViewer.this.objectPanel.removeAll();
                            if (isWeb) {
                                (this).GalleryViewer.this.noSearchResults.setText(String.valueOf(Messages.getString("No_models_matching__")) + toSearchFor + "\" " + Messages.getString("were_found_on_") + (this).GalleryViewer.this.webGalleryHostName);
                            } else {
                                (this).GalleryViewer.this.noSearchResults.setText(String.valueOf(Messages.getString("No_models_matching__")) + toSearchFor + "\" " + Messages.getString("were_found_on_your_machine_"));
                            }
                            (this).GalleryViewer.this.objectPanel.add((this).GalleryViewer.this.noSearchResults);
                            (this).GalleryViewer.this.objectPanel.revalidate();
                            (this).GalleryViewer.this.objectPanel.repaint();
                        }
                        if (isWeb) {
                            (this).GalleryViewer.this.searchWebButton.setText((this).GalleryViewer.this.startSearchWebString);
                        } else {
                            (this).GalleryViewer.this.searchButton.setText((this).GalleryViewer.this.startSearchString);
                            (this).GalleryViewer.this.searchWebButton.setEnabled(true);
                        }
                        (this).GalleryViewer.this.searchingProgressLabel.reset();
                    }
                });
                GalleryViewer.this.stopSearch = true;
                GalleryViewer.this.isInWebGallery = GalleryViewer.this.oldIsInWebGalleryValue;
            }
        };
        searchThread.start();
    }

    protected void changeDirectory(DirectoryStructure toChangeTo) {
        DirectoryStructure actualToChangeTo;
        DirectoryStructure temp = null;
        if (toChangeTo != null) {
            temp = toChangeTo.directoryToUse;
        }
        if ((actualToChangeTo = temp) == this.directoryOnDisplay) {
            return;
        }
        Runnable toRun = null;
        toRun = actualToChangeTo != null && actualToChangeTo.xmlData == null ? new Runnable(){

            @Override
            public void run() {
                GalleryViewer.this.updatePanelsWhileLoading = true;
                GalleryViewer.this.buildNewDirectory(actualToChangeTo, true);
                GalleryViewer.this.updatePanelsWhileLoading = false;
            }
        } : new Runnable(){

            @Override
            public void run() {
                GalleryViewer.this.directoryOnDisplay = actualToChangeTo;
                if (GalleryViewer.this.directoryOnDisplay == null) {
                    GalleryViewer.this.isInWebGallery = false;
                } else if (GalleryViewer.this.directoryOnDisplay.name.startsWith(localGalleryName) || GalleryViewer.this.directoryOnDisplay.name.equals(cdGalleryName)) {
                    GalleryViewer.this.isInWebGallery = false;
                } else if (GalleryViewer.this.directoryOnDisplay.name.equals(webGalleryName)) {
                    GalleryViewer.this.isInWebGallery = true;
                }
                if (GalleryViewer.this.directoryOnDisplay != null && !GalleryViewer.this.isInWebGallery) {
                    try {
                        GalleryViewer.this.directoryOnDisplay.updateSelf(new File(String.valueOf(GalleryViewer.this.directoryOnDisplay.rootNode.rootPath) + GalleryViewer.this.directoryOnDisplay.path));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                GalleryViewer.this.refreshGUI();
            }
        };
        if (this.changingThread != null && this.changingThread.isAlive()) {
            this.stopBuildingGallery = true;
            while (this.changingThread.isAlive()) {
                try {
                    Thread.sleep(10L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.stopBuildingGallery = false;
        }
        if (this.isInWebGallery) {
            this.attributeLabel.setText(String.valueOf(Messages.getString("Loading_from_")) + this.webGalleryHostName + "...");
        } else {
            this.attributeLabel.setText(Messages.getString("Loading___"));
        }
        this.objectPanel.removeAll();
        this.changingThread = new Thread(toRun);
        this.changingThread.start();
    }

    private void updateLoading(final float percentage) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (GalleryViewer.this.isInWebGallery) {
                    GalleryViewer.this.attributeLabel.setText(String.valueOf(Messages.getString("Loading_from_")) + GalleryViewer.this.webGalleryHostName + "..." + String.valueOf((int)(percentage * 100.0f)) + "%");
                } else {
                    GalleryViewer.this.attributeLabel.setText(String.valueOf(Messages.getString("Loading___")) + String.valueOf((int)(percentage * 100.0f)) + "%");
                }
            }
        });
    }

    protected static String cleanUpName(String name) {
        String newName = new String(name);
        if (name.length() > 4 && name.charAt(name.length() - 4) == '.') {
            newName = newName.substring(0, newName.length() - 4);
        }
        return newName;
    }

    public void diplayAttribution(ObjectXmlData o) {
        String displayName;
        String modeledBy = o.getDetail("modeledby");
        String programmedBy = o.getDetail("programmedby");
        String paintedBy = o.getDetail("paintedby");
        String attributeString = displayName = GalleryViewer.cleanUpName(o.name);
        if (modeledBy != null || programmedBy != null || paintedBy != null) {
            attributeString = String.valueOf(attributeString) + ": ";
        }
        boolean haveOne = false;
        if (modeledBy != null) {
            attributeString = String.valueOf(attributeString) + Messages.getString("Modeled_by_") + modeledBy;
            haveOne = true;
        }
        if (paintedBy != null) {
            if (haveOne) {
                attributeString = String.valueOf(attributeString) + ", ";
            }
            attributeString = String.valueOf(attributeString) + Messages.getString("Painted_by_") + paintedBy;
            haveOne = true;
        }
        if (programmedBy != null) {
            if (haveOne) {
                attributeString = String.valueOf(attributeString) + ", ";
            }
            attributeString = String.valueOf(attributeString) + Messages.getString("Programmed_by_") + programmedBy;
        }
        this.attributeLabel.setText(attributeString);
        this.attributePanel.repaint();
    }

    public void removeAttribution() {
        this.attributeLabel.setText(" ");
        this.attributePanel.repaint();
    }

    protected void refreshGUI() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!GalleryViewer.this.stopBuildingGallery) {
                    if (GalleryViewer.this.inBrowseMode) {
                        GalleryViewer.this.createDirectoryButtons();
                        GalleryViewer.this.directoryPanel.revalidate();
                    } else {
                        GalleryViewer.this.searchPanel.revalidate();
                    }
                } else {
                    return;
                }
                GalleryViewer.this.repaint();
                if (GalleryViewer.this.stopBuildingGallery) {
                    return;
                }
                GalleryViewer.this.createGalleryPanels();
                GalleryViewer.this.objectPanel.revalidate();
                GalleryViewer.this.repaint();
                GalleryViewer.this.removeAttribution();
            }
        });
    }

    private void bumpDown(int index) {
    }

    private void resetLayout(int index) {
    }

    private void removeGalleryObject(GalleryObject toRemove) {
        this.objectPanel.remove(toRemove);
        this.resetLayout(0);
    }

    private void modelAdded(ObjectXmlData added, int count) {
        final GalleryObject toAdd = this.createGalleryObject(added);
        if (toAdd != null) {
            ++count;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GalleryViewer.this.objectPanel.add(toAdd);
                    GalleryViewer.this.objectPanel.repaint();
                }
            });
        }
    }

    private void directoryAdded(ObjectXmlData added, final int count) {
        final GalleryObject toAdd = this.createGalleryDirectory(added);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (toAdd != null) {
                    GalleryViewer.this.bumpDown(count);
                    GalleryViewer.this.objectPanel.add(toAdd);
                    GalleryViewer.this.objectPanel.revalidate();
                }
            }
        });
    }

    private GalleryObject getGalleryObject(String objectName) {
        int i = 0;
        while (i < this.objectPanel.getComponentCount()) {
            if (this.objectPanel.getComponent(i) instanceof GalleryObject) {
                GalleryObject current = (GalleryObject)this.objectPanel.getComponent(i);
                if (current.data.name.equals(objectName)) {
                    return current;
                }
            }
            ++i;
        }
        return null;
    }

    private void createGalleryPanels() {
        if (this.directoryOnDisplay == null) {
            this.createRootGalleryPanels();
        } else {
            GalleryObject toAdd;
            long oldTime;
            DirectoryXmlData xmlData = this.directoryOnDisplay.xmlData;
            this.objectPanel.removeAll();
            int count = 0;
            if (xmlData == null || xmlData.directories == null || xmlData.models == null) {
                return;
            }
            int size = xmlData.directories.size() + xmlData.models.size();
            boolean isPeople = false;
            boolean isLocal = false;
            if (xmlData.name.equalsIgnoreCase("people")) {
                size += this.builderButtonsVector.size();
                isPeople = true;
            }
            if (xmlData.name.startsWith(localGalleryName)) {
                ++size;
                isLocal = true;
            }
            int i = 0;
            while (i < xmlData.directories.size()) {
                if (!this.stopBuildingGallery) {
                    ObjectXmlData currentDirectory = (ObjectXmlData)xmlData.directories.get(i);
                    oldTime = System.currentTimeMillis();
                    toAdd = this.createGalleryDirectory(currentDirectory);
                    if (toAdd != null) {
                        this.objectPanel.add(toAdd);
                        ++count;
                    }
                } else {
                    return;
                }
                ++i;
            }
            i = 0;
            while (i < xmlData.models.size()) {
                if (!this.stopBuildingGallery) {
                    ObjectXmlData currentModel = (ObjectXmlData)xmlData.models.get(i);
                    oldTime = System.currentTimeMillis();
                    toAdd = this.createGalleryObject(currentModel);
                    if (toAdd != null) {
                        this.objectPanel.add(toAdd);
                        ++count;
                    }
                } else {
                    return;
                }
                ++i;
            }
            if (isPeople && showBuilder) {
                int p = 0;
                while (p < this.builderButtonsVector.size()) {
                    ++count;
                    GenericBuilderButton builderButton = (GenericBuilderButton)this.builderButtonsVector.get(p);
                    this.objectPanel.add(builderButton);
                    builderButton.updateGUI();
                    ++p;
                }
            }
            if (isLocal) {
                this.bumpDown(++count);
                this.objectPanel.add(this.add3DTextButton);
                this.add3DTextButton.updateGUI();
                this.objectPanel.repaint();
            }
            if (count == 0) {
                this.objectPanel.removeAll();
                if (this.directoryOnDisplay == this.searchResults) {
                    this.objectPanel.add(this.noSearchResults);
                } else {
                    this.objectPanel.add(this.noObjectsLabel);
                }
            }
        }
    }

    private void createRootGalleryPanels() {
        if (this.rootDirectories != null && this.rootDirectories.size() > 0) {
            int count = 0;
            int maxCount = this.rootDirectories.size();
            this.objectPanel.removeAll();
            int i = 0;
            while (i < this.rootDirectories.size()) {
                block11: {
                    if (!this.stopBuildingGallery) {
                        GalleryObject toAdd;
                        block10: {
                            RootDirectoryStructure currentRoot = (RootDirectoryStructure)this.rootDirectories.get(i);
                            toAdd = (GalleryObject)GUIFactory.getGUI(currentRoot.xmlData);
                            try {
                                toAdd.set(currentRoot.xmlData);
                                if (currentRoot.directory.name == cdGalleryName) {
                                    toAdd.setImage(this.cdGalleryIcon);
                                    break block10;
                                }
                                if (currentRoot.directory.name.startsWith(localGalleryName)) {
                                    toAdd.setImage(this.localGalleryIcon);
                                    break block10;
                                }
                                if (currentRoot.directory.name == webGalleryName) {
                                    toAdd.setImage(this.webGalleryIcon);
                                    ((WebGalleryDirectory)toAdd).isTopLevelDirectory = true;
                                    break block10;
                                }
                                if (currentRoot.directory.name != customGalleryName) break block10;
                                toAdd.setImage(this.customGalleryIcon);
                            }
                            catch (Exception e) {
                                toAdd = null;
                                break block11;
                            }
                        }
                        if (toAdd != null) {
                            this.objectPanel.add(toAdd);
                            ++count;
                        }
                    } else {
                        return;
                    }
                }
                ++i;
            }
        }
    }

    protected void goUpOneLevel() {
        if (this.directoryOnDisplay != null) {
            this.changeDirectory(this.directoryOnDisplay.parent);
        }
    }

    private void createDirectoryButtons() {
        DirectoryStructure currentDir = this.directoryOnDisplay;
        Stack<DirectoryStructure> dirs = new Stack<DirectoryStructure>();
        this.directoryPanel.removeAll();
        JLabel currentDirLabel = new JLabel();
        currentDirLabel.setForeground(textColor);
        int count = 0;
        this.upLevelButton.setEnabled(true);
        if (currentDir != null) {
            DirectoryBarButton rootButton = new DirectoryBarButton(null, this);
            this.directoryPanel.add((Component)rootButton, new GridBagConstraints(count, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 3, 0, 3), 0, 0));
            ++count;
            while (currentDir != null) {
                if (this.isInWebGallery && (currentDir.name.startsWith(localGalleryName) || currentDir.name.equals(cdGalleryName))) {
                    if (this.webGallery != null) {
                        dirs.push(this.webGallery.directory);
                        currentDir = this.webGallery.directory.parent;
                        continue;
                    }
                    dirs.push(currentDir);
                    currentDir = currentDir.parent;
                    continue;
                }
                dirs.push(currentDir);
                currentDir = currentDir.parent;
            }
            while (!dirs.empty()) {
                currentDir = (DirectoryStructure)dirs.pop();
                if (count > 0) {
                    JLabel arrow = new JLabel(">");
                    arrow.setForeground(textColor);
                    this.directoryPanel.add((Component)arrow, new GridBagConstraints(count, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 3, 0, 3), 0, 0));
                    ++count;
                }
                if (currentDir == this.directoryOnDisplay) {
                    currentDirLabel.setText(currentDir.name);
                    this.directoryPanel.add((Component)currentDirLabel, new GridBagConstraints(count, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                } else {
                    DirectoryBarButton currentButton = new DirectoryBarButton(currentDir, this);
                    this.directoryPanel.add((Component)currentButton, new GridBagConstraints(count, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
                }
                ++count;
            }
        } else {
            currentDirLabel.setText(homeName);
            this.directoryPanel.add((Component)currentDirLabel, new GridBagConstraints(count, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            ++count;
            this.upLevelButton.setEnabled(false);
            this.upLevelButton.repaint();
        }
        this.directoryPanel.add((Component)this.upLevelButton, new GridBagConstraints(count, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 4, 0, 0), 0, 0));
        this.directoryPanel.add(Box.createHorizontalGlue(), new GridBagConstraints(++count, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void exploreXML(Node current, int level) {
        if (current != null) {
            System.out.println(String.valueOf(level) + ": " + Messages.getString("Name__") + current.getNodeName() + Messages.getString("__Type__") + current.getNodeType() + Messages.getString("__Value__") + current.getNodeValue() + Messages.getString("__Children__"));
            NodeList children = current.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                this.exploreXML(children.item(i), level + 1);
                ++i;
            }
            System.out.println("}");
        }
    }

    protected class AliceCharacterFilter
    implements FileFilter {
        private javax.swing.filechooser.FileFilter filter;

        public void setFilter(javax.swing.filechooser.FileFilter f) {
            this.filter = f;
        }

        @Override
        public boolean accept(File fileToCheck) {
            if (this.filter != null) {
                if (!fileToCheck.isDirectory()) {
                    return this.filter.accept(fileToCheck) || fileToCheck.getName().endsWith(".link");
                }
                return false;
            }
            if (!fileToCheck.isDirectory()) {
                return fileToCheck.getName().endsWith(".a2c") || fileToCheck.getName().endsWith(".link");
            }
            return false;
        }
    }

    protected class DirectoryFilter
    implements FilenameFilter {
        @Override
        public boolean accept(File directory, String name) {
            return name.indexOf(46) == -1;
        }
    }

    protected class DirectoryStructure {
        public String name;
        public DirectoryStructure parent;
        public DirectoryXmlData xmlData;
        public DirectoryStructure firstLocalDirectory = null;
        public DirectoryStructure secondLocalDirectory = null;
        public String path;
        public DirectoryStructure directoryToUse = this;
        public ObjectXmlData data;
        public RootDirectoryStructure rootNode;

        public DirectoryStructure(RootDirectoryStructure root, String name, String path) {
            this.rootNode = root;
            this.parent = null;
            this.name = name;
            this.path = path;
        }

        public boolean equals(Object toCompareTo) {
            if (toCompareTo instanceof DirectoryStructure) {
                DirectoryStructure b = (DirectoryStructure)toCompareTo;
                if (b.name.equals(this.name) && this.data != null && b.data != null) {
                    return this.data.timeStamp == b.data.timeStamp;
                }
            }
            return false;
        }

        public boolean contains(ObjectXmlData toSearchFor) {
            if (this.xmlData != null) {
                int i = 0;
                while (i < this.xmlData.models.size()) {
                    if (((ObjectXmlData)this.xmlData.models.get(i)).equals(toSearchFor)) {
                        return true;
                    }
                    ++i;
                }
                i = 0;
                while (i < this.xmlData.directories.size()) {
                    if (((ObjectXmlData)this.xmlData.directories.get(i)).equals(toSearchFor)) {
                        return true;
                    }
                    ++i;
                }
            }
            return false;
        }

        public Vector getObjectMatches(String searchString) {
            Vector toReturn = null;
            if (this.xmlData != null) {
                toReturn = new Vector();
                int i = 0;
                while (i < this.xmlData.models.size()) {
                    if (((ObjectXmlData)this.xmlData.models.get(i)).matches(searchString)) {
                        toReturn.add(this.xmlData.models.get(i));
                    }
                    if (GalleryViewer.this.stopSearch) break;
                    ++i;
                }
            }
            return toReturn;
        }

        public ObjectXmlData getObjectNamed(String toSearchFor) {
            if (this.xmlData != null) {
                String currentName;
                int i = 0;
                while (i < this.xmlData.models.size()) {
                    currentName = ((ObjectXmlData)this.xmlData.models.get((int)i)).name;
                    if (currentName.equals(toSearchFor)) {
                        return (ObjectXmlData)this.xmlData.models.get(i);
                    }
                    ++i;
                }
                i = 0;
                while (i < this.xmlData.directories.size()) {
                    currentName = ((ObjectXmlData)this.xmlData.directories.get((int)i)).name;
                    if (currentName.equals(toSearchFor)) {
                        return (ObjectXmlData)this.xmlData.directories.get(i);
                    }
                    ++i;
                }
            }
            return null;
        }

        public ObjectXmlData getObjectFileNamed(String toSearchFor) {
            if (this.xmlData != null) {
                String currentName;
                int i = 0;
                while (i < this.xmlData.models.size()) {
                    currentName = String.valueOf(((ObjectXmlData)this.xmlData.models.get((int)i)).parentDirectory.rootNode.rootPath) + ((ObjectXmlData)this.xmlData.models.get((int)i)).objectFilename;
                    if (currentName.equals(toSearchFor)) {
                        return (ObjectXmlData)this.xmlData.models.get(i);
                    }
                    ++i;
                }
                i = 0;
                while (i < this.xmlData.directories.size()) {
                    currentName = String.valueOf(((ObjectXmlData)this.xmlData.directories.get((int)i)).parentDirectory.rootNode.rootPath) + ((ObjectXmlData)this.xmlData.directories.get((int)i)).objectFilename;
                    if (currentName.equals(toSearchFor)) {
                        return (ObjectXmlData)this.xmlData.directories.get(i);
                    }
                    ++i;
                }
            }
            return null;
        }

        public ObjectXmlData getModel(Transferable t) {
            if (this.xmlData != null) {
                int i = 0;
                while (i < this.xmlData.models.size()) {
                    if (t == ((ObjectXmlData)this.xmlData.models.get((int)i)).transferable) {
                        return (ObjectXmlData)this.xmlData.models.get(i);
                    }
                    ++i;
                }
            }
            return null;
        }

        public DirectoryStructure getDirectoryNamed(String toSearchFor) {
            if (this.xmlData != null) {
                return this.xmlData.getDirectoryNamed(toSearchFor);
            }
            return null;
        }

        public ObjectXmlData getDirectoryXMLNamed(String toSearchFor) {
            if (this.xmlData != null) {
                return this.xmlData.getDirectoryXMLNamed(toSearchFor);
            }
            return null;
        }

        public String getGUIPath() {
            DirectoryStructure parentDir = this.parent;
            String toReturn = new String(this.name);
            while (parentDir != null) {
                toReturn = String.valueOf(parentDir.name) + File.separator + toReturn;
                parentDir = parentDir.parent;
            }
            toReturn = String.valueOf(homeName) + File.separator + toReturn;
            return toReturn;
        }

        public DirectoryStructure getDirectory(int i) {
            if (this.xmlData != null) {
                return this.xmlData.getDirectory(i);
            }
            return null;
        }

        private DirectoryStructure initDirStructure(ObjectXmlData currentDirData) {
            if (currentDirData == null) {
                return null;
            }
            currentDirData.parentDirectory = this;
            DirectoryStructure currentDir = new DirectoryStructure(this.rootNode, currentDirData.name, currentDirData.objectFilename);
            if (this.firstLocalDirectory != null) {
                currentDir.firstLocalDirectory = this.firstLocalDirectory.getDirectoryNamed(currentDirData.name);
                currentDir.equals(currentDir.firstLocalDirectory);
            }
            if (this.secondLocalDirectory != null) {
                currentDir.secondLocalDirectory = this.secondLocalDirectory.getDirectoryNamed(currentDirData.name);
                if (currentDir.equals(currentDir.secondLocalDirectory)) {
                    DirectoryStructure cfr_ignored_0 = currentDir.directoryToUse;
                }
            }
            currentDir.data = currentDirData;
            currentDirData.directoryData = currentDir;
            currentDir.parent = this;
            return currentDir;
        }

        private ObjectXmlData createObjectFromZip(File zipFileSource, DocumentBuilder builder) {
            ZipFile zipFile = null;
            try {
                zipFile = new ZipFile(zipFileSource);
            }
            catch (Exception e) {
                return null;
            }
            String xml = GalleryViewer.this.getXML(zipFile);
            ObjectXmlData currentModelData = null;
            if (xml != null && xml != "") {
                Element xmlRoot;
                ByteArrayInputStream bais = new ByteArrayInputStream(xml.getBytes());
                try {
                    Document document = builder.parse(bais);
                    xmlRoot = document.getDocumentElement();
                }
                catch (IOException e) {
                    return null;
                }
                catch (IllegalArgumentException e) {
                    return null;
                }
                catch (SAXException e) {
                    return null;
                }
                NodeList xmlModels = xmlRoot.getElementsByTagName("model");
                Node currentModel = null;
                currentModel = xmlModels.getLength() < 1 ? xmlRoot : xmlModels.item(0);
                currentModelData = GalleryViewer.this.createObjectXmlData(currentModel, this.rootNode.rootPath, this.rootNode.type);
            }
            if (currentModelData == null) {
                currentModelData = GalleryViewer.this.createObjectXmlData(zipFileSource, this.rootNode.rootPath, this.rootNode.type);
            } else {
                String relativeFilename = GalleryViewer.this.getRelativeDirectory(this.rootNode.rootPath, zipFileSource.getAbsolutePath(), File.separator);
                currentModelData.imageFilename = currentModelData.objectFilename = String.valueOf(relativeFilename) + zipFileSource.getName();
            }
            currentModelData.size = (int)((double)zipFileSource.length() / 1000.0);
            currentModelData.timeStamp = zipFileSource.lastModified();
            currentModelData.transferable = GalleryViewer.this.createFileTransferable(zipFileSource.getAbsolutePath());
            return currentModelData;
        }

        private void removeMissing(Vector toSearch) {
            int count = 0;
            while (count < toSearch.size()) {
                ObjectXmlData current = (ObjectXmlData)toSearch.get(count);
                if (!current.isThere) {
                    toSearch.remove(count);
                    continue;
                }
                ++count;
            }
            int i = 0;
            while (i < toSearch.size()) {
                ((ObjectXmlData)toSearch.get((int)i)).isThere = false;
                ++i;
            }
        }

        protected String getLinkPath(File linkFile) {
            try {
                BufferedReader fileReader = new BufferedReader(new FileReader(linkFile));
                char[] b = new char[1000];
                int numRead = fileReader.read(b);
                String content = new String(b, 0, numRead);
                while (numRead != -1) {
                    numRead = fileReader.read(b);
                    if (numRead == -1) continue;
                    String newContent = new String(b, 0, numRead);
                    content = String.valueOf(content) + newContent;
                }
                String toReturn = String.valueOf(this.rootNode.rootPath) + GalleryViewer.this.makeRelativePathReady(content);
                return toReturn;
            }
            catch (Exception exception) {
                return null;
            }
        }

        public int updateSelf(File dirFile) throws IOException, IllegalArgumentException, SAXException, ParserConfigurationException {
            int total;
            if (dirFile == null || !dirFile.isDirectory() || !dirFile.canRead()) {
                return -1;
            }
            File[] modelsInDir = dirFile.listFiles(GalleryViewer.this.characterFilter);
            File[] dirsInDir = dirFile.listFiles(GalleryViewer.this.directoryFilter);
            GalleryViewer.this.glueConstraints.gridx = total = modelsInDir.length + dirsInDir.length;
            int count = 0;
            int dirIndex = 0;
            while (dirIndex < dirsInDir.length) {
                if (GalleryViewer.this.stopBuildingGallery) {
                    return -1;
                }
                ObjectXmlData currentDirData = this.getObjectFileNamed(dirsInDir[dirIndex].getAbsolutePath());
                if (currentDirData == null) {
                    currentDirData = GalleryViewer.this.createDirectoryObjectXmlData(dirsInDir[dirIndex], this.rootNode.rootPath, this.rootNode.type);
                    DirectoryStructure currentDir = this.initDirStructure(currentDirData);
                    if (currentDir != null && currentDirData != null) {
                        this.xmlData.addDirectory(currentDir.directoryToUse.data, dirIndex);
                        if (GalleryViewer.this.updatePanelsWhileLoading) {
                            GalleryViewer.this.directoryAdded(currentDir.directoryToUse.data, count);
                            GalleryViewer.this.updateLoading((float)count / (float)total);
                        }
                    }
                } else {
                    ++count;
                }
                if (currentDirData != null) {
                    currentDirData.isThere = true;
                }
                ++dirIndex;
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = null;
            try {
                builder = factory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                return count;
            }
            int i = 0;
            while (i < modelsInDir.length) {
                if (GalleryViewer.this.stopBuildingGallery) {
                    return -1;
                }
                String absolutePath = modelsInDir[i].getAbsolutePath();
                File toAdd = modelsInDir[i];
                if (modelsInDir[i].getAbsolutePath().endsWith(".link") && (absolutePath = this.getLinkPath(modelsInDir[i])) != null) {
                    toAdd = new File(absolutePath);
                }
                if (absolutePath != null) {
                    ObjectXmlData currentModelData = this.getObjectFileNamed(absolutePath);
                    if (currentModelData == null) {
                        currentModelData = this.createObjectFromZip(toAdd, builder);
                        if (currentModelData != null) {
                            ++count;
                            currentModelData.parentDirectory = this;
                            this.xmlData.addModel(currentModelData, i);
                            if (GalleryViewer.this.updatePanelsWhileLoading) {
                                GalleryViewer.this.modelAdded(currentModelData, count);
                                GalleryViewer.this.updateLoading((float)count / (float)total);
                            }
                        }
                    } else {
                        ++count;
                    }
                    if (currentModelData != null) {
                        currentModelData.isThere = true;
                    }
                }
                ++i;
            }
            if (showBuilder && this.name.equalsIgnoreCase("people") && GalleryViewer.this.updatePanelsWhileLoading && GalleryViewer.this.directoryOnDisplay != GalleryViewer.this.searchResults) {
                int p = 0;
                while (p < GalleryViewer.this.builderButtonsVector.size()) {
                    final GenericBuilderButton builderButton = (GenericBuilderButton)GalleryViewer.this.builderButtonsVector.get(p);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ((DirectoryStructure)DirectoryStructure.this).GalleryViewer.this.objectPanel.add(builderButton);
                            builderButton.updateGUI();
                            ((DirectoryStructure)DirectoryStructure.this).GalleryViewer.this.objectPanel.repaint();
                        }
                    });
                    ++p;
                }
            }
            if (this.name.startsWith(localGalleryName)) {
                ++count;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ((DirectoryStructure)DirectoryStructure.this).GalleryViewer.this.objectPanel.add(((DirectoryStructure)DirectoryStructure.this).GalleryViewer.this.add3DTextButton);
                        ((DirectoryStructure)DirectoryStructure.this).GalleryViewer.this.add3DTextButton.updateGUI();
                        ((DirectoryStructure)DirectoryStructure.this).GalleryViewer.this.objectPanel.repaint();
                    }
                });
            }
            this.removeMissing(this.xmlData.directories);
            this.removeMissing(this.xmlData.models);
            return count;
        }

        public int initSelf(File dirFile) throws IOException, IllegalArgumentException, SAXException, ParserConfigurationException {
            int total;
            if (dirFile == null || !dirFile.isDirectory() || !dirFile.canRead()) {
                return -1;
            }
            this.xmlData = new DirectoryXmlData(this.name);
            File[] modelsInDir = dirFile.listFiles(GalleryViewer.this.characterFilter);
            File[] dirsInDir = dirFile.listFiles(GalleryViewer.this.directoryFilter);
            GalleryViewer.this.glueConstraints.gridx = total = modelsInDir.length + dirsInDir.length;
            int count = 0;
            int i = 0;
            while (i < dirsInDir.length) {
                if (GalleryViewer.this.stopBuildingGallery) {
                    this.xmlData = null;
                    return -1;
                }
                ++count;
                ObjectXmlData currentDirData = GalleryViewer.this.createDirectoryObjectXmlData(dirsInDir[i], this.rootNode.rootPath, this.rootNode.type);
                DirectoryStructure currentDir = this.initDirStructure(currentDirData);
                if (currentDir != null && currentDirData != null) {
                    this.xmlData.addDirectory(currentDir.directoryToUse.data);
                    if (GalleryViewer.this.updatePanelsWhileLoading) {
                        GalleryViewer.this.directoryAdded(currentDir.directoryToUse.data, count);
                        GalleryViewer.this.updateLoading((float)count / (float)total);
                    }
                }
                ++i;
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = null;
            try {
                builder = factory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                return count;
            }
            int i2 = 0;
            while (i2 < modelsInDir.length) {
                ObjectXmlData currentModelData;
                String absolutePath;
                if (GalleryViewer.this.stopBuildingGallery) {
                    this.xmlData = null;
                    return -1;
                }
                File toAdd = modelsInDir[i2];
                if (modelsInDir[i2].getAbsolutePath().endsWith(".link") && (absolutePath = this.getLinkPath(modelsInDir[i2])) != null) {
                    toAdd = new File(absolutePath);
                }
                if ((currentModelData = this.createObjectFromZip(toAdd, builder)) != null) {
                    ++count;
                    currentModelData.parentDirectory = this;
                    this.xmlData.addModel(currentModelData);
                    if (GalleryViewer.this.updatePanelsWhileLoading) {
                        GalleryViewer.this.modelAdded(currentModelData, count);
                        GalleryViewer.this.updateLoading((float)count / (float)total);
                    }
                }
                ++i2;
            }
            if (showBuilder && this.name.equalsIgnoreCase("people") && GalleryViewer.this.updatePanelsWhileLoading && GalleryViewer.this.directoryOnDisplay != GalleryViewer.this.searchResults) {
                int p = 0;
                while (p < GalleryViewer.this.builderButtonsVector.size()) {
                    ++count;
                    final GenericBuilderButton builderButton = (GenericBuilderButton)GalleryViewer.this.builderButtonsVector.get(p);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ((DirectoryStructure)DirectoryStructure.this).GalleryViewer.this.objectPanel.add(builderButton);
                            builderButton.updateGUI();
                            ((DirectoryStructure)DirectoryStructure.this).GalleryViewer.this.objectPanel.repaint();
                        }
                    });
                    ++p;
                }
            }
            if (this.name.startsWith(localGalleryName)) {
                ++count;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ((DirectoryStructure)DirectoryStructure.this).GalleryViewer.this.objectPanel.add(((DirectoryStructure)DirectoryStructure.this).GalleryViewer.this.add3DTextButton);
                        ((DirectoryStructure)DirectoryStructure.this).GalleryViewer.this.add3DTextButton.updateGUI();
                        ((DirectoryStructure)DirectoryStructure.this).GalleryViewer.this.objectPanel.repaint();
                    }
                });
            }
            if (count == 0) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ((DirectoryStructure)DirectoryStructure.this).GalleryViewer.this.objectPanel.removeAll();
                        ((DirectoryStructure)DirectoryStructure.this).GalleryViewer.this.objectPanel.add(((DirectoryStructure)DirectoryStructure.this).GalleryViewer.this.noObjectsLabel);
                    }
                });
            }
            return count;
        }

        public int initSelf(String xml) throws IOException, IllegalArgumentException, SAXException, ParserConfigurationException {
            int total;
            Element xmlRoot;
            if (xml == null) {
                return -1;
            }
            this.xmlData = new DirectoryXmlData(this.name);
            this.xmlData.name = this.name;
            ByteArrayInputStream bais = new ByteArrayInputStream(xml.getBytes());
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            try {
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document document = builder.parse(bais);
                bais.close();
                xmlRoot = document.getDocumentElement();
            }
            catch (ParserConfigurationException e) {
                throw e;
            }
            catch (IOException e) {
                throw e;
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (SAXException e) {
                throw e;
            }
            NodeList xmlDirectories = xmlRoot.getElementsByTagName("directory");
            NodeList xmlModels = xmlRoot.getElementsByTagName("model");
            GalleryViewer.this.glueConstraints.gridx = total = xmlDirectories.getLength() + xmlModels.getLength();
            int count = 0;
            int i = 0;
            while (i < xmlDirectories.getLength()) {
                if (GalleryViewer.this.stopBuildingGallery) {
                    this.xmlData = null;
                    return -1;
                }
                ++count;
                Node currentDirectory = xmlDirectories.item(i);
                ObjectXmlData currentDirData = GalleryViewer.this.createObjectXmlData(currentDirectory, this.rootNode.rootPath, this.rootNode.type);
                if (currentDirData != null) {
                    currentDirData.parentDirectory = this;
                    DirectoryStructure currentDir = new DirectoryStructure(this.rootNode, currentDirData.name, currentDirData.objectFilename);
                    if (this.firstLocalDirectory != null) {
                        currentDir.firstLocalDirectory = this.firstLocalDirectory.getDirectoryNamed(currentDirData.name);
                        currentDir.equals(currentDir.firstLocalDirectory);
                    }
                    if (this.secondLocalDirectory != null) {
                        currentDir.secondLocalDirectory = this.secondLocalDirectory.getDirectoryNamed(currentDirData.name);
                        if (currentDir.equals(currentDir.secondLocalDirectory)) {
                            DirectoryStructure cfr_ignored_0 = currentDir.directoryToUse;
                        }
                    }
                    currentDir.data = currentDirData;
                    currentDirData.directoryData = currentDir;
                    currentDir.parent = this;
                    if (currentDir != null && currentDirData != null) {
                        this.xmlData.addDirectory(currentDir.directoryToUse.data);
                        if (GalleryViewer.this.updatePanelsWhileLoading) {
                            GalleryViewer.this.directoryAdded(currentDir.directoryToUse.data, count);
                            GalleryViewer.this.updateLoading((float)count / (float)total);
                        }
                    }
                }
                ++i;
            }
            i = 0;
            while (i < xmlModels.getLength()) {
                if (GalleryViewer.this.stopBuildingGallery) {
                    this.xmlData = null;
                    return -1;
                }
                ++count;
                Node currentModel = xmlModels.item(i);
                ObjectXmlData currentModelData = GalleryViewer.this.createObjectXmlData(currentModel, this.rootNode.rootPath, this.rootNode.type);
                if (currentModelData != null) {
                    currentModelData.parentDirectory = this;
                    this.xmlData.addModel(currentModelData);
                    if (GalleryViewer.this.updatePanelsWhileLoading) {
                        GalleryViewer.this.modelAdded(currentModelData, count);
                        GalleryViewer.this.updateLoading((float)count / (float)total);
                    }
                }
                ++i;
            }
            return count;
        }
    }

    protected class DirectoryXmlData {
        public Vector directories = new Vector();
        public Vector models = new Vector();
        public String name = "directory";

        public DirectoryXmlData(String name) {
            this.name = name;
        }

        public void addDirectory(ObjectXmlData dir) {
            int i = 0;
            while (i < this.directories.size()) {
                ObjectXmlData current = (ObjectXmlData)this.directories.get(i);
                if (current.equals(dir)) {
                    return;
                }
                ++i;
            }
            this.directories.add(dir);
        }

        public void addDirectory(ObjectXmlData dir, int index) {
            int i = 0;
            while (i < this.directories.size()) {
                ObjectXmlData current = (ObjectXmlData)this.directories.get(i);
                if (current.equals(dir)) {
                    return;
                }
                ++i;
            }
            this.directories.insertElementAt(dir, index);
        }

        public void addModel(ObjectXmlData model) {
            int i = 0;
            while (i < this.models.size()) {
                ObjectXmlData current = (ObjectXmlData)this.models.get(i);
                if (current.equals(model)) {
                    return;
                }
                ++i;
            }
            this.models.add(model);
        }

        public void addModel(ObjectXmlData model, int index) {
            int i = 0;
            while (i < this.models.size()) {
                ObjectXmlData current = (ObjectXmlData)this.models.get(i);
                if (current.equals(model)) {
                    return;
                }
                ++i;
            }
            if (index > -1 && index <= this.models.size()) {
                this.models.insertElementAt(model, index);
            } else {
                this.models.add(model);
            }
        }

        public ObjectXmlData getModel(ObjectXmlData toGet) {
            int i = 0;
            while (i < this.models.size()) {
                ObjectXmlData current = (ObjectXmlData)this.models.get(i);
                if (current.equals(toGet)) {
                    return current;
                }
                ++i;
            }
            return null;
        }

        public DirectoryStructure getDirectory(int i) {
            if (this.directories != null) {
                return ((ObjectXmlData)this.directories.get((int)i)).directoryData;
            }
            return null;
        }

        public ObjectXmlData getDirectory(ObjectXmlData toGet) {
            int i = 0;
            while (i < this.directories.size()) {
                ObjectXmlData current = (ObjectXmlData)this.directories.get(i);
                if (current.equals(toGet)) {
                    return current;
                }
                ++i;
            }
            return null;
        }

        public DirectoryStructure getDirectoryNamed(String toSearchFor) {
            if (this.directories != null) {
                int i = 0;
                while (i < this.directories.size()) {
                    String currentName = ((ObjectXmlData)this.directories.get((int)i)).name;
                    if (currentName.equals(toSearchFor)) {
                        return ((ObjectXmlData)this.directories.get((int)i)).directoryData;
                    }
                    ++i;
                }
            }
            return null;
        }

        public ObjectXmlData getDirectoryXMLNamed(String toSearchFor) {
            if (this.directories != null) {
                int i = 0;
                while (i < this.directories.size()) {
                    String currentName = ((ObjectXmlData)this.directories.get((int)i)).name;
                    if (currentName.equals(toSearchFor)) {
                        return (ObjectXmlData)this.directories.get(i);
                    }
                    ++i;
                }
            }
            return null;
        }
    }

    public class ObjectXmlData {
        public String name;
        public int size = -1;
        public Vector3d dimensions = new Vector3d();
        public String objectFilename = null;
        public String imageFilename = null;
        public Vector details = new Vector();
        public Transferable transferable;
        public int type;
        public GalleryViewer mainViewer;
        public DirectoryStructure directoryData = null;
        public DirectoryStructure parentDirectory = null;
        public long timeStamp = 1L;
        public boolean isThere = false;

        public boolean equals(Object toCheck) {
            if (toCheck instanceof ObjectXmlData) {
                ObjectXmlData b = (ObjectXmlData)toCheck;
                boolean toReturn = b.size == this.size && b.name.equals(this.name) && b.timeStamp == this.timeStamp;
                return toReturn;
            }
            return false;
        }

        public boolean matches(String toSearch) {
            StringTokenizer tokenizer = new StringTokenizer(toSearch.toUpperCase(), " ");
            while (tokenizer.hasMoreTokens()) {
                String current = tokenizer.nextToken();
                if (this.name.toUpperCase().indexOf(current) <= -1) continue;
                return true;
            }
            return false;
        }

        public void setDimensions(String dimensionString) {
            StringTokenizer tokenizer = new StringTokenizer(dimensionString, "x");
            String length = "";
            String width = "";
            String depth = "";
            if (tokenizer.hasMoreTokens()) {
                length = tokenizer.nextToken();
                while (length.endsWith("m") || length.endsWith(" ") || length.endsWith("M")) {
                    length = length.substring(0, length.length() - 1);
                }
            }
            if (tokenizer.hasMoreTokens()) {
                width = tokenizer.nextToken();
                while (width.endsWith("m") || width.endsWith(" ") || width.endsWith("M")) {
                    width = width.substring(0, width.length() - 1);
                }
            }
            if (tokenizer.hasMoreTokens()) {
                depth = tokenizer.nextToken();
                while (depth.endsWith("m") || depth.endsWith(" ") || depth.endsWith("M")) {
                    depth = depth.substring(0, depth.length() - 1);
                }
            }
            try {
                double lengthVal = Double.parseDouble(length);
                double widthVal = Double.parseDouble(width);
                double depthVal = Double.parseDouble(depth);
                this.dimensions.set(lengthVal, widthVal, depthVal);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void setSize(String sizeString) {
            char suffix = sizeString.charAt(sizeString.length() - 1);
            if (suffix == 'm' || suffix == 'M') {
                try {
                    float megSize = Float.parseFloat(sizeString.substring(0, sizeString.length() - 1));
                    this.size = (int)(megSize * 1000.0f);
                }
                catch (NumberFormatException e) {
                    this.size = -1;
                }
            } else if (sizeString.endsWith("mb") || sizeString.endsWith("Mb") || sizeString.endsWith("MB") || sizeString.endsWith("mB")) {
                try {
                    float megSize = Float.parseFloat(sizeString.substring(0, sizeString.length() - 2));
                    this.size = (int)(megSize * 1000.0f);
                }
                catch (NumberFormatException e) {
                    this.size = -1;
                }
            } else if (sizeString.endsWith("kb") || sizeString.endsWith("Kb") || sizeString.endsWith("KB") || sizeString.endsWith("kB")) {
                try {
                    this.size = (int)Float.parseFloat(sizeString.substring(0, sizeString.length() - 2));
                }
                catch (NumberFormatException e) {
                    this.size = -1;
                }
            } else if (suffix == 'k' || suffix == 'K') {
                try {
                    this.size = (int)Float.parseFloat(sizeString.substring(0, sizeString.length() - 1));
                }
                catch (NumberFormatException e) {
                    this.size = -1;
                }
            } else {
                try {
                    this.size = (int)Float.parseFloat(sizeString);
                }
                catch (NumberFormatException e) {
                    this.size = -1;
                }
            }
        }

        public void incrementName() {
        }

        public void addDetail(String detailName, Object detailValue) {
            this.details.add(new StringObjectPair(detailName, detailValue));
        }

        public String getDetail(String toGet) {
            int i = 0;
            while (i < this.details.size()) {
                StringObjectPair current = (StringObjectPair)this.details.get(i);
                if (current.getString().equalsIgnoreCase(toGet)) {
                    if (current.getObject() instanceof String) {
                        return (String)current.getObject();
                    }
                    String toReturn = "";
                    if (current.getObject() instanceof Vector) {
                        Vector allDetails = (Vector)current.getObject();
                        int j = 0;
                        while (j < allDetails.size()) {
                            String currentDetail = allDetails.get(j).toString();
                            if (j < allDetails.size() - 1) {
                                currentDetail = String.valueOf(currentDetail) + ", ";
                            }
                            toReturn = String.valueOf(toReturn) + currentDetail;
                            ++j;
                        }
                        return toReturn;
                    }
                }
                ++i;
            }
            return null;
        }
    }

    protected class RootDirectoryStructure {
        public String rootPath;
        public int type;
        public DirectoryStructure directory;
        public ObjectXmlData xmlData;

        public RootDirectoryStructure(String rootPath, int type, DirectoryStructure directory, ObjectXmlData xmlData) {
            this.xmlData = xmlData;
            this.rootPath = rootPath;
            this.type = type;
            this.directory = directory;
        }

        public ObjectXmlData getObject(String toGet) {
            toGet.indexOf(this.rootPath);
            return null;
        }
    }

    protected class SearchingLabel
    extends JLabel {
        protected String doneString = Messages.getString("Ready_to_search");
        protected String searchingString1 = Messages.getString("Searching");
        protected String searchingString2 = Messages.getString("Searching__");
        protected String searchingString3 = Messages.getString("Searching____");
        protected String searchingString4 = Messages.getString("Searching______");
        protected int state = 0;

        public SearchingLabel() {
            this.setText(this.doneString);
            this.setFont(new Font("Dialog", 1, 18));
            this.setForeground(Color.white);
        }

        public void advance() {
            this.state = (this.state + 1) % 4;
            switch (this.state) {
                case 0: {
                    this.setText(this.searchingString1);
                    break;
                }
                case 1: {
                    this.setText(this.searchingString2);
                    break;
                }
                case 2: {
                    this.setText(this.searchingString3);
                    break;
                }
                case 3: {
                    this.setText(this.searchingString4);
                }
            }
            this.repaint();
        }

        public void reset() {
            this.setText(this.doneString);
            this.repaint();
        }
    }

    protected class ThumbnailFilter
    implements FilenameFilter {
        @Override
        public boolean accept(File directory, String name) {
            return name.equalsIgnoreCase("directoryThumbnail.png");
        }
    }
}

