/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.galleryviewer;

import edu.cmu.cs.stage3.alice.authoringtool.galleryviewer.GalleryViewer;
import edu.cmu.cs.stage3.alice.authoringtool.util.CustomMouseAdapter;
import edu.cmu.cs.stage3.alice.authoringtool.util.DnDGroupingPanel;
import edu.cmu.cs.stage3.alice.authoringtool.util.GUIElement;
import edu.cmu.cs.stage3.image.ImageIO;
import edu.cmu.cs.stage3.lang.Messages;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseEvent;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.vecmath.Vector3d;

public abstract class GalleryObject
extends DnDGroupingPanel
implements GUIElement {
    protected GalleryViewer.ObjectXmlData data;
    protected JLabel nameLabel;
    protected JLabel classLabel;
    protected JLabel imageLabel;
    protected JLabel sizeLabel;
    protected JLabel locationLabel;
    protected JPanel containingPanel;
    protected ImageIcon image;
    protected GalleryViewer mainViewer;
    protected String displayName;
    protected String location;
    protected boolean hasAttribution = true;
    protected String rootPath;
    protected GalleryMouseAdapter mouseAdapter = new GalleryMouseAdapter();
    protected static final Color HIGHLITE = new Color(255, 255, 255);
    protected static final Color BACKGROUND = new Color(128, 128, 128);
    protected static final Color FASTEST_COLOR = new Color(0, 255, 0);
    protected static final Color MIDDLE_COLOR = new Color(255, 255, 0);
    protected static final Color SLOWEST_COLOR = new Color(255, 0, 0);
    protected static final int FASTEST_SIZE = 0;
    protected static final int SLOWEST_SIZE = 1000;
    protected Color sizeColor;
    protected boolean mouseOver = false;
    protected Transferable transferable;

    protected String getToolTipString() {
        return "";
    }

    @Override
    public void setToolTipText(String text) {
        super.setToolTipText(text);
        this.containingPanel.setToolTipText(text);
        this.grip.setToolTipText(text);
    }

    public GalleryObject() {
        this.guiInit();
    }

    public Vector3d getBoundingBox() {
        return this.data.dimensions;
    }

    @Override
    public Image getImage() {
        return super.getImage();
    }

    public String getUniqueIdentifier() {
        int index;
        String root = "";
        String path = GalleryViewer.reverseWebReady(this.data.objectFilename.replace(':', '_'));
        if (this.data.type == 2) {
            root = GalleryViewer.webGalleryName;
        }
        if (this.data.type == 3) {
            root = GalleryViewer.cdGalleryName;
        }
        if (this.data.type == 1) {
            root = GalleryViewer.localGalleryName;
        }
        if ((index = path.lastIndexOf(".xml")) > -1 && index < path.length()) {
            int dirIndex = path.lastIndexOf(File.separator);
            path = dirIndex > -1 && dirIndex < path.length() ? path.substring(0, dirIndex) : "";
        }
        if (path != "") {
            path = String.valueOf(File.separator) + path;
        }
        String toReturn = String.valueOf(root) + path;
        return toReturn;
    }

    public void set(GalleryViewer.ObjectXmlData dataIn) throws IllegalArgumentException {
        if (dataIn != null) {
            this.clean();
            this.data = dataIn;
            this.mainViewer = this.data.mainViewer;
            if (this.data.transferable != null) {
                this.setTransferable(this.data.transferable);
            }
            if (this.data.directoryData != null) {
                this.rootPath = this.data.directoryData.rootNode.rootPath;
            } else if (this.data.parentDirectory != null) {
                this.rootPath = this.data.parentDirectory.rootNode.rootPath;
            }
            this.displayName = GalleryViewer.cleanUpName(dataIn.name);
            this.updateGUI();
            String t = dataIn.objectFilename;
            if (t.endsWith(".a2c")) {
                this.setToolTipText(this.getToolTipString().replace("</body>", "<p>" + t + "</p></body>"));
            }
            this.wakeUp();
        } else {
            this.clean();
            this.data = null;
            this.mainViewer = null;
        }
    }

    @Override
    public void goToSleep() {
        this.removeMouseListener(this.mouseAdapter);
        this.containingPanel.removeMouseListener(this.mouseAdapter);
        this.grip.removeMouseListener(this.mouseAdapter);
        this.removeDragSourceComponent(this.containingPanel);
    }

    @Override
    public void wakeUp() {
        this.addMouseListener(this.mouseAdapter);
        this.containingPanel.addMouseListener(this.mouseAdapter);
        this.grip.addMouseListener(this.mouseAdapter);
        this.addDragSourceComponent(this.containingPanel);
    }

    @Override
    public void clean() {
        this.goToSleep();
        this.data = null;
        this.nameLabel.setText(null);
        this.classLabel.setText(null);
        this.imageLabel.setIcon(null);
        this.imageLabel.setText(null);
        this.sizeLabel.setText(null);
        this.image = null;
        this.mainViewer = null;
    }

    @Override
    public void die() {
        this.clean();
    }

    public abstract void loadImage();

    public static Image retrieveImage(String root, String filename, long timestamp) {
        return null;
    }

    protected void setGalleryViewer(GalleryViewer viewer) {
        this.mainViewer = viewer;
    }

    public void setImage(ImageIcon imageIcon) {
        this.image = imageIcon;
        this.imageLabel.setText(null);
        this.imageLabel.setIcon(this.image);
        this.revalidate();
        this.repaint();
    }

    protected String getClassName() {
        return "Class";
    }

    public static void storeThumbnail(String thumbFilename, Image toStore, long timeStamp) {
        if (toStore != null) {
            String codec = "png";
            File thumbFile = GalleryViewer.createFile(thumbFilename);
            if (thumbFile != null) {
                try {
                    FileOutputStream fos = new FileOutputStream(thumbFile);
                    BufferedOutputStream bos = new BufferedOutputStream(fos);
                    DataOutputStream dos = new DataOutputStream(bos);
                    ImageIO.store(codec, dos, toStore);
                    dos.flush();
                    fos.close();
                    thumbFile.setLastModified(timeStamp);
                }
                catch (InterruptedException interruptedException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    protected Color interpolateColor(int point, int low, int high, Color lowColor, Color highColor) {
        int newB;
        int newG;
        float dLow = (float)(point - low) / (float)(high - low);
        float dHigh = (float)(high - point) / (float)(high - low);
        int newR = (int)((float)highColor.getRed() * dLow) + (int)((float)lowColor.getRed() * dHigh);
        if (newR > 255) {
            newR = 255;
        }
        if ((newG = (int)((float)highColor.getGreen() * dLow) + (int)((float)lowColor.getGreen() * dHigh)) > 255) {
            newG = 255;
        }
        if ((newB = (int)((float)highColor.getBlue() * dLow) + (int)((float)lowColor.getBlue() * dHigh)) > 255) {
            newB = 255;
        }
        return new Color(newR, newG, newB);
    }

    protected Color getSizeColor(int toScale) {
        if (toScale > 1000) {
            return SLOWEST_COLOR;
        }
        if (toScale < 0) {
            return FASTEST_COLOR;
        }
        int middle = 500;
        if (toScale <= middle) {
            return this.interpolateColor(toScale, 0, middle, FASTEST_COLOR, MIDDLE_COLOR);
        }
        return this.interpolateColor(toScale, middle, 1000, MIDDLE_COLOR, SLOWEST_COLOR);
    }

    protected void guiInit() {
        this.setBackground(BACKGROUND);
        this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.containingPanel = new JPanel();
        this.containingPanel.setLayout(new GridBagLayout());
        this.containingPanel.setBorder(null);
        this.containingPanel.setOpaque(false);
        this.nameLabel = new JLabel();
        this.nameLabel.setForeground(GalleryViewer.textColor);
        this.nameLabel.setOpaque(false);
        this.classLabel = new JLabel();
        this.classLabel.setForeground(GalleryViewer.textColor);
        this.classLabel.setOpaque(false);
        this.classLabel.setText(this.getClassName());
        this.imageLabel = new JLabel();
        this.imageLabel.setOpaque(false);
        this.sizeLabel = new JLabel();
        this.sizeLabel.setOpaque(false);
        this.locationLabel = new JLabel();
        this.locationLabel.setForeground(GalleryViewer.textColor);
        this.locationLabel.setOpaque(false);
        this.image = new ImageIcon();
        this.add((Component)this.containingPanel, "Center");
    }

    public static String getDisplayName(String toDisplay) {
        String displayNameToReturn = new String(toDisplay);
        if (Character.isLowerCase(displayNameToReturn.charAt(0))) {
            displayNameToReturn = String.valueOf(Character.toUpperCase(displayNameToReturn.charAt(0))) + displayNameToReturn.substring(1);
        }
        return displayNameToReturn;
    }

    protected void updateGUI() {
        this.containingPanel.removeAll();
        this.containingPanel.add((Component)this.classLabel, new GridBagConstraints(1, 0, 2, 1, 0.0, 0.0, 11, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.containingPanel.add((Component)this.nameLabel, new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 11, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.containingPanel.add((Component)this.imageLabel, new GridBagConstraints(1, 2, 2, 1, 0.0, 0.0, 11, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.classLabel.setText(this.getClassName());
        this.nameLabel.setText(GalleryObject.getDisplayName(this.displayName));
        this.sizeColor = this.getSizeColor(this.data.size);
        this.sizeLabel.setForeground(this.sizeColor);
        this.imageLabel.setIcon(GalleryViewer.loadingImageIcon);
        this.sizeLabel.setText(String.valueOf(String.valueOf(this.data.size)) + " kb");
        this.locationLabel.setText(" " + Messages.getString("on") + " " + this.location);
        if (this.data.size > 0 && this.data.type == 2) {
            this.sizeLabel.setText(String.valueOf(String.valueOf(this.data.size)) + "kb");
            this.sizeLabel.setForeground(this.sizeColor);
            this.containingPanel.add((Component)this.sizeLabel, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
        this.containingPanel.add((Component)this.locationLabel, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.containingPanel.revalidate();
        this.containingPanel.repaint();
    }

    public void respondToMouse() {
        if (this.mainViewer != null) {
            this.mainViewer.displayModelDialog(this.data, this.image);
        }
    }

    public void galleryMouseExited() {
        if (this.mouseOver) {
            this.mouseOver = false;
            if (this.hasAttribution) {
                this.mainViewer.removeAttribution();
            }
            this.repaint();
        }
    }

    public void galleryMouseEntered() {
        if (!this.mouseOver) {
            this.mouseOver = true;
            if (this.hasAttribution) {
                this.mainViewer.diplayAttribution(this.data);
            }
            this.repaint();
        }
    }

    @Override
    public void paintForeground(Graphics g) {
        super.paintForeground(g);
        if (this.mouseOver) {
            Object oldAntialiasing = null;
            if (g instanceof Graphics2D) {
                oldAntialiasing = ((Graphics2D)g).getRenderingHint(RenderingHints.KEY_ANTIALIASING);
                ((Graphics2D)g).addRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
            }
            Rectangle bounds = this.getBounds();
            int i = 1;
            while (i <= 2) {
                g.setColor(new Color(HIGHLITE.getRed(), HIGHLITE.getGreen(), HIGHLITE.getBlue(), 255 - (i - 1) * 60));
                g.drawRoundRect(i, i, bounds.width - 2 * i, bounds.height - 2 * i, this.arcWidth, this.arcHeight);
                ++i;
            }
            if (g instanceof Graphics2D) {
                ((Graphics2D)g).addRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, oldAntialiasing));
            }
        }
    }

    protected class GalleryMouseAdapter
    extends CustomMouseAdapter {
        protected GalleryMouseAdapter() {
        }

        @Override
        public void mouseExited(MouseEvent m) {
            GalleryObject.this.galleryMouseExited();
        }

        @Override
        public void mouseEntered(MouseEvent m) {
            GalleryObject.this.galleryMouseEntered();
        }

        @Override
        protected void singleClickResponse(MouseEvent ev) {
            GalleryObject.this.respondToMouse();
        }
    }
}

