/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.editors.scripteditor;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.Editor;
import edu.cmu.cs.stage3.alice.authoringtool.event.AuthoringToolStateChangedEvent;
import edu.cmu.cs.stage3.alice.authoringtool.util.ScriptEditorPane;
import edu.cmu.cs.stage3.alice.core.property.ScriptProperty;
import edu.cmu.cs.stage3.lang.Messages;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ScriptEditor
extends JPanel
implements Editor {
    public String editorName = Messages.getString("Script_Editor");
    protected ScriptProperty scriptProperty;
    protected AuthoringTool authoringTool;
    protected ScriptEditorPane scriptEditorPane = new ScriptEditorPane();
    protected CaretListener caretListener = new CaretListener(){

        @Override
        public void caretUpdate(CaretEvent e) {
            ScriptEditor.this.updateLineNumber();
        }
    };
    protected DocumentListener documentListener = new DocumentListener(){

        @Override
        public void changedUpdate(DocumentEvent e) {
            ScriptEditor.this.scriptProperty.set(ScriptEditor.this.scriptEditorPane.getText());
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            ScriptEditor.this.scriptProperty.set(ScriptEditor.this.scriptEditorPane.getText());
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            ScriptEditor.this.scriptProperty.set(ScriptEditor.this.scriptEditorPane.getText());
        }
    };
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel southPanel = new JPanel();
    JScrollPane scriptScrollPane = new JScrollPane();
    JLabel lineNumberLabel = new JLabel();
    BoxLayout boxLayout1 = new BoxLayout(this.southPanel, 0);
    Border border1;
    Border border2;
    Border border3;
    JPanel bogusPanel = new JPanel();
    Border border4;

    public ScriptEditor() {
        this.jbInit();
        this.guiInit();
    }

    private void guiInit() {
        this.scriptScrollPane.setViewportView(this.scriptEditorPane);
        this.scriptEditorPane.addCaretListener(this.caretListener);
        this.scriptEditorPane.performAllAction.setEnabled(false);
        this.scriptEditorPane.performSelectedAction.setEnabled(false);
    }

    @Override
    public JComponent getJComponent() {
        return this;
    }

    @Override
    public Object getObject() {
        return this.scriptProperty;
    }

    public void setObject(ScriptProperty scriptProperty) {
        this.scriptEditorPane.getDocument().removeDocumentListener(this.documentListener);
        this.scriptProperty = scriptProperty;
        if (this.scriptProperty != null) {
            if (scriptProperty.getStringValue() == null) {
                scriptProperty.set("");
            }
            this.scriptEditorPane.setText(scriptProperty.getStringValue());
            this.scriptEditorPane.getDocument().addDocumentListener(this.documentListener);
            this.scriptEditorPane.resetUndoManager();
            this.scriptEditorPane.setSandbox(scriptProperty.getOwner().getSandbox());
        } else {
            this.scriptEditorPane.resetUndoManager();
            this.scriptEditorPane.setSandbox(null);
        }
    }

    @Override
    public void setAuthoringTool(AuthoringTool authoringTool) {
        this.authoringTool = authoringTool;
    }

    public void updateLineNumber() {
        this.lineNumberLabel.setText("  " + Messages.getString("line_number__") + (this.scriptEditorPane.getCurrentLineNumber() + 1) + "     ");
    }

    @Override
    public void stateChanging(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void worldLoading(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void worldUnLoading(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void worldStarting(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void worldStopping(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void worldPausing(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void worldSaving(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void stateChanged(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void worldLoaded(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void worldUnLoaded(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void worldStarted(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void worldStopped(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void worldPaused(AuthoringToolStateChangedEvent ev) {
    }

    @Override
    public void worldSaved(AuthoringToolStateChangedEvent ev) {
    }

    private void jbInit() {
        this.border1 = BorderFactory.createBevelBorder(1, Color.white, Color.lightGray, new Color(142, 142, 142), new Color(99, 99, 99));
        this.border2 = BorderFactory.createBevelBorder(1, Color.white, Color.gray, new Color(142, 142, 142), new Color(99, 99, 99));
        this.border3 = BorderFactory.createEmptyBorder(1, 1, 1, 1);
        this.border4 = BorderFactory.createBevelBorder(1, Color.white, Color.lightGray, new Color(99, 99, 99), new Color(142, 142, 142));
        this.setLayout(this.borderLayout1);
        this.lineNumberLabel.setBorder(this.border1);
        this.lineNumberLabel.setText("  " + Messages.getString("line_number__") + "    ");
        this.southPanel.setLayout(this.boxLayout1);
        this.southPanel.setBorder(this.border3);
        this.bogusPanel.setBorder(this.border4);
        this.add((Component)this.southPanel, "South");
        this.southPanel.add((Component)this.bogusPanel, null);
        this.southPanel.add((Component)this.lineNumberLabel, null);
        this.add((Component)this.scriptScrollPane, "Center");
    }
}

