/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.editors.compositeeditor;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources;
import edu.cmu.cs.stage3.alice.authoringtool.editors.compositeeditor.CompositeElementEditor;
import edu.cmu.cs.stage3.alice.authoringtool.editors.compositeeditor.CompositeElementPanel;
import edu.cmu.cs.stage3.alice.authoringtool.util.GUIFactory;
import edu.cmu.cs.stage3.alice.authoringtool.util.SetPropertyImmediatelyFactory;
import edu.cmu.cs.stage3.alice.core.Code;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.List;
import edu.cmu.cs.stage3.alice.core.Sandbox;
import edu.cmu.cs.stage3.alice.core.Variable;
import edu.cmu.cs.stage3.alice.core.event.ObjectArrayPropertyEvent;
import edu.cmu.cs.stage3.alice.core.event.ObjectArrayPropertyListener;
import edu.cmu.cs.stage3.alice.core.event.PropertyEvent;
import edu.cmu.cs.stage3.alice.core.property.ListProperty;
import edu.cmu.cs.stage3.alice.core.property.ObjectArrayProperty;
import edu.cmu.cs.stage3.alice.core.property.VariableProperty;
import edu.cmu.cs.stage3.alice.core.question.userdefined.Composite;
import edu.cmu.cs.stage3.alice.core.question.userdefined.ForEach;
import edu.cmu.cs.stage3.alice.core.response.CompositeResponse;
import edu.cmu.cs.stage3.lang.Messages;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.dnd.DropTarget;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JLabel;

public abstract class ForEachElementPanel
extends CompositeElementPanel
implements ObjectArrayPropertyListener {
    protected boolean nameListening = false;
    protected JLabel endHeader;
    protected String endHeaderText;
    protected String middleHeaderText;
    protected JComponent listInput;
    protected JComponent variable;
    protected ListProperty m_list;
    protected VariableProperty m_each;
    protected static BufferedImage forEachBackgroundImage;
    protected static Dimension forEachBackgroundImageSize;

    static {
        forEachBackgroundImageSize = new Dimension(-1, -1);
    }

    public ForEachElementPanel() {
        this.backgroundColor = AuthoringToolResources.getColor("ForEachInOrder");
        this.headerText = Messages.getString("For_all");
        this.endHeaderText = Messages.getString("at_a_time");
        this.middleHeaderText = Messages.getString("__one");
    }

    @Override
    protected void variableInit() {
        super.variableInit();
        if (this.m_element instanceof edu.cmu.cs.stage3.alice.core.response.ForEach) {
            edu.cmu.cs.stage3.alice.core.response.ForEach proxy = (edu.cmu.cs.stage3.alice.core.response.ForEach)this.m_element;
            this.m_list = proxy.list;
            this.m_each = proxy.each;
        } else if (this.m_element instanceof ForEach) {
            ForEach proxy = (ForEach)this.m_element;
            this.m_list = proxy.list;
            this.m_each = proxy.each;
        }
    }

    @Override
    protected void setDropTargets() {
        super.setDropTargets();
        this.endHeader.setDropTarget(new DropTarget(this.endHeader, this.componentElementPanel));
    }

    protected void listenToChildren(ObjectArrayProperty components) {
        if (components != null) {
            components.addObjectArrayPropertyListener(this);
            int i = 0;
            while (i < components.size()) {
                Code current;
                if (components.get(i) instanceof CompositeResponse) {
                    current = (CompositeResponse)components.get(i);
                    this.listenToChildren(current.componentResponses);
                } else if (components.get(i) instanceof Composite) {
                    current = (Composite)components.get(i);
                    this.listenToChildren(((Composite)current).components);
                }
                ++i;
            }
        }
    }

    protected void stopListenToChildren(ObjectArrayProperty components) {
        if (components != null) {
            components.removeObjectArrayPropertyListener(this);
            int i = 0;
            while (i < components.size()) {
                Code current;
                if (components.get(i) instanceof CompositeResponse) {
                    current = (CompositeResponse)components.get(i);
                    this.stopListenToChildren(current.componentResponses);
                } else if (components.get(i) instanceof Composite) {
                    current = (Composite)components.get(i);
                    this.stopListenToChildren(((Composite)current).components);
                }
                ++i;
            }
        }
    }

    @Override
    protected void startListening() {
        super.startListening();
        if (this.m_list != null) {
            this.m_list.addPropertyListener(this);
            if (this.m_list.get() != null) {
                ((Element)this.m_list.get()).name.addPropertyListener(this);
                this.nameListening = true;
            }
        }
        if (this.m_each != null) {
            this.m_each.addPropertyListener(this);
        }
        this.listenToChildren(this.m_components);
    }

    @Override
    protected void stopListening() {
        super.stopListening();
        if (this.m_list != null) {
            this.m_list.removePropertyListener(this);
            if (this.m_list.get() != null) {
                ((Element)this.m_list.get()).name.removePropertyListener(this);
                this.nameListening = true;
            }
        }
        if (this.m_each != null) {
            this.m_each.removePropertyListener(this);
        }
        this.stopListenToChildren(this.m_components);
    }

    public int countPreviousInstances(Element parent, Object toCheck) {
        if (parent == null) {
            return 0;
        }
        ListProperty list = null;
        if (parent instanceof ForEach) {
            list = ((ForEach)parent).list;
        }
        if (parent instanceof edu.cmu.cs.stage3.alice.core.response.ForEach) {
            list = ((edu.cmu.cs.stage3.alice.core.response.ForEach)parent).list;
        }
        if (list != null && list.get() == toCheck) {
            if (parent.getParent() != null && !(parent.getParent() instanceof Sandbox)) {
                return this.countPreviousInstances(parent.getParent(), toCheck) + 1;
            }
            return 1;
        }
        if (parent.getParent() != null && !(parent.getParent() instanceof Sandbox)) {
            return this.countPreviousInstances(parent.getParent(), toCheck);
        }
        return 0;
    }

    private String makeVariableName(Element inputList) {
        int numPrevious = 0;
        if (this.m_element.getParent() != null && !(this.m_element.getParent() instanceof Sandbox)) {
            numPrevious = this.countPreviousInstances(this.m_element.getParent(), inputList);
        }
        String toAdd = "";
        if (numPrevious > 0) {
            toAdd = "_#" + (numPrevious + 1);
        }
        return String.valueOf(Messages.getString("item_from_")) + inputList.name.getStringValue() + toAdd;
    }

    @Override
    public void setHeaderLabel() {
        if (this.headerLabel != null) {
            this.headerLabel.setText(this.headerText);
        }
        if (this.endHeader != null) {
            this.endHeader.setText(this.endHeaderText);
            if (CompositeElementEditor.IS_JAVA) {
                if (!this.isExpanded) {
                    this.endHeader.setText(String.valueOf(this.endHeaderText) + " { " + this.getDots() + " }");
                } else {
                    this.endHeader.setText(String.valueOf(this.endHeaderText) + " {");
                }
            }
        }
    }

    @Override
    protected void generateGUI() {
        super.generateGUI();
        if (this.endHeader == null) {
            this.endHeader = new JLabel(this.endHeaderText);
        }
    }

    @Override
    protected void restoreDrag() {
        super.restoreDrag();
        this.addDragSourceComponent(this.endHeader);
    }

    protected void updateName() {
        Variable v = (Variable)this.m_each.getValue();
        v.name.set(this.makeVariableName((Element)this.m_list.get()));
        this.headerPanel.remove(this.variable);
        this.variable = GUIFactory.getVariableDnDPanel((Variable)this.m_each.get());
        this.headerPanel.add((Component)this.variable, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 2, 0, 2), 0, 0));
    }

    @Override
    protected void updateGUI() {
        super.updateGUI();
        SetPropertyImmediatelyFactory pif = new SetPropertyImmediatelyFactory(this.m_list){

            @Override
            public void run(Object v) {
                if (!(v instanceof List)) {
                    if (v instanceof Variable) {
                        if (!(((Variable)v).value.get() instanceof List)) {
                            return;
                        }
                    } else {
                        return;
                    }
                }
                super.run(v);
            }
        };
        if (this.m_list.get() != null) {
            this.setVariable();
        }
        this.variable = GUIFactory.getVariableDnDPanel((Variable)this.m_each.get());
        this.listInput = GUIFactory.getPropertyViewController(this.m_list, false, true, AuthoringToolResources.shouldGUIOmitPropertyName(this.m_list), pif);
        this.headerPanel.remove(this.glue);
        this.headerPanel.add((Component)this.listInput, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 2, 0, 2), 0, 0));
        this.headerPanel.add((Component)new JLabel(this.middleHeaderText), new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 2, 0, 2), 0, 0));
        this.headerPanel.add((Component)this.variable, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 2, 0, 2), 0, 0));
        this.headerPanel.add((Component)this.endHeader, new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 2, 0, 2), 0, 0));
        this.headerPanel.add(this.glue, new GridBagConstraints(7, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected boolean isTopOccurrance(Element parent, Object toCheck) {
        if (parent == null) {
            return true;
        }
        ListProperty list = null;
        if (parent instanceof ForEach) {
            list = ((ForEach)parent).list;
        }
        if (parent instanceof edu.cmu.cs.stage3.alice.core.response.ForEach) {
            list = ((edu.cmu.cs.stage3.alice.core.response.ForEach)parent).list;
        }
        if (list != null && list.get() == toCheck) {
            return false;
        }
        return this.isTopOccurrance(parent.getParent(), toCheck);
    }

    protected void setVariableName() {
        Element l = (Element)this.m_list.get();
        String newName = this.makeVariableName(l);
        ((Element)this.m_each.get()).name.set(newName);
    }

    private void setVariable() {
        if (this.m_each.get() != null && this.m_list.get() != null) {
            Element l = (Element)this.m_list.get();
            Class valueClass = null;
            if (l instanceof List) {
                valueClass = (Class)((List)l).valueClass.get();
            } else if (l instanceof Variable) {
                valueClass = (Class)((List)((Variable)l).value.get()).valueClass.get();
            }
            ((Variable)this.m_each.get()).valueClass.set(valueClass);
            this.setVariableName();
        }
    }

    @Override
    public void objectArrayPropertyChanging(ObjectArrayPropertyEvent objectArrayPropertyEvent) {
    }

    protected void setAllNames(ObjectArrayProperty currentContainer, int currentLevel) {
        String baseName = String.valueOf(Messages.getString("item_from_")) + ((Element)this.m_list.get()).name.getStringValue();
        int i = 0;
        while (i < currentContainer.size()) {
            Object list = null;
            Element var = null;
            if (currentContainer.get(i) instanceof edu.cmu.cs.stage3.alice.core.response.ForEach) {
                list = ((edu.cmu.cs.stage3.alice.core.response.ForEach)currentContainer.get((int)i)).list.get();
                var = (Element)((edu.cmu.cs.stage3.alice.core.response.ForEach)currentContainer.get((int)i)).each.get();
            } else if (currentContainer.get(i) instanceof ForEach) {
                list = ((ForEach)currentContainer.get((int)i)).list.get();
                var = (Element)((ForEach)currentContainer.get((int)i)).each.get();
            }
            if (list == this.m_list.get()) {
                var.name.set(String.valueOf(baseName) + "_#" + currentLevel);
            }
            if (currentContainer.get(i) instanceof CompositeResponse) {
                this.setAllNames(((CompositeResponse)currentContainer.get((int)i)).componentResponses, currentLevel + 1);
            } else if (currentContainer.get(i) instanceof Composite) {
                this.setAllNames(((Composite)currentContainer.get((int)i)).components, currentLevel + 1);
            }
            ++i;
        }
    }

    @Override
    public void objectArrayPropertyChanged(ObjectArrayPropertyEvent objectArrayPropertyEvent) {
        this.stopListening();
        this.startListening();
        if (this.isTopOccurrance(this.m_element.getParent(), this.m_list.get())) {
            this.m_each.getElementValue().name.set(String.valueOf(Messages.getString("item_from_")) + ((Element)this.m_list.get()).name.getStringValue());
            this.setAllNames(this.m_components, 2);
        }
    }

    @Override
    public void propertyChanged(PropertyEvent propertyEvent) {
        if (propertyEvent.getProperty() == this.m_each && this.m_each.get() != null) {
            Element l = (Element)this.m_list.get();
            Class valueClass = null;
            if (l instanceof List) {
                valueClass = (Class)((List)l).valueClass.get();
            } else if (l instanceof Variable) {
                valueClass = (Class)((List)((Variable)l).value.get()).valueClass.get();
            }
            ((Variable)this.m_each.get()).valueClass.set(valueClass);
            this.setVariableName();
        }
        if (propertyEvent.getProperty() == this.m_list) {
            if (this.m_list.get() != null && !this.nameListening) {
                ((Element)this.m_list.get()).name.addPropertyListener(this);
                this.nameListening = true;
            }
            this.setVariable();
        } else if (this.m_list.get() != null && propertyEvent.getProperty() == ((Element)this.m_list.get()).name) {
            this.setVariableName();
        } else {
            super.propertyChanged(propertyEvent);
        }
    }

    protected void createBackgroundImage(int width, int height) {
        forEachBackgroundImageSize.setSize(width, height);
        forEachBackgroundImage = new BufferedImage(width, height, 2);
        Graphics2D g = (Graphics2D)forEachBackgroundImage.getGraphics();
        g.addRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        g.setColor(this.backgroundColor);
        g.fillRect(0, 0, width, height);
    }

    protected void paintTextureEffect(Graphics g, Rectangle bounds) {
        if (bounds.width > ForEachElementPanel.forEachBackgroundImageSize.width || bounds.height > ForEachElementPanel.forEachBackgroundImageSize.height) {
            this.createBackgroundImage(bounds.width, bounds.height);
        }
        g.setClip(bounds.x, bounds.y, bounds.width, bounds.height);
        g.drawImage(forEachBackgroundImage, bounds.x, bounds.y, this);
    }
}

