/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.editors.behaviorgroupseditor;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources;
import edu.cmu.cs.stage3.alice.authoringtool.editors.behaviorgroupseditor.BasicBehaviorPanel;
import edu.cmu.cs.stage3.alice.authoringtool.editors.behaviorgroupseditor.BehaviorGroupsEditor;
import edu.cmu.cs.stage3.alice.authoringtool.util.GUIFactory;
import edu.cmu.cs.stage3.alice.authoringtool.util.GroupingPanel;
import edu.cmu.cs.stage3.alice.authoringtool.util.SetPropertyImmediatelyFactory;
import edu.cmu.cs.stage3.alice.core.Response;
import edu.cmu.cs.stage3.alice.core.behavior.TriggerBehavior;
import edu.cmu.cs.stage3.lang.Messages;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class TriggerBehaviorPanel
extends BasicBehaviorPanel
implements ComponentListener {
    JComponent triggerPanel;
    private boolean isSecondLine = false;
    private Component topParent = null;
    private Component containingPanel = null;
    private boolean shouldCheckSize = true;
    private JLabel lastLabel;

    public TriggerBehaviorPanel() {
        this.addComponentListener(this);
    }

    public void set(TriggerBehavior behavior, AuthoringTool authoringTool) {
        super.set(behavior, authoringTool);
    }

    @Override
    public void getHTML(StringBuffer toWriteTo, boolean useColor) {
        Color bgColor = COLOR;
        String strikeStart = "";
        String strikeEnd = "";
        if (!this.m_behavior.isEnabled.booleanValue()) {
            bgColor = AuthoringToolResources.getColor("disabledHTML");
            strikeStart = "<strike><font color=\"" + this.getHTMLColorString(AuthoringToolResources.getColor("disabledHTMLText")) + "\">";
            strikeEnd = "</font></strike>";
        }
        Response response = (Response)((TriggerBehavior)this.m_behavior).triggerResponse.get();
        toWriteTo.append("<tr>\n<td bgcolor=" + this.getHTMLColorString(bgColor) + " colspan=\"2\">" + strikeStart);
        this.labelPanel.remove(this.lastLabel);
        toWriteTo.append(GUIFactory.getHTMLStringForComponent(this.labelPanel));
        this.labelPanel.add((Component)this.lastLabel, new GridBagConstraints(this.labelPanel.getComponentCount(), 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 0), 0, 0));
        toWriteTo.append(String.valueOf(strikeEnd) + "</td>\n</tr>\n");
        toWriteTo.append("<tr>\n<td bgcolor=" + this.getHTMLColorString(bgColor) + " align=\"right\">" + strikeStart + Messages.getString("_b_Do___b_") + strikeEnd + "</td>\n");
        toWriteTo.append("<td bgcolor=" + this.getHTMLColorString(bgColor) + " width=\"100%\"><table cellpadding=\"2\" cellspacing=\"0\" width=\"100%\">");
        toWriteTo.append(GUIFactory.getHTMLStringForComponent(this.triggerPanel));
        toWriteTo.append("</table>\n</td>\n</tr>\n");
    }

    @Override
    protected void removeAllListening() {
        super.removeAllListening();
        if (this.m_containingPanel != null) {
            this.removeDragSourceComponent(this.m_containingPanel);
            this.m_containingPanel.removeMouseListener(this.behaviorMouseListener);
        }
        if (this.triggerPanel != null) {
            this.removeDragSourceComponent(this.triggerPanel);
            this.triggerPanel.removeMouseListener(this.behaviorMouseListener);
            this.removeComponentListener(this);
            this.triggerPanel.removeComponentListener(this);
        }
    }

    @Override
    public void release() {
        super.release();
    }

    @Override
    protected void guiInit() {
        super.guiInit();
        if (this.m_containingPanel == null) {
            this.m_containingPanel = new GroupingPanel();
            this.m_containingPanel.setBorder(null);
            this.m_containingPanel.setLayout(new GridBagLayout());
            this.m_containingPanel.setBackground(COLOR);
            this.m_containingPanel.addMouseListener(this.behaviorMouseListener);
        }
        this.remove(this.m_containingPanel);
        this.addDragSourceComponent(this.m_containingPanel);
        this.m_containingPanel.removeAll();
        if (this.labelPanel == null) {
            this.labelPanel = new GroupingPanel();
            this.labelPanel.setBorder(null);
            this.labelPanel.setLayout(new GridBagLayout());
            this.labelPanel.setBackground(COLOR);
            this.labelPanel.addMouseListener(this.behaviorMouseListener);
        }
        this.addDragSourceComponent(this.labelPanel);
        this.labelPanel.removeAll();
        this.setBackground(COLOR);
        this.buildLabel(this.labelPanel);
        int x = this.labelPanel.getComponentCount();
        this.lastLabel = new JLabel();
        if (this.isSecondLine) {
            this.lastLabel.setText(",");
        } else {
            this.lastLabel.setText(Messages.getString("___do"));
        }
        this.labelPanel.add((Component)this.lastLabel, new GridBagConstraints(x, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 0), 0, 0));
        SetPropertyImmediatelyFactory triggerFactory = new SetPropertyImmediatelyFactory(((TriggerBehavior)this.m_behavior).triggerResponse);
        this.triggerPanel = GUIFactory.getPropertyViewController(((TriggerBehavior)this.m_behavior).triggerResponse, false, true, true, triggerFactory);
        this.triggerPanel.addComponentListener(this);
        this.m_containingPanel.add((Component)this.labelPanel, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 2), 0, 0));
        if (this.isSecondLine) {
            this.m_containingPanel.add((Component)new JLabel(Messages.getString("do_")), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 15, 0, 2), 0, 0));
            this.m_containingPanel.add((Component)this.triggerPanel, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 2, 0, 2), 0, 0));
        } else {
            this.m_containingPanel.add((Component)this.triggerPanel, new GridBagConstraints(x + 1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 2, 0, 2), 0, 0));
        }
        this.add((Component)this.m_containingPanel, "Center");
        this.repaint();
        this.revalidate();
    }

    private Component getTopParent(Component c) {
        if (c == null) {
            return null;
        }
        if (c instanceof BehaviorGroupsEditor) {
            return c;
        }
        return this.getTopParent(c.getParent());
    }

    private void recheckLength() {
        if (this.containingPanel == null) {
            this.topParent = this.getTopParent(this.getParent());
            if (this.topParent != null) {
                this.topParent.addComponentListener(this);
            }
            if (this.topParent instanceof BehaviorGroupsEditor) {
                this.containingPanel = ((BehaviorGroupsEditor)this.topParent).getContainingPanel();
            }
        }
        if (this.topParent == null) {
            return;
        }
        int calculatedWidth = this.labelPanel.getWidth() + this.triggerPanel.getWidth() + 45 + 8;
        if (this.isSecondLine) {
            calculatedWidth += 23;
        }
        if (this.isSecondLine) {
            if (calculatedWidth < this.topParent.getWidth()) {
                this.isSecondLine = false;
                this.guiInit();
            }
        } else if (calculatedWidth > this.topParent.getWidth()) {
            this.isSecondLine = true;
            this.guiInit();
        }
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        if (this.shouldCheckSize) {
            this.recheckLength();
        }
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }
}

