/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.editors.behaviorgroupseditor;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.editors.behaviorgroupseditor.BasicBehaviorPanel;
import edu.cmu.cs.stage3.alice.authoringtool.editors.behaviorgroupseditor.CompositeComponentBehaviorPanel;
import edu.cmu.cs.stage3.alice.authoringtool.editors.compositeeditor.CompositeComponentElementPanel;
import edu.cmu.cs.stage3.alice.authoringtool.editors.compositeeditor.CompositeComponentOwner;
import edu.cmu.cs.stage3.alice.authoringtool.editors.compositeeditor.CompositeElementPanel;
import edu.cmu.cs.stage3.alice.authoringtool.util.GUIElement;
import edu.cmu.cs.stage3.alice.authoringtool.util.GUIFactory;
import edu.cmu.cs.stage3.alice.authoringtool.util.GroupingPanel;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.Sandbox;
import edu.cmu.cs.stage3.alice.core.event.PropertyEvent;
import edu.cmu.cs.stage3.alice.core.event.PropertyListener;
import edu.cmu.cs.stage3.alice.core.property.ObjectArrayProperty;
import edu.cmu.cs.stage3.lang.Messages;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class BehaviorGroupEditor
extends GroupingPanel
implements PropertyListener,
GUIElement,
CompositeComponentOwner {
    protected CompositeComponentElementPanel componentElementPanel;
    protected Element m_element;
    protected ObjectArrayProperty m_components;
    protected String headerText = Messages.getString("Events");
    protected GroupingPanel headerPanel;
    protected JPanel containingPanel;
    protected JButton expandButton;
    protected Action expandAction;
    protected JLabel headerLabel;
    protected boolean isExpanded = true;
    protected Color backgroundColor = new Color(255, 255, 255);
    protected ImageIcon plus;
    protected ImageIcon minus;
    protected Component glue;
    protected AuthoringTool authoringTool;
    protected ActionListener actionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (BehaviorGroupEditor.this.isExpanded) {
                BehaviorGroupEditor.this.reduceComponentElementPanel();
            } else {
                BehaviorGroupEditor.this.expandComponentElementPanel();
            }
        }
    };
    protected boolean shouldShowLabel = true;
    protected static String IS_EXPANDED_KEY = "edu.cmu.cs.stage3.alice.authoringtool.editors.behavioreditor IS_EXPANDED_KEY";

    public BehaviorGroupEditor() {
        this.setBorder(null);
        this.generateGUI();
    }

    public void set(Element element, AuthoringTool authoringToolIn) {
        this.clean();
        this.m_element = element;
        this.authoringTool = authoringToolIn;
        this.variableInit();
        this.startListening();
        this.setHeaderLabel();
        this.updateGUI();
        this.setDropTargets();
    }

    public Vector getBehaviorComponents() {
        Vector<Component> toReturn = new Vector<Component>();
        int i = 0;
        while (i < this.componentElementPanel.getComponentCount()) {
            if (this.componentElementPanel.getComponent(i) instanceof BasicBehaviorPanel) {
                toReturn.add(this.componentElementPanel.getComponent(i));
            }
            ++i;
        }
        return toReturn;
    }

    public void setAuthoringTool(AuthoringTool authoringTool) {
        this.authoringTool = authoringTool;
        if (this.componentElementPanel != null) {
            this.componentElementPanel.setAuthoringTool(authoringTool);
        }
    }

    public void setEmptyString(String emptyString) {
        if (this.componentElementPanel != null) {
            this.componentElementPanel.setEmptyString(emptyString);
        }
    }

    protected void setDropTargets() {
        this.headerLabel.setDropTarget(new DropTarget(this.headerLabel, this.componentElementPanel));
        this.setDropTarget(new DropTarget(this, this.componentElementPanel));
        this.containingPanel.setDropTarget(new DropTarget(this.containingPanel, this.componentElementPanel));
        this.headerPanel.setDropTarget(new DropTarget(this.headerPanel, this.componentElementPanel));
        this.glue.setDropTarget(new DropTarget(this.glue, this.componentElementPanel));
        this.expandButton.setDropTarget(new DropTarget(this.expandButton, this.componentElementPanel));
    }

    protected void variableInit() {
        Object isExpandedValue = this.m_element.data.get(IS_EXPANDED_KEY);
        this.headerText = this.m_element.name.getStringValue();
        if (isExpandedValue instanceof Boolean) {
            this.isExpanded = (Boolean)isExpandedValue;
        }
        if (this.m_element instanceof Sandbox) {
            Sandbox proxy = (Sandbox)this.m_element;
            this.m_components = proxy.behaviors;
            this.componentElementPanel = new CompositeComponentBehaviorPanel();
            this.componentElementPanel.set(this.m_components, this, this.authoringTool);
            this.componentElementPanel.setBackground(this.backgroundColor);
        }
    }

    @Override
    public Component getGrip() {
        return null;
    }

    @Override
    public Container getParent() {
        return super.getParent();
    }

    protected void startListening() {
        if (this.m_element != null) {
            this.m_element.name.addPropertyListener(this);
        }
    }

    protected void stopListening() {
        if (this.m_element != null) {
            this.m_element.name.removePropertyListener(this);
        }
    }

    @Override
    public void goToSleep() {
        this.stopListening();
        if (this.componentElementPanel != null) {
            this.componentElementPanel.goToSleep();
        }
    }

    @Override
    public void wakeUp() {
        this.startListening();
        if (this.componentElementPanel != null) {
            this.componentElementPanel.wakeUp();
        }
    }

    @Override
    public void release() {
        super.release();
        if (this.componentElementPanel != null) {
            this.componentElementPanel.release();
        }
        GUIFactory.releaseGUI(this);
    }

    @Override
    public void clean() {
        this.goToSleep();
        if (this.componentElementPanel != null) {
            if (this.containingPanel != null) {
                this.containingPanel.remove(this.componentElementPanel);
            }
            this.componentElementPanel.release();
            this.componentElementPanel = null;
        }
    }

    protected void removeAllListening() {
        this.expandButton.removeActionListener(this.actionListener);
    }

    @Override
    public void die() {
        this.clean();
        this.removeAllListening();
    }

    public void prePropertyChange(PropertyEvent propertyEvent) {
    }

    @Override
    public void propertyChanging(PropertyEvent propertyEvent) {
    }

    @Override
    public void propertyChanged(PropertyEvent propertyEvent) {
        if (propertyEvent.getProperty() == this.m_element.name) {
            this.headerText = this.m_element.name.getStringValue();
            this.headerLabel.setText(this.headerText);
            this.revalidate();
            this.repaint();
        }
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.containingPanel != null) {
            this.containingPanel.setBackground(this.backgroundColor);
        }
        if (this.headerLabel != null) {
            this.headerLabel.setBackground(this.backgroundColor);
        }
        if (this.headerPanel != null) {
            this.headerPanel.setBackground(this.backgroundColor);
        }
        if (this.componentElementPanel != null) {
            this.componentElementPanel.setBackground(this.backgroundColor);
        }
    }

    protected void generateGUI() {
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        this.plus = new ImageIcon(CompositeElementPanel.class.getResource("images/plus.gif"));
        this.minus = new ImageIcon(CompositeElementPanel.class.getResource("images/minus.gif"));
        this.expandButton = new JButton();
        this.expandButton.setContentAreaFilled(false);
        this.expandButton.setMargin(new Insets(0, 0, 0, 0));
        this.expandButton.setFocusPainted(false);
        this.expandButton.setBorderPainted(false);
        this.expandButton.setBorder(null);
        this.expandButton.addActionListener(this.actionListener);
        this.glue = Box.createHorizontalGlue();
        if (this.headerLabel == null) {
            this.headerLabel = new JLabel();
            this.setHeaderLabel();
            this.headerLabel.setOpaque(false);
        }
        if (this.containingPanel == null) {
            this.containingPanel = new JPanel();
            this.containingPanel.setLayout(new BorderLayout());
            this.containingPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.containingPanel.setOpaque(false);
        }
        if (this.headerPanel == null) {
            this.headerPanel = new GroupingPanel();
            this.headerPanel.setLayout(new GridBagLayout());
            this.headerPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.headerPanel.setOpaque(false);
        }
    }

    public void removeLabel() {
        this.shouldShowLabel = false;
        this.containingPanel.remove(this.headerPanel);
        this.expandComponentElementPanel();
        this.revalidate();
        this.repaint();
    }

    public void addLabel() {
        this.shouldShowLabel = true;
        this.containingPanel.add((Component)this.headerPanel, "North");
        this.revalidate();
        this.repaint();
    }

    protected void updateGUI() {
        this.containingPanel.removeAll();
        this.headerPanel.removeAll();
        if (this.isExpanded) {
            this.expandButton.setIcon(this.minus);
        } else {
            this.expandButton.setIcon(this.plus);
        }
        this.headerLabel.setText(this.headerText);
        this.headerPanel.add((Component)this.expandButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.headerPanel.add((Component)this.headerLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 4, 0, 2), 0, 0));
        this.headerPanel.add(this.glue, new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        if (this.shouldShowLabel) {
            this.containingPanel.add((Component)this.headerPanel, "North");
        }
        if (this.isExpanded) {
            this.containingPanel.add((Component)this.componentElementPanel, "Center");
        }
        this.add((Component)this.containingPanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.setBackground(this.backgroundColor);
    }

    @Override
    public boolean isExpanded() {
        return this.isExpanded;
    }

    public void expandComponentElementPanel() {
        if (!this.isExpanded) {
            this.m_element.data.put(IS_EXPANDED_KEY, Boolean.TRUE);
            this.isExpanded = true;
            this.setHeaderLabel();
            this.expandButton.setIcon(this.minus);
            this.containingPanel.add((Component)this.componentElementPanel, "Center");
            this.revalidate();
        }
    }

    public void setHeaderLabel() {
        if (this.headerLabel != null) {
            this.headerLabel.setText(this.headerText);
        }
    }

    public void reduceComponentElementPanel() {
        if (this.isExpanded) {
            this.m_element.data.put(IS_EXPANDED_KEY, Boolean.FALSE);
            this.isExpanded = false;
            this.setHeaderLabel();
            this.expandButton.setIcon(this.plus);
            this.containingPanel.remove(this.componentElementPanel);
            this.revalidate();
        }
    }

    public CompositeComponentElementPanel getComponentPanel() {
        return this.componentElementPanel;
    }

    public void addResponsePanel(JComponent toAdd, int position) {
        this.componentElementPanel.addElementPanel(toAdd, position);
    }

    @Override
    public Element getElement() {
        return this.m_element;
    }
}

