/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.dialog;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources;
import edu.cmu.cs.stage3.alice.authoringtool.util.ElementUsageGraph;
import edu.cmu.cs.stage3.alice.core.Behavior;
import edu.cmu.cs.stage3.alice.core.Response;
import edu.cmu.cs.stage3.alice.core.World;
import edu.cmu.cs.stage3.alice.core.question.userdefined.UserDefinedQuestion;
import edu.cmu.cs.stage3.alice.core.response.UserDefinedResponse;
import edu.cmu.cs.stage3.alice.core.util.IndexedTriangleArrayCounter;
import edu.cmu.cs.stage3.alice.core.util.TextureMapCounter;
import edu.cmu.cs.stage3.lang.Messages;
import edu.cmu.cs.stage3.swing.ContentPane;
import edu.cmu.cs.stage3.util.HowMuch;
import edu.cmu.cs.stage3.util.criterion.InstanceOfCriterion;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;

public class WorldInfoContentPane
extends ContentPane {
    protected World world;
    protected ElementUsageGraph responseUsageGraph;
    Border border1;
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel buttonPanel = new JPanel();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JButton doneButton = new JButton();
    Border border2;
    JScrollPane mainScrollPane = new JScrollPane();
    JLabel textureMemoryLabel = new JLabel();
    JPanel mainPanel = new JPanel();
    JLabel responseUsageLabel = new JLabel();
    JLabel objectCountLabel = new JLabel();
    JLabel polyCountLabel = new JLabel();
    JLabel currentRendererLabel = new JLabel();
    Component component1;
    JPanel responseUsagePanel = new JPanel();
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    BorderLayout borderLayout2 = new BorderLayout();
    JLabel behaviorCountLabel = new JLabel();
    JLabel userDefinedResponseCountLabel = new JLabel();
    JLabel textureCountLabel = new JLabel();
    JLabel playCountLabel = new JLabel();
    JLabel saveCountLabel = new JLabel();
    JLabel worldOpenTimeLabel = new JLabel();
    JLabel userDefinedQuestionCountLabel = new JLabel();

    public WorldInfoContentPane() {
        this.jbInit();
        this.guiInit();
    }

    @Override
    public String getTitle() {
        return Messages.getString("World_Statistics");
    }

    private void guiInit() {
        this.setSize(500, 600);
        this.responseUsageGraph = new ElementUsageGraph();
        this.responseUsageGraph.setElementCriterion(new InstanceOfCriterion(Response.class));
        this.responseUsagePanel.add((Component)this.responseUsageGraph, "Center");
    }

    public void setWorld(World world) {
        this.world = world;
        this.responseUsageGraph.setRoot(world);
        this.refresh();
    }

    private void refresh() {
        if (this.world != null) {
            IndexedTriangleArrayCounter itaCounter = new IndexedTriangleArrayCounter();
            TextureMapCounter textureMapCounter = new TextureMapCounter();
            this.world.visit(itaCounter, HowMuch.INSTANCE_AND_ALL_DESCENDANTS);
            this.world.visit(textureMapCounter, HowMuch.INSTANCE_AND_ALL_DESCENDANTS);
            int playCount = 0;
            int saveCount = 0;
            long worldOpenTime = 0L;
            if (this.world.data.get("edu.cmu.cs.stage3.alice.authoringtool.playCount") != null) {
                playCount = Integer.parseInt((String)this.world.data.get("edu.cmu.cs.stage3.alice.authoringtool.playCount"));
            }
            if (this.world.data.get("edu.cmu.cs.stage3.alice.authoringtool.saveCount") != null) {
                saveCount = Integer.parseInt((String)this.world.data.get("edu.cmu.cs.stage3.alice.authoringtool.saveCount"));
            }
            if (this.world.data.get("edu.cmu.cs.stage3.alice.authoringtool.worldOpenTime") != null) {
                worldOpenTime = Long.parseLong((String)this.world.data.get("edu.cmu.cs.stage3.alice.authoringtool.worldOpenTime"));
            }
            worldOpenTime /= 60000L;
            this.objectCountLabel.setText(String.valueOf(Messages.getString("Number_of_3D_objects__")) + itaCounter.getShownIndexedTriangleArrayCount());
            this.polyCountLabel.setText(String.valueOf(Messages.getString("Number_of_polygons__")) + itaCounter.getShownIndexCount() / 3);
            this.textureCountLabel.setText(String.valueOf(Messages.getString("Number_of_textures__")) + textureMapCounter.getTextureMapCount());
            this.textureMemoryLabel.setText(String.valueOf(Messages.getString("Texture_memory_used__")) + AuthoringToolResources.formatMemorySize(textureMapCounter.getTextureMapMemoryCount()));
            this.userDefinedResponseCountLabel.setText(String.valueOf(Messages.getString("Number_of_user_defined_animations__")) + this.world.getDescendants(UserDefinedResponse.class).length);
            this.userDefinedQuestionCountLabel.setText(String.valueOf(Messages.getString("Number_of_user_defined_questions__")) + this.world.getDescendants(UserDefinedQuestion.class).length);
            this.behaviorCountLabel.setText(String.valueOf(Messages.getString("Number_of_behaviors__")) + this.world.getDescendants(Behavior.class).length);
            this.playCountLabel.setText(String.valueOf(Messages.getString("Number_of_times_the_world_has_been_run__")) + playCount);
            this.saveCountLabel.setText(String.valueOf(Messages.getString("Number_of_times_the_world_has_been_saved__")) + saveCount);
            this.worldOpenTimeLabel.setText(String.valueOf(Messages.getString("Amount_of_time_the_world_has_been_open__")) + worldOpenTime + " " + (worldOpenTime == 1L ? Messages.getString("minute") : Messages.getString("minutes")));
            this.currentRendererLabel.setText(String.valueOf(Messages.getString("Current_renderer__")) + AuthoringTool.getHack().getCurrentRendererText());
            this.responseUsageGraph.refresh();
        }
    }

    private void jbInit() {
        this.border1 = BorderFactory.createEmptyBorder(8, 8, 8, 8);
        this.border2 = BorderFactory.createEmptyBorder(8, 8, 8, 8);
        this.component1 = Box.createGlue();
        this.setBackground(new Color(232, 230, 255));
        this.setLayout(this.borderLayout1);
        this.buttonPanel.setOpaque(false);
        this.buttonPanel.setLayout(this.gridBagLayout1);
        this.doneButton.setText(Messages.getString("Done"));
        this.textureMemoryLabel.setText(Messages.getString("Texture_memory_used__"));
        this.mainPanel.setBorder(this.border2);
        this.mainPanel.setOpaque(false);
        this.mainPanel.setLayout(this.gridBagLayout2);
        this.responseUsageLabel.setText(Messages.getString("Animation_usage_"));
        this.objectCountLabel.setText(Messages.getString("Number_of_3D_objects__"));
        this.polyCountLabel.setText(Messages.getString("Number_of_polygons__"));
        this.responseUsagePanel.setOpaque(false);
        this.responseUsagePanel.setLayout(this.borderLayout2);
        this.behaviorCountLabel.setText(Messages.getString("Number_of_behaviors__"));
        this.userDefinedResponseCountLabel.setText(Messages.getString("Number_of_user_defined_animations_"));
        this.mainScrollPane.getViewport().setBackground(new Color(232, 230, 255));
        this.mainScrollPane.setOpaque(false);
        this.textureCountLabel.setText(Messages.getString("Number_of_textures__"));
        this.playCountLabel.setText(Messages.getString("Number_of_times_the_world_has_been_run__"));
        this.saveCountLabel.setText(Messages.getString("Number_of_times_the_world_has_been_saved__"));
        this.worldOpenTimeLabel.setText(Messages.getString("Amount_of_time_the_world_has_been_open__"));
        this.userDefinedQuestionCountLabel.setText(Messages.getString("Number_of_user_defined_questions__"));
        this.add((Component)this.buttonPanel, "South");
        this.buttonPanel.add((Component)this.doneButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 0, 2, 0), 0, 0));
        this.add((Component)this.mainScrollPane, "Center");
        this.mainScrollPane.getViewport().add((Component)this.mainPanel, null);
        this.mainPanel.add((Component)this.objectCountLabel, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 2, 0), 0, 0));
        this.mainPanel.add((Component)this.polyCountLabel, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 2, 0), 0, 0));
        this.mainPanel.add((Component)this.textureMemoryLabel, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 2, 0), 0, 0));
        this.mainPanel.add((Component)this.userDefinedResponseCountLabel, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 2, 0), 0, 0));
        this.mainPanel.add((Component)this.behaviorCountLabel, new GridBagConstraints(0, 6, 2, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 2, 0), 0, 0));
        this.mainPanel.add((Component)this.responseUsageLabel, new GridBagConstraints(0, 11, 2, 1, 1.0, 0.0, 17, 0, new Insets(8, 0, 2, 0), 0, 0));
        this.mainPanel.add((Component)this.responseUsagePanel, new GridBagConstraints(0, 12, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 4, 0), 0, 0));
        this.mainPanel.add(this.component1, new GridBagConstraints(0, 13, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.mainPanel.add((Component)this.textureCountLabel, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 2, 0), 0, 0));
        this.mainPanel.add((Component)this.playCountLabel, new GridBagConstraints(0, 7, 2, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 2, 0), 0, 0));
        this.mainPanel.add((Component)this.saveCountLabel, new GridBagConstraints(0, 8, 2, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 2, 0), 0, 0));
        this.mainPanel.add((Component)this.worldOpenTimeLabel, new GridBagConstraints(0, 9, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 2, 0), 0, 0));
        this.mainPanel.add((Component)this.currentRendererLabel, new GridBagConstraints(0, 10, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 2, 0), 0, 0));
        this.mainPanel.add((Component)this.userDefinedQuestionCountLabel, new GridBagConstraints(0, 5, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 2, 0), 0, 0));
    }

    @Override
    public void addOKActionListener(ActionListener l) {
        this.doneButton.addActionListener(l);
    }

    @Override
    public void removeOKActionListener(ActionListener l) {
        this.doneButton.removeActionListener(l);
    }
}

