/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.dialog;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.JAlice;
import edu.cmu.cs.stage3.alice.authoringtool.dialog.AliceAlertContentPane;
import edu.cmu.cs.stage3.alice.authoringtool.dialog.OutputComponent;
import edu.cmu.cs.stage3.lang.Messages;
import edu.cmu.cs.stage3.swing.DialogManager;
import java.awt.Component;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class StdErrOutContentPane
extends AliceAlertContentPane {
    public static final int HISTORY_MODE = 2;
    protected boolean errorDialog = false;
    protected AuthoringTool authoringTool;
    protected OutputComponent errOutputComponent;
    protected OutputComponent stdOutputComponent;
    protected String lastError;
    protected String lastOutput;
    protected String titleString;
    protected boolean isShowing = false;
    protected boolean errorContentAdded = false;
    protected boolean textContentAdded = false;
    protected boolean shouldListenToErrors = true;
    protected boolean shouldListenToPrint = true;

    public StdErrOutContentPane(AuthoringTool authoringTool, boolean errorDialog) {
        if (errorDialog) {
            this.titleString = Messages.getString("Alice___Error_Console");
            this.authoringTool = authoringTool;
            this.errOutputComponent = authoringTool.getStdErrOutputComponent();
            this.writeGenericAliceHeaderToTextPane();
            this.errOutputComponent.getTextPane().getDocument().addDocumentListener(new ErrOutputDocumentListener());
        } else {
            this.titleString = Messages.getString("Alice___Text_Output");
            this.authoringTool = authoringTool;
            this.stdOutputComponent = authoringTool.getStdOutOutputComponent();
            this.stdOutputComponent.getTextPane().getDocument().addDocumentListener(new StdOutputDocumentListener());
        }
    }

    protected void writeGenericAliceHeaderToTextPane() {
        this.detailTextPane.setText("");
        this.detailStream.println(String.valueOf(Messages.getString("Alice_version__")) + JAlice.getVersion());
        String[] systemProperties = new String[]{"os.name", "os.version", "os.arch", "java.vm.name", "java.vm.version", "user.dir"};
        int i = 0;
        while (i < systemProperties.length) {
            this.detailStream.println(String.valueOf(systemProperties[i]) + ": " + System.getProperty(systemProperties[i]));
            ++i;
        }
        this.detailStream.println();
    }

    @Override
    public void preDialogShow(JDialog parentDialog) {
        super.preDialogShow(parentDialog);
    }

    public void stopReactingToPrint() {
        this.shouldListenToPrint = false;
    }

    public void startReactingToPrint() {
        if (this.stdOutputComponent != null) {
            this.stdOutputComponent.stdOutStream.flush();
        }
        this.shouldListenToPrint = true;
    }

    public void stopReactingToError() {
        this.shouldListenToErrors = false;
    }

    public void startReactingToError() {
        if (this.errOutputComponent != null) {
            this.errOutputComponent.stdErrStream.flush();
        }
        this.shouldListenToErrors = true;
    }

    @Override
    public void postDialogShow(JDialog parentDialog) {
        this.isShowing = false;
        this.setMode(0);
        super.postDialogShow(parentDialog);
    }

    public int showStdErrDialog() {
        if (!this.isShowing) {
            this.isShowing = true;
            this.errorDialog = true;
            return DialogManager.showDialog(this);
        }
        return -1;
    }

    public int showStdOutDialog() {
        if (!this.isShowing) {
            this.isShowing = true;
            this.errorDialog = false;
            return DialogManager.showDialog(this);
        }
        return -1;
    }

    @Override
    public String getTitle() {
        return this.titleString;
    }

    protected void setHistoryDetail() {
        this.add((Component)this.detailScrollPane, "Center");
        this.buttonPanel.removeAll();
        this.buttonConstraints.gridx = 0;
        this.buttonPanel.add((Component)this.cancelButton, this.buttonConstraints);
        ++this.buttonConstraints.gridx;
        this.buttonPanel.add((Component)this.copyButton, this.buttonConstraints);
        ++this.buttonConstraints.gridx;
        this.buttonPanel.add((Component)this.cancelButton, this.buttonConstraints);
        ++this.buttonConstraints.gridx;
        this.glueConstraints.gridx = this.buttonConstraints.gridx;
        this.buttonPanel.add(this.buttonGlue, this.glueConstraints);
        if (this.errorContentAdded) {
            this.messageLabel.setText(Messages.getString("Something_bad_has_occurred_"));
        } else if (this.textContentAdded) {
            this.messageLabel.setText(Messages.getString("Nothing_bad_has_occurred_"));
        } else {
            this.messageLabel.setText(Messages.getString("Nothing_bad_has_occurred_"));
        }
    }

    @Override
    protected void setLessDetail() {
        super.setLessDetail();
        this.messageLabel.setText(Messages.getString("An_unknown_error_has_occurred_"));
    }

    @Override
    protected void setMoreDetail() {
        super.setMoreDetail();
        this.messageLabel.setText(Messages.getString("An_unknown_error_has_occurred_"));
    }

    @Override
    protected void handleModeSwitch(int mode) {
        if (mode == 0) {
            this.setLessDetail();
        } else if (mode == 1) {
            this.setMoreDetail();
        } else if (mode == 2) {
            this.setHistoryDetail();
        } else {
            throw new IllegalArgumentException(String.valueOf(Messages.getString("Illegal_mode__")) + mode);
        }
        this.packDialog();
    }

    protected class ErrOutputDocumentListener
    implements DocumentListener {
        protected ErrOutputDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent ev) {
            try {
                StdErrOutContentPane.this.lastError = ev.getDocument().getText(ev.getOffset(), ev.getLength());
                if (StdErrOutContentPane.this.lastError.trim().startsWith(Messages.getString("Unable_to_handle_format"))) {
                    StdErrOutContentPane.this.lastError = String.valueOf(Messages.getString("_n_nYour_sound_file_cannot_be_played_in_Alice__n")) + Messages.getString("Please_find_an_audio_editor_to_convert_the_file_to_one_with_a_PCM_encoding__n") + Messages.getString("See_the_tutorial_on_converting_sound_files_at_our_Alice_website__n") + Messages.getString("Right_click_to_clear_the_messages_here__n_n") + StdErrOutContentPane.this.lastError;
                }
                StdErrOutContentPane.this.detailTextPane.getDocument().insertString(StdErrOutContentPane.this.detailTextPane.getDocument().getLength(), StdErrOutContentPane.this.lastError, StdErrOutContentPane.this.detailTextPane.stdErrStyle);
                if (StdErrOutContentPane.this.lastError.startsWith("java.lang.ClassCastException")) {
                    StdErrOutContentPane.this.lastError = "OOPS!! Looks like we have a slight layout problem. Not a big deal, press OK to continue. \n\n";
                    StdErrOutContentPane.this.detailTextPane.getDocument().insertString(0, StdErrOutContentPane.this.lastError, StdErrOutContentPane.this.detailTextPane.stdErrStyle);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            StdErrOutContentPane.this.errorContentAdded = true;
            this.update();
        }

        @Override
        public void removeUpdate(DocumentEvent ev) {
            this.update();
        }

        @Override
        public void changedUpdate(DocumentEvent ev) {
            this.update();
        }

        private void update() {
            if (StdErrOutContentPane.this.shouldListenToErrors) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (!((ErrOutputDocumentListener)ErrOutputDocumentListener.this).StdErrOutContentPane.this.isShowing) {
                            ((ErrOutputDocumentListener)ErrOutputDocumentListener.this).StdErrOutContentPane.this.isShowing = true;
                            int n = DialogManager.showDialog(StdErrOutContentPane.this);
                        }
                    }
                });
            }
        }
    }

    protected class StdOutputDocumentListener
    implements DocumentListener {
        protected StdOutputDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent ev) {
            try {
                StdErrOutContentPane.this.lastOutput = ev.getDocument().getText(ev.getOffset(), ev.getLength());
                StdErrOutContentPane.this.detailTextPane.getDocument().insertString(StdErrOutContentPane.this.detailTextPane.getDocument().getLength(), StdErrOutContentPane.this.lastOutput, StdErrOutContentPane.this.detailTextPane.stdOutStyle);
            }
            catch (Exception exception) {
                // empty catch block
            }
            StdErrOutContentPane.this.textContentAdded = true;
            this.update();
        }

        @Override
        public void removeUpdate(DocumentEvent ev) {
            this.update();
        }

        @Override
        public void changedUpdate(DocumentEvent ev) {
            this.update();
        }

        private void update() {
            if (StdErrOutContentPane.this.shouldListenToPrint) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (!((StdOutputDocumentListener)StdOutputDocumentListener.this).StdErrOutContentPane.this.isShowing) {
                            ((StdOutputDocumentListener)StdOutputDocumentListener.this).StdErrOutContentPane.this.isShowing = true;
                            int n = DialogManager.showDialog(StdErrOutContentPane.this);
                        }
                    }
                });
            }
        }
    }
}

