/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.dialog;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources;
import edu.cmu.cs.stage3.alice.authoringtool.JAlice;
import edu.cmu.cs.stage3.alice.authoringtool.util.Configuration;
import edu.cmu.cs.stage3.lang.Messages;
import edu.cmu.cs.stage3.swing.ContentPane;
import edu.cmu.cs.stage3.swing.DialogManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class SaveForWebContentPane
extends ContentPane {
    private AuthoringTool authoringTool;
    private boolean ignoreSizeChange = false;
    private Vector m_okActionListeners = new Vector();
    private static Configuration authoringToolConfig = Configuration.getLocalConfiguration(JAlice.class.getPackage());
    private BorderLayout borderLayout1 = new BorderLayout();
    private Border border1;
    private Border setTitleBorder;
    private Border border2;
    private JPanel mainPanel = new JPanel();
    private JFileChooser htmlFileChooser = new JFileChooser();
    private JPanel fileChooserPanel = new JPanel();
    private Border border3;
    private JTextField heightTextField = new JTextField();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private GridBagLayout setTitleGridBagLayout = new GridBagLayout();
    private JTextField widthTextField = new JTextField();
    private JLabel heightLabel = new JLabel();
    private JLabel widthLabel = new JLabel();
    private JCheckBox constrainAspectRatioCheckBox = new JCheckBox();
    private JPanel controlsPanel = new JPanel();
    private JPanel setTitlePanel = new JPanel();
    private JTextField setTitleTextField = new JTextField(Messages.getString("My_Alice_World"));
    private GridBagLayout gridBagLayout2 = new GridBagLayout();
    private Border border4;
    private TitledBorder titledBorder1;
    private GridBagLayout gridBagLayout3 = new GridBagLayout();
    private JPanel directoryPathPanel = new JPanel();
    private String rootDirectoryPath = "c:\\";
    private String localDirectoryPath = Messages.getString("My_Alice_World");
    private JLabel directoryPath = new JLabel(String.valueOf(this.rootDirectoryPath) + this.localDirectoryPath + File.separator);
    private JButton browseDirectoryButton = new JButton(Messages.getString("browse"));
    private JLabel a2wFileName = new JLabel(Messages.getString("My_Alice_World_a2w"));
    private JLabel htmlFileName = new JLabel(Messages.getString("My_Alice_World_html"));
    private JLabel appletLabel = new JLabel("aliceapplet.jar");
    private JTextField authorNameTextField = new JTextField();
    private JLabel authorLabel = new JLabel(Messages.getString("Author_s_name"));
    private String a2wTitle = Messages.getString("Your_world");
    private String htmlTitle = Messages.getString("The_web_page");
    private String appletTitle = Messages.getString("The_Alice_applet");
    private JCheckBox saveDirectoryCheckBox = new JCheckBox();
    private JCheckBox saveCodeCheckBox = new JCheckBox();
    private JLabel filesToSaveLabel = new JLabel(Messages.getString("These_files_will_be_saved_in_this_directory_"));
    private JButton saveButton = new JButton(Messages.getString("Save"));
    private JButton cancelButton = new JButton(Messages.getString("Cancel"));

    public SaveForWebContentPane(AuthoringTool authoringTool) {
        this.authoringTool = authoringTool;
        this.jbInit();
        this.guiInit();
        this.authorNameTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SaveForWebContentPane.this.saveButton.doClick();
            }
        });
    }

    @Override
    public String getTitle() {
        return Messages.getString("Save_World_for_the_Web");
    }

    @Override
    public void addOKActionListener(ActionListener l) {
        this.m_okActionListeners.addElement(l);
    }

    @Override
    public void removeOKActionListener(ActionListener l) {
        this.m_okActionListeners.removeElement(l);
    }

    @Override
    public void addCancelActionListener(ActionListener l) {
        this.cancelButton.addActionListener(l);
    }

    @Override
    public void removeCancelActionListener(ActionListener l) {
        this.cancelButton.removeActionListener(l);
    }

    private void fireOKActionListeners() {
        ActionEvent e = new ActionEvent(this, 1001, Messages.getString("OK"));
        int i = 0;
        while (i < this.m_okActionListeners.size()) {
            ActionListener l = (ActionListener)this.m_okActionListeners.elementAt(i);
            l.actionPerformed(e);
            ++i;
        }
    }

    public File getExportDirectory() {
        return new File(this.directoryPath.getText());
    }

    public String getExportFileName() {
        return this.htmlFileName.getText();
    }

    public String getExportAuthorName() {
        return this.authorNameTextField.getText();
    }

    public int getExportWidth() {
        return Integer.parseInt(this.widthTextField.getText());
    }

    public int getExportHeight() {
        return Integer.parseInt(this.heightTextField.getText());
    }

    public boolean isCodeToBeExported() {
        return this.saveCodeCheckBox.isSelected();
    }

    private void guiInit() {
        this.setSize(575, 510);
        this.widthTextField.setText("320");
        this.heightTextField.setText("240");
        this.constrainAspectRatioCheckBox.setSelected(true);
        this.widthTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent ev) {
                this.updateHeightTextField();
            }

            @Override
            public void removeUpdate(DocumentEvent ev) {
                this.updateHeightTextField();
            }

            private void updateHeightTextField() {
                if (SaveForWebContentPane.this.constrainAspectRatioCheckBox.isSelected() && !SaveForWebContentPane.this.ignoreSizeChange) {
                    SaveForWebContentPane.this.ignoreSizeChange = true;
                    double aspectRatio = AuthoringToolResources.getAspectRatio(SaveForWebContentPane.this.authoringTool.getWorld());
                    int width = -1;
                    try {
                        width = Integer.parseInt(SaveForWebContentPane.this.widthTextField.getText());
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (width > 0) {
                        SaveForWebContentPane.this.heightTextField.setText(Integer.toString((int)((double)width / aspectRatio)));
                    }
                    SaveForWebContentPane.this.ignoreSizeChange = false;
                }
            }

            @Override
            public void changedUpdate(DocumentEvent ev) {
            }
        });
        this.heightTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent ev) {
                this.updateWidthTextField();
            }

            @Override
            public void removeUpdate(DocumentEvent ev) {
                this.updateWidthTextField();
            }

            private void updateWidthTextField() {
                if (SaveForWebContentPane.this.constrainAspectRatioCheckBox.isSelected() && !SaveForWebContentPane.this.ignoreSizeChange) {
                    SaveForWebContentPane.this.ignoreSizeChange = true;
                    double aspectRatio = AuthoringToolResources.getAspectRatio(SaveForWebContentPane.this.authoringTool.getWorld());
                    int height = -1;
                    try {
                        height = Integer.parseInt(SaveForWebContentPane.this.heightTextField.getText());
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (height > 0) {
                        SaveForWebContentPane.this.widthTextField.setText(Integer.toString((int)(aspectRatio * (double)height)));
                    }
                    SaveForWebContentPane.this.ignoreSizeChange = false;
                }
            }

            @Override
            public void changedUpdate(DocumentEvent ev) {
            }
        });
        this.setTitleTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent ev) {
                SaveForWebContentPane.this.updateTextFields();
            }

            @Override
            public void removeUpdate(DocumentEvent ev) {
                SaveForWebContentPane.this.updateTextFields();
            }

            @Override
            public void changedUpdate(DocumentEvent ev) {
            }
        });
        this.saveDirectoryCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SaveForWebContentPane.this.updateDirectory();
            }
        });
        this.saveCodeCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SaveForWebContentPane.this.updateTextFields();
            }
        });
        this.browseDirectoryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogManager.showDialog(SaveForWebContentPane.this.htmlFileChooser, Messages.getString("Set_directory"));
            }
        });
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String authorName = SaveForWebContentPane.this.authorNameTextField.getText();
                if (authorName.length() > 0) {
                    int width;
                    try {
                        width = Integer.parseInt(SaveForWebContentPane.this.widthTextField.getText());
                    }
                    catch (NumberFormatException nfe) {
                        width = -1;
                    }
                    if (width > 0) {
                        int height;
                        try {
                            height = Integer.parseInt(SaveForWebContentPane.this.heightTextField.getText());
                        }
                        catch (NumberFormatException nfe) {
                            height = -1;
                        }
                        if (height > 0) {
                            SaveForWebContentPane.this.fireOKActionListeners();
                        } else {
                            DialogManager.showMessageDialog(Messages.getString("You_must_enter_a_valid_height__a_number_greater_than_0__before_proceeding_"), Messages.getString("You_have_not_entered_a_valid_height_"), 2);
                        }
                    } else {
                        DialogManager.showMessageDialog(Messages.getString("You_must_enter_a_valid_width__a_number_greater_than_0__before_proceeding_"), Messages.getString("You_have_not_entered_a_valid_width_"), 2);
                    }
                } else {
                    DialogManager.showMessageDialog(Messages.getString("You_must_enter_the_author_s_name_before_proceeding_"), Messages.getString("You_have_not_entered_the_author_s_name"), 2);
                }
            }
        });
        File currentDir = new File(authoringToolConfig.getValue("directories.worldsDirectory"));
        try {
            if (currentDir.exists()) {
                this.rootDirectoryPath = String.valueOf(currentDir.getAbsolutePath()) + File.separator;
                this.htmlFileChooser.setCurrentDirectory(currentDir);
            } else {
                this.rootDirectoryPath = String.valueOf(JAlice.getAliceUserDirectory().getAbsolutePath()) + File.separator;
                this.htmlFileChooser.setCurrentDirectory(JAlice.getAliceUserDirectory());
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        this.updateDirectory();
        this.htmlFileChooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (ev.getActionCommand().equals("ApproveSelection")) {
                    File file = SaveForWebContentPane.this.htmlFileChooser.getSelectedFile();
                    SaveForWebContentPane.this.rootDirectoryPath = String.valueOf(file.getAbsolutePath()) + File.separator;
                    SaveForWebContentPane.this.updateDirectory();
                } else {
                    ev.getActionCommand().equals("CancelSelection");
                }
            }
        });
    }

    @Override
    public void setVisible(boolean visibility) {
        File currentName;
        super.setVisible(visibility);
        if (visibility && this.authoringTool != null && (currentName = this.authoringTool.getCurrentWorldLocation()) != null) {
            String newTitle = currentName.getName();
            newTitle = newTitle.substring(0, newTitle.lastIndexOf("."));
            this.setTitleTextField.setText(newTitle);
            this.updateDirectory();
            this.updateTextFields();
            this.updateRatio();
        }
    }

    private String getValidFilename(String newValue) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < newValue.length()) {
            char c = newValue.charAt(i);
            switch (c) {
                case ' ': 
                case '\"': 
                case '*': 
                case '/': 
                case ':': 
                case '<': 
                case '>': 
                case '?': 
                case '\\': 
                case '|': {
                    sb.append('_');
                    break;
                }
                default: {
                    sb.append(c);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    private void updateDirectory() {
        if (this.saveDirectoryCheckBox.isSelected()) {
            this.localDirectoryPath = this.getValidFilename(this.setTitleTextField.getText());
            this.directoryPath.setText(String.valueOf(this.rootDirectoryPath) + this.localDirectoryPath + File.separator);
        } else {
            this.directoryPath.setText(this.rootDirectoryPath);
        }
    }

    private void updateTextFields() {
        String newValue = this.getValidFilename(this.setTitleTextField.getText());
        if (this.saveDirectoryCheckBox.isSelected()) {
            this.updateDirectory();
        }
        this.a2wFileName.setText(String.valueOf(newValue) + ".a2w");
        this.htmlFileName.setText(String.valueOf(newValue) + ".html");
    }

    private void updateRatio() {
        if (this.constrainAspectRatioCheckBox.isSelected()) {
            double aspectRatio = AuthoringToolResources.getAspectRatio(this.authoringTool.getWorld());
            int width = -1;
            int height = -1;
            try {
                width = Integer.parseInt(this.widthTextField.getText());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                height = Integer.parseInt(this.heightTextField.getText());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (width > 0) {
                height = (int)((double)width / aspectRatio);
                this.heightTextField.setText(Integer.toString(height));
            } else if (height > 0) {
                width = (int)(aspectRatio * (double)height);
                this.widthTextField.setText(Integer.toString(width));
            }
        }
    }

    void constrainAspectRatioCheckBox_actionPerformed(ActionEvent ev) {
        this.updateRatio();
    }

    private void jbInit() {
        this.border1 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(142, 142, 142)), Messages.getString("Size_in_browser"));
        this.setTitleBorder = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(142, 142, 142)), Messages.getString("Title"));
        this.border2 = BorderFactory.createEmptyBorder(8, 8, 0, 8);
        this.border3 = BorderFactory.createEmptyBorder(12, 12, 12, 12);
        this.border4 = BorderFactory.createEtchedBorder(Color.white, new Color(142, 142, 142));
        this.titledBorder1 = new TitledBorder(this.border4, Messages.getString("Save_Location"));
        this.fileChooserPanel.setLayout(this.gridBagLayout3);
        this.setLayout(this.borderLayout1);
        this.mainPanel.setLayout(this.gridBagLayout2);
        this.mainPanel.setBorder(this.border3);
        this.heightTextField.setColumns(6);
        this.widthTextField.setColumns(6);
        this.heightLabel.setText(Messages.getString("height_"));
        this.widthLabel.setText(Messages.getString("width_"));
        this.setTitleTextField.setColumns(36);
        this.authorNameTextField.setColumns(28);
        this.constrainAspectRatioCheckBox.setText(Messages.getString("constrain_aspect_ratio"));
        this.constrainAspectRatioCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SaveForWebContentPane.this.constrainAspectRatioCheckBox_actionPerformed(e);
            }
        });
        this.controlsPanel.setLayout(this.gridBagLayout1);
        this.controlsPanel.setBorder(this.border1);
        this.setTitlePanel.setLayout(this.setTitleGridBagLayout);
        this.setTitlePanel.setBorder(this.setTitleBorder);
        this.fileChooserPanel.setBorder(this.titledBorder1);
        this.htmlFileChooser.setFileSelectionMode(1);
        int fontSize = Integer.parseInt(authoringToolConfig.getValue("fontSize"));
        this.directoryPathPanel.setPreferredSize(new Dimension(300, fontSize * 2 - 5));
        this.directoryPathPanel.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        this.directoryPathPanel.setLayout(new BorderLayout());
        this.directoryPathPanel.add((Component)this.directoryPath, "Center");
        this.add((Component)this.mainPanel, "Center");
        this.filesToSaveLabel.setForeground(Color.black);
        this.saveDirectoryCheckBox.setSelected(true);
        this.saveDirectoryCheckBox.setText(Messages.getString("Use_title_to_create_new_directory_for_the_files_below"));
        this.saveCodeCheckBox.setSelected(false);
        this.saveCodeCheckBox.setText(Messages.getString("Add_the_code_for_this_world_to_this_page"));
        this.a2wFileName.setToolTipText(this.a2wTitle);
        this.a2wFileName.setBounds(2, 2, 2, 2);
        this.htmlFileName.setToolTipText(this.htmlTitle);
        this.htmlFileName.setBounds(2, 2, 2, 2);
        this.appletLabel.setToolTipText(this.appletTitle);
        this.appletLabel.setBounds(2, 2, 2, 2);
        this.setTitlePanel.add((Component)this.setTitleTextField, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 17, 0, new Insets(4, 4, 4, 4), 0, 0));
        this.setTitlePanel.add((Component)this.authorNameTextField, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 4, 0, 0), 0, 0));
        this.setTitlePanel.add((Component)this.authorLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 4, 0, 0), 0, 0));
        this.controlsPanel.add((Component)this.widthLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 14, 0, new Insets(0, 20, 4, 4), 0, 0));
        this.controlsPanel.add((Component)this.widthTextField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 16, 0, new Insets(0, 0, 4, 0), 0, 0));
        this.controlsPanel.add((Component)this.heightLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 14, 0, new Insets(0, 20, 4, 4), 0, 0));
        this.controlsPanel.add((Component)this.heightTextField, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 16, 0, new Insets(0, 0, 4, 0), 0, 0));
        this.controlsPanel.add((Component)this.constrainAspectRatioCheckBox, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 16, 0, new Insets(0, 0, 4, 0), 0, 0));
        this.fileChooserPanel.add((Component)this.directoryPathPanel, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 17, 2, new Insets(4, 8, 0, 8), 0, 0));
        this.fileChooserPanel.add((Component)this.browseDirectoryButton, new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(4, 0, 0, 8), 0, 0));
        this.fileChooserPanel.add((Component)this.saveDirectoryCheckBox, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 0, new Insets(2, 8, 4, 0), 0, 0));
        this.fileChooserPanel.add((Component)this.saveCodeCheckBox, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 17, 0, new Insets(2, 8, 4, 0), 0, 0));
        this.fileChooserPanel.add((Component)this.filesToSaveLabel, new GridBagConstraints(0, 3, 2, 1, 1.0, 1.0, 18, 0, new Insets(4, 10, 0, 0), 0, 0));
        this.fileChooserPanel.add((Component)this.a2wFileName, new GridBagConstraints(0, 4, 2, 1, 1.0, 1.0, 18, 0, new Insets(2, 20, 0, 0), 0, 0));
        this.fileChooserPanel.add((Component)this.htmlFileName, new GridBagConstraints(0, 5, 2, 1, 1.0, 1.0, 18, 0, new Insets(4, 20, 0, 0), 0, 0));
        this.fileChooserPanel.add((Component)this.appletLabel, new GridBagConstraints(0, 6, 2, 1, 1.0, 1.0, 18, 0, new Insets(4, 20, 0, 0), 0, 0));
        this.mainPanel.add((Component)this.setTitlePanel, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 12, 0), 0, 0));
        this.mainPanel.add((Component)this.controlsPanel, new GridBagConstraints(0, 1, 3, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 12, 0), 0, 0));
        this.mainPanel.add((Component)this.fileChooserPanel, new GridBagConstraints(0, 2, 3, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.mainPanel.add(Box.createHorizontalGlue(), new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.mainPanel.add((Component)this.saveButton, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(4, 0, 4, 0), 0, 0));
        this.mainPanel.add((Component)this.cancelButton, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(4, 4, 4, 0), 0, 0));
    }
}

