/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.dialog;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.JAlice;
import edu.cmu.cs.stage3.alice.authoringtool.dialog.OutputComponent;
import edu.cmu.cs.stage3.alice.authoringtool.util.Configuration;
import edu.cmu.cs.stage3.alice.authoringtool.util.StyledStreamTextPane;
import edu.cmu.cs.stage3.alice.authoringtool.util.WatcherPanel;
import edu.cmu.cs.stage3.lang.Messages;
import edu.cmu.cs.stage3.swing.ContentPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.text.NumberFormat;
import java.util.StringTokenizer;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class RenderContentPane
extends ContentPane {
    protected JPanel renderPanel = new JPanel(new BorderLayout());
    protected JPanel buttonPanel = new JPanel(new GridBagLayout());
    protected JSplitPane stdOutSplitPane = new JSplitPane(0);
    protected Configuration config = Configuration.getLocalConfiguration(JAlice.class.getPackage());
    protected double aspectRatio;
    protected AuthoringTool authoringTool;
    protected boolean showStdOut = false;
    protected int stdOutHeight = 100;
    protected int watcherWidth = 200;
    protected OutputComponent stdOutOutputComponent;
    protected WatcherPanel watcherPanel;
    protected JScrollPane watcherScrollPane;
    protected JSplitPane watcherSplitPane = new JSplitPane(1);
    protected JButton pauseButton;
    protected JButton resumeButton;
    protected JButton restartButton;
    protected JButton stopButton;
    protected JButton takePictureButton;
    protected JSlider speedSlider;
    protected JLabel speedLabel;
    protected RenderCanvasFocusListener renderCanvasFocusListener = new RenderCanvasFocusListener();
    protected boolean shiftIsDown = false;
    protected JScrollPane textScrollPane;
    protected StyledStreamTextPane detailTextPane = new StyledStreamTextPane();
    protected boolean doNotListenToSpeedSlider = false;
    protected boolean doNotListenToResize = false;
    protected final int dividerSize = 8;
    protected String title;
    protected ActionListener okActionListener;
    protected TextOutputDocumentListener textListener = new TextOutputDocumentListener();

    public RenderContentPane(AuthoringTool authoringTool) {
        this.authoringTool = authoringTool;
        this.stdOutOutputComponent = authoringTool.getStdOutOutputComponent();
        this.watcherPanel = authoringTool.getWatcherPanel();
        this.guiInit();
    }

    public void setAspectRatio(double aspectRatio) {
        this.aspectRatio = aspectRatio;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String newTitle) {
        this.title = newTitle;
    }

    protected void setRenderWindowSizeBasedOnSavedBounds() {
        Rectangle bounds = this.getRenderBounds();
        this.renderPanel.setPreferredSize(new Dimension(bounds.width, bounds.height));
    }

    @Override
    public void preDialogShow(JDialog parentDialog) {
        super.preDialogShow(parentDialog);
        final Component renderCanvas = this.getRenderCanvas();
        if (renderCanvas != null) {
            renderCanvas.addFocusListener(this.renderCanvasFocusListener);
            Timer focusTimer = new Timer(100, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    renderCanvas.requestFocus();
                }
            });
            focusTimer.setRepeats(false);
            focusTimer.start();
        }
        this.stdOutOutputComponent.stdOutStream.println(Messages.getString("Running_World"));
        this.stdOutOutputComponent.stdOutStream.flush();
        this.stdOutOutputComponent.getTextPane().getDocument().addDocumentListener(this.textListener);
        Rectangle bounds = this.getRenderBounds();
        this.renderPanel.setPreferredSize(new Dimension(bounds.width, bounds.height));
        parentDialog.setLocation(bounds.getLocation());
        this.showStdOut = false;
        this.keyMapInit();
        this.updateGUI();
        if (this.config.getValue("rendering.ensureRenderDialogIsOnScreen").equalsIgnoreCase("true")) {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension dialogSize = parentDialog.getSize();
            Point dialogLocation = parentDialog.getLocation();
            Rectangle screenRect = new Rectangle(0, 0, screenSize.width, screenSize.height);
            if (!SwingUtilities.isRectangleContainingRectangle(screenRect, parentDialog.getBounds())) {
                if (dialogLocation.x + dialogSize.width > screenSize.width) {
                    dialogLocation.x = screenSize.width - dialogSize.width;
                }
                if (dialogLocation.x < 0) {
                    dialogLocation.x = 0;
                }
                if (dialogLocation.y + dialogSize.height > screenSize.height) {
                    dialogLocation.y = screenSize.height - dialogSize.height;
                }
                if (dialogLocation.y < 0) {
                    dialogLocation.y = 0;
                }
                if (this.config.getValue("rendering.constrainRenderDialogAspectRatio").equalsIgnoreCase("false")) {
                    Dimension renderSize;
                    if (dialogSize.width > screenSize.width) {
                        renderSize = this.renderPanel.getPreferredSize();
                        renderSize.width = screenSize.width - 8;
                        this.renderPanel.setPreferredSize(renderSize);
                    }
                    if (dialogSize.height > screenSize.height) {
                        renderSize = this.renderPanel.getPreferredSize();
                        renderSize.height = screenSize.height - 27;
                        this.renderPanel.setPreferredSize(renderSize);
                    }
                } else if (dialogSize.height > screenSize.height || dialogSize.width > screenSize.width) {
                    double windowAspect = (double)screenSize.width / (double)screenSize.height;
                    if (this.aspectRatio > windowAspect) {
                        Dimension renderSize = this.renderPanel.getPreferredSize();
                        renderSize.width = screenSize.width - 8;
                        renderSize.height = (int)Math.round((double)renderSize.width / this.aspectRatio);
                        this.renderPanel.setPreferredSize(renderSize);
                    } else {
                        Dimension renderSize = this.renderPanel.getPreferredSize();
                        renderSize.height = screenSize.height - 27;
                        renderSize.width = (int)Math.round((double)renderSize.height * this.aspectRatio);
                        this.renderPanel.setPreferredSize(renderSize);
                    }
                }
                parentDialog.setLocation(dialogLocation);
                this.authoringTool.getJAliceFrame().sceneEditor.makeDirty();
                this.renderPanel.invalidate();
                parentDialog.pack();
            }
        }
    }

    @Override
    public void postDialogShow(JDialog parentDialog) {
        Component renderCanvas;
        super.postDialogShow(parentDialog);
        this.authoringTool.worldStopRunning();
        this.speedSlider.setValue(0);
        this.saveRenderBounds();
        this.showStdOut = false;
        if (this.config.getValue("clearStdOutOnRun").equalsIgnoreCase("true")) {
            this.detailTextPane.setText("");
        }
        if ((renderCanvas = this.getRenderCanvas()) != null) {
            renderCanvas.removeFocusListener(this.renderCanvasFocusListener);
        }
        this.stdOutOutputComponent.getTextPane().getDocument().removeDocumentListener(this.textListener);
        this.stdOutOutputComponent.stdOutStream.println(String.valueOf(Messages.getString("Stopping_World")) + "\n");
        this.stdOutOutputComponent.stdOutStream.flush();
    }

    @Override
    public void addOKActionListener(ActionListener l) {
        this.okActionListener = l;
        this.stopButton.addActionListener(l);
    }

    @Override
    public void removeOKActionListener(ActionListener l) {
        this.okActionListener = null;
        this.stopButton.removeActionListener(l);
    }

    private void guiInit() {
        this.title = Messages.getString("Alice_World");
        this.setRenderWindowSizeBasedOnSavedBounds();
        this.watcherScrollPane = new JScrollPane(this.watcherPanel, 20, 30);
        this.textScrollPane = new JScrollPane(this.detailTextPane, 20, 30);
        this.detailTextPane.setEditable(false);
        this.pauseButton = new JButton(this.authoringTool.getActions().pauseWorldAction);
        this.resumeButton = new JButton(this.authoringTool.getActions().resumeWorldAction);
        this.restartButton = new JButton(this.authoringTool.getActions().restartWorldAction);
        this.stopButton = new JButton(this.authoringTool.getActions().stopWorldAction);
        this.takePictureButton = new JButton(this.authoringTool.getActions().takePictureAction);
        this.takePictureButton.setEnabled(true);
        this.speedLabel = new JLabel(Messages.getString("Speed__1x"));
        int fontSize = Integer.parseInt(this.config.getValue("fontSize"));
        this.speedLabel.setFont(new Font("SansSerif", 1, (int)((double)(12 * fontSize) / 12.0)));
        this.speedLabel.setPreferredSize(new Dimension(80, 12));
        this.speedLabel.setMinimumSize(new Dimension(20, 12));
        this.speedLabel.setMaximumSize(new Dimension(80, 12));
        this.pauseButton.setMargin(new Insets(3, 2, 3, 2));
        this.resumeButton.setMargin(new Insets(3, 2, 3, 2));
        this.restartButton.setMargin(new Insets(3, 2, 3, 2));
        this.stopButton.setMargin(new Insets(3, 2, 3, 2));
        this.takePictureButton.setMargin(new Insets(3, 2, 3, 2));
        this.speedSlider = new JSlider(0, 9, 0);
        this.speedSlider.setPreferredSize(new Dimension(100, 16));
        this.speedSlider.setMinimumSize(new Dimension(40, 16));
        this.speedSlider.setMaximumSize(new Dimension(100, 16));
        this.speedSlider.setSnapToTicks(true);
        this.speedSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent ce) {
                Component renderCanvas;
                JSlider s = (JSlider)ce.getSource();
                if (!RenderContentPane.this.doNotListenToSpeedSlider) {
                    int value = s.getValue();
                    if (value >= 0) {
                        RenderContentPane.this.updateSpeed((double)value + 1.0);
                    } else if (value < 0) {
                        RenderContentPane.this.updateSpeed(1.0 / (double)(1 + value * -1));
                    }
                }
                if ((renderCanvas = RenderContentPane.this.getRenderCanvas()) != null && renderCanvas.isShowing()) {
                    renderCanvas.requestFocus();
                }
            }
        });
        this.buttonPanel.add((Component)this.speedSlider, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        this.buttonPanel.add((Component)this.pauseButton, new GridBagConstraints(2, 0, 1, 2, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.buttonPanel.add((Component)this.speedLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 2, 0, 2), 0, 0));
        this.buttonPanel.add((Component)this.resumeButton, new GridBagConstraints(5, 0, 1, 2, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.buttonPanel.add((Component)this.restartButton, new GridBagConstraints(6, 0, 1, 2, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.buttonPanel.add((Component)this.stopButton, new GridBagConstraints(7, 0, 1, 2, 0.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.buttonPanel.add((Component)this.takePictureButton, new GridBagConstraints(8, 0, 1, 2, 1.0, 0.0, 13, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.watcherSplitPane = new JSplitPane(1);
        this.watcherSplitPane.setContinuousLayout(true);
        this.watcherSplitPane.setDividerSize(0);
        this.watcherSplitPane.setResizeWeight(1.0);
        this.watcherSplitPane.setLeftComponent(this.renderPanel);
        this.stdOutSplitPane = new JSplitPane(0);
        this.stdOutSplitPane.setContinuousLayout(true);
        this.stdOutSplitPane.setDividerSize(0);
        this.stdOutSplitPane.setResizeWeight(1.0);
        this.stdOutSplitPane.setTopComponent(this.watcherSplitPane);
        this.setLayout(new BorderLayout());
        this.add((Component)this.buttonPanel, "North");
        this.add((Component)this.stdOutSplitPane, "Center");
        this.updateGUI();
    }

    private void keyMapInit() {
        for (Action action : this.authoringTool.getActions().renderActions) {
            Component root;
            String commandKey;
            KeyStroke keyStroke;
            try {
                keyStroke = (KeyStroke)action.getValue("AcceleratorKey");
                commandKey = (String)action.getValue("ActionCommandKey");
            }
            catch (ClassCastException e) {
                continue;
            }
            if (keyStroke == null || commandKey == null || !((root = SwingUtilities.getRoot(this)) instanceof JDialog)) continue;
            ((JDialog)root).getRootPane().registerKeyboardAction(action, commandKey, keyStroke, 2);
        }
    }

    public void saveRenderBounds() {
        Point pos = new Point(0, 0);
        Dimension size = this.renderPanel.getSize();
        Component root = SwingUtilities.getRoot(this);
        if (root instanceof JDialog) {
            SwingUtilities.convertPointToScreen(pos, root);
        } else {
            SwingUtilities.convertPointToScreen(pos, this.renderPanel);
        }
        this.config.setValue("rendering.renderWindowBounds", String.valueOf(pos.x) + ", " + pos.y + ", " + size.width + ", " + size.height);
    }

    public void saveRenderBounds(Rectangle newBounds) {
        this.config.setValue("rendering.renderWindowBounds", String.valueOf(newBounds.x) + ", " + newBounds.y + ", " + newBounds.width + ", " + newBounds.height);
    }

    protected boolean shouldConstrainAspectOnResize() {
        return !this.showStdOut && !this.authoringTool.getWatcherPanel().isThereSomethingToWatch() && this.config.getValue("rendering.constrainRenderDialogAspectRatio").equalsIgnoreCase("true");
    }

    public JPanel getRenderPanel() {
        return this.renderPanel;
    }

    public Rectangle getRenderBounds() {
        String boundsString = this.config.getValue("rendering.renderWindowBounds");
        StringTokenizer st = new StringTokenizer(boundsString, " \t,");
        if (st.countTokens() == 4) {
            try {
                int x = Integer.parseInt(st.nextToken());
                int y = Integer.parseInt(st.nextToken());
                int width = Integer.parseInt(st.nextToken());
                int height = Integer.parseInt(st.nextToken());
                Rectangle bounds = new Rectangle(x, y, width, height);
                double currentAspectRatio = (double)width / (double)height;
                if (this.shouldConstrainAspectOnResize()) {
                    this.constrainToAspectRatio(bounds, currentAspectRatio > 1.0);
                }
                return bounds;
            }
            catch (NumberFormatException e) {
                AuthoringTool.showErrorDialog(Messages.getString("Parse_error_in_config_value__rendering_renderWindowBounds"), e);
            }
        } else {
            AuthoringTool.showErrorDialog(Messages.getString("Incorrect_number_of_tokens_in_config_value__rendering_renderWindowBounds"), null);
        }
        return null;
    }

    public void constrainToAspectRatio(Rectangle bounds, boolean stretchHorizontally) {
        if (this.aspectRatio > 0.0) {
            if (stretchHorizontally) {
                bounds.width = (int)Math.round((double)bounds.height * this.aspectRatio);
            } else {
                bounds.height = (int)Math.round((double)bounds.width / this.aspectRatio);
            }
        }
    }

    public void updateSpeed(double newSpeed) {
        this.authoringTool.setWorldSpeed(newSpeed);
        String speedText = NumberFormat.getInstance().format(newSpeed);
        if (newSpeed < 1.0) {
            if (newSpeed == 0.5) {
                speedText = "1/2";
            } else if (newSpeed == 0.25) {
                speedText = "1/4";
            } else if (newSpeed == 0.2) {
                speedText = "1/5";
            } else if (newSpeed > 0.3 && newSpeed < 0.34) {
                speedText = "1/3";
            } else if (newSpeed > 0.16 && newSpeed < 0.168) {
                speedText = "1/6";
            } else if (newSpeed > 0.14 && newSpeed < 0.143) {
                speedText = "1/7";
            }
        }
        this.speedLabel.setText(String.valueOf(Messages.getString("Speed__")) + speedText + "x");
        this.speedLabel.repaint();
    }

    public void setSpeedSliderValue(int value) {
        this.speedSlider.setValue(value);
    }

    public void stopWorld() {
        if (this.okActionListener != null) {
            this.okActionListener.actionPerformed(null);
        }
    }

    public void updateGUI() {
        int renderWidth = this.renderPanel.getWidth();
        int renderHeight = this.renderPanel.getHeight();
        if (this.showStdOut) {
            this.textScrollPane.setPreferredSize(new Dimension(renderWidth, this.stdOutHeight));
            this.stdOutSplitPane.setBottomComponent(this.textScrollPane);
            this.stdOutSplitPane.setDividerSize(8);
        } else {
            this.stdOutSplitPane.setBottomComponent(null);
            this.stdOutSplitPane.setDividerLocation(0);
            this.stdOutSplitPane.setDividerSize(0);
        }
        if (this.authoringTool.getWatcherPanel().isThereSomethingToWatch()) {
            this.watcherScrollPane.setPreferredSize(new Dimension(this.watcherWidth, renderHeight));
            this.watcherSplitPane.setRightComponent(this.watcherScrollPane);
            this.watcherSplitPane.setDividerSize(8);
        } else {
            this.watcherSplitPane.setRightComponent(null);
            this.watcherSplitPane.setDividerLocation(0);
            this.watcherSplitPane.setDividerSize(0);
        }
        this.packDialog();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.showStdOut = false;
        this.updateGUI();
    }

    public Component getRenderCanvas() {
        Component authoringToolRenderPanel = this.renderPanel.getComponent(0);
        if (authoringToolRenderPanel instanceof Container) {
            return ((Container)authoringToolRenderPanel).getComponent(0);
        }
        return null;
    }

    public class RenderCanvasFocusListener
    extends FocusAdapter {
        public void focusLost() {
            Component renderCanvas = RenderContentPane.this.getRenderCanvas();
            if (renderCanvas != null && renderCanvas.isShowing()) {
                renderCanvas.requestFocus();
            }
        }
    }

    protected class RenderComponentListener
    extends ComponentAdapter {
        protected RenderComponentListener() {
        }

        @Override
        public void componentResized(ComponentEvent ev) {
            if (RenderContentPane.this.shouldConstrainAspectOnResize() && !RenderContentPane.this.doNotListenToResize) {
                int deltaHeight;
                RenderContentPane.this.doNotListenToResize = true;
                Rectangle oldBounds = RenderContentPane.this.getRenderBounds();
                Dimension newSize = RenderContentPane.this.renderPanel.getSize();
                Rectangle newBounds = new Rectangle(oldBounds.getLocation(), newSize);
                int deltaWidth = Math.abs(oldBounds.width - newSize.width);
                RenderContentPane.this.constrainToAspectRatio(newBounds, deltaWidth < (deltaHeight = Math.abs(oldBounds.height - newSize.height)));
                RenderContentPane.this.config.setValue("rendering.renderWindowBounds", String.valueOf(newBounds.x) + ", " + newBounds.y + ", " + newBounds.width + ", " + newBounds.height);
                RenderContentPane.this.renderPanel.setPreferredSize(new Dimension(newBounds.width, newBounds.height));
                RenderContentPane.this.buttonPanel.setPreferredSize(new Dimension(newBounds.width, RenderContentPane.this.buttonPanel.getHeight()));
                RenderContentPane.this.packDialog();
                RenderContentPane.this.doNotListenToResize = false;
            }
        }
    }

    protected class TextOutputDocumentListener
    implements DocumentListener {
        protected TextOutputDocumentListener() {
        }

        @Override
        public void insertUpdate(final DocumentEvent ev) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        String textUpdate = ev.getDocument().getText(ev.getOffset(), ev.getLength());
                        ((TextOutputDocumentListener)TextOutputDocumentListener.this).RenderContentPane.this.detailTextPane.getDocument().insertString(((TextOutputDocumentListener)TextOutputDocumentListener.this).RenderContentPane.this.detailTextPane.getDocument().getLength(), textUpdate, ((TextOutputDocumentListener)TextOutputDocumentListener.this).RenderContentPane.this.detailTextPane.stdOutStyle);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    TextOutputDocumentListener.this.update();
                }
            });
        }

        @Override
        public void removeUpdate(DocumentEvent ev) {
            this.update();
        }

        @Override
        public void changedUpdate(DocumentEvent ev) {
            this.update();
        }

        private void update() {
            if (!RenderContentPane.this.showStdOut) {
                RenderContentPane.this.saveRenderBounds();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        RenderContentPane.this.updateGUI();
                        ((TextOutputDocumentListener)TextOutputDocumentListener.this).RenderContentPane.this.showStdOut = true;
                        Component renderCanvas = RenderContentPane.this.getRenderCanvas();
                        if (renderCanvas != null) {
                            renderCanvas.requestFocus();
                        }
                    }
                });
            }
        }
    }
}

