/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.dialog;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources;
import edu.cmu.cs.stage3.alice.authoringtool.dialog.NewNamedElementContentPane;
import edu.cmu.cs.stage3.alice.authoringtool.util.Configuration;
import edu.cmu.cs.stage3.alice.authoringtool.util.GUIFactory;
import edu.cmu.cs.stage3.alice.authoringtool.util.ObjectArrayPropertyEditor;
import edu.cmu.cs.stage3.alice.authoringtool.util.PopupItemFactory;
import edu.cmu.cs.stage3.alice.authoringtool.util.SetPropertyImmediatelyFactory;
import edu.cmu.cs.stage3.alice.authoringtool.util.TypeChooser;
import edu.cmu.cs.stage3.alice.authoringtool.viewcontroller.ElementPropertyViewController;
import edu.cmu.cs.stage3.alice.authoringtool.viewcontroller.PropertyViewController;
import edu.cmu.cs.stage3.alice.core.Array;
import edu.cmu.cs.stage3.alice.core.Collection;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.List;
import edu.cmu.cs.stage3.alice.core.Variable;
import edu.cmu.cs.stage3.lang.Messages;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class NewNamedTypedElementContentPane
extends NewNamedElementContentPane {
    private static final int INSET = 8;
    private TypeChooser m_typeChooser;
    private PopupItemFactory factory;
    private Element context;
    private JPanel valuePanel;
    private JComponent placeholder;
    private JComponent pad;
    private JComponent valueComponent;
    private JComponent valuesComponent;
    protected JLabel valueLabel;
    private JComponent valueViewController;
    public JCheckBox makeCollectionCheckBox;
    private JComboBox collectionTypeCombo;
    private ObjectArrayPropertyEditor objectArrayPropertyEditor;
    private JScrollPane objectArrayScrollPane;
    private Variable m_variable;
    protected boolean listsOnly;
    protected boolean showValue;

    protected void initVariables() {
        this.listsOnly = false;
        this.showValue = true;
    }

    @Override
    protected void initTopComponents(GridBagConstraints gbc) {
        super.initTopComponents(gbc);
        this.initVariables();
        Configuration authoringToolConfig = Configuration.getLocalConfiguration(AuthoringTool.class.getPackage());
        this.m_typeChooser = new TypeChooser(this.getValidityChecker());
        this.valuePanel = new JPanel();
        this.valuePanel.setLayout(new GridBagLayout());
        this.valueLabel = new JLabel();
        this.valuesComponent = new JPanel();
        this.valuesComponent.setBorder(null);
        this.valuesComponent.setOpaque(false);
        this.valuesComponent.setLayout(new BorderLayout());
        this.valueComponent = new JPanel();
        this.valueComponent.setBorder(null);
        this.valueComponent.setOpaque(false);
        this.valueComponent.setLayout(new BorderLayout());
        this.m_variable = new Variable();
        this.factory = new SetPropertyImmediatelyFactory(this.m_variable.value);
        this.objectArrayPropertyEditor = new ObjectArrayPropertyEditor();
        this.objectArrayScrollPane = new JScrollPane(this.objectArrayPropertyEditor);
        this.objectArrayScrollPane.setPreferredSize(new Dimension(1, 150));
        this.makeCollectionCheckBox = new JCheckBox(Messages.getString("make_a"));
        int fontSize = Integer.parseInt(authoringToolConfig.getValue("fontSize"));
        this.makeCollectionCheckBox.setFont(new Font("SansSerif", 1, (int)((double)(12 * fontSize) / 12.0)));
        this.makeCollectionCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewNamedTypedElementContentPane.this.refreshValuePanel();
            }
        });
        this.m_typeChooser.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent ev) {
                NewNamedTypedElementContentPane.this.refreshValuePanel();
            }
        });
        this.collectionTypeCombo = new JComboBox();
        this.collectionTypeCombo.addItem(new makeObj("List"));
        this.collectionTypeCombo.addItem(new makeObj("Array"));
        this.collectionTypeCombo.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (value instanceof Class) {
                    String className = ((Class)value).getName();
                    value = className.substring(className.lastIndexOf(".") + 1);
                }
                return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            }
        });
        this.collectionTypeCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                NewNamedTypedElementContentPane.this.refreshValuePanel();
            }
        });
        this.pad = new JPanel();
        this.placeholder = new JPanel();
        gbc.gridwidth = -1;
        gbc.insets.right = 0;
        this.add((Component)new JLabel(Messages.getString("Type_")), gbc);
        gbc.insets.right = 8;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        this.add((Component)this.m_typeChooser, gbc);
        gbc.weightx = 0.0;
        gbc.gridwidth = 0;
        this.layoutValuePanel();
        this.add((Component)this.valuePanel, gbc);
    }

    @Override
    public void reset(Element context) {
        super.reset(context);
        this.context = context;
        this.m_variable = new Variable();
        this.factory = new SetPropertyImmediatelyFactory(this.m_variable.value);
        this.layoutValuePanel();
    }

    @Override
    public void preDialogShow(JDialog dialog) {
        super.preDialogShow(dialog);
        if (!this.getListsOnly()) {
            this.makeCollectionCheckBox.setSelected(false);
        }
    }

    @Override
    public void postDialogShow(JDialog dialog) {
        super.postDialogShow(dialog);
    }

    @Override
    public boolean isReadyToDispose(int option) {
        if (option == 0) {
            this.refreshValuePanel();
            this.m_typeChooser.addCurrentTypeToList();
        } else {
            this.m_variable = option == 2 ? null : null;
        }
        return true;
    }

    public boolean getShowValue() {
        return this.showValue;
    }

    public boolean getListsOnly() {
        return this.listsOnly;
    }

    private void updateCollection() {
        Class type = this.m_typeChooser.getType();
        makeObj obj = (makeObj)this.collectionTypeCombo.getSelectedItem();
        Class<?> collectionType = obj.getItem();
        Collection collection = null;
        if (this.m_variable.value.get() != null && collectionType.isAssignableFrom(this.m_variable.value.get().getClass())) {
            collection = (Collection)this.m_variable.value.get();
            if (collection.valueClass.getClassValue() != type) {
                collection.values.clear();
                collection.valueClass.set(type);
            }
        } else {
            try {
                collection = (Collection)collectionType.newInstance();
            }
            catch (Exception e) {
                AuthoringTool.showErrorDialog(String.valueOf(Messages.getString("Could_not_create_a_collection_of_type_")) + collectionType, e);
                collection = new List();
            }
            collection.valueClass.set(type);
            if (this.valueViewController instanceof PropertyViewController) {
                ((PropertyViewController)this.valueViewController).release();
                this.valueViewController = null;
            }
            this.m_variable.value.set(null);
            this.m_variable.valueClass.set(collectionType);
            this.m_variable.value.set(collection);
        }
        this.objectArrayPropertyEditor.setType(type);
        this.objectArrayPropertyEditor.setObjectArrayProperty(collection.values);
    }

    private void updateVariableValue() {
        Class type = this.m_typeChooser.getType();
        Object currentValue = this.m_variable.value.get();
        if (currentValue == null || !type.isAssignableFrom(currentValue.getClass())) {
            if (this.valueViewController instanceof PropertyViewController) {
                ((PropertyViewController)this.valueViewController).release();
                this.valueViewController = null;
            }
            this.m_variable.value.set(null);
            this.m_variable.valueClass.set(type);
            this.m_variable.value.set(AuthoringToolResources.getDefaultValueForClass(type));
            this.valueViewController = GUIFactory.getPropertyViewController(this.m_variable.value, true, false, true, this.factory);
            if (this.valueViewController instanceof ElementPropertyViewController) {
                ((ElementPropertyViewController)this.valueViewController).setRoot(this.context.getRoot());
            }
        }
    }

    private void layoutValuePanel() {
        this.valuePanel.removeAll();
        if (this.listsOnly) {
            this.makeCollectionCheckBox.setSelected(true);
            this.collectionTypeCombo.setSelectedItem("List");
            this.makeCollectionCheckBox.setEnabled(false);
            this.collectionTypeCombo.setEnabled(false);
        } else {
            this.makeCollectionCheckBox.setSelected(false);
            this.makeCollectionCheckBox.setEnabled(true);
            this.collectionTypeCombo.setEnabled(true);
        }
        GridBagConstraints gbcValue = new GridBagConstraints();
        gbcValue.fill = 1;
        gbcValue.insets.top = 8;
        if (this.showValue) {
            gbcValue.insets.left = 8;
            gbcValue.insets.right = 8;
            this.valuePanel.add((Component)this.valueLabel, gbcValue);
            this.valuePanel.add((Component)this.valueComponent, gbcValue);
            gbcValue.weightx = 1.0;
            this.valuePanel.add((Component)this.pad, gbcValue);
            gbcValue.weightx = 0.0;
            gbcValue.insets.right = 0;
            this.valuePanel.add((Component)this.makeCollectionCheckBox, gbcValue);
            gbcValue.gridwidth = 0;
            gbcValue.insets.left = 8;
            gbcValue.insets.right = 8;
            this.valuePanel.add((Component)this.collectionTypeCombo, gbcValue);
            gbcValue.weightx = 0.0;
            gbcValue.weighty = 1.0;
            this.valuePanel.add((Component)this.valuesComponent, gbcValue);
        } else {
            gbcValue.insets.right = 8;
            gbcValue.weightx = 1.0;
            this.valuePanel.add((Component)this.pad, gbcValue);
            gbcValue.weightx = 0.0;
            this.valuePanel.add((Component)this.makeCollectionCheckBox, gbcValue);
            gbcValue.gridwidth = 0;
            this.valuePanel.add((Component)this.collectionTypeCombo, gbcValue);
            gbcValue.weighty = 1.0;
            this.valuePanel.add((Component)this.placeholder, gbcValue);
        }
        this.refreshValuePanel();
    }

    private void refreshValuePanel() {
        if (this.m_typeChooser.getType() != null) {
            if (this.makeCollectionCheckBox.isSelected()) {
                this.updateCollection();
            } else {
                this.updateVariableValue();
            }
        }
        this.valuesComponent.removeAll();
        this.valueComponent.removeAll();
        if (this.makeCollectionCheckBox.isSelected()) {
            this.valueLabel.setText(Messages.getString("Values_"));
            this.valueComponent.add((Component)this.placeholder, "Center");
            this.valuesComponent.add((Component)this.objectArrayScrollPane, "Center");
        } else {
            this.valueLabel.setText(Messages.getString("Value_"));
            if (this.valueViewController != null) {
                this.valueComponent.add((Component)this.valueViewController, "Center");
            }
            this.valuesComponent.add((Component)this.placeholder, "Center");
        }
        this.packDialog();
    }

    public void setListsOnly(boolean b) {
        if (this.listsOnly != b) {
            this.listsOnly = b;
            this.layoutValuePanel();
        }
    }

    public void setShowValue(boolean showValue) {
        if (this.showValue != showValue) {
            this.showValue = showValue;
            this.layoutValuePanel();
        }
    }

    public Variable getVariable() {
        if (this.m_variable == null) {
            return null;
        }
        if ((this.makeCollectionCheckBox.isSelected() || this.listsOnly) && this.m_variable.value.get() instanceof Collection) {
            this.m_variable.addChild((Collection)this.m_variable.value.get());
        }
        this.m_variable.name.set(this.getNameValue());
        return this.m_variable;
    }

    public Class getTypeValue() {
        return this.m_typeChooser.getType();
    }

    private class makeObj {
        public String s;

        public makeObj(String item) {
            this.s = item;
        }

        public Class<?> getItem() {
            if (this.s == "List") {
                return List.class;
            }
            return Array.class;
        }

        public String toString() {
            return Messages.getString(this.s);
        }
    }
}

