/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.dialog;

import edu.cmu.cs.stage3.alice.authoringtool.util.CheckForValidityCallback;
import edu.cmu.cs.stage3.alice.authoringtool.util.NameTextField;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.lang.Messages;
import edu.cmu.cs.stage3.swing.ContentPane;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public abstract class NewNamedElementContentPane
extends ContentPane {
    private JButton m_okButton = new JButton(Messages.getString("OK"));
    private JButton m_cancelButton = new JButton(Messages.getString("Cancel"));
    private HashMap validityHashmap = new HashMap();
    private CheckForValidityCallback validityChecker = new CheckForValidityCallback(){

        @Override
        public void setValidity(Object source, boolean value) {
            NewNamedElementContentPane.this.okButtonEnabler(source, value);
        }

        @Override
        public void doAction() {
            if (NewNamedElementContentPane.this.m_okButton.isEnabled()) {
                NewNamedElementContentPane.this.m_okButton.doClick();
            }
        }
    };
    private NameTextField m_nameTextField = new NameTextField(this.validityChecker);

    public NewNamedElementContentPane() {
        this.m_nameTextField.setMinimumSize(new Dimension(150, 26));
        this.m_nameTextField.setPreferredSize(new Dimension(150, 26));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        this.initTopComponents(gbc);
        this.initBottomComponents(gbc);
    }

    protected void initTopComponents(GridBagConstraints gbc) {
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.gridwidth = -1;
        gbc.insets.top = 8;
        gbc.insets.left = 8;
        this.add((Component)new JLabel(Messages.getString("Name_")), gbc);
        gbc.insets.right = 8;
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        this.add((Component)this.m_nameTextField, gbc);
        gbc.weightx = 0.0;
    }

    protected void initBottomComponents(GridBagConstraints gbc) {
        JPanel okCancelPanel = new JPanel();
        GridBagConstraints gbcOKCancel = new GridBagConstraints();
        okCancelPanel.add((Component)this.m_okButton, gbcOKCancel);
        okCancelPanel.add((Component)this.m_cancelButton, gbcOKCancel);
        gbc.anchor = 15;
        this.add((Component)okCancelPanel, gbc);
    }

    @Override
    public void addOKActionListener(ActionListener l) {
        this.m_okButton.addActionListener(l);
    }

    @Override
    public void removeOKActionListener(ActionListener l) {
        this.m_okButton.removeActionListener(l);
    }

    @Override
    public void addCancelActionListener(ActionListener l) {
        this.m_cancelButton.addActionListener(l);
    }

    @Override
    public void removeCancelActionListener(ActionListener l) {
        this.m_cancelButton.removeActionListener(l);
    }

    public void reset(Element parent) {
        this.m_nameTextField.setText("");
        this.m_nameTextField.setParent(parent);
        this.m_nameTextField.grabFocus();
    }

    public String getNameValue() {
        return this.m_nameTextField.getText();
    }

    private void okButtonEnabler(Object source, boolean value) {
        this.validityHashmap.put(source, new Boolean(value));
        Iterator valueIterator = this.validityHashmap.values().iterator();
        boolean isEnableable = true;
        while (valueIterator.hasNext()) {
            Object currentValue = valueIterator.next();
            if (!(currentValue instanceof Boolean) || ((Boolean)currentValue).booleanValue()) continue;
            isEnableable = false;
            break;
        }
        this.m_okButton.setEnabled(isEnableable);
    }

    protected CheckForValidityCallback getValidityChecker() {
        return this.validityChecker;
    }
}

