/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.dialog;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources;
import edu.cmu.cs.stage3.alice.authoringtool.JAlice;
import edu.cmu.cs.stage3.alice.authoringtool.dialog.CustomCheckBox;
import edu.cmu.cs.stage3.alice.authoringtool.dialog.CustomListButton;
import edu.cmu.cs.stage3.alice.authoringtool.editors.behaviorgroupseditor.BasicBehaviorPanel;
import edu.cmu.cs.stage3.alice.authoringtool.editors.compositeeditor.CompositeElementEditor;
import edu.cmu.cs.stage3.alice.authoringtool.editors.responseeditor.ResponseEditor;
import edu.cmu.cs.stage3.alice.authoringtool.util.CallToUserDefinedQuestionPrototype;
import edu.cmu.cs.stage3.alice.authoringtool.util.CallToUserDefinedResponsePrototype;
import edu.cmu.cs.stage3.alice.authoringtool.util.Configuration;
import edu.cmu.cs.stage3.alice.authoringtool.util.ExtensionFileFilter;
import edu.cmu.cs.stage3.alice.authoringtool.util.ExtensionGroupFileFilter;
import edu.cmu.cs.stage3.alice.authoringtool.util.GUIFactory;
import edu.cmu.cs.stage3.alice.core.Behavior;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.Group;
import edu.cmu.cs.stage3.alice.core.Response;
import edu.cmu.cs.stage3.alice.core.Sandbox;
import edu.cmu.cs.stage3.alice.core.World;
import edu.cmu.cs.stage3.alice.core.question.userdefined.UserDefinedQuestion;
import edu.cmu.cs.stage3.alice.core.response.UserDefinedResponse;
import edu.cmu.cs.stage3.io.FileUtilities;
import edu.cmu.cs.stage3.lang.Messages;
import edu.cmu.cs.stage3.math.GoldenRatio;
import edu.cmu.cs.stage3.progress.ProgressCancelException;
import edu.cmu.cs.stage3.progress.ProgressObserver;
import edu.cmu.cs.stage3.swing.ContentPane;
import edu.cmu.cs.stage3.swing.DialogManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class ExportCodeForPrintingContentPane
extends ContentPane {
    private AuthoringTool m_authoringTool;
    private JFileChooser m_pathFileChooser = new JFileChooser();
    private JTextField m_authorNameTextField = new JTextField();
    private JTextField m_pathTextField = new JTextField();
    private JPanel m_elementsToBeExportedPanel = new JPanel();
    private Vector m_okActionListeners = new Vector();
    private JButton m_exportButton = new JButton(Messages.getString("Export_Code"));
    private JButton m_cancelButton = new JButton(Messages.getString("Cancel"));

    public ExportCodeForPrintingContentPane(AuthoringTool authoringTool) {
        File dir;
        this.m_authoringTool = authoringTool;
        ArrayList<ExtensionFileFilter> extensions = new ArrayList<ExtensionFileFilter>();
        extensions.add(new ExtensionFileFilter("htm", "*.htm"));
        extensions.add(new ExtensionFileFilter("html", "*.html"));
        this.m_pathFileChooser.setFileFilter(new ExtensionGroupFileFilter(extensions, Messages.getString("Web_pages")));
        Configuration authoringToolConfig = Configuration.getLocalConfiguration(JAlice.class.getPackage());
        String path = authoringToolConfig.getValue("directories.worldsDirectory");
        if (path != null && (dir = new File(path)) != null && dir.exists() && dir.isDirectory()) {
            try {
                Runnable testRun = new Runnable(){

                    @Override
                    public void run() {
                        ExportCodeForPrintingContentPane.this.m_pathFileChooser.setCurrentDirectory(dir);
                    }
                };
                if (!SwingUtilities.isEventDispatchThread()) {
                    SwingUtilities.invokeAndWait(testRun);
                }
            }
            catch (ArrayIndexOutOfBoundsException testRun) {
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        this.m_pathFileChooser.setDialogType(0);
        this.m_pathFileChooser.setFileSelectionMode(0);
        this.m_pathFileChooser.setApproveButtonText(Messages.getString("Set_File"));
        JButton selectAllButton = new JButton(Messages.getString("Select_All"));
        selectAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportCodeForPrintingContentPane.this.setAllSelected(true);
            }
        });
        JButton deselectAllButton = new JButton(Messages.getString("Deselect_All"));
        deselectAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportCodeForPrintingContentPane.this.setAllSelected(false);
            }
        });
        this.m_authorNameTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportCodeForPrintingContentPane.this.m_exportButton.doClick();
            }
        });
        this.m_pathTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportCodeForPrintingContentPane.this.m_exportButton.doClick();
            }
        });
        JButton browseButton = new JButton(Messages.getString("Browse___"));
        browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportCodeForPrintingContentPane.this.handleBrowseButton();
            }
        });
        this.m_exportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportCodeForPrintingContentPane.this.handleExportButton();
            }
        });
        JScrollPane whatToPrintScrollPane = new JScrollPane(this.m_elementsToBeExportedPanel);
        this.m_elementsToBeExportedPanel.setLayout(new GridBagLayout());
        this.m_elementsToBeExportedPanel.setBackground(Color.white);
        JPanel selectPanel = new JPanel();
        selectPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbcSelect = new GridBagConstraints();
        gbcSelect.anchor = 18;
        gbcSelect.fill = 1;
        gbcSelect.gridwidth = 0;
        selectPanel.add((Component)selectAllButton, gbcSelect);
        selectPanel.add((Component)deselectAllButton, gbcSelect);
        gbcSelect.weighty = 1.0;
        selectPanel.add((Component)new JLabel(), gbcSelect);
        JPanel pathPanel = new JPanel();
        pathPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbcPath = new GridBagConstraints();
        gbcPath.anchor = 18;
        gbcPath.fill = 1;
        gbcPath.gridwidth = -1;
        pathPanel.add((Component)new JLabel(Messages.getString("Export_to_")), gbcPath);
        gbcPath.gridwidth = 0;
        gbcPath.weightx = 1.0;
        pathPanel.add((Component)this.m_pathTextField, gbcPath);
        gbcPath.weightx = 0.0;
        JPanel authorPanel = new JPanel();
        authorPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbcAuthor = new GridBagConstraints();
        gbcAuthor.anchor = 18;
        gbcAuthor.fill = 1;
        gbcAuthor.gridwidth = -1;
        authorPanel.add((Component)new JLabel(Messages.getString("Author_s_name_")), gbcAuthor);
        gbcAuthor.gridwidth = 0;
        gbcAuthor.weightx = 1.0;
        authorPanel.add((Component)this.m_authorNameTextField, gbcAuthor);
        gbcAuthor.weightx = 0.0;
        JPanel okCancelPanel = new JPanel();
        okCancelPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbcOKCancel = new GridBagConstraints();
        gbcOKCancel.insets.left = 8;
        okCancelPanel.add((Component)this.m_exportButton, gbcOKCancel);
        okCancelPanel.add((Component)this.m_cancelButton, gbcOKCancel);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 1;
        gbc.insets.left = 8;
        gbc.insets.top = 8;
        gbc.insets.right = 8;
        gbc.gridwidth = -1;
        this.add((Component)new JLabel(Messages.getString("What_to_export_")), gbc);
        gbc.gridwidth = 0;
        this.add((Component)new JLabel(), gbc);
        gbc.insets.top = 0;
        gbc.weighty = 1.0;
        gbc.gridwidth = -1;
        gbc.weightx = 1.0;
        this.add((Component)whatToPrintScrollPane, gbc);
        gbc.weightx = 0.0;
        gbc.gridwidth = 0;
        this.add((Component)selectPanel, gbc);
        gbc.weighty = 0.0;
        gbc.insets.top = 8;
        gbc.gridwidth = -1;
        this.add((Component)pathPanel, gbc);
        gbc.gridwidth = 0;
        this.add((Component)browseButton, gbc);
        gbc.gridwidth = -1;
        this.add((Component)authorPanel, gbc);
        gbc.gridwidth = 0;
        this.add((Component)new JLabel(), gbc);
        gbc.insets.bottom = 8;
        gbc.gridwidth = 0;
        this.add((Component)okCancelPanel, gbc);
        int height = 400;
        int width = GoldenRatio.getLongerSideLength(height);
        this.setPreferredSize(new Dimension(width, height));
    }

    @Override
    public void preDialogShow(JDialog dialog) {
        super.preDialogShow(dialog);
        this.initialize("");
    }

    @Override
    public void postDialogShow(JDialog dialog) {
        super.postDialogShow(dialog);
    }

    @Override
    public String getTitle() {
        return Messages.getString("Export_to_HTML___");
    }

    private void fireOKActionListeners() {
        ActionEvent e = new ActionEvent(this, 1001, Messages.getString("OK"));
        int i = 0;
        while (i < this.m_okActionListeners.size()) {
            ActionListener l = (ActionListener)this.m_okActionListeners.elementAt(i);
            l.actionPerformed(e);
            ++i;
        }
    }

    @Override
    public void addOKActionListener(ActionListener l) {
        this.m_okActionListeners.addElement(l);
    }

    @Override
    public void removeOKActionListener(ActionListener l) {
        this.m_okActionListeners.removeElement(l);
    }

    @Override
    public void addCancelActionListener(ActionListener l) {
        this.m_cancelButton.addActionListener(l);
    }

    @Override
    public void removeCancelActionListener(ActionListener l) {
        this.m_cancelButton.removeActionListener(l);
    }

    public void initialize(String authorName) {
        this.setAllSelected(true);
        this.m_authorNameTextField.setText(authorName);
        this.m_authorNameTextField.setName(authorName);
        Configuration authoringToolConfig = Configuration.getLocalConfiguration(JAlice.class.getPackage());
        File file = new File(authoringToolConfig.getValue("directories.worldsDirectory"), String.valueOf(ExportCodeForPrintingContentPane.getWorldName(this.m_authoringTool.getCurrentWorldLocation())) + ".html");
        this.m_pathTextField.setText(file.getAbsolutePath());
        World world = this.m_authoringTool.getWorld();
        Vector objectsToEdit = new Vector();
        this.addObjectsToEdit(world, objectsToEdit);
        if (world != null) {
            int i = 0;
            while (i < world.sandboxes.size()) {
                this.addObjectsToEdit((Sandbox)world.sandboxes.get(i), objectsToEdit);
                ++i;
            }
            i = 0;
            while (i < world.groups.size()) {
                Group o = (Group)world.groups.get(i);
                int j = 0;
                while (j < o.size()) {
                    this.addObjectsToEdit((Sandbox)o.getChildAt(j), objectsToEdit);
                    ++j;
                }
                ++i;
            }
        }
        this.buildWhatToPrintPanel(objectsToEdit);
    }

    public File getFileToExportTo() {
        String path = this.m_pathTextField.getText();
        return new File(path);
    }

    private void setAllSelected(boolean isSelected) {
        int i = 0;
        while (i < this.m_elementsToBeExportedPanel.getComponentCount()) {
            Component componentI = this.m_elementsToBeExportedPanel.getComponent(i);
            if (componentI instanceof CustomCheckBox) {
                ((CustomCheckBox)componentI).setSelected(isSelected);
            }
            ++i;
        }
    }

    private void addObjectsToEdit(Sandbox sandbox, Vector toAddTo) {
        if (sandbox != null && (sandbox.behaviors.size() != 0 || sandbox.responses.size() != 0 || sandbox.questions.size() != 0)) {
            toAddTo.add(sandbox.name.getStringValue());
            int i = sandbox.behaviors.size() - 1;
            while (i >= 0) {
                toAddTo.add(sandbox.behaviors.get(i));
                --i;
            }
            i = 0;
            while (i < sandbox.responses.size()) {
                toAddTo.add(sandbox.responses.get(i));
                ++i;
            }
            i = 0;
            while (i < sandbox.questions.size()) {
                toAddTo.add(sandbox.questions.get(i));
                ++i;
            }
        }
    }

    protected void buildWhatToPrintPanel(Vector objectsToPrint) {
        this.m_elementsToBeExportedPanel.removeAll();
        CustomListButton currentButton = null;
        int count = 0;
        boolean isWorld = false;
        int i = 0;
        while (i < objectsToPrint.size()) {
            Object currentObject = objectsToPrint.elementAt(i);
            AbstractButton toAdd = null;
            int leftIndent = 0;
            if (currentObject instanceof String) {
                currentButton = new CustomListButton();
                currentButton.setText(currentObject.toString());
                toAdd = currentButton;
                leftIndent = 0;
                isWorld = currentButton.getText().equalsIgnoreCase("world");
            } else {
                JComponent gui;
                toAdd = new CustomCheckBox();
                if (currentButton != null) {
                    currentButton.addCheckBox((CustomCheckBox)toAdd);
                }
                if (currentObject instanceof Behavior) {
                    JComponent gui2 = GUIFactory.getGUI(currentObject);
                    ((CustomCheckBox)toAdd).image = this.m_authoringTool.getJAliceFrame().getImageForComponent(gui2);
                    ((CustomCheckBox)toAdd).gui = gui2;
                    ((CustomCheckBox)toAdd).object = currentObject;
                    toAdd.setOpaque(false);
                } else if (currentObject instanceof UserDefinedResponse) {
                    CallToUserDefinedResponsePrototype callToUserDefinedResponsePrototype = new CallToUserDefinedResponsePrototype((UserDefinedResponse)currentObject);
                    gui = GUIFactory.getGUI(callToUserDefinedResponsePrototype);
                    ((CustomCheckBox)toAdd).image = this.m_authoringTool.getJAliceFrame().getImageForComponent(gui);
                    ((CustomCheckBox)toAdd).gui = gui;
                    ((CustomCheckBox)toAdd).object = currentObject;
                    toAdd.setOpaque(false);
                } else if (currentObject instanceof UserDefinedQuestion) {
                    CallToUserDefinedQuestionPrototype callToUserDefinedQuestionPrototype = new CallToUserDefinedQuestionPrototype((UserDefinedQuestion)currentObject);
                    gui = GUIFactory.getGUI(callToUserDefinedQuestionPrototype);
                    ((CustomCheckBox)toAdd).image = this.m_authoringTool.getJAliceFrame().getImageForComponent(gui);
                    ((CustomCheckBox)toAdd).gui = gui;
                    ((CustomCheckBox)toAdd).object = currentObject;
                    toAdd.setOpaque(false);
                }
                if (isWorld) {
                    toAdd.setSelected(true);
                } else {
                    toAdd.setSelected(false);
                }
                ((CustomCheckBox)toAdd).setIndex(i);
            }
            Color bgColor = Color.white;
            if (currentObject instanceof Response) {
                bgColor = AuthoringToolResources.getColor("userDefinedResponseEditor");
            } else if (currentObject instanceof UserDefinedQuestion) {
                bgColor = AuthoringToolResources.getColor("userDefinedQuestionEditor");
            } else if (currentObject instanceof BasicBehaviorPanel) {
                bgColor = AuthoringToolResources.getColor("behavior");
            }
            toAdd.setBackground(bgColor);
            this.m_elementsToBeExportedPanel.add((Component)toAdd, new GridBagConstraints(0, i, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, leftIndent, 0, 0), 0, 0));
            ++count;
            ++i;
        }
        this.m_elementsToBeExportedPanel.add(Box.createVerticalGlue(), new GridBagConstraints(0, count, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.m_elementsToBeExportedPanel.revalidate();
        this.m_elementsToBeExportedPanel.repaint();
    }

    private void handleBrowseButton() {
        File file;
        int result = DialogManager.showDialog(this.m_pathFileChooser, null);
        if (result == 0 && (file = this.m_pathFileChooser.getSelectedFile()) != null) {
            String path = file.getAbsolutePath();
            if (!path.endsWith(".html") && !path.endsWith(".htm")) {
                path = String.valueOf(path) + ".html";
            }
            this.m_pathTextField.setText(path);
        }
    }

    private void handleWriteProblem(File file) {
        DialogManager.showMessageDialog(String.valueOf(Messages.getString("Cannot_write_to___")) + file.getAbsolutePath() + "\"", Messages.getString("Cannot_write"), 0);
    }

    private void handleExportButton() {
        if (this.m_authorNameTextField.getText().length() == 0) {
            DialogManager.showMessageDialog(Messages.getString("You_must_enter_the_author_s_name_before_proceeding_"), Messages.getString("You_have_not_entered_the_author_s_name"), 0);
        } else {
            File file = this.getFileToExportTo();
            if (file.exists()) {
                int result = DialogManager.showConfirmDialog(Messages.getString("You_are_about_to_save_over_an_existing_file__Are_you_sure_you_want_to_"), Messages.getString("Save_Over_Warning"), 0);
                if (result != 0) {
                    return;
                }
            } else {
                try {
                    file.createNewFile();
                }
                catch (Throwable t) {
                    this.handleWriteProblem(file);
                    return;
                }
            }
            if (file.canWrite()) {
                this.fireOKActionListeners();
            } else {
                this.handleWriteProblem(file);
            }
        }
    }

    private static String getWorldName(File worldFile) {
        if (worldFile != null) {
            return FileUtilities.getBaseName(worldFile);
        }
        return Messages.getString("Unnamed_World");
    }

    private JComponent getComponentForObject(Object toFind) {
        int i = 0;
        while (i < this.m_elementsToBeExportedPanel.getComponentCount()) {
            Component c = this.m_elementsToBeExportedPanel.getComponent(i);
            if (c instanceof CustomCheckBox && ((CustomCheckBox)c).object == toFind) {
                return ((CustomCheckBox)c).gui;
            }
            ++i;
        }
        return null;
    }

    public void getHTML(StringBuffer buffer, File worldFile, boolean addHeaderAndFooter, boolean addAuthor, ProgressObserver progressObserver) throws ProgressCancelException {
        if (progressObserver != null) {
            progressObserver.progressBegin(this.m_elementsToBeExportedPanel.getComponentCount());
        }
        String worldName = ExportCodeForPrintingContentPane.getWorldName(worldFile);
        if (addHeaderAndFooter) {
            buffer.append("<html>\n<head>\n<title>" + worldName + "'s Code</title>\n</head>\n<body>\n");
        }
        buffer.append("<h1>" + worldName + "'s Code</h1>\n");
        if (addAuthor) {
            buffer.append("<h1> Created by: " + this.m_authorNameTextField.getText() + "</h1>\n");
        }
        boolean notOnBehaviorsYet = true;
        boolean notOnResponsesYet = true;
        boolean notOnQuestionsYet = true;
        String currentTitle = "";
        boolean anyItemsYet = false;
        int i = 0;
        while (i < this.m_elementsToBeExportedPanel.getComponentCount()) {
            CustomCheckBox currentBox;
            if (this.m_elementsToBeExportedPanel.getComponent(i) instanceof CustomListButton) {
                String name = ((CustomListButton)this.m_elementsToBeExportedPanel.getComponent(i)).getText();
                currentTitle = "<h2>" + name + "</h2>\n";
                anyItemsYet = false;
                notOnBehaviorsYet = true;
                notOnResponsesYet = true;
                notOnQuestionsYet = true;
            } else if (this.m_elementsToBeExportedPanel.getComponent(i) instanceof CustomCheckBox && (currentBox = (CustomCheckBox)this.m_elementsToBeExportedPanel.getComponent(i)).isSelected()) {
                if (!anyItemsYet) {
                    buffer.append(currentTitle);
                    anyItemsYet = true;
                }
                if (!(currentBox.object instanceof Behavior)) {
                    Component currentEditor = this.m_authoringTool.getEditorForElement((Element)currentBox.object);
                    if (currentEditor instanceof CompositeElementEditor) {
                        if (currentEditor instanceof ResponseEditor) {
                            if (notOnResponsesYet) {
                                buffer.append("<h3>Methods</h3>\n");
                                notOnResponsesYet = false;
                            }
                        } else if (notOnQuestionsYet) {
                            String cappedQuestionString = String.valueOf(AuthoringToolResources.QUESTION_STRING.substring(0, 1).toUpperCase()) + AuthoringToolResources.QUESTION_STRING.substring(1);
                            buffer.append("<h3>" + cappedQuestionString + "s</h3>\n");
                            notOnQuestionsYet = false;
                        }
                        buffer.append("<table cellpadding=\"2\" cellspacing=\"0\" width=\"100%\">\n");
                        ((CompositeElementEditor)currentEditor).getHTML(buffer, true);
                        buffer.append("\n</table>\n<br>\n<br>\n");
                    }
                } else {
                    JComponent component;
                    if (notOnBehaviorsYet) {
                        buffer.append("<h3>Events</h3>\n");
                        notOnBehaviorsYet = false;
                    }
                    if ((component = this.getComponentForObject(currentBox.object)) instanceof BasicBehaviorPanel) {
                        BasicBehaviorPanel behaviorPanel = (BasicBehaviorPanel)component;
                        buffer.append("<table  style=\"border-left: 1px solid #c0c0c0; border-top: 1px solid #c0c0c0; border-bottom: 1px solid #c0c0c0; border-right: 1px solid #c0c0c0\" cellpadding=\"2\" cellspacing=\"0\" width=\"100%\">\n");
                        behaviorPanel.getHTML(buffer, true);
                        buffer.append("\n</table>\n<br>\n<br>\n");
                    }
                }
            }
            if (progressObserver != null) {
                progressObserver.progressUpdate(i, null);
            }
            ++i;
        }
        if (addHeaderAndFooter) {
            buffer.append("</body>\n</html>\n");
        }
        if (progressObserver != null) {
            progressObserver.progressEnd();
        }
    }
}

