/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.datatransfer;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

public class FileListTransferable
implements Transferable {
    protected List fileList;
    protected DataFlavor[] flavors;

    public FileListTransferable(List fileList) {
        this.fileList = fileList;
        this.flavors = new DataFlavor[2];
        this.flavors[0] = DataFlavor.javaFileListFlavor;
        this.flavors[1] = DataFlavor.stringFlavor;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return this.flavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        int i = 0;
        while (i < this.flavors.length) {
            if (flavor.equals(this.flavors[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (flavor.equals(DataFlavor.javaFileListFlavor)) {
            return this.fileList;
        }
        if (flavor.equals(DataFlavor.stringFlavor)) {
            String files = "";
            Iterator iter = this.fileList.iterator();
            while (iter.hasNext()) {
                files = String.valueOf(files) + ((File)iter.next()).getAbsolutePath() + "; ";
            }
            return files;
        }
        throw new UnsupportedFlavorException(flavor);
    }
}

