/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources;
import edu.cmu.cs.stage3.alice.authoringtool.editors.variablegroupeditor.VariableGroupEditor;
import edu.cmu.cs.stage3.alice.authoringtool.util.GUIFactory;
import edu.cmu.cs.stage3.alice.authoringtool.util.PopupItemFactory;
import edu.cmu.cs.stage3.alice.authoringtool.viewcontroller.PropertyGUI;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.Property;
import edu.cmu.cs.stage3.alice.core.ReferenceFrame;
import edu.cmu.cs.stage3.alice.core.Sandbox;
import edu.cmu.cs.stage3.alice.core.Transformable;
import edu.cmu.cs.stage3.alice.core.response.PropertyAnimation;
import edu.cmu.cs.stage3.util.StringObjectPair;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;

public class PropertyPanel
extends JPanel {
    protected Element element;
    protected VariableGroupEditor variableGroupEditor = new VariableGroupEditor();
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel propertySubPanel = new JPanel();
    BorderLayout borderLayout2 = new BorderLayout();
    JComboBox propertyGroupCombo = new JComboBox();
    Border border1;
    JScrollPane propertyScrollPane = new JScrollPane();
    Border border2;
    Border border3;
    Border border4;
    Border border5;
    JPanel propertyManipulationPanel = new JPanel();
    Border border6;
    Border border7;
    CardLayout cardLayout1 = new CardLayout();

    public PropertyPanel() {
        this.jbInit();
        this.propertyGroupCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ev) {
                CardLayout cardLayout = (CardLayout)PropertyPanel.this.propertyManipulationPanel.getLayout();
                cardLayout.show(PropertyPanel.this.propertyManipulationPanel, (String)ev.getItem());
            }
        });
    }

    public Element getElement() {
        return this.element;
    }

    public void setElement(Element element) {
        this.element = element;
        this.refreshGUI();
    }

    public void refreshGUI() {
        this.propertyManipulationPanel.removeAll();
        this.propertyGroupCombo.removeAllItems();
        if (this.element != null) {
            Vector structure = AuthoringToolResources.getPropertyStructure(this.element, false);
            if (structure != null) {
                for (StringObjectPair sop : structure) {
                    String groupName = sop.getString();
                    Vector propertyNames = (Vector)sop.getObject();
                    JPanel subPanel = new JPanel();
                    subPanel.setBackground(Color.white);
                    subPanel.setLayout(new GridBagLayout());
                    if (propertyNames != null) {
                        int i = 0;
                        for (String name : propertyNames) {
                            final Property property = this.element.getPropertyNamed(name);
                            if (property != null) {
                                PopupItemFactory factory = new PopupItemFactory(){

                                    @Override
                                    public Object createItem(final Object o) {
                                        return new Runnable(){

                                            @Override
                                            public void run() {
                                                if (property.getOwner() instanceof Transformable && property == ((Transformable)property.getOwner()).vehicle) {
                                                    ((Transformable)property.getOwner()).setVehiclePreservingAbsoluteTransformation((ReferenceFrame)o);
                                                } else {
                                                    PropertyAnimation response = new PropertyAnimation();
                                                    response.element.set(property.getOwner());
                                                    response.propertyName.set(property.getName());
                                                    response.value.set(o);
                                                    PropertyAnimation undoResponse = new PropertyAnimation();
                                                    undoResponse.element.set(property.getOwner());
                                                    undoResponse.propertyName.set(property.getName());
                                                    undoResponse.value.set(property.getValue());
                                                    AuthoringTool.getHack().performOneShot(response, undoResponse, new Property[]{property});
                                                }
                                            }
                                        };
                                    }
                                };
                                PropertyGUI gui = GUIFactory.getPropertyGUI(property, true, false, factory);
                                if (gui != null) {
                                    GridBagConstraints constraints = new GridBagConstraints(0, i, 1, 1, 1.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0);
                                    subPanel.add((Component)gui, constraints);
                                    ++i;
                                    continue;
                                }
                                AuthoringTool.showErrorDialog("Unable to create gui for property: " + property, null);
                                continue;
                            }
                            AuthoringTool.showErrorDialog("no property on " + this.element + " named " + name, null);
                        }
                        GridBagConstraints glueConstraints = new GridBagConstraints(0, i, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0);
                        subPanel.add(Box.createGlue(), glueConstraints);
                    }
                    this.propertyManipulationPanel.add((Component)subPanel, this.element.name.get() + "'s " + groupName);
                    this.propertyGroupCombo.addItem(this.element.name.get() + "'s " + groupName);
                }
            }
            if (this.element instanceof Sandbox) {
                this.variableGroupEditor.setVariableObjectArrayProperty(((Sandbox)this.element).variables);
                this.propertyManipulationPanel.add((Component)this.variableGroupEditor, this.element.name.get() + "'s variables");
                this.propertyGroupCombo.addItem(this.element.name.get() + "'s variables");
            }
        }
        this.revalidate();
        this.repaint();
    }

    private void jbInit() {
        this.border1 = BorderFactory.createEmptyBorder(8, 8, 8, 8);
        this.border2 = BorderFactory.createLineBorder(SystemColor.controlText, 1);
        this.border3 = BorderFactory.createCompoundBorder(this.border2, this.border1);
        this.border4 = BorderFactory.createEmptyBorder(8, 8, 8, 8);
        this.border5 = BorderFactory.createEmptyBorder(2, 2, 2, 2);
        this.border6 = BorderFactory.createLineBorder(SystemColor.controlText, 1);
        this.border7 = BorderFactory.createCompoundBorder(this.border6, this.border5);
        this.setLayout(this.borderLayout1);
        this.propertySubPanel.setLayout(this.borderLayout2);
        this.propertySubPanel.setBorder(this.border1);
        this.setBackground(new Color(204, 204, 204));
        this.setMinimumSize(new Dimension(0, 0));
        this.propertyManipulationPanel.setLayout(this.cardLayout1);
        this.borderLayout2.setHgap(8);
        this.borderLayout2.setVgap(8);
        this.propertyManipulationPanel.setBackground(Color.white);
        this.add((Component)this.propertySubPanel, "Center");
        this.propertySubPanel.add((Component)this.propertyGroupCombo, "North");
        this.propertySubPanel.add((Component)this.propertyScrollPane, "Center");
        this.propertyScrollPane.getViewport().add((Component)this.propertyManipulationPanel, null);
    }
}

