/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool;

import com.apple.eawt.AppEvent;
import com.apple.eawt.Application;
import com.apple.eawt.OpenFilesHandler;
import com.sun.media.codec.audio.mp3.JavaDecoder;
import edu.cmu.cs.stage3.alice.authoringtool.AikMin;
import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.util.Configuration;
import edu.cmu.cs.stage3.alice.authoringtool.util.SplashScreen;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.DefaultRenderTargetFactory;
import edu.cmu.cs.stage3.lang.Messages;
import edu.cmu.cs.stage3.swing.DialogManager;
import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.awt.Color;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class JAlice {
    private static String version;
    private static String backgroundColor;
    private static String directory;
    private Package authoringToolPackage = Package.getPackage("edu.cmu.cs.stage3.alice.authoringtool");
    static AuthoringTool authoringTool;
    static File aliceHomeDirectory;
    static File aliceUserDirectory;
    static SplashScreen splashScreen;
    static File defaultWorld;
    static File worldToLoad;
    static boolean stdOutToConsole;
    static boolean stdErrToConsole;
    static String defaultRendererClassname;
    static boolean mainHasFinished;
    private static boolean listenerRegistered;

    static {
        block24: {
            version = "2.4.3";
            backgroundColor = new Color(0, 78, 152).toString();
            directory = null;
            try {
                File versionFile;
                File newFile;
                File bakFile = new File(String.valueOf(JAlice.getAliceHomeDirectory().getParent().toString()) + File.separator + "Aliceold.exe");
                if (bakFile.exists()) {
                    bakFile.delete();
                }
                if ((newFile = new File(String.valueOf(JAlice.getAliceHomeDirectory().getParent().toString()) + File.separator + "Alicenew.exe")).exists()) {
                    JOptionPane.showMessageDialog(new JFrame(), "You must restart Alice to complete the software update.", "Software Update", 1);
                    File oldFile = new File(String.valueOf(JAlice.getAliceHomeDirectory().getParent().toString()) + File.separator + "Alice.exe");
                    if (newFile.exists()) {
                        oldFile.renameTo(new File(String.valueOf(JAlice.getAliceHomeDirectory().getParent().toString()) + File.separator + "Aliceold.exe"));
                        newFile.renameTo(oldFile);
                    }
                    newFile = new File(String.valueOf(JAlice.getAliceHomeDirectory().toString()) + File.separator + "lib" + File.separator + "win32" + File.separator + "jni_directx7renderer.dll.new");
                    oldFile = new File(String.valueOf(JAlice.getAliceHomeDirectory().toString()) + File.separator + "lib" + File.separator + "win32" + File.separator + "jni_directx7renderer.dll");
                    if (newFile.exists()) {
                        oldFile.delete();
                        newFile.renameTo(oldFile);
                    }
                    newFile = new File(String.valueOf(JAlice.getAliceHomeDirectory().toString()) + File.separator + "lib" + File.separator + "win32" + File.separator + "jni_awtutilities.dll.new");
                    oldFile = new File(String.valueOf(JAlice.getAliceHomeDirectory().toString()) + File.separator + "lib" + File.separator + "win32" + File.separator + "jni_awtutilities.dll");
                    if (newFile.exists()) {
                        oldFile.delete();
                        newFile.renameTo(oldFile);
                    }
                    try {
                        String file;
                        if (AikMin.isWindows()) {
                            file = String.valueOf(JAlice.getAliceHomeDirectory().getParent().toString()) + "\\Alice.exe";
                            if (new File(file).exists()) {
                                Runtime.getRuntime().exec(file);
                            } else {
                                DialogManager.showMessageDialog("Missing Alice.exe in Alice directory. Please restart Alice manually.");
                            }
                        } else if (AikMin.isMAC()) {
                            String decodedPath = URLDecoder.decode(JAlice.class.getProtectionDomain().getCodeSource().getLocation().getPath(), "UTF-8");
                            decodedPath = decodedPath.substring(0, decodedPath.lastIndexOf(".app") + 4);
                            String[] params = new String[]{"open", "-n", decodedPath};
                            Runtime.getRuntime().exec(params);
                        } else {
                            file = String.valueOf(JAlice.getAliceHomeDirectory().getParent().toString()) + "/Required/run-alice";
                            if (new File(file).exists()) {
                                try {
                                    Runtime.getRuntime().exec(file);
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            } else {
                                DialogManager.showMessageDialog("Missing Alice executable in Alice directory. Please restart Alice manually.");
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    System.exit(0);
                }
                if ((versionFile = new File(JAlice.getAliceHomeDirectory(), "etc/config.txt").getAbsoluteFile()).exists()) {
                    if (versionFile.canRead()) {
                        BufferedReader br = new BufferedReader(new FileReader(versionFile));
                        String colorString = br.readLine();
                        directory = br.readLine();
                        br.close();
                        if (colorString == null || (colorString = colorString.trim()).length() <= 0) break block24;
                        try {
                            if (!colorString.startsWith("0x")) {
                                String[] color = colorString.split(",");
                                double red = Integer.decode(color[0]).doubleValue() / 255.0;
                                double green = Integer.decode(color[1]).doubleValue() / 255.0;
                                double blue = Integer.decode(color[2]).doubleValue() / 255.0;
                                backgroundColor = new edu.cmu.cs.stage3.alice.scenegraph.Color(red, green, blue).toString();
                                break block24;
                            }
                            Color newColor = Color.decode(colorString);
                            backgroundColor = new edu.cmu.cs.stage3.alice.scenegraph.Color(newColor).toString();
                        }
                        catch (Throwable colorT) {
                            colorT.printStackTrace();
                        }
                        break block24;
                    }
                    version = Messages.getString("cannot_read_config_txt");
                    break block24;
                }
                version = Messages.getString("config_txt_does_not_exist");
            }
            catch (Throwable t) {
                t.printStackTrace();
                version = Messages.getString("error_while_reading_config_txt");
            }
        }
        aliceHomeDirectory = null;
        aliceUserDirectory = null;
        worldToLoad = null;
        stdOutToConsole = false;
        stdErrToConsole = false;
        defaultRendererClassname = null;
        mainHasFinished = false;
        listenerRegistered = false;
    }

    public static String getVersion() {
        return version;
    }

    public static void main(String[] args) {
        try {
            String[] mp3args = new String[]{};
            JavaDecoder.main((String[])mp3args);
        }
        catch (Throwable t) {
            t.printStackTrace(System.out);
        }
        try {
            File firstRun = new File(JAlice.getAliceHomeDirectory(), "etc/firstRun.txt").getAbsoluteFile();
            if (firstRun.exists() || AikMin.target == 1) {
                firstRun.delete();
                if (JAlice.getAliceUserDirectory().exists()) {
                    new File(JAlice.getAliceUserDirectory(), "AlicePreferences.xml").getAbsoluteFile().delete();
                }
            }
            firstRun = null;
            JAlice.localInit();
            boolean useJavaBasedSplashScreen = true;
            String useSplashScreenString = System.getProperty("alice.useJavaBasedSplashScreen");
            if (useSplashScreenString != null && !useSplashScreenString.equalsIgnoreCase("true")) {
                useJavaBasedSplashScreen = false;
            }
            if (useJavaBasedSplashScreen) {
                Class.forName("edu.cmu.cs.stage3.alice.authoringtool.util.Configuration");
                splashScreen = JAlice.initSplashScreen();
                splashScreen.showSplash();
            }
            if (AikMin.isMAC()) {
                Application app = Application.getApplication();
                app.setOpenFileHandler(new OpenFilesHandler(){

                    public void openFiles(AppEvent.OpenFilesEvent event) {
                        ArrayList<String> filenames = new ArrayList<String>();
                        for (File f : event.getFiles()) {
                            filenames.add(f.getAbsolutePath());
                        }
                        if (!listenerRegistered) {
                            worldToLoad = new File(filenames.toArray(new String[filenames.size()])[0]).getAbsoluteFile();
                            listenerRegistered = true;
                        } else {
                            try {
                                String decodedPath = URLDecoder.decode(JAlice.class.getProtectionDomain().getCodeSource().getLocation().getPath(), "UTF-8");
                                decodedPath = decodedPath.substring(0, decodedPath.lastIndexOf(".app") + 4);
                                String[] params = new String[]{"open", "-n", decodedPath, filenames.toArray(new String[filenames.size()])[0]};
                                Runtime.getRuntime().exec(params);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                });
            }
            JAlice.parseCommandLineArgs(args);
            Class.forName("edu.cmu.cs.stage3.alice.authoringtool.util.Configuration");
            JAlice.configInit();
            try {
                File aliceHasNotExitedFile = new File(JAlice.getAliceUserDirectory(), "aliceHasNotExited.txt");
                if (aliceHasNotExitedFile.exists()) {
                    aliceHasNotExitedFile.delete();
                }
                aliceHasNotExitedFile.createNewFile();
                OutputStreamWriter writer = new OutputStreamWriter(new FileOutputStream(aliceHasNotExitedFile));
                writer.write("Alice_has_not_exited_propertly_yet_");
                writer.flush();
                writer.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            Class.forName("edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources");
            Class.forName("edu.cmu.cs.stage3.alice.authoringtool.util.EditorUtilities");
            defaultWorld = new File(JAlice.getAliceHomeDirectory(), "etc/default_" + AikMin.locale + ".a2w").getAbsoluteFile();
            if (!defaultWorld.exists() || !defaultWorld.canRead()) {
                JOptionPane.showMessageDialog(new JFrame(), String.valueOf(defaultWorld.getAbsolutePath()) + " " + Messages.getString("does_not_exist_or_cannot_be_read__No_starting_world_will_be_available_"), Messages.getString("Warning"), 0);
                System.exit(1);
            }
            authoringTool = new AuthoringTool(defaultWorld, worldToLoad, stdOutToConsole, stdErrToConsole);
            if (useJavaBasedSplashScreen) {
                splashScreen.dispose();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        mainHasFinished = true;
    }

    private static void localInit() {
        Configuration authoringtoolConfig = Configuration.getLocalConfiguration(JAlice.class.getPackage());
        if (authoringtoolConfig.getValue("language") == null) {
            authoringtoolConfig.setValue("language", AikMin.defaultLanguage);
        }
        AikMin.locale = authoringtoolConfig.getValue("language");
    }

    private static SplashScreen initSplashScreen() {
        URL url = JAlice.class.getResource("images/AliceSplash_" + AikMin.locale + ".png");
        if (url == null) {
            url = JAlice.class.getResource("images/AliceSplash_English.png");
        }
        Image splashImage = Toolkit.getDefaultToolkit().getImage(url);
        return new SplashScreen(splashImage);
    }

    private static void configInit() {
        File captureDir;
        String charDir;
        File defaultGallery;
        int screenHeight;
        int screenWidth;
        Configuration authoringtoolConfig = Configuration.getLocalConfiguration(JAlice.class.getPackage());
        authoringtoolConfig.setValue("backgroundColor", backgroundColor);
        if (authoringtoolConfig.getValue("recentWorlds.maxWorlds") == null) {
            authoringtoolConfig.setValue("recentWorlds.maxWorlds", Integer.toString(8));
        }
        if (authoringtoolConfig.getValueList("recentWorlds.worlds") == null) {
            authoringtoolConfig.setValueList("recentWorlds.worlds", new String[0]);
        }
        if (authoringtoolConfig.getValue("enableHighContrastMode") == null) {
            authoringtoolConfig.setValue("enableHighContrastMode", "false");
        }
        if (authoringtoolConfig.getValue("enableLoggingMode") == null) {
            authoringtoolConfig.setValue("enableLoggingMode", "false");
        }
        if (authoringtoolConfig.getValue("disableTooltipMode") == null) {
            authoringtoolConfig.setValue("disableTooltipMode", "false");
        }
        if (authoringtoolConfig.getValue("showBuilderMode") == null) {
            authoringtoolConfig.setValue("showBuilderMode", "false");
        }
        if (authoringtoolConfig.getValue("fontSize") == null) {
            authoringtoolConfig.setValue("fontSize", Integer.toString(12));
        }
        if (authoringtoolConfig.getValue("showObjectLoadFeedback") == null) {
            authoringtoolConfig.setValue("showObjectLoadFeedback", "true");
        }
        if (authoringtoolConfig.getValue("maximumWorldBackupCount") == null) {
            authoringtoolConfig.setValue("maximumWorldBackupCount", Integer.toString(5));
        }
        if (authoringtoolConfig.getValue("maxRecentlyUsedValues") == null) {
            authoringtoolConfig.setValue("maxRecentlyUsedValues", Integer.toString(5));
        }
        if (authoringtoolConfig.getValue("numberOfClipboards") == null) {
            authoringtoolConfig.setValue("numberOfClipboards", Integer.toString(1));
        }
        if (authoringtoolConfig.getValue("showWorldStats") == null) {
            authoringtoolConfig.setValue("showWorldStats", "false");
        }
        if (authoringtoolConfig.getValue("enableScripting") == null) {
            authoringtoolConfig.setValue("enableScripting", "false");
        }
        if (authoringtoolConfig.getValue("promptToSaveInterval") == null) {
            authoringtoolConfig.setValue("promptToSaveInterval", Integer.toString(15));
        }
        if (authoringtoolConfig.getValue("doNotShowUnhookedMethodWarning") == null) {
            authoringtoolConfig.setValue("doNotShowUnhookedMethodWarning", "false");
        }
        if (authoringtoolConfig.getValue("clearStdOutOnRun") == null) {
            authoringtoolConfig.setValue("clearStdOutOnRun", "true");
        }
        if (authoringtoolConfig.getValue("resourceFile") == null) {
            authoringtoolConfig.setValue("resourceFile", "Alice Style.py");
        }
        if (authoringtoolConfig.getValue("watcherPanelEnabled") == null) {
            authoringtoolConfig.setValue("watcherPanelEnabled", "false");
        }
        if (authoringtoolConfig.getValue("showStartUpDialog") == null) {
            authoringtoolConfig.setValue("showStartUpDialog", "true");
        }
        if (authoringtoolConfig.getValue("showWebWarningDialog") == null) {
            authoringtoolConfig.setValue("showWebWarningDialog", "true");
        }
        if (authoringtoolConfig.getValue("showStartUpDialog_OpenTab") == null) {
            authoringtoolConfig.setValue("showStartUpDialog_OpenTab", Integer.toString(4));
        }
        if (authoringtoolConfig.getValue("loadSavedTabs") == null) {
            authoringtoolConfig.setValue("loadSavedTabs", "false");
        }
        if (authoringtoolConfig.getValue("saveThumbnailWithWorld") == null) {
            authoringtoolConfig.setValue("saveThumbnailWithWorld", "true");
        }
        if (authoringtoolConfig.getValue("mainWindowBounds") == null) {
            screenWidth = 1280;
            screenHeight = 720;
            int x = 0;
            int y = 0;
            authoringtoolConfig.setValue("mainWindowBounds", String.valueOf(x) + ", " + y + ", " + screenWidth + ", " + screenHeight);
        }
        if (authoringtoolConfig.getValueList("rendering.orderedRendererList") == null) {
            Class[] rendererClasses = DefaultRenderTargetFactory.getPotentialRendererClasses();
            String[] list = new String[rendererClasses.length];
            int i = 0;
            while (i < rendererClasses.length) {
                list[i] = rendererClasses[i].getName();
                ++i;
            }
            authoringtoolConfig.setValueList("rendering.orderedRendererList", list);
        }
        if (authoringtoolConfig.getValue("rendering.showFPS") == null) {
            authoringtoolConfig.setValue("rendering.showFPS", "false");
        }
        if (authoringtoolConfig.getValue("rendering.forceSoftwareRendering") == null) {
            authoringtoolConfig.setValue("rendering.forceSoftwareRendering", "false");
        }
        if (authoringtoolConfig.getValue("rendering.deleteFiles") == null) {
            authoringtoolConfig.setValue("rendering.deleteFiles", "true");
        }
        if (authoringtoolConfig.getValue("rendering.renderWindowMatchesSceneEditor") == null) {
            authoringtoolConfig.setValue("rendering.renderWindowMatchesSceneEditor", "true");
        }
        if (authoringtoolConfig.getValue("rendering.ensureRenderDialogIsOnScreen") == null) {
            authoringtoolConfig.setValue("rendering.ensureRenderDialogIsOnScreen", "true");
        }
        if (authoringtoolConfig.getValue("rendering.renderWindowBounds") == null) {
            screenWidth = (int)Toolkit.getDefaultToolkit().getScreenSize().getWidth();
            screenHeight = (int)Toolkit.getDefaultToolkit().getScreenSize().getHeight();
            int width = 480;
            int height = 360;
            int x = (screenWidth - width) / 2;
            int y = (screenHeight - height) / 2;
            authoringtoolConfig.setValue("rendering.renderWindowBounds", String.valueOf(x) + ", " + y + ", " + width + ", " + height);
        }
        if (authoringtoolConfig.getValue("rendering.runtimeScratchPadEnabled") == null) {
            authoringtoolConfig.setValue("rendering.runtimeScratchPadEnabled", "false");
        }
        if (authoringtoolConfig.getValue("rendering.runtimeScratchPadHeight") == null) {
            authoringtoolConfig.setValue("rendering.runtimeScratchPadHeight", "300");
        }
        if (authoringtoolConfig.getValue("rendering.useBorderlessWindow") == null) {
            authoringtoolConfig.setValue("rendering.useBorderlessWindow", "false");
        }
        if (authoringtoolConfig.getValue("rendering.constrainRenderDialogAspectRatio") == null) {
            authoringtoolConfig.setValue("rendering.constrainRenderDialogAspectRatio", "true");
        }
        if (authoringtoolConfig.getValue("gui.pickUpTiles") == null) {
            authoringtoolConfig.setValue("gui.pickUpTiles", "true");
        }
        if (authoringtoolConfig.getValue("gui.useAlphaTiles") == null) {
            authoringtoolConfig.setValue("gui.useAlphaTiles", "false");
        }
        if (authoringtoolConfig.getValue("useSingleFileLoadStore") == null) {
            authoringtoolConfig.setValue("useSingleFileLoadStore", "true");
        }
        if (authoringtoolConfig.getValue("directories.worldsDirectory") == null) {
            String dir = String.valueOf(System.getProperty("user.home")) + System.getProperty("file.separator") + "Desktop";
            authoringtoolConfig.setValue("directories.worldsDirectory", dir);
        }
        if ((defaultGallery = new File("gallery").getAbsoluteFile()).exists()) {
            String[] list = defaultGallery.list();
            authoringtoolConfig.setValueList("directories.galleryDirectory", list);
        }
        if (authoringtoolConfig.getValue("directories.importDirectory") == null) {
            String dir = String.valueOf(System.getProperty("user.home")) + System.getProperty("file.separator") + "Desktop";
            authoringtoolConfig.setValue("directories.importDirectory", dir);
        }
        if (authoringtoolConfig.getValue("directories.examplesDirectory") == null) {
            authoringtoolConfig.setValue("directories.examplesDirectory", "exampleWorlds");
        }
        if ((charDir = authoringtoolConfig.getValue("directories.charactersDirectory")) == null) {
            charDir = String.valueOf(System.getProperty("user.home")) + System.getProperty("file.separator") + "Desktop" + System.getProperty("file.separator") + "CustomGallery";
        }
        if (!(captureDir = new File(charDir)).exists() && !captureDir.mkdir()) {
            charDir = String.valueOf(System.getProperty("user.home")) + System.getProperty("file.separator") + "Desktop";
            captureDir = new File(charDir);
        }
        authoringtoolConfig.setValue("directories.charactersDirectory", charDir);
        if (authoringtoolConfig.getValue("directories.templatesDirectory") == null) {
            authoringtoolConfig.setValue("directories.templatesDirectory", "templateWorlds" + System.getProperty("file.separator") + AikMin.locale);
        }
        if (authoringtoolConfig.getValue("directories.textbookExamplesDirectory") == null) {
            authoringtoolConfig.setValue("directories.textbookExamplesDirectory", "textbookExampleWorlds");
        }
        if (authoringtoolConfig.getValue("screenCapture.directory") == null) {
            String dir = String.valueOf(System.getProperty("user.home")) + System.getProperty("file.separator") + "Desktop";
            authoringtoolConfig.setValue("screenCapture.directory", dir);
        }
        if (authoringtoolConfig.getValue("screenCapture.baseName") == null) {
            authoringtoolConfig.setValue("screenCapture.baseName", "capture");
        }
        if (authoringtoolConfig.getValue("screenCapture.numDigits") == null) {
            authoringtoolConfig.setValue("screenCapture.numDigits", "2");
        }
        if (authoringtoolConfig.getValue("screenCapture.codec") == null) {
            authoringtoolConfig.setValue("screenCapture.codec", "jpeg");
        }
        if (authoringtoolConfig.getValue("screenCapture.codec").equalsIgnoreCase("gif")) {
            authoringtoolConfig.setValue("screenCapture.codec", "jpeg");
        }
        if (authoringtoolConfig.getValue("screenCapture.informUser") == null) {
            authoringtoolConfig.setValue("screenCapture.informUser", "true");
        }
        if (authoringtoolConfig.getValue("saveInfiniteBackups") == null) {
            authoringtoolConfig.setValue("saveInfiniteBackups", "false");
        }
        if (authoringtoolConfig.getValue("doProfiling") == null) {
            authoringtoolConfig.setValue("doProfiling", "false");
        }
    }

    private static void parseCommandLineArgs(String[] args) {
        int c;
        LongOpt[] options = new LongOpt[]{new LongOpt("stdOutToConsole", 0, null, 111), new LongOpt("stdErrToConsole", 0, null, 101), new LongOpt("defaultRenderer", 1, null, 114), new LongOpt("help", 0, null, 104)};
        String helpMessage = "\nUsage: JAlice <options> <world>\n\noptions:\n    --stdOutToConsole|-o:\n        directs System.stdOut to the console instead of the output text area.\n    --stdErrToConsole|-e:\n        directs System.stdOut to the console instead of the output text area.\n    --defaultRenderer|-r <classname>:\n        the Renderer specified by <classname> will be used as the default Renderer\n    --help|-h:\n        prints this help message\n\nworld:\n    a pathname to a world on disk to be loaded at startup.\n";
        Getopt g = new Getopt("JAlice", args, ":oeh", options);
        while ((c = g.getopt()) != -1) {
            switch (c) {
                case 111: {
                    stdOutToConsole = true;
                    break;
                }
                case 101: {
                    stdErrToConsole = true;
                    break;
                }
                case 114: {
                    defaultRendererClassname = g.getOptarg();
                    break;
                }
                case 63: 
                case 104: {
                    System.err.println(helpMessage);
                    System.exit(0);
                    break;
                }
                default: {
                    System.err.println("ignoring " + c + " on the command line.");
                }
            }
        }
        int i = g.getOptind();
        if (i >= 0 && i < args.length) {
            if (AikMin.isWindows()) {
                int ch = 58;
                String file = args[i].toString();
                file = file.substring(file.lastIndexOf(ch) - 1, file.length());
                worldToLoad = new File(file).getAbsoluteFile();
            } else if (!AikMin.isMAC()) {
                worldToLoad = new File(args[i]).getAbsoluteFile();
            }
        }
    }

    public static boolean isMainFinished() {
        return mainHasFinished;
    }

    public static void setAliceHomeDirectory(File file) {
        aliceHomeDirectory = file;
    }

    public static File getAliceHomeDirectory() {
        if (aliceHomeDirectory == null) {
            if (System.getProperty("alice.home") != null) {
                JAlice.setAliceHomeDirectory(new File(System.getProperty("alice.home")).getAbsoluteFile());
            } else {
                JAlice.setAliceHomeDirectory(new File(System.getProperty("user.dir")).getAbsoluteFile());
            }
        }
        return aliceHomeDirectory;
    }

    public static void setAliceUserDirectory(File file) {
        if (file != null) {
            if (file.exists()) {
                aliceUserDirectory = file;
            } else if (file.mkdirs()) {
                aliceUserDirectory = file;
            }
        }
    }

    public static File getAliceUserDirectory() {
        if (aliceUserDirectory == null) {
            File dirFromProperties = null;
            if (System.getProperty("alice.userDir") != null) {
                dirFromProperties = new File(System.getProperty("alice.userDir")).getAbsoluteFile();
            }
            File userHome = new File(System.getProperty("user.home")).getAbsoluteFile();
            File aliceHome = JAlice.getAliceHomeDirectory();
            File aliceUser = null;
            if (directory != null) {
                aliceUser = new File(directory, ".alice2");
            } else if (dirFromProperties != null) {
                aliceUser = dirFromProperties;
            } else if (userHome.exists() && userHome.canRead() && userHome.canWrite()) {
                aliceUser = new File(userHome, ".alice2");
            } else if (aliceHome != null && aliceHome.exists() && aliceHome.canRead() && aliceHome.canWrite()) {
                aliceUser = new File(aliceHome, ".alice2");
            }
            JAlice.setAliceUserDirectory(aliceUser);
        }
        return aliceUserDirectory;
    }
}

