/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources;
import edu.cmu.cs.stage3.alice.authoringtool.JAliceFrame;
import edu.cmu.cs.stage3.lang.Messages;
import java.awt.event.ActionEvent;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.KeyStroke;

public class Actions {
    public AbstractAction newWorldAction;
    public AbstractAction openWorldAction;
    public AbstractAction openExampleWorldAction;
    public AbstractAction saveWorldAction;
    public AbstractAction saveWorld;
    public AbstractAction saveWorldAsAction;
    public AbstractAction saveForWebAction;
    public AbstractAction importObjectAction;
    public AbstractAction quitAction;
    public AbstractAction cutAction;
    public AbstractAction copyAction;
    public AbstractAction pasteAction;
    public AbstractAction undoAction;
    public AbstractAction redoAction;
    public AbstractAction aboutAction;
    public AbstractAction playAction;
    public AbstractAction addCharacterAction;
    public AbstractAction add3DTextAction;
    public AbstractAction exportMovieAction;
    public AbstractAction trashAction;
    public AbstractAction helpAction;
    public AbstractAction onScreenHelpAction;
    public AbstractAction preferencesAction;
    public AbstractAction makeBillboardAction;
    public AbstractAction showWorldInfoAction;
    public AbstractAction launchTutorialAction;
    public AbstractAction launchTutorialFileAction;
    public AbstractAction launchTutorialEditor;
    public AbstractAction launchSoftwareUpdate;
    public AbstractAction showStdOutDialogAction;
    public AbstractAction showStdErrDialogAction;
    public AbstractAction showPrintDialogAction;
    public AbstractAction pauseWorldAction;
    public AbstractAction resumeWorldAction;
    public AbstractAction restartWorldAction;
    public AbstractAction stopWorldAction;
    public AbstractAction takePictureAction;
    public AbstractAction restartStopWorldAction;
    public AbstractAction logInstructorIntervention;
    public AbstractAction licenseAction;
    protected AuthoringTool authoringTool;
    protected JAliceFrame jAliceFrame;
    protected LinkedList applicationActions = new LinkedList();
    public LinkedList renderActions = new LinkedList();

    public Actions(AuthoringTool authoringTool, JAliceFrame jAliceFrame) {
        this.authoringTool = authoringTool;
        this.jAliceFrame = jAliceFrame;
        this.actionInit();
        this.keyInit();
        this.undoAction.setEnabled(false);
        this.redoAction.setEnabled(false);
    }

    private void actionInit() {
        this.newWorldAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Actions.this.authoringTool.newWorld();
            }
        };
        this.openWorldAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Actions.this.authoringTool.openWorld();
            }
        };
        this.openExampleWorldAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Actions.this.authoringTool.openExampleWorld();
            }
        };
        this.saveWorldAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Actions.this.authoringTool.saveWorld();
            }
        };
        this.saveWorld = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Actions.this.authoringTool.saveWorld();
            }
        };
        this.saveWorldAsAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Actions.this.authoringTool.saveWorldAs();
            }
        };
        this.saveForWebAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Actions.this.authoringTool.saveForWeb();
            }
        };
        this.importObjectAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Actions.this.authoringTool.getImportFileChooser().setFileFilter(Actions.this.authoringTool.getImportFileChooser().getAcceptAllFileFilter());
                Actions.this.authoringTool.importElement();
            }
        };
        this.quitAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Actions.this.authoringTool.quit(false);
            }
        };
        this.cutAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        };
        this.copyAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        };
        this.pasteAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        };
        this.undoAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Actions.this.authoringTool.getUndoRedoStack().undo();
            }
        };
        this.redoAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Actions.this.authoringTool.getUndoRedoStack().redo();
            }
        };
        this.aboutAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Actions.this.authoringTool.showAbout();
            }
        };
        this.playAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Actions.this.authoringTool.play();
            }
        };
        this.addCharacterAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Actions.this.authoringTool.loadAndAddCharacter();
            }
        };
        this.add3DTextAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Actions.this.authoringTool.add3DText();
            }
        };
        this.exportMovieAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Actions.this.authoringTool.exportMovie();
            }
        };
        this.trashAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        };
        this.helpAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        };
        this.onScreenHelpAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Actions.this.authoringTool.showOnScreenHelp();
            }
        };
        this.preferencesAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Actions.this.authoringTool.showPreferences();
            }
        };
        this.makeBillboardAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Actions.this.authoringTool.makeBillboard();
            }
        };
        this.showWorldInfoAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Actions.this.authoringTool.showWorldInfoDialog();
            }
        };
        this.launchTutorialAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Actions.this.authoringTool.launchTutorial();
            }
        };
        this.launchTutorialFileAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Actions.this.authoringTool.openTutorialWorld();
            }
        };
        this.launchTutorialEditor = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Actions.this.authoringTool.openTutorialEditor();
            }
        };
        this.launchSoftwareUpdate = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Actions.this.authoringTool.updateAlice();
            }
        };
        this.showStdOutDialogAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Actions.this.authoringTool.showStdOutDialog();
            }
        };
        this.showStdErrDialogAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Actions.this.authoringTool.showStdErrDialog();
            }
        };
        this.showPrintDialogAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Actions.this.authoringTool.showPrintDialog();
            }
        };
        this.pauseWorldAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Actions.this.authoringTool.pause();
            }
        };
        this.resumeWorldAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Actions.this.authoringTool.resume();
            }
        };
        this.restartWorldAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Actions.this.authoringTool.restartWorld();
            }
        };
        this.restartStopWorldAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Actions.this.authoringTool.restartWorld();
                Actions.this.authoringTool.pause();
            }
        };
        this.stopWorldAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Actions.this.authoringTool.stopWorld();
            }
        };
        this.takePictureAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Actions.this.takePictureAction.setEnabled(false);
                Actions.this.authoringTool.takePicture();
                Actions.this.takePictureAction.setEnabled(true);
            }
        };
        this.logInstructorIntervention = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Actions.this.authoringTool.logInstructorIntervention();
            }
        };
        this.licenseAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Actions.this.authoringTool.showLicense();
            }
        };
        this.newWorldAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(78, 2));
        this.newWorldAction.putValue("ActionCommandKey", "newWorld");
        this.newWorldAction.putValue("MnemonicKey", new Integer(78));
        this.newWorldAction.putValue("Name", Messages.getString("New_World"));
        this.newWorldAction.putValue("ShortDescription", Messages.getString("Create_a_new_world"));
        this.newWorldAction.putValue("SmallIcon", AuthoringToolResources.getIconForString("new"));
        this.applicationActions.add(this.newWorldAction);
        this.openWorldAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(79, 2));
        this.openWorldAction.putValue("ActionCommandKey", "openWorld");
        this.openWorldAction.putValue("MnemonicKey", new Integer(79));
        this.openWorldAction.putValue("Name", Messages.getString("Open_World___"));
        this.openWorldAction.putValue("ShortDescription", Messages.getString("Open_an_existing_world"));
        this.openWorldAction.putValue("SmallIcon", AuthoringToolResources.getIconForString("open"));
        this.applicationActions.add(this.openWorldAction);
        this.saveWorldAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, 2));
        this.saveWorldAction.putValue("ActionCommandKey", "saveWorld");
        this.saveWorldAction.putValue("MnemonicKey", new Integer(83));
        this.saveWorldAction.putValue("Name", Messages.getString("Save_World"));
        this.saveWorldAction.putValue("ShortDescription", Messages.getString("Save_the_current_world"));
        this.saveWorldAction.putValue("SmallIcon", AuthoringToolResources.getIconForString("save"));
        this.applicationActions.add(this.saveWorldAction);
        this.saveWorld.putValue("AcceleratorKey", KeyStroke.getKeyStroke(113, 0));
        this.saveWorld.putValue("ActionCommandKey", "saveWorld");
        this.saveWorld.putValue("Name", Messages.getString("Save_World"));
        this.applicationActions.add(this.saveWorld);
        this.saveWorldAsAction.putValue("ActionCommandKey", "saveWorldAs");
        this.saveWorldAsAction.putValue("MnemonicKey", new Integer(118));
        this.saveWorldAsAction.putValue("Name", Messages.getString("Save_World_As___"));
        this.saveWorldAsAction.putValue("ShortDescription", Messages.getString("Save_the_current_world"));
        this.applicationActions.add(this.saveWorldAsAction);
        this.saveForWebAction.putValue("ActionCommandKey", "saveForWeb");
        this.saveForWebAction.putValue("MnemonicKey", new Integer(119));
        this.saveForWebAction.putValue("Name", Messages.getString("Export_As_A_Web_Page___"));
        this.saveForWebAction.putValue("ShortDescription", Messages.getString("Export_as_a_web_page"));
        this.applicationActions.add(this.saveForWebAction);
        this.importObjectAction.putValue("ActionCommandKey", "importObject");
        this.importObjectAction.putValue("MnemonicKey", new Integer(73));
        this.importObjectAction.putValue("Name", Messages.getString("Import___"));
        this.importObjectAction.putValue("ShortDescription", Messages.getString("Import"));
        this.importObjectAction.putValue("SmallIcon", AuthoringToolResources.getIconForString("import"));
        this.applicationActions.add(this.importObjectAction);
        this.quitAction.putValue("ActionCommandKey", "quit");
        this.quitAction.putValue("MnemonicKey", new Integer(120));
        this.quitAction.putValue("Name", Messages.getString("Exit"));
        this.quitAction.putValue("ShortDescription", Messages.getString("Exit_Alice"));
        this.applicationActions.add(this.quitAction);
        this.cutAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(88, 2));
        this.cutAction.putValue("ActionCommandKey", "cut");
        this.cutAction.putValue("MnemonicKey", new Integer(116));
        this.cutAction.putValue("Name", Messages.getString("Cut"));
        this.cutAction.putValue("ShortDescription", Messages.getString("Cut"));
        this.cutAction.putValue("SmallIcon", AuthoringToolResources.getIconForString("cut"));
        this.applicationActions.add(this.cutAction);
        this.copyAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(67, 2));
        this.copyAction.putValue("ActionCommandKey", "copy");
        this.copyAction.putValue("MnemonicKey", new Integer(67));
        this.copyAction.putValue("Name", Messages.getString("Copy"));
        this.copyAction.putValue("ShortDescription", Messages.getString("Copy"));
        this.copyAction.putValue("SmallIcon", AuthoringToolResources.getIconForString("copy"));
        this.applicationActions.add(this.copyAction);
        this.pasteAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(86, 2));
        this.pasteAction.putValue("ActionCommandKey", "paste");
        this.pasteAction.putValue("MnemonicKey", new Integer(80));
        this.pasteAction.putValue("Name", Messages.getString("Paste"));
        this.pasteAction.putValue("ShortDescription", Messages.getString("Paste"));
        this.pasteAction.putValue("SmallIcon", AuthoringToolResources.getIconForString("paste"));
        this.applicationActions.add(this.pasteAction);
        this.undoAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(90, 2));
        this.undoAction.putValue("ActionCommandKey", "undo");
        this.undoAction.putValue("MnemonicKey", new Integer(85));
        this.undoAction.putValue("Name", Messages.getString("Undo"));
        this.undoAction.putValue("ShortDescription", Messages.getString("Undo_the_Last_Action"));
        this.undoAction.putValue("SmallIcon", AuthoringToolResources.getIconForString("undo"));
        this.applicationActions.add(this.undoAction);
        this.redoAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(89, 2));
        this.redoAction.putValue("ActionCommandKey", "redo");
        this.redoAction.putValue("MnemonicKey", new Integer(82));
        this.redoAction.putValue("Name", Messages.getString("Redo"));
        this.redoAction.putValue("ShortDescription", Messages.getString("Redo"));
        this.redoAction.putValue("SmallIcon", AuthoringToolResources.getIconForString("redo"));
        this.applicationActions.add(this.redoAction);
        this.aboutAction.putValue("ActionCommandKey", "about");
        this.aboutAction.putValue("MnemonicKey", new Integer(65));
        this.aboutAction.putValue("Name", Messages.getString("About_Alice"));
        this.aboutAction.putValue("ShortDescription", Messages.getString("About_Alice"));
        this.aboutAction.putValue("SmallIcon", AuthoringToolResources.getIconForString("about"));
        this.applicationActions.add(this.aboutAction);
        this.onScreenHelpAction.putValue("ActionCommandKey", "onScreenHelp");
        this.onScreenHelpAction.putValue("MnemonicKey", new Integer(79));
        this.onScreenHelpAction.putValue("Name", Messages.getString("On_Screen_Help__experimental_"));
        this.onScreenHelpAction.putValue("ShortDescription", Messages.getString("Experimental_Tutorial_Editor"));
        this.applicationActions.add(this.onScreenHelpAction);
        this.playAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(116, 0));
        this.playAction.putValue("ActionCommandKey", "play");
        this.playAction.putValue("Name", Messages.getString("Play"));
        this.playAction.putValue("ShortDescription", "<html><font face=arial size=-1>" + Messages.getString("Play_the_world_") + "<p><p>" + Messages.getString("Opens_the_play_window_and_p_starts_the_world_running_") + "</font></html>");
        this.playAction.putValue("SmallIcon", AuthoringToolResources.getIconForString("play"));
        this.applicationActions.add(this.playAction);
        this.addCharacterAction.putValue("ActionCommandKey", "addObject");
        this.addCharacterAction.putValue("Name", Messages.getString("Add_Object___"));
        this.addCharacterAction.putValue("ShortDescription", Messages.getString("Add_a_previously_stored_Object"));
        this.applicationActions.add(this.addCharacterAction);
        this.add3DTextAction.putValue("ActionCommandKey", "add3DText");
        this.add3DTextAction.putValue("Name", Messages.getString("Add_3D_Text___"));
        this.add3DTextAction.putValue("ShortDescription", Messages.getString("Add_Text_extruded_into_3D"));
        this.applicationActions.add(this.add3DTextAction);
        this.exportMovieAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(117, 0));
        this.exportMovieAction.putValue("ActionCommandKey", "exportVideo");
        this.exportMovieAction.putValue("Name", Messages.getString("Export_Video___"));
        this.exportMovieAction.putValue("ShortDescription", Messages.getString("Export_the_current_world_as_a_video"));
        this.applicationActions.add(this.exportMovieAction);
        this.trashAction.putValue("ActionCommandKey", "trash");
        this.trashAction.putValue("ShortDescription", "<html><font face=arial size=-1>" + Messages.getString("Trash") + "<p><p>" + Messages.getString("Drag_and_drop_tiles_here_to_delete_them_") + "</font></html>");
        this.applicationActions.add(this.trashAction);
        this.openExampleWorldAction.putValue("ActionCommandKey", "openExampleWorld");
        this.openExampleWorldAction.putValue("Name", Messages.getString("Example_Worlds"));
        this.openExampleWorldAction.putValue("ShortDescription", Messages.getString("Open_an_Example_World"));
        this.applicationActions.add(this.openExampleWorldAction);
        this.helpAction.putValue("ActionCommandKey", "help");
        this.helpAction.putValue("MnemonicKey", new Integer(72));
        this.helpAction.putValue("Name", Messages.getString("Help_Topics"));
        this.helpAction.putValue("ShortDescription", Messages.getString("Alice_Documentation"));
        this.applicationActions.add(this.helpAction);
        this.preferencesAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(119, 0));
        this.preferencesAction.putValue("ActionCommandKey", "preferences");
        this.preferencesAction.putValue("MnemonicKey", new Integer(80));
        this.preferencesAction.putValue("Name", Messages.getString("Preferences"));
        this.preferencesAction.putValue("ShortDescription", Messages.getString("Set_Preferences"));
        this.applicationActions.add(this.preferencesAction);
        this.makeBillboardAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(66, 2));
        this.makeBillboardAction.putValue("ActionCommandKey", "makeBillboard");
        this.makeBillboardAction.putValue("MnemonicKey", new Integer(66));
        this.makeBillboardAction.putValue("Name", Messages.getString("Make_Billboard___"));
        this.makeBillboardAction.putValue("ShortDescription", Messages.getString("Make_a_billboard_object_from_an_image"));
        this.applicationActions.add(this.makeBillboardAction);
        this.showWorldInfoAction.putValue("ActionCommandKey", "showWorldInfo");
        this.showWorldInfoAction.putValue("MnemonicKey", new Integer(73));
        this.showWorldInfoAction.putValue("Name", Messages.getString("World_Statistics"));
        this.showWorldInfoAction.putValue("ShortDescription", Messages.getString("Show_information_about_the_current_world"));
        this.applicationActions.add(this.showWorldInfoAction);
        this.launchTutorialAction.putValue("ActionCommandKey", "launchTutorial");
        this.launchTutorialAction.putValue("MnemonicKey", new Integer(84));
        this.launchTutorialAction.putValue("Name", Messages.getString("Teach_Me"));
        this.launchTutorialAction.putValue("ShortDescription", Messages.getString("Launch_the_Tutorial"));
        this.applicationActions.add(this.launchTutorialAction);
        this.launchTutorialFileAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(112, 0));
        this.launchTutorialFileAction.putValue("ActionCommandKey", "launchTutorialFile");
        this.launchTutorialFileAction.putValue("MnemonicKey", new Integer(84));
        this.launchTutorialFileAction.putValue("Name", Messages.getString("Tutorial"));
        this.launchTutorialFileAction.putValue("ShortDescription", Messages.getString("Open_a_tutorial"));
        this.applicationActions.add(this.launchTutorialFileAction);
        this.launchTutorialEditor.putValue("ActionCommandKey", "launchTutorialEditor");
        this.launchTutorialEditor.putValue("Name", "Tutorial Editor");
        this.launchTutorialEditor.putValue("ShortDescription", "Create or edit a tutorial");
        this.applicationActions.add(this.launchTutorialEditor);
        this.launchSoftwareUpdate.putValue("ActionCommandKey", "launchSoftwareUpdate");
        this.launchSoftwareUpdate.putValue("Name", Messages.getString("Update_Software"));
        this.launchSoftwareUpdate.putValue("ShortDescription", Messages.getString("Update_Software"));
        this.applicationActions.add(this.launchSoftwareUpdate);
        this.showStdOutDialogAction.putValue("ActionCommandKey", "showStdOutDialog");
        this.showStdOutDialogAction.putValue("MnemonicKey", new Integer(79));
        this.showStdOutDialogAction.putValue("Name", Messages.getString("Text_Output"));
        this.showStdOutDialogAction.putValue("ShortDescription", Messages.getString("Show_text_output_window"));
        this.applicationActions.add(this.showStdOutDialogAction);
        this.showStdErrDialogAction.putValue("ActionCommandKey", "showStdErrDialog");
        this.showStdErrDialogAction.putValue("MnemonicKey", new Integer(69));
        this.showStdErrDialogAction.putValue("Name", Messages.getString("Error_Console"));
        this.showStdErrDialogAction.putValue("ShortDescription", Messages.getString("Show_error_console_window"));
        this.applicationActions.add(this.showStdErrDialogAction);
        this.showPrintDialogAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(80, 2));
        this.showPrintDialogAction.putValue("ActionCommandKey", "showPrintDialog");
        this.showPrintDialogAction.putValue("MnemonicKey", new Integer(80));
        this.showPrintDialogAction.putValue("Name", Messages.getString("Export_Code_For_Printing___"));
        this.showPrintDialogAction.putValue("ShortDescription", Messages.getString("Export_user_defined_methods_and_questions_for_printing"));
        this.applicationActions.add(this.showPrintDialogAction);
        this.pauseWorldAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(19, 0));
        this.pauseWorldAction.putValue("ActionCommandKey", "pauseWorld");
        this.pauseWorldAction.putValue("Name", Messages.getString("Pause"));
        this.pauseWorldAction.putValue("ShortDescription", Messages.getString("Pause_the_running_of_the_world__Pause_Break_"));
        this.renderActions.add(this.pauseWorldAction);
        this.resumeWorldAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(33, 0));
        this.resumeWorldAction.putValue("ActionCommandKey", "resumeWorld");
        this.resumeWorldAction.putValue("Name", "  " + Messages.getString("Play__"));
        this.resumeWorldAction.putValue("ShortDescription", Messages.getString("Resume_the_running_of_the_world__Page_Up_"));
        this.renderActions.add(this.resumeWorldAction);
        this.restartWorldAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(8, 0));
        this.restartWorldAction.putValue("ActionCommandKey", "restartWorld");
        this.restartWorldAction.putValue("Name", Messages.getString("Restart"));
        this.restartWorldAction.putValue("ShortDescription", Messages.getString("Restart_the_world__Backspace_"));
        this.renderActions.add(this.restartWorldAction);
        this.restartStopWorldAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(8, 0));
        this.restartStopWorldAction.putValue("ActionCommandKey", "restartWorld");
        this.restartStopWorldAction.putValue("Name", Messages.getString("Restart"));
        this.restartStopWorldAction.putValue("ShortDescription", Messages.getString("Restart_the_world__Backspace_"));
        this.renderActions.add(this.restartStopWorldAction);
        this.stopWorldAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(27, 0));
        this.stopWorldAction.putValue("ActionCommandKey", "stopWorld");
        this.stopWorldAction.putValue("Name", Messages.getString("Stop"));
        this.stopWorldAction.putValue("ShortDescription", Messages.getString("Stop_the_running_of_the_world__Esc_"));
        this.renderActions.add(this.stopWorldAction);
        this.takePictureAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(71, 2));
        this.takePictureAction.putValue("ActionCommandKey", "takePicture");
        this.takePictureAction.putValue("Name", Messages.getString("Take_Picture"));
        this.takePictureAction.putValue("ShortDescription", Messages.getString("Take_a_screenshot_of_the_current_scene__Ctrl_G_"));
        this.renderActions.add(this.takePictureAction);
        this.logInstructorIntervention.putValue("ActionCommandKey", "logInstructor");
        this.logInstructorIntervention.putValue("MnemonicKey", new Integer(76));
        this.logInstructorIntervention.putValue("Name", Messages.getString("Log_Instructor_Actions"));
        this.logInstructorIntervention.putValue("ShortDescription", Messages.getString("Add_record_of_instructor_actions_to_log"));
        this.logInstructorIntervention.putValue("SmallIcon", AuthoringToolResources.getIconForString("log"));
        this.applicationActions.add(this.logInstructorIntervention);
        this.licenseAction.putValue("ActionCommandKey", "license");
        this.licenseAction.putValue("Name", Messages.getString("View_License"));
        this.licenseAction.putValue("ShortDescription", Messages.getString("View_License"));
        this.applicationActions.add(this.licenseAction);
    }

    private void keyInit() {
        for (Action action : this.applicationActions) {
            String commandKey;
            KeyStroke keyStroke;
            try {
                keyStroke = (KeyStroke)action.getValue("AcceleratorKey");
                commandKey = (String)action.getValue("ActionCommandKey");
            }
            catch (ClassCastException e) {
                continue;
            }
            if (keyStroke == null || commandKey == null) continue;
            this.jAliceFrame.registerKeyboardAction(action, commandKey, keyStroke, 2);
        }
    }
}

