/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool;

import edu.cmu.cs.stage3.alice.authoringtool.Importer;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.lang.Messages;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;

public abstract class AbstractImporter
implements Importer {
    private Object location = null;
    protected String plainName = null;

    @Override
    public abstract Map getExtensionMap();

    @Override
    public Element load(String filename) throws IOException {
        this.location = new File(filename).getParentFile();
        String fullName = new File(filename).getName();
        this.plainName = fullName.substring(0, fullName.indexOf(46));
        if (!Element.isPotentialNameValid(this.plainName)) {
            this.plainName = Element.generateValidName(this.plainName);
        }
        FileInputStream fis = new FileInputStream(filename);
        Element castMember = this.load(fis, this.getExtension(filename));
        fis.close();
        this.plainName = null;
        return castMember;
    }

    @Override
    public Element load(File file) throws IOException {
        this.location = file.getParentFile();
        String fullName = file.getName();
        this.plainName = fullName.substring(0, fullName.indexOf(46));
        if (!Element.isPotentialNameValid(this.plainName)) {
            this.plainName = Element.generateValidName(this.plainName);
        }
        FileInputStream fis = new FileInputStream(file);
        Element castMember = this.load(fis, this.getExtension(file.getName()));
        fis.close();
        this.plainName = null;
        return castMember;
    }

    @Override
    public Element load(URL url) throws IOException {
        String externalForm = url.toExternalForm();
        this.location = new URL(externalForm.substring(0, externalForm.lastIndexOf(47) + 1));
        String fullName = externalForm.substring(externalForm.lastIndexOf(47) + 1);
        this.plainName = fullName.substring(0, fullName.lastIndexOf(46));
        if (!Element.isPotentialNameValid(this.plainName)) {
            this.plainName = Element.generateValidName(this.plainName);
        }
        Element castMember = this.load(url.openStream(), this.getExtension(url.getFile()));
        this.plainName = null;
        return castMember;
    }

    protected abstract Element load(InputStream var1, String var2) throws IOException;

    public Object getLocation() {
        return this.location;
    }

    private String getExtension(String filename) {
        if (filename == null) {
            throw new IllegalArgumentException(Messages.getString("null_filename_encountered"));
        }
        filename.trim();
        int i = filename.lastIndexOf(".");
        if (i == -1) {
            throw new IllegalArgumentException(String.valueOf(Messages.getString("unable_to_determine_the_extension_of_")) + filename);
        }
        String ext = filename.substring(i + 1);
        if (ext.length() < 1) {
            throw new IllegalArgumentException(String.valueOf(Messages.getString("unable_to_determine_the_extension_of_")) + filename);
        }
        ext = ext.toUpperCase();
        if (this.getExtensionMap().get(ext) == null) {
            throw new IllegalArgumentException(String.valueOf(ext) + " " + Messages.getString("files_are_not_supported_by_this_Importer"));
        }
        return ext;
    }
}

