/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.util.texture;

import com.sun.opengl.impl.Debug;
import com.sun.opengl.util.texture.TextureCoords;
import com.sun.opengl.util.texture.TextureData;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import javax.media.opengl.GL;
import javax.media.opengl.GLException;
import javax.media.opengl.glu.GLU;

public class Texture {
    private int target;
    private int texID;
    private int texWidth;
    private int texHeight;
    private int imgWidth;
    private int imgHeight;
    private boolean mustFlipVertically;
    private TextureCoords coords;
    private int estimatedMemorySize;
    private static final boolean DEBUG = Debug.debug("Texture");

    Texture(TextureData textureData) throws GLException {
        GL gL = GLU.getCurrentGL();
        this.texID = Texture.createTextureID(gL);
        this.updateImage(textureData);
    }

    Texture(int n) throws GLException {
        GL gL = GLU.getCurrentGL();
        this.texID = Texture.createTextureID(gL);
        this.target = n;
    }

    public void enable() throws GLException {
        GLU.getCurrentGL().glEnable(this.target);
    }

    public void disable() throws GLException {
        GLU.getCurrentGL().glDisable(this.target);
    }

    public void bind() throws GLException {
        GLU.getCurrentGL().glBindTexture(this.target, this.texID);
    }

    public void dispose() throws GLException {
        GLU.getCurrentGL().glDeleteTextures(1, new int[]{this.texID}, 0);
        this.texID = 0;
    }

    public int getTarget() {
        return this.target;
    }

    public int getWidth() {
        return this.texWidth;
    }

    public int getHeight() {
        return this.texHeight;
    }

    public int getImageWidth() {
        return this.imgWidth;
    }

    public int getImageHeight() {
        return this.imgHeight;
    }

    public TextureCoords getImageTexCoords() {
        return this.coords;
    }

    public TextureCoords getSubImageTexCoords(int n, int n2, int n3, int n4) {
        if (this.target == 34037) {
            if (this.mustFlipVertically) {
                return new TextureCoords(n, this.texHeight - n2, n3, this.texHeight - n4);
            }
            return new TextureCoords(n, n2, n3, n4);
        }
        float f = (float)n / (float)this.texWidth;
        float f2 = (float)n2 / (float)this.texHeight;
        float f3 = (float)n3 / (float)this.texWidth;
        float f4 = (float)n4 / (float)this.texHeight;
        if (this.mustFlipVertically) {
            return new TextureCoords(f, 1.0f - f2, f3, 1.0f - f4);
        }
        return new TextureCoords(f, f2, f3, f4);
    }

    public void updateImage(TextureData textureData) throws GLException {
        this.updateImage(textureData, 0);
    }

    public boolean getMustFlipVertically() {
        return this.mustFlipVertically;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateImage(TextureData textureData, int n) throws GLException {
        GL gL = GLU.getCurrentGL();
        this.imgWidth = textureData.getWidth();
        this.imgHeight = textureData.getHeight();
        this.mustFlipVertically = textureData.getMustFlipVertically();
        int n2 = 0;
        if (textureData.getMipmap()) {
            this.imgWidth = Texture.nextPowerOfTwo(this.imgWidth);
            this.imgHeight = Texture.nextPowerOfTwo(this.imgHeight);
            this.texWidth = this.imgWidth;
            this.texHeight = this.imgHeight;
            n2 = 3553;
        } else if (Texture.isPowerOfTwo(this.imgWidth) && Texture.isPowerOfTwo(this.imgHeight) || gL.isExtensionAvailable("GL_ARB_texture_non_power_of_two")) {
            if (DEBUG) {
                if (Texture.isPowerOfTwo(this.imgWidth) && Texture.isPowerOfTwo(this.imgHeight)) {
                    System.err.println("Power-of-two texture");
                } else {
                    System.err.println("Using GL_ARB_texture_non_power_of_two");
                }
            }
            this.texWidth = this.imgWidth;
            this.texHeight = this.imgHeight;
            n2 = 3553;
        } else if (gL.isExtensionAvailable("GL_ARB_texture_rectangle")) {
            if (DEBUG) {
                System.err.println("Using GL_ARB_texture_rectangle");
            }
            this.texWidth = this.imgWidth;
            this.texHeight = this.imgHeight;
            n2 = 34037;
        } else {
            if (DEBUG) {
                System.err.println("Expanding texture to power-of-two dimensions");
            }
            if (textureData.getBorder() != 0) {
                throw new RuntimeException("Scaling up a non-power-of-two texture which has a border won't work");
            }
            this.texWidth = Texture.nextPowerOfTwo(this.imgWidth);
            this.texHeight = Texture.nextPowerOfTwo(this.imgHeight);
            n2 = 3553;
        }
        this.setImageSize(this.imgWidth, this.imgHeight, n2);
        if (n != 0) {
            n2 = n;
            if (this.target == 0) {
                throw new GLException("Override of target failed; no target specified yet");
            }
            gL.glBindTexture(this.target, this.texID);
        } else {
            gL.glBindTexture(n2, this.texID);
        }
        int n3 = textureData.getMipmap() ? 9987 : 9729;
        int n4 = 9729;
        int n5 = 33071;
        if (n2 != 34037) {
            gL.glTexParameteri(n2, 10241, n3);
            gL.glTexParameteri(n2, 10240, n4);
            gL.glTexParameteri(n2, 10242, n5);
            gL.glTexParameteri(n2, 10243, n5);
            if (n2 == 34067) {
                gL.glTexParameteri(n2, 32882, n5);
            }
        }
        if (textureData.getMipmap()) {
            int[] nArray = new int[1];
            gL.glGetIntegerv(3317, nArray, 0);
            gL.glPixelStorei(3317, textureData.getAlignment());
            if (textureData.isDataCompressed()) {
                throw new GLException("May not request mipmap generation for compressed textures");
            }
            try {
                GLU gLU = new GLU();
                gLU.gluBuild2DMipmaps(n2, textureData.getInternalFormat(), textureData.getWidth(), textureData.getHeight(), textureData.getPixelFormat(), textureData.getPixelType(), textureData.getBuffer());
            }
            finally {
                gL.glPixelStorei(3317, nArray[0]);
            }
        } else {
            this.checkCompressedTextureExtensions(textureData);
            Buffer[] bufferArray = textureData.getMipmapData();
            if (bufferArray != null) {
                int n6 = this.texWidth;
                int n7 = this.texHeight;
                for (int i = 0; i < bufferArray.length; ++i) {
                    if (textureData.isDataCompressed()) {
                        gL.glCompressedTexImage2D(n2, i, textureData.getInternalFormat(), n6, n7, textureData.getBorder(), bufferArray[i].remaining(), bufferArray[i]);
                    } else {
                        gL.glTexImage2D(n2, i, textureData.getInternalFormat(), n6, n7, textureData.getBorder(), textureData.getPixelFormat(), textureData.getPixelType(), null);
                        this.updateSubImageImpl(textureData, n2, i, 0, 0);
                    }
                    n6 /= 2;
                    n7 /= 2;
                }
            } else if (textureData.isDataCompressed()) {
                gL.glCompressedTexImage2D(n2, 0, textureData.getInternalFormat(), this.texWidth, this.texHeight, textureData.getBorder(), textureData.getBuffer().capacity(), textureData.getBuffer());
            } else {
                gL.glTexImage2D(n2, 0, textureData.getInternalFormat(), this.texWidth, this.texHeight, textureData.getBorder(), textureData.getPixelFormat(), textureData.getPixelType(), null);
                this.updateSubImageImpl(textureData, n2, 0, 0, 0);
            }
        }
        if (this.target == 0 || this.target == 3553 || this.target == 34037) {
            this.target = n2;
        }
        this.estimatedMemorySize = textureData.getEstimatedMemorySize();
    }

    public void updateSubImage(TextureData textureData, int n, int n2, int n3) throws GLException {
        this.updateSubImageImpl(textureData, this.target, n, n2, n3);
    }

    public void setTexParameterf(int n, float f) {
        this.bind();
        GL gL = GLU.getCurrentGL();
        gL.glTexParameterf(this.target, n, f);
    }

    public void setTexParameterfv(int n, FloatBuffer floatBuffer) {
        this.bind();
        GL gL = GLU.getCurrentGL();
        gL.glTexParameterfv(this.target, n, floatBuffer);
    }

    public void setTexParameterfv(int n, float[] fArray, int n2) {
        this.bind();
        GL gL = GLU.getCurrentGL();
        gL.glTexParameterfv(this.target, n, fArray, n2);
    }

    public void setTexParameteri(int n, int n2) {
        this.bind();
        GL gL = GLU.getCurrentGL();
        gL.glTexParameteri(this.target, n, n2);
    }

    public void setTexParameteriv(int n, IntBuffer intBuffer) {
        this.bind();
        GL gL = GLU.getCurrentGL();
        gL.glTexParameteriv(this.target, n, intBuffer);
    }

    public void setTexParameteriv(int n, int[] nArray, int n2) {
        this.bind();
        GL gL = GLU.getCurrentGL();
        gL.glTexParameteriv(this.target, n, nArray, n2);
    }

    public int getTextureObject() {
        return this.texID;
    }

    public int getEstimatedMemorySize() {
        return this.estimatedMemorySize;
    }

    private static boolean isPowerOfTwo(int n) {
        return (n & n - 1) == 0;
    }

    private static int nextPowerOfTwo(int n) {
        int n2;
        for (n2 = 1; n2 < n; n2 <<= 1) {
        }
        return n2;
    }

    private void setImageSize(int n, int n2, int n3) {
        this.imgWidth = n;
        this.imgHeight = n2;
        this.coords = n3 == 34037 ? (this.mustFlipVertically ? new TextureCoords(0.0f, this.imgHeight, this.imgWidth, 0.0f) : new TextureCoords(0.0f, 0.0f, this.imgWidth, this.imgHeight)) : (this.mustFlipVertically ? new TextureCoords(0.0f, (float)this.imgHeight / (float)this.texHeight, (float)this.imgWidth / (float)this.texWidth, 0.0f) : new TextureCoords(0.0f, 0.0f, (float)this.imgWidth / (float)this.texWidth, (float)this.imgHeight / (float)this.texHeight));
    }

    private void updateSubImageImpl(TextureData textureData, int n, int n2, int n3, int n4) throws GLException {
        Buffer buffer = textureData.getBuffer();
        if (buffer == null && textureData.getMipmapData() == null) {
            return;
        }
        GL gL = GLU.getCurrentGL();
        gL.glBindTexture(n, this.texID);
        int n5 = textureData.getWidth();
        int n6 = textureData.getHeight();
        if (textureData.getMipmapData() != null) {
            for (int i = 0; i < n2; ++i) {
                n5 /= 2;
                n6 /= 2;
            }
            buffer = textureData.getMipmapData()[n2];
        }
        this.checkCompressedTextureExtensions(textureData);
        if (textureData.isDataCompressed()) {
            gL.glCompressedTexSubImage2D(n, n2, n3, n4, n5, n6, textureData.getInternalFormat(), buffer.remaining(), buffer);
        } else {
            int[] nArray = new int[1];
            gL.glGetIntegerv(3317, nArray, 0);
            gL.glPixelStorei(3317, textureData.getAlignment());
            gL.glTexSubImage2D(n, n2, n3, n4, n5, n6, textureData.getPixelFormat(), textureData.getPixelType(), buffer);
            gL.glPixelStorei(3317, nArray[0]);
        }
    }

    private void checkCompressedTextureExtensions(TextureData textureData) {
        GL gL = GLU.getCurrentGL();
        if (textureData.isDataCompressed()) {
            switch (textureData.getInternalFormat()) {
                case 33776: 
                case 33777: 
                case 33778: 
                case 33779: {
                    if (gL.isExtensionAvailable("GL_EXT_texture_compression_s3tc") || gL.isExtensionAvailable("GL_NV_texture_compression_vtc")) break;
                    throw new GLException("DXTn compressed textures not supported by this graphics card");
                }
            }
        }
    }

    private static int createTextureID(GL gL) {
        int[] nArray = new int[1];
        gL.glGenTextures(1, nArray, 0);
        return nArray[0];
    }
}

