/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.impl.macosx;

import com.sun.opengl.impl.macosx.CGL;
import com.sun.opengl.impl.macosx.MacOSXGLContext;
import com.sun.opengl.impl.macosx.MacOSXPbufferGLDrawable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.StringTokenizer;
import javax.media.opengl.GL;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLException;

public class MacOSXPbufferGLContext
extends MacOSXGLContext {
    protected MacOSXPbufferGLDrawable drawable;
    private int textureTarget;
    private int texture;
    private static boolean isTigerOrLater;

    public MacOSXPbufferGLContext(MacOSXPbufferGLDrawable macOSXPbufferGLDrawable, GLContext gLContext) {
        super(macOSXPbufferGLDrawable, gLContext);
        this.drawable = macOSXPbufferGLDrawable;
    }

    public void bindPbufferToTexture() {
        GL gL = this.getGL();
        gL.glBindTexture(this.textureTarget, this.texture);
        CGL.setContextTextureImageToPBuffer(this.nsContext, this.drawable.getPbuffer(), 1028);
    }

    public void releasePbufferFromTexture() {
    }

    protected int makeCurrentImpl() throws GLException {
        if (this.drawable.getPbuffer() == 0L) {
            if (DEBUG) {
                System.err.println("Pbuffer not instantiated yet for " + this);
            }
            return 0;
        }
        int n = super.makeCurrentImpl();
        if (n == 2) {
            boolean bl = this.drawable.getCapabilities().getPbufferRenderToTextureRectangle();
            GL gL = this.getGL();
            if (bl && !gL.isExtensionAvailable("GL_EXT_texture_rectangle")) {
                System.err.println("MacOSXPbufferGLContext: WARNING: GL_EXT_texture_rectangle extension not supported; skipping requested render_to_texture_rectangle support for pbuffer");
                bl = false;
            }
            this.textureTarget = bl ? 34037 : 3553;
            int[] nArray = new int[1];
            gL.glGenTextures(1, nArray, 0);
            this.texture = nArray[0];
            gL.glBindTexture(this.textureTarget, this.texture);
            gL.glTexParameteri(this.textureTarget, 10241, 9728);
            gL.glTexParameteri(this.textureTarget, 10240, 9728);
            gL.glTexParameteri(this.textureTarget, 10242, 33071);
            gL.glTexParameteri(this.textureTarget, 10243, 33071);
            gL.glCopyTexImage2D(this.textureTarget, 0, 6407, 0, 0, this.drawable.getWidth(), this.drawable.getHeight(), 0);
        }
        return n;
    }

    public int getFloatingPointMode() {
        return 1;
    }

    protected boolean create() {
        GLCapabilities gLCapabilities = this.drawable.getCapabilities();
        if (gLCapabilities.getPbufferFloatingPointBuffers() && !isTigerOrLater) {
            throw new GLException("Floating-point pbuffers supported only on OS X 10.4 or later");
        }
        if (!super.create(true, gLCapabilities.getPbufferFloatingPointBuffers())) {
            return false;
        }
        CGL.setContextPBuffer(this.nsContext, this.drawable.getPbuffer());
        return true;
    }

    static {
        String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("os.version");
            }
        });
        StringTokenizer stringTokenizer = new StringTokenizer(string, ". ");
        int n = Integer.parseInt(stringTokenizer.nextToken());
        int n2 = Integer.parseInt(stringTokenizer.nextToken());
        isTigerOrLater = n > 10 || n2 > 3;
    }
}

